/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis.util;

import com.oscar.gis.binary.BinaryParser;
import com.oscar.gis.util.Geometry;
import com.oscar.gis.util.GeometryCollection;
import com.oscar.gis.util.LineString;
import com.oscar.gis.util.MultiLineString;
import com.oscar.gis.util.MultiPoint;
import com.oscar.gis.util.MultiPolygon;
import com.oscar.gis.util.Point;
import com.oscar.gis.util.Polygon;
import java.sql.SQLException;

public class GeometryBuilder {
    public static final String SRIDPREFIX = "SRID=";

    public static Geometry geomFromString(String string) throws SQLException {
        return GeometryBuilder.geomFromString(string, false);
    }

    public static Geometry geomFromString(String string, boolean bl) throws SQLException {
        BinaryParser binaryParser = new BinaryParser();
        return GeometryBuilder.geomFromString(string, binaryParser, bl);
    }

    public static Geometry geomFromString(String string, BinaryParser binaryParser) throws SQLException {
        return GeometryBuilder.geomFromString(string, binaryParser, false);
    }

    public static Geometry geomFromString(String string, BinaryParser binaryParser, boolean bl) throws SQLException {
        Object object;
        string = string.trim();
        int n2 = 0;
        if (string.startsWith(SRIDPREFIX)) {
            object = GeometryBuilder.splitSRID(string);
            string = object[1].trim();
            n2 = Geometry.parseSRID(Integer.parseInt(object[0].substring(5)));
        }
        if (string.startsWith("00") || string.startsWith("01")) {
            object = binaryParser.parse(string);
        } else if (string.endsWith("EMPTY")) {
            object = new GeometryCollection();
        } else if (string.startsWith("MULTIPOLYGON")) {
            object = new MultiPolygon(string, bl);
        } else if (string.startsWith("MULTILINESTRING")) {
            object = new MultiLineString(string, bl);
        } else if (string.startsWith("MULTIPOINT")) {
            object = new MultiPoint(string, bl);
        } else if (string.startsWith("POLYGON")) {
            object = new Polygon(string, bl);
        } else if (string.startsWith("LINESTRING")) {
            object = new LineString(string, bl);
        } else if (string.startsWith("POINT")) {
            object = new Point(string, bl);
        } else if (string.startsWith("GEOMETRYCOLLECTION")) {
            object = new GeometryCollection(string, bl);
        } else {
            throw new SQLException("Unknown type: " + string);
        }
        if (n2 != 0) {
            ((Geometry)object).setSrid(n2);
        }
        return object;
    }

    public static String[] splitSRID(String string) throws SQLException {
        int n2 = string.indexOf(59, 5);
        if (n2 == -1) {
            throw new SQLException("Error parsing Geometry - SRID not delimited with ';' ");
        }
        return new String[]{string.substring(0, n2), string.substring(n2 + 1)};
    }
}

