/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis.util;

import com.oscar.gis.util.ComposedGeom;
import com.oscar.gis.util.Geometry;
import com.oscar.gis.util.LineString;
import java.sql.SQLException;

public class MultiLineString
extends ComposedGeom {
    private static final long serialVersionUID = 256L;
    double len = -1.0;

    @Override
    public int hashCode() {
        return super.hashCode() ^ (int)this.length();
    }

    public MultiLineString() {
        super(5);
    }

    public MultiLineString(LineString[] lineStringArray) {
        super(5, lineStringArray);
    }

    public MultiLineString(String string) throws SQLException {
        this(string, false);
    }

    public MultiLineString(String string, boolean bl) throws SQLException {
        super(5, string, bl);
    }

    @Override
    protected Geometry createSubGeomInstance(String string, boolean bl) throws SQLException {
        return new LineString(string, bl);
    }

    @Override
    protected Geometry[] createSubGeomArray(int n2) {
        return new LineString[n2];
    }

    public int numLines() {
        return this.subgeoms.length;
    }

    public LineString[] getLines() {
        return (LineString[])this.subgeoms.clone();
    }

    public LineString getLine(int n2) {
        if (n2 >= 0 & n2 < this.subgeoms.length) {
            return (LineString)this.subgeoms[n2];
        }
        return null;
    }

    public double length() {
        if (this.len < 0.0) {
            LineString[] lineStringArray = (LineString[])this.subgeoms;
            if (lineStringArray.length <= 0) {
                this.len = 0.0;
            } else {
                double d2 = 0.0;
                for (int i2 = 0; i2 < lineStringArray.length; ++i2) {
                    d2 += lineStringArray[i2].length();
                }
                this.len = d2;
            }
        }
        return this.len;
    }
}

