/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis.util;

import com.oscar.gis.util.Geometry;
import com.oscar.gis.util.GeometryTokenizer;
import java.sql.SQLException;

public class Point
extends Geometry {
    private static final long serialVersionUID = 256L;
    public static final boolean CUTINTS = true;
    private double x;
    private double y;
    private double z;
    private double m = 0.0;

    @Override
    public int hashCode() {
        return super.hashCode() ^ Point.hashCode(this.x) ^ Point.hashCode(this.y) ^ Point.hashCode(this.z) ^ Point.hashCode(this.m);
    }

    public static int hashCode(double d2) {
        long l2 = Double.doubleToLongBits(d2);
        return (int)(l2 ^ l2 >>> 32);
    }

    @Override
    protected boolean equalsintern(Geometry geometry) {
        geometry = (Point)geometry;
        return this.equals(geometry);
    }

    public static boolean double_equals(double d2, double d3) {
        if (Double.isNaN(d2) && Double.isNaN(d3)) {
            return true;
        }
        return d2 == d3;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Point) {
            boolean bl = Point.double_equals(this.x, ((Point)object).x);
            boolean bl2 = Point.double_equals(this.y, ((Point)object).y);
            boolean bl3 = this.dimension == 2 || Point.double_equals(this.z, ((Point)object).z);
            boolean bl4 = !this.haveMeasure || Point.double_equals(this.m, ((Point)object).m);
            bl4 = bl && bl2 && bl3 && bl4;
            return bl4;
        }
        return false;
    }

    @Override
    public Point getPoint(int n2) {
        if (n2 == 0) {
            return this;
        }
        throw new ArrayIndexOutOfBoundsException("Point only has a single Point! " + n2);
    }

    @Override
    public Point getFirstPoint() {
        return this;
    }

    @Override
    public Point getLastPoint() {
        return this;
    }

    @Override
    public int numPoints() {
        return 1;
    }

    public Point() {
        super(1);
    }

    public Point(double d2, double d3, double d4) {
        this();
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.dimension = 3;
    }

    public Point(double d2, double d3) {
        this();
        this.x = d2;
        this.y = d3;
        this.z = 0.0;
        this.dimension = 2;
    }

    public Point(String string) throws SQLException {
        this(string, false);
    }

    protected Point(String object, boolean bl) throws SQLException {
        this();
        object = this.initSRID((String)object);
        if (((String)object).indexOf("POINTM") == 0) {
            bl = true;
            object = ((String)object).substring(6).trim();
        } else if (((String)object).indexOf("POINT") == 0) {
            object = ((String)object).substring(5).trim();
        }
        object = GeometryTokenizer.removeLeadingAndTrailingStrings((String)object, "(", ")");
        object = GeometryTokenizer.tokenize((String)object, ' ');
        try {
            this.x = Double.parseDouble((String)object.get(0));
            this.y = Double.parseDouble((String)object.get(1));
            if (object.size() == 3 && !(bl |= object.size() == 4) || object.size() == 4) {
                this.z = Double.parseDouble((String)object.get(2));
                this.dimension = 3;
            } else {
                this.dimension = 2;
            }
            if (bl) {
                this.m = Double.parseDouble((String)object.get(this.dimension));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Error parsing Point: " + numberFormatException.toString());
        }
        this.haveMeasure = bl;
    }

    @Override
    public void innerWKT(StringBuffer stringBuffer) {
        stringBuffer.append(this.x);
        Point.cutint(stringBuffer);
        stringBuffer.append(' ');
        stringBuffer.append(this.y);
        Point.cutint(stringBuffer);
        if (this.dimension == 3) {
            stringBuffer.append(' ');
            stringBuffer.append(this.z);
            Point.cutint(stringBuffer);
        }
        if (this.haveMeasure) {
            stringBuffer.append(' ');
            stringBuffer.append(this.m);
            Point.cutint(stringBuffer);
        }
    }

    private static void cutint(StringBuffer stringBuffer) {
        int n2 = stringBuffer.length() - 2;
        if (stringBuffer.charAt(n2 + 1) == '0' && stringBuffer.charAt(n2) == '.') {
            stringBuffer.setLength(n2);
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getM() {
        return this.m;
    }

    public void setX(double d2) {
        this.x = d2;
    }

    public void setY(double d2) {
        this.y = d2;
    }

    public void setZ(double d2) {
        this.z = d2;
    }

    public void setM(double d2) {
        this.haveMeasure = true;
        this.m = d2;
    }

    public void setX(int n2) {
        this.x = n2;
    }

    public void setY(int n2) {
        this.y = n2;
    }

    public void setZ(int n2) {
        this.z = n2;
    }

    public double distance(Point point) {
        if (this.dimension != point.dimension) {
            throw new IllegalArgumentException("Points have different dimensions!");
        }
        double d2 = this.x - point.x;
        switch (this.dimension) {
            case 1: {
                double d3 = d2;
                return Math.sqrt(d3 * d3);
            }
            case 2: {
                double d4 = this.y - point.y;
                double d5 = d2;
                double d6 = d4;
                return Math.sqrt(d5 * d5 + d6 * d6);
            }
            case 3: {
                double d7 = this.y - point.y;
                double d8 = this.z - point.z;
                double d9 = d2;
                double d10 = d7;
                double d11 = d8;
                return Math.sqrt(d9 * d9 + d10 * d10 + d11 * d11);
            }
        }
        throw new IllegalArgumentException("Illegal dimension of Point" + this.dimension);
    }

    @Override
    public boolean checkConsistency() {
        return !(!super.checkConsistency() || this.dimension != 3 && this.z != 0.0 || !this.haveMeasure && this.m != 0.0);
    }
}

