/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class BlogResultSet {
    protected String curFile;
    protected long curPos;
    protected byte[] curData;
    protected RandomAccessFile output;
    private String exportFile = "tmp.txt";
    private FileChannel fileChannel;
    private ByteBuffer byteBuffer;
    private boolean isExportEnd = false;

    public BlogResultSet(String string) {
        this.exportFile = string;
        this.byteBuffer = ByteBuffer.allocate(0x100000);
    }

    public String getCurFile() {
        return this.curFile;
    }

    public void setCurFile(String string) {
        this.curFile = string;
    }

    public long getCurPos() {
        return this.curPos;
    }

    public void setCurPos(long l2) {
        this.curPos = l2;
    }

    public byte[] getCurData() {
        return this.curData;
    }

    public void setCurData(byte[] byArray) {
        IOException iOException;
        this.curData = byArray;
        if (this.output == null || this.fileChannel == null) {
            try {
                this.output = new RandomAccessFile(this.exportFile, "rw");
                this.fileChannel = this.output.getChannel();
            }
            catch (FileNotFoundException fileNotFoundException) {
                iOException = fileNotFoundException;
                fileNotFoundException.printStackTrace();
            }
        }
        try {
            boolean bl;
            do {
                bl = false;
                if (byArray.length + this.byteBuffer.position() >= this.byteBuffer.capacity()) {
                    if (this.byteBuffer.position() == 0) {
                        this.fileChannel.write(ByteBuffer.wrap(byArray));
                        continue;
                    }
                    this.flushBuffer();
                    bl = true;
                    continue;
                }
                this.byteBuffer.put(byArray);
            } while (bl);
            return;
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            iOException2.printStackTrace();
            return;
        }
    }

    private void flushBuffer() throws IOException {
        this.byteBuffer.flip();
        while (this.byteBuffer.hasRemaining()) {
            this.fileChannel.write(this.byteBuffer);
        }
        this.byteBuffer.clear();
    }

    public void setOutputFileSeek(long l2) {
        if (this.output != null) {
            try {
                if (this.byteBuffer.position() > 0) {
                    this.flushBuffer();
                }
                this.fileChannel.force(true);
                this.fileChannel.truncate(l2);
                Driver.writeLog("curFile:" + this.curFile + ":::Truncated pos::" + l2);
                return;
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                iOException.printStackTrace();
            }
        }
    }

    /*
     * Loose catch block
     */
    public void close() {
        block18: {
            this.curData = null;
            if (this.output != null) {
                IOException iOException;
                block17: {
                    if (this.byteBuffer.position() <= 0) break block17;
                    this.flushBuffer();
                }
                try {
                    this.fileChannel.force(true);
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                    iOException2.printStackTrace();
                }
                try {
                    this.fileChannel.close();
                    this.output.close();
                }
                catch (IOException iOException3) {
                    iOException = iOException3;
                    iOException3.printStackTrace();
                }
                this.byteBuffer = null;
                break block18;
                catch (IOException iOException4) {
                    IOException iOException5;
                    try {
                        iOException5 = iOException4;
                        iOException4.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        IOException iOException6;
                        try {
                            this.fileChannel.force(true);
                        }
                        catch (IOException iOException7) {
                            iOException6 = iOException7;
                            iOException7.printStackTrace();
                        }
                        try {
                            this.fileChannel.close();
                            this.output.close();
                        }
                        catch (IOException iOException8) {
                            iOException6 = iOException8;
                            iOException8.printStackTrace();
                        }
                        this.byteBuffer = null;
                        throw throwable;
                    }
                    try {
                        this.fileChannel.force(true);
                    }
                    catch (IOException iOException9) {
                        iOException5 = iOException9;
                        iOException9.printStackTrace();
                    }
                    try {
                        this.fileChannel.close();
                        this.output.close();
                    }
                    catch (IOException iOException10) {
                        iOException5 = iOException10;
                        iOException10.printStackTrace();
                    }
                    this.byteBuffer = null;
                }
            }
        }
        this.output = null;
    }

    public boolean getIsExportEnd() {
        return this.isExportEnd;
    }

    public void setIsExportEnd(boolean bl) {
        this.isExportEnd = bl;
    }
}

