/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.core.ExportBinaryCallback;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CSVExportBinaryCallback
implements ExportBinaryCallback {
    OutputStream out;
    byte[] colSepByte;
    byte[] rowSepByte;
    char escape = (char)34;
    boolean useEscape = false;
    private byte[] columnBuffer = new byte[16384];
    int colPosition = 0;
    boolean hasHeadColumn = false;

    public CSVExportBinaryCallback(String string, String string2, String string3, Character c2, boolean bl, boolean bl2) throws IOException {
        this(string, string2, string3, c2, bl);
        this.hasHeadColumn = bl2;
    }

    public CSVExportBinaryCallback(String object, String string, String string2, Character c2, boolean bl) throws IOException {
        this.colSepByte = string.getBytes();
        this.rowSepByte = string2.getBytes();
        if (c2 != null) {
            this.useEscape = true;
            this.escape = c2.charValue();
        }
        if (!((File)(object = new File((String)object))).exists()) {
            ((File)object).createNewFile();
        }
        this.out = new BufferedOutputStream(new FileOutputStream((File)object, bl));
    }

    public CSVExportBinaryCallback(String string, String string2, String string3, boolean bl, int n2) throws IOException {
        this(string, string2, string3, null, bl);
    }

    @Override
    public void processColumn(int n2, int n3, byte[] byArray) throws IOException {
        this.writeColumn(byArray);
    }

    @Override
    public void processEndColumn() throws IOException {
        this.out.write(this.colSepByte);
    }

    @Override
    public void processEndRow(long l2) throws IOException {
        this.out.write(this.rowSepByte);
    }

    @Override
    public void processEnd() throws IOException {
        this.out.close();
        this.columnBuffer = null;
    }

    public void writeColumn(byte[] byArray) throws IOException {
        if (byArray != null && this.useEscape) {
            boolean bl = false;
            boolean bl2 = false;
            int n2 = byArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3;
                if (byArray[i2] == this.escape) {
                    bl = true;
                    this.columnBuffer[this.colPosition++] = byArray[i2];
                    this.columnBuffer[this.colPosition++] = byArray[i2];
                    continue;
                }
                int n4 = i2;
                if (bl) {
                    this.columnBuffer[this.colPosition++] = byArray[i2];
                    continue;
                }
                if (n2 - i2 >= this.colSepByte.length) {
                    n3 = 0;
                    while (n3 < this.colSepByte.length) {
                        if (this.colSepByte[n3] != byArray[i2]) {
                            i2 = n4;
                            break;
                        }
                        if (n3 == this.colSepByte.length - 1) {
                            bl2 = true;
                            bl = true;
                        }
                        ++n3;
                        ++i2;
                    }
                }
                if (!bl2 && n2 - i2 >= this.rowSepByte.length) {
                    n3 = 0;
                    while (n3 < this.rowSepByte.length) {
                        if (this.rowSepByte[n3] != byArray[i2]) {
                            i2 = n4;
                            break;
                        }
                        if (n3 == this.rowSepByte.length - 1) {
                            bl = true;
                        }
                        ++n3;
                        ++i2;
                    }
                }
                if (n4 == i2) {
                    this.columnBuffer[this.colPosition++] = byArray[i2];
                    continue;
                }
                System.arraycopy(byArray, n4, this.columnBuffer, this.colPosition, i2 - n4 + 1);
            }
            if (bl) {
                this.out.write(this.escape);
                this.out.write(this.columnBuffer, 0, this.colPosition);
                this.out.write(this.escape);
            } else {
                this.out.write(this.columnBuffer, 0, this.colPosition);
            }
            this.colPosition = 0;
        }
    }

    @Override
    public boolean hasHeadColumn() {
        return this.hasHeadColumn;
    }
}

