/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.core.ExportStringCallback;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class CSVExportStringCallback
implements ExportStringCallback {
    Writer writer;
    String colSep;
    String rowSep;
    char escape = (char)34;
    boolean useEscape = false;
    char[] columnBuffer = new char[16384];
    int colPosition = 0;
    boolean hasHeadColumn = false;

    public CSVExportStringCallback(String string, String string2, String string3, Character c2, boolean bl, boolean bl2) throws IOException {
        this(string, string2, string3, c2, bl);
        this.hasHeadColumn = bl2;
    }

    public CSVExportStringCallback(String object, String string, String string2, Character c2, boolean bl) throws IOException {
        this.colSep = string;
        this.rowSep = string2;
        if (c2 != null) {
            this.useEscape = true;
            this.escape = c2.charValue();
        }
        if (!((File)(object = new File((String)object))).exists()) {
            ((File)object).createNewFile();
        }
        this.writer = new BufferedWriter(new FileWriter((File)object, bl));
    }

    public CSVExportStringCallback(String string, String string2, String string3, boolean bl) throws IOException {
        this(string, string2, string3, null, bl);
    }

    @Override
    public void processEndColumn() throws IOException {
        this.writer.write(this.colSep);
    }

    @Override
    public void processEndRow(long l2) throws IOException {
        this.writer.write(this.rowSep);
    }

    @Override
    public void processEnd() throws IOException {
        this.writer.close();
        this.columnBuffer = null;
    }

    @Override
    public void processColumn(int n2, int n3, String string) throws IOException {
        if (string != null) {
            if (this.useEscape) {
                n3 = 0;
                if (string.indexOf(this.colSep) >= 0 || string.indexOf(this.rowSep) >= 0) {
                    n3 = 1;
                }
                char[] cArray = string.toCharArray();
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    if (cArray[i2] == this.escape) {
                        this.columnBuffer[this.colPosition++] = cArray[i2];
                        this.columnBuffer[this.colPosition++] = cArray[i2];
                        n3 = 1;
                        continue;
                    }
                    this.columnBuffer[this.colPosition++] = cArray[i2];
                }
                if (n3 != 0) {
                    this.writer.write(this.escape);
                    this.writer.write(this.columnBuffer, 0, this.colPosition);
                    this.writer.write(this.escape);
                } else {
                    this.writer.write(cArray, 0, this.colPosition);
                }
                this.colPosition = 0;
                return;
            }
            this.writer.write(string);
        }
    }

    @Override
    public boolean hasHeadColumn() {
        return this.hasHeadColumn;
    }
}

