/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.core.ImportDataProvider;
import com.oscar.util.ImportDataContainer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CSVImportBinaryProvider
implements ImportDataProvider {
    InputStream input;
    byte[] colSepByte;
    byte[] rowSepByte;
    char escape = (char)34;
    boolean useEscape = false;
    private byte[] dataBuffer = new byte[16384];
    byte[] columnBuffer = new byte[8192];
    List rows = new ArrayList();
    List current_row;
    Iterator it;
    int rowPosition = -1;
    int byteLength = 0;
    int position = 0;
    int colPosition = 0;
    int fetchSize = 1000;
    String fileEncoding = null;
    boolean hasHeadColumn = false;

    public CSVImportBinaryProvider(String string, String string2, String string3, Character c2, Charset charset, boolean bl) throws IOException {
        this(string, string2, string3, c2, charset);
        this.hasHeadColumn = bl;
    }

    public CSVImportBinaryProvider(String string, String string2, String string3, Character c2) throws IOException {
        this(new BufferedInputStream(new FileInputStream(new File(string))), string2, string3, c2);
    }

    public CSVImportBinaryProvider(String string, String string2, String string3) throws IOException {
        this(string, string2, string3, null);
    }

    public CSVImportBinaryProvider(InputStream inputStream, String string, String string2, Character c2) throws IOException {
        this.colSepByte = string.getBytes();
        this.rowSepByte = string2.getBytes();
        if (c2 != null) {
            this.useEscape = true;
            this.escape = c2.charValue();
        }
        this.input = inputStream;
        this.parse();
    }

    public CSVImportBinaryProvider(String string, String string2, String string3, Character c2, Charset charset) throws IOException {
        this(string, string2, string3, c2);
        this.fileEncoding = charset.name();
    }

    @Override
    public int setNextColumnData(ImportDataContainer importDataContainer) {
        try {
            if (this.it.hasNext()) {
                importDataContainer.setDataType(2);
                importDataContainer.setData(this.it.next());
                return 1;
            }
            return 4;
        }
        catch (Exception exception) {
            return 2;
        }
    }

    @Override
    public boolean nextRow() throws IOException {
        if (++this.rowPosition < this.rows.size()) {
            this.current_row = (List)this.rows.get(this.rowPosition);
            this.it = this.current_row.iterator();
            return true;
        }
        this.rowPosition = 0;
        this.parse();
        if (this.rows.size() > 0) {
            this.current_row = (List)this.rows.get(this.rowPosition);
            this.it = this.current_row.iterator();
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parse() throws IOException {
        int n2;
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        byte[] cfr_ignored_0 = new byte[0];
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n7 = this.colSepByte.length > this.rowSepByte.length ? this.colSepByte.length : this.rowSepByte.length;
        int n8 = String.valueOf(this.colSepByte).indexOf(String.valueOf(this.rowSepByte)) < 0 ? 0 : 1;
        this.rows.clear();
        ArrayList arrayList = new ArrayList(0);
        block4: while (n4 != -1) {
            int n9;
            n4 = this.input.read(this.dataBuffer, this.position, this.dataBuffer.length - this.position);
            if (n4 == -1) {
                n9 = this.position;
                n5 = this.position;
                if (bl3) {
                    bl3 = false;
                }
            } else {
                n9 = n4 + this.position;
                this.position = 0;
            }
            for (n2 = 0; n2 < n9; ++n2) {
                if (n4 != -1 && n2 >= n9 - n7) {
                    this.swap(n9);
                    bl3 = false;
                    continue block4;
                }
                int n10 = n2;
                if (bl3) {
                    if (this.dataBuffer[n2] == this.escape) {
                        if (this.dataBuffer[++n2] == this.escape) {
                            this.columnBuffer[this.colPosition++] = (byte)this.escape;
                            if (n2 != n9 - 1) continue;
                            --n2;
                            continue;
                        }
                        --n2;
                        bl3 = false;
                        continue;
                    }
                    this.columnBuffer[this.colPosition++] = this.dataBuffer[n2];
                    continue;
                }
                if (this.useEscape && this.dataBuffer[n2] == this.escape) {
                    bl3 = true;
                    continue;
                }
                switch (n8) {
                    case 0: {
                        int n11;
                        for (n11 = 0; n11 < this.colSepByte.length; ++n2, ++n11) {
                            if (this.dataBuffer[n2] == this.colSepByte[n11]) {
                                bl = true;
                                continue;
                            }
                            bl = false;
                            break;
                        }
                        if (bl) {
                            this.byteLength += n2 - this.position - this.colSepByte.length;
                            byte[] byArray = new byte[this.colPosition];
                            System.arraycopy(this.columnBuffer, 0, byArray, 0, this.colPosition);
                            this.addColumn(n3++, byArray, arrayList);
                            byte[] cfr_ignored_1 = new byte[0];
                            this.position = n2--;
                            this.colPosition = 0;
                            bl4 = true;
                        } else {
                            n2 = n10;
                            for (n11 = 0; n11 < this.rowSepByte.length; ++n2, ++n11) {
                                if (this.dataBuffer[n2] == this.rowSepByte[n11]) {
                                    bl2 = true;
                                    continue;
                                }
                                bl2 = false;
                                break;
                            }
                            if (bl2) {
                                this.byteLength += n2 - this.position - this.rowSepByte.length;
                                byte[] byArray = new byte[this.colPosition];
                                System.arraycopy(this.columnBuffer, 0, byArray, 0, this.colPosition);
                                this.addColumn(n3++, byArray, arrayList);
                                byte[] cfr_ignored_2 = new byte[0];
                                this.position = n2--;
                                this.colPosition = 0;
                                bl4 = false;
                                this.addRow(arrayList);
                                if (++n6 == this.fetchSize) {
                                    this.swap(n9);
                                    break block4;
                                }
                                arrayList = new ArrayList();
                                n3 = 1;
                            } else {
                                this.columnBuffer[this.colPosition++] = this.dataBuffer[n2];
                            }
                        }
                        bl = false;
                        bl2 = false;
                        if (this.position != n9) break;
                        this.position = 0;
                        break;
                    }
                    case 1: {
                        int n11;
                        for (n11 = 0; n11 < this.rowSepByte.length; ++n2, ++n11) {
                            if (this.dataBuffer[n2] == this.rowSepByte[n11]) {
                                bl2 = true;
                                continue;
                            }
                            bl2 = false;
                            break;
                        }
                        if (bl2) {
                            this.byteLength += n2 - this.position - this.rowSepByte.length;
                            byte[] byArray = new byte[this.colPosition];
                            System.arraycopy(this.columnBuffer, 0, byArray, 0, this.colPosition);
                            this.addColumn(n3++, byArray, arrayList);
                            byte[] cfr_ignored_3 = new byte[0];
                            this.position = n2--;
                            this.colPosition = 0;
                            bl4 = false;
                            this.addRow(arrayList);
                            if (++n6 == this.fetchSize) {
                                this.swap(n9);
                                break block4;
                            }
                            arrayList = new ArrayList();
                            n3 = 1;
                        } else {
                            n2 = n10;
                            for (n11 = 0; n11 < this.colSepByte.length; ++n2, ++n11) {
                                if (this.dataBuffer[n2] == this.colSepByte[n11]) {
                                    bl = true;
                                    continue;
                                }
                                bl = false;
                                break;
                            }
                            if (bl) {
                                this.byteLength += n2 - this.position - this.colSepByte.length;
                                byte[] byArray = new byte[this.colPosition];
                                System.arraycopy(this.columnBuffer, 0, byArray, 0, this.colPosition);
                                this.addColumn(n3++, byArray, arrayList);
                                byte[] cfr_ignored_4 = new byte[0];
                                this.position = n2--;
                                this.colPosition = 0;
                                bl4 = true;
                            } else {
                                this.columnBuffer[this.colPosition++] = this.dataBuffer[n2];
                            }
                        }
                        bl = false;
                        bl2 = false;
                        if (this.position != n9) break;
                        this.position = 0;
                    }
                }
            }
        }
        if (bl4) {
            byte[] byArray;
            this.colPosition = 0;
            bl3 = this.useEscape && n5 >= 2 && this.dataBuffer[0] == this.escape;
            if (!bl3) {
                byArray = new byte[n5];
                System.arraycopy(this.dataBuffer, 0, byArray, 0, n5);
            } else {
                for (n2 = 1; n2 < n5; ++n2) {
                    if (this.dataBuffer[n2] == this.escape) {
                        if (n2 == n5 - 1 || this.dataBuffer[++n2] != this.escape) break;
                        this.columnBuffer[this.colPosition++] = (byte)this.escape;
                        continue;
                    }
                    this.columnBuffer[this.colPosition++] = this.dataBuffer[n2];
                }
                byArray = new byte[this.colPosition];
                System.arraycopy(this.columnBuffer, 0, byArray, 0, this.colPosition);
            }
            this.addColumn(n3, byArray, arrayList);
            this.addRow(arrayList);
        }
    }

    private void swap(int n2) {
        System.arraycopy(this.dataBuffer, this.position, this.dataBuffer, 0, n2 - this.position);
        this.position = n2 - this.position;
        this.colPosition = 0;
    }

    private void addColumn(int n2, byte[] byArray, List list) {
        if (byArray.length != 0) {
            list.add(byArray);
            return;
        }
        list.add(null);
    }

    private void addRow(List list) {
        this.rows.add(list);
    }

    public void setFetchSize(int n2) {
        this.fetchSize = n2;
    }

    @Override
    public void close() throws IOException {
        this.dataBuffer = null;
        this.columnBuffer = null;
        this.input.close();
    }

    @Override
    public String getFileEncoding() {
        if (this.fileEncoding == null) {
            return System.getProperty("file.encoding");
        }
        return this.fileEncoding;
    }

    @Override
    public boolean hasHeadColumn() {
        return this.hasHeadColumn;
    }
}

