/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.jdbc.OscarArray;
import com.oscar.util.OSQLException;
import com.oscar.util.TypeConverter;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class ConnectionArray
extends OscarArray {
    private String typeName;
    private BaseConnection conn;
    private Object[] elements;
    private Calendar localCalendar;

    public ConnectionArray(BaseConnection baseConnection, String charSequence, Object[] objectArray) {
        this.typeName = charSequence;
        this.conn = baseConnection;
        this.elements = objectArray;
        charSequence = new StringBuffer();
        this.appendArray((StringBuffer)charSequence, objectArray);
        this.rawString = ((StringBuffer)charSequence).toString();
        this.localCalendar = baseConnection.getCalendar();
    }

    private void appendArray(StringBuffer stringBuffer, Object object) {
        stringBuffer.append('{');
        int n2 = Array.getLength(object);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2;
            if (i2 > 0) {
                stringBuffer.append(',');
            }
            if ((object2 = Array.get(object, i2)) == null) {
                stringBuffer.append("NULL");
                continue;
            }
            if (object2.getClass().isArray()) {
                this.appendArray(stringBuffer, object2);
                continue;
            }
            object2 = object2.toString();
            this.escapeArrayElement(stringBuffer, (String)object2);
        }
        stringBuffer.append('}');
    }

    private void escapeArrayElement(StringBuffer stringBuffer, String string) {
        stringBuffer.append('\"');
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\"' || c2 == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c2);
        }
        stringBuffer.append('\"');
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.typeName;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.conn.getSQLType(((OscarArray)this).getBaseTypeName());
    }

    @Override
    public Object getArray() throws SQLException {
        if (this.elements != null) {
            return ((OscarArray)this).getArray(1L, this.elements.length, null);
        }
        return ((OscarArray)this).getArray(1L, 0, null);
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return ((OscarArray)this).getArray(1L, 0, map);
    }

    @Override
    public Object getArray(long l2, int n2) throws SQLException {
        return ((OscarArray)this).getArray(l2, n2, null);
    }

    @Override
    public Object getArray(long l2, int n2, Map<String, Class<?>> objectArray) throws SQLException {
        this.checkFree();
        if (objectArray != null) {
            throw Driver.notImplemented();
        }
        if (l2 < 1L) {
            throw new OSQLException("OSCAR-00304", "88888", 304);
        }
        if (--l2 + (long)n2 > (long)this.elements.length) {
            throw new OSQLException("OSCAR-00304", "888880", 304);
        }
        int n3 = 0;
        switch (((OscarArray)this).getBaseType()) {
            case -7: 
            case 16: {
                objectArray = new Boolean[n2];
                while (n2 > 0) {
                    ((Boolean[])objectArray)[n3++] = TypeConverter.toBoolean(this.elements[(int)l2++].toString(), -7);
                    --n2;
                }
                break;
            }
            case 4: 
            case 5: {
                objectArray = new Integer[n2];
                while (n2 > 0) {
                    ((Integer[])objectArray)[n3++] = TypeConverter.toInt(this.elements[(int)l2++].toString(), 4);
                    --n2;
                }
                break;
            }
            case -5: {
                objectArray = new Long[n2];
                while (n2 > 0) {
                    ((Long[])objectArray)[n3++] = TypeConverter.toLong(this.elements[(int)l2++].toString(), -5);
                    --n2;
                }
                break;
            }
            case 2: 
            case 3: {
                objectArray = new BigDecimal[n2];
                while (n2 > 0) {
                    ((BigDecimal[])objectArray)[n3++] = TypeConverter.toBigDecimal(this.elements[(int)l2++].toString(), 2);
                    --n2;
                }
                break;
            }
            case 7: {
                objectArray = new Float[n2];
                while (n2 > 0) {
                    ((Float[])objectArray)[n3++] = Float.valueOf(TypeConverter.toFloat(this.elements[(int)l2++].toString(), 7));
                    --n2;
                }
                break;
            }
            case 8: {
                objectArray = new Double[n2];
                while (n2 > 0) {
                    ((Double[])objectArray)[n3++] = TypeConverter.toDouble(this.elements[(int)l2++].toString(), 8);
                    --n2;
                }
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                objectArray = new String[n2];
                while (n2 > 0) {
                    ((String[])objectArray)[n3++] = this.elements[(int)l2++].toString();
                    --n2;
                }
                break;
            }
            case 91: {
                objectArray = new Date[n2];
                while (n2 > 0) {
                    ((Date[])objectArray)[n3++] = TypeConverter.toDate(this.elements[(int)l2++].toString(), 91);
                    --n2;
                }
                break;
            }
            case 92: {
                objectArray = new Time[n2];
                while (n2 > 0) {
                    ((Time[])objectArray)[n3++] = TypeConverter.toTime(this.elements[(int)l2++].toString(), 92, this.localCalendar);
                    --n2;
                }
                break;
            }
            case 93: {
                objectArray = new Timestamp[n2];
                while (n2 > 0) {
                    ((Timestamp[])objectArray)[n3++] = TypeConverter.toTimestamp(this.elements[(int)l2++].toString(), 93, this.localCalendar);
                    --n2;
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        return objectArray;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return ((OscarArray)this).getResultSet(1L, 0, null);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return ((OscarArray)this).getResultSet(1L, 0, map);
    }

    @Override
    public ResultSet getResultSet(long l2, int n2) throws SQLException {
        return ((OscarArray)this).getResultSet(l2, n2, null);
    }

    @Override
    public ResultSet getResultSet(long l2, int n2, Map<String, Class<?>> map) throws SQLException {
        ResultSet resultSet;
        this.checkFree();
        if (2 == this.conn.getProtocolVersion().getProtocolType()) {
            ConnectionArray connectionArray = this;
            resultSet = connectionArray.getResultSetV2(connectionArray.conn, l2, n2, map);
        } else {
            ConnectionArray connectionArray = this;
            resultSet = connectionArray.getResultSetV1(connectionArray.conn, l2, n2, map);
        }
        return resultSet;
    }

    @Override
    public void free() throws SQLException {
        this.typeName = null;
        this.elements = null;
        this.free = true;
    }
}

