/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import java.net.SocketException;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;

public abstract class ExceptionUtil {
    public static final int STATE_CLOSED_NO = 0;
    public static final int STATE_CLOSED_YES = 1;
    public static final int STATE_DISCONNECTIONED = 2;

    public static int isConnectionClosed(Exception exception) {
        if (!(exception instanceof SQLException)) {
            return 0;
        }
        if (exception instanceof SQLRecoverableException) {
            return 1;
        }
        if ("08003".equals(((SQLException)(exception = (SQLException)exception)).getSQLState())) {
            if (((SQLException)exception).getErrorCode() == 211) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static int isConnectionClosed(Throwable throwable) {
        if (!(throwable instanceof SQLException)) {
            return 0;
        }
        if ("08003".equals(((SQLException)(throwable = (SQLException)throwable)).getSQLState())) {
            if (((SQLException)throwable).getErrorCode() == 211) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static boolean isSocketConnectionError(Throwable throwable) {
        SocketException socketException = null;
        if (throwable instanceof SocketException) {
            socketException = (SocketException)throwable;
        } else if (throwable.getCause() instanceof SocketException) {
            socketException = (SocketException)throwable.getCause();
        }
        if (socketException != null) {
            if (socketException.getMessage().startsWith("Software caused connection abort: ")) {
                return true;
            }
            if (socketException.getMessage().startsWith("Connection reset")) {
                return true;
            }
            if (throwable.getMessage().contains("Broken pipe") || throwable.getMessage().contains("\u65ad\u5f00\u7684\u7ba1\u9053")) {
                return true;
            }
        } else if (throwable.getMessage().contains("system closing")) {
            return true;
        }
        return false;
    }
}

