/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.util.Node;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class MetaData {
    private Connection conn;
    private HashMap<Integer, Node> nodeList;

    public MetaData() {
    }

    public MetaData(Connection connection) throws SQLException {
        this.conn = connection;
        this.initClusterNodeList();
    }

    public void initClusterNodeList() throws SQLException {
        ResultSet resultSet = this.executeQuery("SELECT * from CSYS_NODE");
        this.nodeList = new HashMap();
        while (resultSet.next()) {
            int n2 = resultSet.getInt("nodeid");
            Object object = resultSet.getString("host");
            int n3 = resultSet.getInt("port");
            String string = resultSet.getString("driver");
            String string2 = resultSet.getString("url");
            object = new Node(n2, (String)object, n3, string, string2);
            this.nodeList.put(n2, (Node)object);
        }
    }

    public ResultSet executeQuery(String object) throws SQLException {
        try (PreparedStatement preparedStatement = null;){
            preparedStatement = this.conn.prepareStatement((String)object);
            object = preparedStatement.executeQuery();
        }
        return object;
    }

    public ResultSet executeQuery(String string, String ... stringArray) throws SQLException {
        ResultSet resultSet;
        try (PreparedStatement preparedStatement = null;){
            preparedStatement = this.conn.prepareStatement(string);
            if (stringArray != null) {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    preparedStatement.setString(i2 + 1, stringArray[i2]);
                }
            }
            resultSet = preparedStatement.executeQuery();
        }
        return resultSet;
    }

    public int executeUpdate(String string) throws SQLException {
        int n2;
        try (PreparedStatement preparedStatement = null;){
            preparedStatement = this.conn.prepareStatement(string);
            n2 = preparedStatement.executeUpdate();
        }
        return n2;
    }

    public String getUrl(Integer n2) {
        return this.nodeList.get(n2).getUrl();
    }

    public HashMap<Integer, Node> getNodeList() {
        return this.nodeList;
    }
}

