/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.core.BaseConnection;
import com.oscar.jdbc.OscarBlob;
import com.oscar.jdbc.OscarClob;
import com.oscar.jdbc.OscarLob;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.jdbc.OscarStatement;
import com.oscar.util.InputStreamHandle;
import com.oscar.util.StreamHandle;
import com.oscar.util.TableNameParser;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class OSCARTransfer {
    private String[] columnTypes = null;
    private List<String> rows = new LinkedList<String>();
    private String table;
    private long tableOid;
    private Connection conn;
    private boolean closed;
    private StringBuffer buf = new StringBuffer(128);
    private Statement st;
    private static final int DEFAULT_LOB_BUF_SIZE = 633600;
    private int colIndex = -1;
    private ArrayList tempLobList = new ArrayList();

    public OSCARTransfer(Connection connection) {
        this.conn = connection;
    }

    public void setColumnType(String string, String[] stringArray) throws SQLException {
        if (stringArray == null) {
            throw new SQLException("oscar.tran.notype", "HY000", 1);
        }
        this.setTable(string);
        this.columnTypes = stringArray;
    }

    public void setTable(String string) throws SQLException {
        this.table = string;
        Object object = TableNameParser.parserToQueryString(string);
        object = "SELECT C.OID FROM V_SYS_CLASS C, V_SYS_NAMESPACE N  WHERE C.RELNAME=" + object[1] + " AND C.RELKIND='r' AND N.NSPNAME=" + object[0] + " AND C.RELNAMESPACE=N.OID";
        if (((OscarResultSet)(object = (OscarResultSet)((BaseConnection)((Object)this.conn)).execSQL((String)object))).next()) {
            this.tableOid = ((OscarResultSet)object).getLong(1);
            return;
        }
        throw new SQLException("\u8868" + string + "\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728");
    }

    public void addRow(Object[] objectArray) throws SQLException {
        if (objectArray == null) {
            throw new SQLException("oscar.tran.notype", "HY000", 1);
        }
        if (objectArray.length != this.columnTypes.length) {
            throw new SQLException("oscar.tran.lengtherror", "HY000", 1);
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            this.colIndex = i2 + 1;
            if (objectArray[i2] != null) {
                Object object;
                if (objectArray[i2] instanceof String) {
                    object = ((String)objectArray[i2]).trim();
                    if (!((String)object).equalsIgnoreCase("null")) {
                        String string;
                        if (this.columnTypes[i2].equalsIgnoreCase("blob")) {
                            String string2 = ((String)object).substring(1, ((String)object).length() - 1);
                            string = this.createBlob(string2);
                            objectArray[i2] = string;
                        } else if (this.columnTypes[i2].equalsIgnoreCase("clob")) {
                            String string3 = ((String)object).substring(1, ((String)object).length() - 1);
                            string = this.createClob(string3);
                            objectArray[i2] = string;
                        }
                    } else {
                        objectArray[i2] = "";
                    }
                } else if (objectArray[i2] instanceof InputStream) {
                    try {
                        object = (InputStream)objectArray[i2];
                        if (this.columnTypes[i2].equalsIgnoreCase("blob")) {
                            long l2 = InputStreamHandle.readLong((InputStream)object);
                            objectArray[i2] = object = this.createBlob((InputStream)object, l2);
                        }
                        if (this.columnTypes[i2].equalsIgnoreCase("clob")) {
                            long l3 = InputStreamHandle.readLong((InputStream)object);
                            objectArray[i2] = object = this.createClob((InputStream)object, l3);
                        }
                        throw new SQLException("oscar.tran.notype", "HY000", 1);
                    }
                    catch (IOException iOException) {
                        throw new SQLException("oscar.trans:" + iOException.toString());
                    }
                } else if (objectArray[i2] instanceof Reader) {
                    object = (Reader)objectArray[i2];
                    if (this.columnTypes[i2].equalsIgnoreCase("clob")) {
                        String string = this.createClob((Reader)object, -1L);
                        objectArray[i2] = string;
                    }
                } else if (objectArray[i2] instanceof StringBuffer) {
                    if (this.columnTypes[i2].equalsIgnoreCase("clob")) {
                        object = ((StringBuffer)objectArray[i2]).toString();
                        objectArray[i2] = this.createClob(new StringReader((String)object), (long)((String)object).length());
                    }
                } else if (objectArray[i2] instanceof byte[]) {
                    if (this.columnTypes[i2].equalsIgnoreCase("blob")) {
                        objectArray[i2] = this.createBlob(new ByteArrayInputStream((byte[])objectArray[i2]), ((byte[])objectArray[i2]).length);
                    }
                } else if (objectArray[i2] instanceof Blob) {
                    object = (Blob)objectArray[i2];
                    objectArray[i2] = this.createBlob(object.getBinaryStream(), object.length());
                } else if (objectArray[i2] instanceof Clob) {
                    object = (Clob)objectArray[i2];
                    objectArray[i2] = this.createClob(object.getCharacterStream(), object.length());
                }
            } else {
                objectArray[i2] = "";
            }
            this.buf.append(objectArray[i2]);
            if (i2 >= objectArray.length - 1) continue;
            this.buf.append(',');
        }
        this.buf.append('\n');
        this.rows.add(this.buf.toString());
        this.buf.setLength(0);
    }

    public void setRow(String[] stringArray) throws SQLException {
        this.addRow(stringArray);
    }

    private String createBlob(String object) throws SQLException {
        try {
            object = new FileInputStream((String)object);
        }
        catch (IOException iOException) {
            throw new SQLException("oscar.trans" + iOException.toString());
        }
        return this.createBlob((InputStream)object, -1L);
    }

    private String createBlob(InputStream inputStream, long l2) throws SQLException {
        Object object = (BaseConnection)((Object)this.conn);
        object = object.getVersion().isHaveEmptyXlobWithOid() ? OscarBlob.createForTable(this.conn, this.tableOid, this.colIndex) : object.createTempBlob(true, 0);
        this.tempLobList.add(object);
        OutputStream outputStream = ((OscarLob)object).setBinaryStream(1L);
        try {
            StreamHandle.write(outputStream, inputStream, l2, 633600);
        }
        catch (IOException iOException) {
            throw new SQLException("oscar.trans:" + iOException.toString());
        }
        return ((OscarLob)object).getLocatorStr();
    }

    private String createClob(String object) throws SQLException {
        try {
            object = new FileInputStream((String)object);
        }
        catch (IOException iOException) {
            throw new SQLException("oscar.trans" + iOException.toString());
        }
        return this.createClob((InputStream)object, -1L);
    }

    private String createClob(InputStream inputStream, long l2) throws SQLException {
        Object object = (BaseConnection)((Object)this.conn);
        object = object.getVersion().isHaveEmptyXlobWithOid() ? OscarClob.createForTable(this.conn, this.tableOid, this.colIndex) : object.createTempClob(true, 0);
        this.tempLobList.add(object);
        OutputStream outputStream = ((OscarLob)object).setBinaryStream(1L);
        try {
            StreamHandle.write(outputStream, inputStream, l2, 633600);
        }
        catch (IOException iOException) {
            throw new SQLException("oscar.trans:" + iOException.toString());
        }
        return ((OscarLob)object).getLocatorStr();
    }

    private String createClob(Reader reader, long l2) throws SQLException {
        Object object = (BaseConnection)((Object)this.conn);
        object = object.getVersion().isHaveEmptyXlobWithOid() ? OscarClob.createForTable(this.conn, this.tableOid, this.colIndex) : object.createTempClob(true, 0);
        this.tempLobList.add(object);
        try {
            StreamHandle.write(object.setCharacterStream(1L), reader, l2, 633600);
        }
        catch (IOException iOException) {
            throw new SQLException("oscar.trans" + iOException.toString());
        }
        return ((OscarClob)object).getLocatorStr();
    }

    public int executeTransfer() throws SQLException {
        if (this.closed) {
            throw new SQLException("oscar.trans.closed");
        }
        if (this.st == null) {
            this.st = this.conn.createStatement();
        }
        ((OscarStatement)this.st).importValues(this.rows);
        this.st.execute("IMPORT " + this.table);
        this.rows = new LinkedList<String>();
        for (int i2 = 0; i2 < this.tempLobList.size(); ++i2) {
            OscarLob oscarLob = (OscarLob)this.tempLobList.get(i2);
            oscarLob.close();
        }
        return ((OscarStatement)this.st).getTransferRowCount();
    }

    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.buf = null;
        this.conn = null;
        this.columnTypes = null;
        this.st = null;
        this.closed = true;
    }
}

