/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.core.BaseStatement;
import com.oscar.core.Field;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.sql.Time;
import com.oscar.util.OSQLException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.TimeZone;

public class Oscar42ResultSet
extends OscarResultSet {
    public Oscar42ResultSet(BaseStatement baseStatement, Field[] fieldArray, List list, String string, long l2, long l3, int n2, int n3) throws SQLException {
        super(baseStatement, fieldArray, list, string, l2, l3, n2, n3);
    }

    public Oscar42ResultSet(BaseStatement baseStatement, Field[] fieldArray, List list, String string, long l2, long l3, int n2, int n3, int n4) throws SQLException {
        super(baseStatement, fieldArray, list, string, l2, l3, n2, n3, n4);
    }

    @Override
    public <T> T getObject(int n2, Class<T> object) throws SQLException {
        Timestamp timestamp;
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (object == null) {
            throw new OSQLException("OSCAR-00319", "88888", 319);
        }
        Field field = this.fields[n2 - 1];
        int n3 = field.getSQLType();
        int n4 = field.getOscarType();
        if (object.equals(LocalDate.class)) {
            Date date;
            if (n3 == 91 && (date = this.getDate(n2)) != null) {
                return (T)LocalDate.of(date.getYear() + 1900, date.getMonth() + 1, date.getDate());
            }
            Timestamp timestamp2 = this.getTimestamp(n2);
            if (timestamp2 != null) {
                if (timestamp2 instanceof com.oscar.sql.Timestamp) {
                    com.oscar.sql.Timestamp timestamp3 = (com.oscar.sql.Timestamp)timestamp2;
                    timestamp3.stringValue();
                    return (T)LocalDate.of(timestamp3.fetchYearString(), timestamp3.fetchMonthString(), timestamp3.fetchDayString());
                }
                return (T)timestamp2.toLocalDateTime().toLocalDate();
            }
        } else if (object.equals(LocalDateTime.class)) {
            Timestamp timestamp4 = this.getTimestamp(n2);
            if (timestamp4 != null) {
                if (timestamp4 instanceof com.oscar.sql.Timestamp) {
                    com.oscar.sql.Timestamp timestamp5 = (com.oscar.sql.Timestamp)timestamp4;
                    timestamp5.stringValue();
                    return (T)LocalDateTime.of(timestamp5.fetchYearString(), timestamp5.fetchMonthString(), timestamp5.fetchDayString(), timestamp5.fetchHourString(), timestamp5.fetchMinuteString(), timestamp5.fetchSecondString(), timestamp5.fetchNanosString());
                }
                return (T)timestamp4.toLocalDateTime();
            }
        } else if (object.equals(LocalTime.class)) {
            java.sql.Time time;
            if ((n3 == 92 || n4 == 27) && (time = this.getTime(n2)) != null) {
                if (time instanceof Time) {
                    return (T)LocalTime.of(time.getHours(), time.getMinutes(), time.getSeconds());
                }
                return (T)LocalTime.parse(time.toString());
            }
            Timestamp timestamp6 = this.getTimestamp(n2);
            if (timestamp6 != null) {
                if (timestamp6 instanceof com.oscar.sql.Timestamp) {
                    com.oscar.sql.Timestamp timestamp7 = (com.oscar.sql.Timestamp)timestamp6;
                    timestamp7.stringValue();
                    return (T)LocalTime.of(timestamp7.fetchHourString(), timestamp7.fetchMinuteString(), timestamp7.fetchSecondString());
                }
                return (T)timestamp6.toLocalDateTime().toLocalTime();
            }
        } else if (object.equals(OffsetDateTime.class)) {
            Timestamp timestamp8 = this.getTimestamp(n2);
            if (timestamp8 != null) {
                if (timestamp8 instanceof com.oscar.sql.Timestamp) {
                    com.oscar.sql.Timestamp timestamp9 = (com.oscar.sql.Timestamp)timestamp8;
                    timestamp9.stringValue();
                    object = ((com.oscar.sql.Timestamp)timestamp8).fetchZoneString();
                    object = ((String)object).isEmpty() ? LocalDateTime.now(ZoneOffset.systemDefault()).atZone(ZoneOffset.systemDefault()).getOffset() : ZoneOffset.of((String)object);
                    return (T)OffsetDateTime.of(timestamp9.fetchYearString(), timestamp9.fetchMonthString(), timestamp9.fetchDayString(), timestamp9.fetchHourString(), timestamp9.fetchMinuteString(), timestamp9.fetchSecondString(), timestamp9.fetchNanosString(), (ZoneOffset)object);
                }
                ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(timestamp8.getTimezoneOffset());
                return (T)OffsetDateTime.of(timestamp8.getYear(), timestamp8.getMonth(), timestamp8.getDay(), timestamp8.getHours(), timestamp8.getMinutes(), timestamp8.getSeconds(), timestamp8.getNanos(), zoneOffset);
            }
        } else if (object.equals(OffsetTime.class)) {
            java.sql.Time time;
            if (n4 == 27 && (time = this.getOscarTime(n2)) != null) {
                if (time instanceof Time) {
                    Time time2 = (Time)time;
                    object = time2.getZoneString();
                    object = ((String)object).isEmpty() ? LocalDateTime.now(ZoneOffset.systemDefault()).atZone(ZoneOffset.systemDefault()).getOffset() : ZoneOffset.of((String)object);
                    return (T)OffsetTime.of(time.getHours(), time.getMinutes(), time.getSeconds(), time2.getNanos(), (ZoneOffset)object);
                }
                return (T)OffsetTime.of(LocalTime.parse(time.toString()), LocalDateTime.now(ZoneOffset.systemDefault()).atZone(ZoneOffset.systemDefault()).getOffset());
            }
            Timestamp timestamp10 = this.getTimestamp(n2);
            if (timestamp10 != null) {
                if (timestamp10 instanceof com.oscar.sql.Timestamp) {
                    com.oscar.sql.Timestamp timestamp11 = (com.oscar.sql.Timestamp)timestamp10;
                    timestamp11.stringValue();
                    object = ((com.oscar.sql.Timestamp)timestamp10).fetchZoneString();
                    object = ((String)object).isEmpty() ? LocalDateTime.now(ZoneOffset.systemDefault()).atZone(ZoneOffset.systemDefault()).getOffset() : ZoneOffset.of((String)object);
                    return (T)OffsetTime.of(timestamp11.fetchHourString(), timestamp11.fetchMinuteString(), timestamp11.fetchSecondString(), timestamp11.fetchNanosString(), (ZoneOffset)object);
                }
                return (T)OffsetDateTime.of(timestamp10.toLocalDateTime(), LocalDateTime.now(ZoneOffset.systemDefault()).atZone(ZoneOffset.systemDefault()).getOffset());
            }
        } else if (object.equals(ZonedDateTime.class) && (timestamp = this.getTimestamp(n2)) != null) {
            if (timestamp instanceof com.oscar.sql.Timestamp) {
                com.oscar.sql.Timestamp timestamp12 = (com.oscar.sql.Timestamp)timestamp;
                timestamp12.stringValue();
                object = timestamp12.fetchZoneString().isEmpty() ? TimeZone.getDefault().toZoneId() : ZoneId.of(timestamp12.fetchZoneString());
                return (T)ZonedDateTime.of(timestamp12.fetchYearString(), timestamp12.fetchMonthString(), timestamp12.fetchDayString(), timestamp12.fetchHourString(), timestamp12.fetchMinuteString(), timestamp12.fetchSecondString(), timestamp12.fetchNanosString(), (ZoneId)object);
            }
            return (T)ZonedDateTime.ofInstant(timestamp.toInstant(), TimeZone.getDefault().toZoneId());
        }
        return super.getObject(n2, object);
    }

    @Override
    public Object getObject(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        Field field = this.fields[n2 - 1];
        if (field.getOscarType() == 27) {
            return ((OscarResultSet)this).getObject(n2, OffsetTime.class);
        }
        return super.getObject(n2);
    }
}

