/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.Field;
import com.oscar.util.Convert;
import com.oscar.util.OSQLException;
import com.oscar.util.converter.DateConverter;
import com.oscar.util.converter.NumberConverter;
import com.oscar.util.converter.TimeConverter;
import com.oscar.util.converter.TimestampConverter;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public abstract class OscarArray
implements java.sql.Array {
    protected boolean free = false;
    protected String rawString = null;

    public void checkFree() throws OSQLException {
        if (this.free) {
            throw new OSQLException("OSCAR-001001", "88888", 1001);
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return null;
    }

    @Override
    public int getBaseType() throws SQLException {
        return 0;
    }

    @Override
    public Object getArray() throws SQLException {
        return null;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    @Override
    public Object getArray(long l2, int n2) throws SQLException {
        return null;
    }

    @Override
    public Object getArray(long l2, int n2, Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    public short[] getShortArray() throws SQLException {
        Object object = this.getArray();
        if (object instanceof short[] || object == null) {
            return (short[])object;
        }
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            short[] sArray = new short[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                sArray[i2] = Convert.toShort(Array.get(object, i2));
            }
            return sArray;
        }
        throw new OSQLException("RESULT is NOT ARRAY", "");
    }

    public int[] getIntArray() throws SQLException {
        Object object = this.getArray();
        if (object instanceof int[] || object == null) {
            return (int[])object;
        }
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            int[] nArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = Convert.toInt(Array.get(object, i2));
            }
            return nArray;
        }
        throw new OSQLException("Result is not array", "");
    }

    public long[] getLongArray() throws SQLException {
        Object object = this.getArray();
        if (object instanceof long[] || object == null) {
            return (long[])object;
        }
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            long[] lArray = new long[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                lArray[i2] = Convert.toLong(Array.get(object, i2));
            }
            return lArray;
        }
        throw new OSQLException("Result is not array", "");
    }

    public float[] getFloatArray() throws SQLException {
        Object object = this.getArray();
        if (object instanceof float[] || object == null) {
            return (float[])object;
        }
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            float[] fArray = new float[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                fArray[i2] = Convert.toFloat(Array.get(object, i2)).floatValue();
            }
            return fArray;
        }
        throw new OSQLException("Result is not array", "");
    }

    public double[] getDoubleArray() throws SQLException {
        Object object = this.getArray();
        if (object instanceof double[] || object == null) {
            return (double[])object;
        }
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            double[] dArray = new double[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                dArray[i2] = Convert.toDouble(Array.get(object, i2));
            }
            return dArray;
        }
        throw new OSQLException("Result is not array", "");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getResultSet(long l2, int n2) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getResultSet(long l2, int n2, Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    @Override
    public void free() throws SQLException {
        this.free = true;
    }

    protected ResultSet getResultSetV1(BaseConnection baseConnection, long l2, int n2, Map object) throws SQLException {
        Object object2 = this.getArray(l2, n2, (Map<String, Class<?>>)object);
        object = new ArrayList();
        Field[] fieldArray = new Field[2];
        Field[] fieldArray2 = fieldArray;
        fieldArray[0] = new Field(baseConnection, "INDEX", baseConnection.getDBTypeOid("INT2"), 2);
        switch (this.getBaseType()) {
            case -7: {
                object2 = (String[])object2;
                if (fieldArray2[1] == null) {
                    fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("BIT"), -1);
                }
                for (int i2 = 0; i2 < ((Object[])object2).length; ++i2) {
                    byte[][] byArray = new byte[2][0];
                    byte[][] byArray2 = byArray;
                    byArray[0] = baseConnection.getEncoding().encode(Integer.toString((int)l2 + i2));
                    byArray2[1] = baseConnection.getEncoding().encode((String)object2[i2]);
                    ((ArrayList)object).add(byArray2);
                }
                break;
            }
            case 5: {
                fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("INT2"), 2);
                break;
            }
            case 4: {
                Integer[] integerArray = (Integer[])object2;
                if (fieldArray2[1] == null) {
                    fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("INT4"), 4);
                }
                for (int i3 = 0; i3 < integerArray.length; ++i3) {
                    byte[][] byArray = new byte[2][0];
                    object2 = byArray;
                    byArray[0] = baseConnection.getEncoding().encode(Integer.toString((int)l2 + i3));
                    ((ArrayList)object).add(object2);
                }
                break;
            }
            case -5: {
                Long[] longArray = (Long[])object2;
                fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("INT8"), 8);
                for (int i4 = 0; i4 < longArray.length; ++i4) {
                    byte[][] byArray = new byte[2][0];
                    byte[][] byArray3 = byArray;
                    byArray[0] = baseConnection.getEncoding().encode(Integer.toString((int)l2 + i4));
                    byArray3[1] = baseConnection.getEncoding().encode(Long.toString(longArray[i4]));
                    ((ArrayList)object).add(byArray3);
                }
                break;
            }
            case 2: {
                object2 = (BigDecimal[])object2;
                fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("NUMERIC"), -1);
                for (int i5 = 0; i5 < ((Object[])object2).length; ++i5) {
                    byte[][] byArray = new byte[2][0];
                    byte[][] byArray4 = byArray;
                    byArray[0] = baseConnection.getEncoding().encode(Integer.toString((int)l2 + i5));
                    byArray4[1] = baseConnection.getEncoding().encode(((BigDecimal)object2[i5]).toString());
                    ((ArrayList)object).add(byArray4);
                }
                break;
            }
            case 7: {
                Float[] floatArray = (Float[])object2;
                fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("FLOAT4"), 4);
                for (int i6 = 0; i6 < floatArray.length; ++i6) {
                    byte[][] byArray = new byte[2][0];
                    object2 = byArray;
                    byArray[0] = baseConnection.getEncoding().encode(Integer.toString((int)l2 + i6));
                    object2[1] = baseConnection.getEncoding().encode(Float.toString(floatArray[i6].floatValue()));
                    ((ArrayList)object).add(object2);
                }
                break;
            }
            case 8: {
                Double[] doubleArray = (Double[])object2;
                fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("FLOAT8"), 8);
                for (int i7 = 0; i7 < doubleArray.length; ++i7) {
                    byte[][] byArray = new byte[2][0];
                    byte[][] byArray5 = byArray;
                    byArray[0] = baseConnection.getEncoding().encode(Integer.toString((int)l2 + i7));
                    byArray5[1] = baseConnection.getEncoding().encode(Double.toString(doubleArray[i7]));
                    ((ArrayList)object).add(byArray5);
                }
                break;
            }
            case 1: {
                fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("CHAR"), 1);
                break;
            }
            case 12: {
                object2 = (String[])object2;
                if (fieldArray2[1] == null) {
                    fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("VARCHAR"), -1);
                }
                for (int i8 = 0; i8 < ((Object[])object2).length; ++i8) {
                    byte[][] byArray = new byte[2][0];
                    byte[][] byArray6 = byArray;
                    byArray[0] = baseConnection.getEncoding().encode(Integer.toString((int)l2 + i8));
                    byArray6[1] = baseConnection.getEncoding().encode((String)object2[i8]);
                    ((ArrayList)object).add(byArray6);
                }
                break;
            }
            case 91: {
                Date[] dateArray = (Date[])object2;
                fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("DATE"), 4);
                for (int i9 = 0; i9 < dateArray.length; ++i9) {
                    byte[][] byArray = new byte[2][0];
                    object2 = byArray;
                    byArray[0] = baseConnection.getEncoding().encode(Integer.toString((int)l2 + i9));
                    object2[1] = baseConnection.getEncoding().encode(dateArray[i9].toString());
                    ((ArrayList)object).add(object2);
                }
                break;
            }
            case 92: {
                Time[] timeArray = (Time[])object2;
                fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("TIME"), 8);
                for (int i10 = 0; i10 < timeArray.length; ++i10) {
                    byte[][] byArray = new byte[2][0];
                    byte[][] byArray7 = byArray;
                    byArray[0] = baseConnection.getEncoding().encode(Integer.toString((int)l2 + i10));
                    byArray7[1] = baseConnection.getEncoding().encode(timeArray[i10].toString());
                    ((ArrayList)object).add(byArray7);
                }
                break;
            }
            case 93: {
                object2 = (Timestamp[])object2;
                fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("TIMESTAMP"), 8);
                for (int i11 = 0; i11 < ((Object[])object2).length; ++i11) {
                    byte[][] byArray = new byte[2][0];
                    byte[][] byArray8 = byArray;
                    byArray[0] = baseConnection.getEncoding().encode(Integer.toString((int)l2 + i11));
                    byArray8[1] = baseConnection.getEncoding().encode(((Timestamp)object2[i11]).toString());
                    ((ArrayList)object).add(byArray8);
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        return baseConnection.getDefaultStatement().createResultSet(fieldArray2, (List<byte[][]>)object, "OK", 1L, 0L);
    }

    protected ResultSet getResultSetV2(BaseConnection baseConnection, long l2, int n2, Map object) throws SQLException {
        Object object2 = this.getArray(l2, n2, (Map<String, Class<?>>)object);
        object = new ArrayList();
        Field[] fieldArray = new Field[2];
        Field[] fieldArray2 = fieldArray;
        fieldArray[0] = new Field(baseConnection, "INDEX", baseConnection.getDBTypeOid("INT2"), 2);
        Object object3 = baseConnection.getCalendar();
        switch (this.getBaseType()) {
            case -7: {
                object2 = (String[])object2;
                if (fieldArray2[1] == null) {
                    fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("BIT"), -1);
                }
                for (int i2 = 0; i2 < ((Object[])object2).length; ++i2) {
                    byte[][] byArray = new byte[2][0];
                    byte[][] byArray2 = byArray;
                    byArray[0] = NumberConverter.convertIntToBytes((int)l2 + i2);
                    byArray2[1] = baseConnection.getEncoding().encode((String)object2[i2]);
                    ((ArrayList)object).add(byArray2);
                }
                break;
            }
            case 5: {
                fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("INT2"), 2);
                break;
            }
            case 4: {
                object3 = (Integer[])object2;
                if (fieldArray2[1] == null) {
                    fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("INT4"), 4);
                }
                for (int i3 = 0; i3 < ((Number[])object3).length; ++i3) {
                    byte[][] byArray = new byte[2][0];
                    object2 = byArray;
                    byArray[0] = NumberConverter.convertIntToBytes((int)l2 + i3);
                    object2[1] = NumberConverter.convertIntToBytes((Integer)object3[i3]);
                    ((ArrayList)object).add(object2);
                }
                break;
            }
            case -5: {
                Long[] longArray = (Long[])object2;
                fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("INT8"), 8);
                for (int i4 = 0; i4 < longArray.length; ++i4) {
                    byte[][] byArray = new byte[2][0];
                    object3 = byArray;
                    byArray[0] = NumberConverter.convertIntToBytes((int)l2 + i4);
                    object3[1] = NumberConverter.convertLongToBytes(longArray[i4]);
                    ((ArrayList)object).add(object3);
                }
                break;
            }
            case 2: {
                object2 = (BigDecimal[])object2;
                fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("NUMERIC"), -1);
                for (int i5 = 0; i5 < ((Object[])object2).length; ++i5) {
                    byte[][] byArray = new byte[2][0];
                    byte[][] byArray3 = byArray;
                    byArray[0] = NumberConverter.convertIntToBytes((int)l2 + i5);
                    byArray3[1] = baseConnection.getEncoding().encode(((BigDecimal)object2[i5]).toString());
                    ((ArrayList)object).add(byArray3);
                }
                break;
            }
            case 7: {
                object3 = (Float[])object2;
                fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("FLOAT4"), 4);
                for (int i6 = 0; i6 < ((Number[])object3).length; ++i6) {
                    byte[][] byArray = new byte[2][0];
                    object2 = byArray;
                    byArray[0] = NumberConverter.convertIntToBytes((int)l2 + i6);
                    object2[1] = NumberConverter.convertDoubleToBytes(Double.parseDouble(Float.toString(((Float)object3[i6]).floatValue())));
                    ((ArrayList)object).add(object2);
                }
                break;
            }
            case 8: {
                Double[] doubleArray = (Double[])object2;
                fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("FLOAT8"), 8);
                for (int i7 = 0; i7 < doubleArray.length; ++i7) {
                    byte[][] byArray = new byte[2][0];
                    byte[][] byArray4 = byArray;
                    byArray[0] = NumberConverter.convertIntToBytes((int)l2 + i7);
                    byArray4[1] = NumberConverter.convertDoubleToBytes(doubleArray[i7]);
                    ((ArrayList)object).add(byArray4);
                }
                break;
            }
            case 1: {
                fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("CHAR"), 1);
                break;
            }
            case 12: {
                object2 = (String[])object2;
                if (fieldArray2[1] == null) {
                    fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("VARCHAR"), -1);
                }
                for (int i8 = 0; i8 < ((Object[])object2).length; ++i8) {
                    byte[][] byArray = new byte[2][0];
                    byte[][] byArray5 = byArray;
                    byArray[0] = NumberConverter.convertIntToBytes((int)l2 + i8);
                    byArray5[1] = baseConnection.getEncoding().encode((String)object2[i8]);
                    ((ArrayList)object).add(byArray5);
                }
                break;
            }
            case 91: {
                Date[] dateArray = (Date[])object2;
                fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("DATE"), 4);
                for (int i9 = 0; i9 < dateArray.length; ++i9) {
                    byte[][] byArray = new byte[2][0];
                    object2 = byArray;
                    byArray[0] = NumberConverter.convertIntToBytes((int)l2 + i9);
                    object2[1] = DateConverter.convertDateToBytes(dateArray[i9], (Calendar)object3);
                    ((ArrayList)object).add(object2);
                }
                break;
            }
            case 92: {
                Time[] timeArray = (Time[])object2;
                fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("TIME"), 8);
                for (int i10 = 0; i10 < timeArray.length; ++i10) {
                    byte[][] byArray = new byte[2][0];
                    byte[][] byArray6 = byArray;
                    byArray[0] = NumberConverter.convertIntToBytes((int)l2 + i10);
                    byArray6[1] = TimeConverter.convertTimeToBytes(timeArray[i10], (Calendar)object3);
                    ((ArrayList)object).add(byArray6);
                }
                break;
            }
            case 93: {
                object2 = (Timestamp[])object2;
                fieldArray2[1] = new Field(baseConnection, "VALUE", baseConnection.getDBTypeOid("TIMESTAMP"), 8);
                for (int i11 = 0; i11 < ((Object[])object2).length; ++i11) {
                    byte[][] byArray = new byte[2][0];
                    byte[][] byArray7 = byArray;
                    byArray[0] = NumberConverter.convertIntToBytes((int)l2 + i11);
                    byArray7[1] = TimestampConverter.convertTimestampToBytes((Timestamp)object2[i11], (Calendar)object3);
                    ((ArrayList)object).add(byArray7);
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        return baseConnection.getDefaultStatement().createResultSet(fieldArray2, (List<byte[][]>)object, "OK", 1L, 0L);
    }

    public String toString() {
        if (this.rawString != null) {
            return this.rawString;
        }
        return super.toString();
    }
}

