/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.jdbc.OscarLob;
import com.oscar.util.OSQLException;
import com.oscar.util.StreamHandle;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;

public class OscarBlob
extends OscarLob
implements Blob {
    public static OscarBlob empty_lob() {
        return new OscarBlob();
    }

    public static OscarBlob createTemporary(Connection object, boolean bl, int n2) throws SQLException {
        if (!(object instanceof BaseConnection)) {
            throw new OSQLException("OSCAR-00505", "88888", 505);
        }
        object = (BaseConnection)((Object)((BaseConnection)object).getMasterConnection());
        return new OscarBlob((BaseConnection)object, bl, n2);
    }

    public static OscarBlob createForTable(Connection object, long l2, int n2) throws SQLException {
        if (!(object instanceof BaseConnection)) {
            throw new OSQLException("OSCAR-00505", "88888", 505);
        }
        object = (BaseConnection)((Object)((BaseConnection)object).getMasterConnection());
        return new OscarBlob((BaseConnection)object, l2, n2);
    }

    public static OscarBlob createByLocator(Connection object, String string) throws SQLException {
        if (!(object instanceof BaseConnection)) {
            throw new OSQLException("OSCAR-00505", "88888", 505);
        }
        object = (BaseConnection)((Object)((BaseConnection)object).getMasterConnection());
        return new OscarBlob((BaseConnection)object, string);
    }

    public static void freeTemporary(OscarBlob oscarBlob) throws SQLException {
        oscarBlob.freeTemporary();
    }

    private OscarBlob() {
    }

    private OscarBlob(BaseConnection baseConnection, String string) throws SQLException {
        super(baseConnection, string, 1);
    }

    private OscarBlob(BaseConnection baseConnection, boolean bl, int n2) throws SQLException {
        super(baseConnection, bl, n2);
    }

    private OscarBlob(BaseConnection baseConnection, long l2, int n2) throws SQLException {
        super(baseConnection, l2, n2);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog("connid" + this.connection.getSessionID() + ", " + OscarBlob.class + " getBinaryStream() ");
        }
        this.checkFree();
        this.checkEmptyLob();
        return this.getBinaryStream(1L);
    }

    @Override
    public long position(byte[] byArray, long l2) throws SQLException {
        return super.positionInternal(byArray, l2);
    }

    @Override
    public long position(Blob blob, long l2) throws SQLException {
        return super.positionInternal((OscarLob)((Object)blob), l2);
    }

    @Override
    public int setBytes(long l2, byte[] byArray) throws SQLException {
        this.checkFree();
        if (l2 <= 0L || byArray == null) {
            throw new IllegalArgumentException("wrong parameter");
        }
        int n2 = this.setBytes(l2, byArray, 0, byArray.length);
        return n2;
    }

    @Override
    public long write(long l2, InputStream inputStream, long l3) throws SQLException {
        long l4;
        try {
            OutputStream outputStream = this.setBinaryStream(l2, (int)l3);
            l4 = StreamHandle.write(outputStream, inputStream, l3, this.getBufferSize());
            outputStream.close();
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            Driver.writeLog(iOException);
            throw new OSQLException("OSCAR-00508", "88888", 508);
        }
        return l4;
    }

    @Override
    public int getType() {
        return 1;
    }

    public String getSubString(long l2, int n2) throws SQLException {
        String string;
        this.checkEmptyLob();
        if (l2 <= 0L || n2 < 0) {
            throw new OSQLException("OSCAR-00502", "88888", 502);
        }
        if (n2 == 0) {
            string = "";
        } else {
            try {
                Reader reader = this.getCharacterStream(l2);
                string = StreamHandle.read(reader, n2, this.getBufferSize());
                reader.close();
            }
            catch (IOException iOException) {
                throw new OSQLException("OSCAR-00502", "88888", 502, iOException);
            }
        }
        return string;
    }

    public Reader getCharacterStream(long l2) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog("connid" + this.connection.getSessionID() + ", " + OscarBlob.class + " getCharacterStream(long pos),pos:" + l2);
        }
        this.checkEmptyLob();
        try {
            return new InputStreamReader(this.getBinaryStream(l2), this.connection.getEncoding().getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
    }

    @Override
    public InputStream getBinaryStream(long l2, long l3) throws SQLException {
        this.checkFree();
        this.checkEmptyLob();
        if (l2 < 0L) {
            throw new SQLException("");
        }
        return new OscarLob.LobInputStream((OscarLob)this, l2, l3);
    }
}

