/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.ImportHandler;
import com.oscar.jdbc.OscarJdbc2BulkConnection;
import com.oscar.util.CommonUtil;
import com.oscar.util.OSQLException;
import com.oscar.util.OscarSqlProcessor;
import com.oscar.util.TableNameParser;
import com.oscar.util.Word;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OscarBulkInsertPrepareStatement
implements PreparedStatement {
    private OscarJdbc2BulkConnection connection = null;
    private ImportHandler bulkHandler = null;
    private String tableName = null;
    private String[] fieldName = null;
    private String fieldNameStr = null;
    protected boolean isClosed = false;
    private boolean poolable = true;
    protected int maxfieldSize = 0;
    protected int fetchSize = 16;
    private HashMap<Integer, String> constantMap = new HashMap();
    private HashMap<Integer, Integer> variableMap = new HashMap();
    protected int maxrows = 0;
    protected int timeout = 0;
    protected SQLWarning warnings = null;
    protected int resultSetHoldability = 2;
    protected int fetchdirection = 1000;
    protected int resultSetType = 1003;
    protected int resultSetConcurrency = 1007;
    private String schemaName = null;

    OscarBulkInsertPrepareStatement(OscarJdbc2BulkConnection oscarJdbc2BulkConnection, String string, int n2, int n3, int n4, OscarSqlProcessor.ParseResult parseResult, String string2) throws SQLException {
        this.connection = oscarJdbc2BulkConnection;
        this.parseSQL(string, parseResult, string2);
        this.bulkHandler = this.schemaName != null ? oscarJdbc2BulkConnection.createImportHandler(this.schemaName, this.tableName) : oscarJdbc2BulkConnection.createImportHandler(this.tableName);
        this.bulkHandler.setBufferSize(oscarJdbc2BulkConnection.getBufferSize());
        if (this.fieldNameStr != null) {
            this.bulkHandler.setColumnOrder(this.fieldNameStr);
        }
        this.resultSetHoldability = n4;
        this.resultSetType = n2;
        this.resultSetConcurrency = n3;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSQL(String string, OscarSqlProcessor.ParseResult object, String serializable) throws SQLException {
        void var3_14;
        int n2;
        Object object2;
        Object object3 = Pattern.compile("INSERT\\s+INTO\\s+((\".*?(|\"\").*?\")|(\\w|[\u4e00-\u9fa5])+)\\s*((\\.)\\s*(((\".*\")|(\"\"))|(\\w|[\u4e00-\u9fa5])+))?(\\s+|\\(+)", 2);
        Pattern pattern = Pattern.compile("INSERT\\s+INTO", 2);
        if (!((Matcher)(object3 = ((Pattern)object3).matcher((CharSequence)((Object)serializable)))).find()) throw new SQLException("Parsing grammarerror, your sql is: " + string);
        String string2 = ((Matcher)object3).group();
        if (((Matcher)(object3 = pattern.matcher(string2))).find()) {
            this.tableName = string2.endsWith("(") ? string2.substring(((Matcher)object3).group().length(), string2.length() - 1).trim() : string2.substring(((Matcher)object3).group().length(), string2.length()).trim();
            object2 = TableNameParser.parserToDbNames(this.tableName);
            this.schemaName = object2[0];
            this.tableName = object2[1];
        }
        if (string2.endsWith("(")) {
            object3 = ((String)((Object)serializable)).substring(string2.length() - 1, ((String)((Object)serializable)).length());
            n2 = string2.length() - 1;
        } else {
            object3 = ((String)((Object)serializable)).substring(string2.length(), ((String)((Object)serializable)).length());
            n2 = string2.length();
        }
        string2 = null;
        if (object != null && ((OscarSqlProcessor.ParseResult)object).getValuesWordIndex() > 0) {
            object2 = ((OscarSqlProcessor.ParseResult)object).getAllWords().get(((OscarSqlProcessor.ParseResult)object).getValuesWordIndex());
            string2 = ((String)((Object)serializable)).substring(n2, ((Word)object2).getTokenBegin());
            object3 = ((String)((Object)serializable)).substring(((Word)object2).getTokenEnd(), ((String)((Object)serializable)).length());
        } else {
            object2 = Pattern.compile("\\((\\s*(('.*?[^\\\\]')|(\\w|[\u4e00-\u9fa5])+|\\?)\\s*)(,\\s*(('.*?[^\\\\]')|(\\w|[\u4e00-\u9fa5])+|\\?)\\s*)*\\)", 2);
            object = ((Pattern)object2).matcher((CharSequence)object3);
            if (((String)object3).trim().toUpperCase().startsWith("VALUES")) {
                if (!((Matcher)object).find()) throw new SQLException("Parsing grammarerror, your sql is: " + string);
                object3 = ((Matcher)object).group();
            } else {
                Pattern pattern2 = Pattern.compile("\\((\\s*((\".*?[^\\\\]\")|(\\w|[\u4e00-\u9fa5])+|\\?)\\s*)(,\\s*((\".*?[^\\\\]\")|(\\w|[\u4e00-\u9fa5])+|\\?)\\s*)*\\)", 2);
                Matcher matcher = pattern2.matcher((CharSequence)object3);
                if (!matcher.find()) {
                    throw new SQLException("Parsing grammarerror, your sql is: " + string);
                }
                string2 = matcher.group();
                if (!((Matcher)object).find(string2.length())) throw new SQLException("Parsing grammarerror, your sql is: " + string);
                object3 = ((Matcher)object).group();
            }
        }
        object2 = Pattern.compile("\\s*((\".*?[^\\\\]\")|(\\w|[\u4e00-\u9fa5])+|\\?)\\s*", 2);
        if (string2 != null) {
            object = ((Pattern)object2).matcher(string2);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (((Matcher)object).find()) {
                arrayList.add(((Matcher)object).group());
            }
            String[] stringArray = new String[arrayList.size()];
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                stringArray[i2] = (String)arrayList.get(i2);
            }
            if (stringArray.length > 0) {
                void var3_11;
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                while (var3_11 < stringArray.length) {
                    string2 = stringArray[var3_11].trim();
                    stringArray[var3_11] = string2.length() > 2 && string2.startsWith("\"") && string2.endsWith("\"") ? string2.substring(1, string2.length() - 1) : string2.toUpperCase();
                    stringBuffer.append(stringArray[var3_11]).append(",");
                    ++var3_11;
                }
                this.fieldNameStr = stringBuffer.substring(0, stringBuffer.length() - 1);
                this.fieldName = stringArray;
            }
        }
        String[] stringArray = Pattern.compile("\\s*(('.*?[^\\\\]')|\\w+|\\?)\\s*", 2);
        Matcher matcher = stringArray.matcher((CharSequence)object3);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (matcher.find()) {
            arrayList.add(matcher.group());
        }
        stringArray = new String[arrayList.size()];
        boolean bl = false;
        while (var3_14 < arrayList.size()) {
            stringArray[var3_14] = (String)arrayList.get((int)var3_14);
            ++var3_14;
        }
        if (stringArray.length <= 0 || this.fieldName != null && stringArray.length != this.fieldName.length) {
            throw new SQLException("The total number of question marks must be the same as the total number of column names, your sql is: " + string);
        }
        boolean bl2 = false;
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            stringArray[i3] = stringArray[i3].trim();
            if ("?".equals(stringArray[i3])) {
                void var3_16;
                this.variableMap.put((int)(++var3_16), i3 + 1);
                continue;
            }
            if ("null".equalsIgnoreCase(stringArray[i3])) {
                this.constantMap.put(i3 + 1, null);
                continue;
            }
            if (stringArray[i3].matches("^'.*'$")) {
                stringArray[i3] = stringArray[i3].substring(1, stringArray[i3].length() - 1);
            }
            this.constantMap.put(i3 + 1, stringArray[i3]);
        }
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.bulkHandler != null) {
            this.bulkHandler.close();
            this.bulkHandler = null;
        }
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return this.maxfieldSize;
    }

    @Override
    public void setMaxFieldSize(int n2) throws SQLException {
        this.checkClosed();
        this.maxfieldSize = n2;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxrows;
    }

    @Override
    public void setMaxRows(int n2) throws SQLException {
        if (n2 < 0) {
            throw new OSQLException("OSCAR-00408", "88888", 408);
        }
        this.maxrows = n2;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    @Override
    public void setQueryTimeout(int n2) throws SQLException {
        this.timeout = n2;
    }

    @Override
    public void cancel() throws SQLException {
        this.connection.cancelQuery();
    }

    public void addWarning(SQLWarning sQLWarning) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(sQLWarning);
            return;
        }
        this.warnings = sQLWarning;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.checkClosed();
        this.clearWarnings();
        if (this.bulkHandler != null) {
            return this.bulkHandler.execute();
        }
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        return CommonUtil.convertToInt(this.bulkHandler.getCurrentUpdateCount());
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int n2) throws SQLException {
        this.checkClosed();
        if (n2 != 1000 && n2 != 1001 && n2 != 1002) {
            throw new OSQLException("OSCAR-00418", "88888", 418);
        }
        if (this.resultSetType == 1003 && n2 != 1000) {
            throw new OSQLException("OSCAR-00418", "88888", 418);
        }
        this.fetchdirection = n2;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchdirection;
    }

    @Override
    public void setFetchSize(int n2) throws SQLException {
        this.checkClosed();
        if (n2 < 0) {
            throw new OSQLException("OSCAR-00307", "88888", 307);
        }
        this.fetchSize = n2;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkClosed();
        return this.resultSetType;
    }

    @Override
    public void addBatch(String string) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        this.execute();
        int n2 = CommonUtil.convertToInt(this.bulkHandler.getCurrentUpdateCount());
        if (n2 > 0) {
            nArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = 1;
            }
        } else {
            nArray = new int[1];
        }
        return nArray;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int n2) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String string, int n2) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public boolean execute(String string, int n2) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.execute();
        return CommonUtil.convertToInt(this.bulkHandler.getCurrentUpdateCount());
    }

    @Override
    public void setNull(int n2, int n3) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setNull(n2, n3);
    }

    @Override
    public void setBoolean(int n2, boolean bl) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setBoolean(n2, bl);
    }

    @Override
    public void setByte(int n2, byte by) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setByte(n2, by);
    }

    @Override
    public void setShort(int n2, short s2) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setShort(n2, s2);
    }

    @Override
    public void setInt(int n2, int n3) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setInt(n2, n3);
    }

    @Override
    public void setLong(int n2, long l2) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setLong(n2, l2);
    }

    @Override
    public void setFloat(int n2, float f2) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setFloat(n2, f2);
    }

    @Override
    public void setDouble(int n2, double d2) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setDouble(n2, d2);
    }

    @Override
    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setBigDecimal(n2, bigDecimal);
    }

    @Override
    public void setString(int n2, String string) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setString(n2, string);
    }

    @Override
    public void setBytes(int n2, byte[] byArray) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setBytes(n2, byArray);
    }

    @Override
    public void setDate(int n2, Date date) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setDate(n2, date);
    }

    @Override
    public void setTime(int n2, Time time) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setTime(n2, time);
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setTimestamp(n2, timestamp);
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setAsciiStream(n2, inputStream);
    }

    @Override
    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setUnicodeStream(n2, inputStream);
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setBinaryStream(n2, inputStream, n3);
    }

    @Override
    public void clearParameters() throws SQLException {
    }

    @Override
    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void setObject(int n2, Object object, int n3) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setObject(n2, object, n3);
    }

    @Override
    public void setObject(int n2, Object object) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setObject(n2, object);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.bulkHandler.execute();
    }

    @Override
    public void addBatch() throws SQLException {
        for (Map.Entry<Integer, String> entry : this.constantMap.entrySet()) {
            this.bulkHandler.setString((int)entry.getKey(), entry.getValue());
        }
        this.bulkHandler.endRow();
    }

    @Override
    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void setRef(int n2, Ref ref) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void setBlob(int n2, Blob blob) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setBlob(n2, blob);
    }

    @Override
    public void setClob(int n2, Clob clob) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setClob(n2, clob);
    }

    @Override
    public void setArray(int n2, Array array) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setArray(n2, array);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setDate(n2, date, calendar);
    }

    @Override
    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setTime(n2, time, calendar);
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setTimestamp(n2, timestamp, calendar);
    }

    @Override
    public void setNull(int n2, int n3, String string) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setNull(n2, n3, string);
    }

    @Override
    public void setURL(int n2, URL uRL) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new OSQLException("OSCAR-00409", "00409", 118);
        }
    }

    private int reIndex(int n2) throws OSQLException {
        Integer n3 = this.variableMap.get(n2);
        if (n3 == null) {
            throw new OSQLException("OSCAR-00305", "88888", 305);
        }
        return n3;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        this.checkClosed();
        this.poolable = bl;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.poolable;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public void setRowId(int n2, RowId rowId) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void setNString(int n2, String string) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void setNClob(int n2, NClob nClob) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void setClob(int n2, Reader reader, long l2) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setCharacterStream(n2, reader, l2);
    }

    @Override
    public void setBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setBlob(n2, inputStream, l2);
    }

    @Override
    public void setNClob(int n2, Reader reader, long l2) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void setSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        this.checkClosed();
        if (sQLXML == null || sQLXML.getString() == null) {
            this.setNull(n2, 2009);
            return;
        }
        this.setString(n2, sQLXML.getString());
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setBlob(n2, inputStream, l2);
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setBinaryStream(n2, inputStream, l2);
    }

    @Override
    public void setCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setCharacterStream(n2, reader, l2);
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setAsciiStream(n2, inputStream);
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setBinaryStream(n2, inputStream);
    }

    @Override
    public void setCharacterStream(int n2, Reader reader) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setCharacterStream(n2, reader);
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void setClob(int n2, Reader reader) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setCharacterStream(n2, reader);
    }

    @Override
    public void setBlob(int n2, InputStream inputStream) throws SQLException {
        n2 = this.reIndex(n2);
        this.bulkHandler.setBinaryStream(n2, inputStream);
    }

    @Override
    public void setNClob(int n2, Reader reader) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }
}

