/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.Field;
import com.oscar.jdbc.OscarParaMetaData;
import com.oscar.jdbc.OscarPreparedStatementV2;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.jdbc.OscarStatement;
import com.oscar.jdbc.entity.ParamInfo;
import com.oscar.jdbc.handler.NClobInvocationHandler;
import com.oscar.util.OSQLException;
import com.oscar.util.OscarSqlProcessor;
import com.oscar.util.TypeConverter;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OscarCallableStatementV2
extends OscarPreparedStatementV2
implements CallableStatement {
    private HashMap<Integer, Integer> outParameterScale = null;
    OscarSqlProcessor.ParseFunctionResult pr;

    public OscarCallableStatementV2(BaseConnection baseConnection, String string) throws SQLException {
        super(baseConnection, string);
        this.setStatementType(2);
    }

    public BaseResultSet createResultSet(Field[] fieldArray, List list, String string, long l2, long l3) throws SQLException {
        return OscarResultSet.getInstanceV2CallableStatement(this, fieldArray, list, string, l2, l3, this.fetchSize, this.maxrows);
    }

    @Override
    protected String subParseSqlStmt(String object) throws SQLException {
        object = OscarSqlProcessor.modifyJdbcCall((String)object, this.connection);
        this.isCallable = ((OscarSqlProcessor.ParseFunctionResult)object).isCallable();
        this.isAnonymous = ((OscarSqlProcessor.ParseFunctionResult)object).isAnonymous();
        this.isFunc = ((OscarSqlProcessor.ParseFunctionResult)object).isFunc();
        this.isResultNeeded = ((OscarSqlProcessor.ParseFunctionResult)object).isResultNeeded();
        this.isHaveFuncReturn = ((OscarSqlProcessor.ParseFunctionResult)object).haveFuncReturn();
        this.pr = object;
        return ((OscarSqlProcessor.ParseFunctionResult)object).getAfterSql();
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.isAnonymous && this.outParameterIndex.size() > 0 && !this.anonymousSupportPrepare) {
            throw new SQLException("PL registerOutParameter must anonymousSupportPrepare=true");
        }
        return super.execute();
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)((OscarStatement)this).getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        ((OscarStatement)this).setString(n2, string2);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)((OscarStatement)this).getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        ((OscarStatement)this).setCharacterStream(n2, reader, l2);
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)((OscarStatement)this).getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        ((OscarStatement)this).setClob(n2, (Clob)nClob);
    }

    @Override
    public void setNClob(String string, Reader reader, long l2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)((OscarStatement)this).getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setClob(n2, reader, l2);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)((OscarStatement)this).getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setClob(n2, reader);
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        Clob clob = this.getClob(n2);
        if (clob == null) {
            return null;
        }
        return (NClob)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{NClob.class}, (InvocationHandler)new NClobInvocationHandler(clob));
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)((OscarStatement)this).getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getNClob(n2);
    }

    @Override
    public String getNString(int n2) throws SQLException {
        return this.getString(n2);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getString(string);
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        return this.getCharacterStream(n2);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(string);
    }

    @Override
    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        this.checkClosed();
        if (clazz == null) {
            throw new SQLException("Type parameter can not be null");
        }
        if (clazz.equals(String.class)) {
            return (T)this.getString(n2);
        }
        if (clazz.equals(BigDecimal.class)) {
            return (T)this.getBigDecimal(n2);
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(this.getBoolean(n2));
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(this.getInt(n2));
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return (T)Long.valueOf(this.getLong(n2));
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return (T)Float.valueOf(this.getFloat(n2));
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return (T)Double.valueOf(this.getDouble(n2));
        }
        if (clazz.equals(byte[].class)) {
            return (T)this.getBytes(n2);
        }
        if (clazz.equals(Date.class)) {
            return (T)this.getDate(n2);
        }
        if (clazz.equals(Time.class)) {
            return (T)this.getTime(n2);
        }
        if (clazz.equals(Timestamp.class)) {
            return (T)this.getTimestamp(n2);
        }
        if (clazz.equals(Clob.class)) {
            return (T)this.getClob(n2);
        }
        if (clazz.equals(Blob.class)) {
            return (T)this.getBlob(n2);
        }
        if (clazz.equals(Array.class)) {
            return (T)this.getArray(n2);
        }
        if (clazz.equals(Ref.class)) {
            return (T)this.getRef(n2);
        }
        if (clazz.equals(URL.class)) {
            return (T)this.getURL(n2);
        }
        if (clazz.equals(Struct.class)) {
            throw Driver.notImplemented();
        }
        if (clazz.equals(RowId.class)) {
            return (T)this.getRowId(n2);
        }
        if (clazz.equals(NClob.class)) {
            return (T)this.getNClob(n2);
        }
        if (clazz.equals(SQLXML.class)) {
            return (T)this.getSQLXML(n2);
        }
        return (T)this.getObject(n2);
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)((OscarStatement)this).getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getObject(n2, clazz);
    }

    @Override
    public void registerOutParameter(String string, int n2, int n3) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)((OscarStatement)this).getParameterMetaData();
        }
        int n4 = this.pMetaData.getIndex(string);
        this.registerOutParameter(n4, n2, n3);
    }

    @Override
    public void registerOutParameter(int n2, int n3, int n4) throws SQLException {
        this.registerOutParameter(n2, n3);
        if (this.outParameterScale == null) {
            this.outParameterScale = new HashMap();
        }
        this.outParameterScale.put(n2, n4);
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2, 3, "BigDecimal");
        BigDecimal bigDecimal = TypeConverter.toBigDecimal(this.getFixedString(n2), this.m_functionTypes[n2 - 1]);
        if (bigDecimal != null && this.outParameterScale != null && this.outParameterScale.containsKey(n2)) {
            bigDecimal = bigDecimal.setScale((int)this.outParameterScale.get(n2), 4);
        }
        return bigDecimal;
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)((OscarStatement)this).getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getBigDecimal(n2);
    }

    @Override
    public void closeOrCache() throws SQLException {
        super.closeOrCache();
        if (this.outParameterScale != null) {
            this.outParameterScale.clear();
            this.outParameterScale = null;
        }
    }

    @Override
    protected void getProcedureResult() throws SQLException {
        if (this.outParameterIndex.size() <= 0) {
            return;
        }
        BaseResultSet baseResultSet = this.result.getLastResult();
        if (baseResultSet == null) {
            baseResultSet = this.result;
        }
        baseResultSet.next();
        byte[][] byArray = baseResultSet.getCurrentRow();
        this.m_functionTypes = new int[this.m_binds.length];
        int n2 = this.parameterNum;
        int n3 = 0;
        if (!this.isResultNeeded && this.isFunc) {
            ++n2;
            this.m_returnValue = byArray[0];
            this.m_returnType = baseResultSet.getMetaData().getColumnType(1);
            ++n3;
        }
        if (n2 != baseResultSet.getColumnCount()) {
            Object object = this.pr.getParams();
            if (object == null) {
                OscarSqlProcessor.initObjectInfo(this.pr, this.connection);
                object = this.pr.getParams();
            }
            if (object != null) {
                Collection<ParamInfo> object22 = object.values();
                HashMap hashMap = new HashMap();
                long l2 = -1L;
                for (ParamInfo paramInfo : object22) {
                    long l3 = paramInfo.getOid();
                    if (hashMap.containsKey(l3)) {
                        ((List)hashMap.get(l3)).add(paramInfo);
                        continue;
                    }
                    ArrayList<ParamInfo> arrayList = new ArrayList<ParamInfo>();
                    arrayList.add(paramInfo);
                    hashMap.put(l3, arrayList);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    Long l4 = (Long)entry.getKey();
                    if (((List)entry.getValue()).size() != this.fragmentsCount - 1) continue;
                    l2 = l4;
                    break;
                }
                if (l2 == -1L) {
                    throw new OSQLException("OSCAR-00407", "88888", 407);
                }
                object = (List)hashMap.get(l2);
                if (object != null) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        int n4;
                        ParamInfo paramInfo = (ParamInfo)iterator.next();
                        int n5 = paramInfo.getSequence();
                        if (this.outParameterIndex.contains(n5) || (n4 = paramInfo.getInout()) != 2 && n4 != 3) continue;
                        this.outParameterIndex.add(this.parameterNum++, n5);
                        Collections.sort(this.outParameterIndex);
                        int n6 = this.outParameterIndex.indexOf(n5);
                        this.outParameterType.insertElementAt(this.connection.getSQLType(paramInfo.getType()), n6);
                    }
                }
            }
        }
        for (Integer n6 : this.outParameterIndex) {
            int n7 = n6 - 1;
            this.m_functionTypes[n7] = baseResultSet.getMetaData().getColumnType(n3 + 1);
            this.m_outValues[n7] = byArray[n3];
            ++n3;
        }
    }
}

