/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.jdbc.OscarLob;
import com.oscar.util.OSQLException;
import com.oscar.util.StreamHandle;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;

public class OscarClob
extends OscarLob
implements Clob {
    public static OscarClob empty_lob() {
        return new OscarClob();
    }

    public static OscarClob createTemporary(Connection object, boolean bl, int n2) throws SQLException {
        if (!(object instanceof BaseConnection)) {
            throw new OSQLException("OSCAR-00505", "88888", 505);
        }
        object = (BaseConnection)((Object)((BaseConnection)object).getMasterConnection());
        return new OscarClob((BaseConnection)object, bl, n2);
    }

    public static OscarClob createForTable(Connection object, long l2, int n2) throws SQLException {
        if (!(object instanceof BaseConnection)) {
            throw new OSQLException("OSCAR-00505", "88888", 505);
        }
        object = (BaseConnection)((Object)((BaseConnection)object).getMasterConnection());
        return new OscarClob((BaseConnection)object, l2, n2);
    }

    public static OscarClob createByLocator(Connection object, String string) throws SQLException {
        if (!(object instanceof BaseConnection)) {
            throw new OSQLException("OSCAR-00505", "88888", 505);
        }
        object = (BaseConnection)((Object)((BaseConnection)object).getMasterConnection());
        return new OscarClob((BaseConnection)object, string);
    }

    private OscarClob() {
    }

    private OscarClob(BaseConnection baseConnection, String string) throws SQLException {
        super(baseConnection, string, 2);
    }

    private OscarClob(BaseConnection baseConnection, boolean bl, int n2) throws SQLException {
        super(baseConnection, bl, n2);
    }

    private OscarClob(BaseConnection baseConnection, long l2, int n2) throws SQLException {
        super(baseConnection, l2, n2);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.checkFree();
        this.checkEmptyLob();
        return this.getAsciiStream(1L);
    }

    public InputStream getAsciiStream(long l2) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog("connid" + this.connection.getSessionID() + ", " + OscarClob.class + " getAsciiStream(long pos),pos:" + l2);
        }
        this.checkFree();
        this.checkEmptyLob();
        return this.getBinaryStream(l2);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkFree();
        this.checkEmptyLob();
        return this.getCharacterStream(1L);
    }

    public Reader getCharacterStream(long l2) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog("connid" + this.connection.getSessionID() + ", " + OscarClob.class + " getCharacterStream(long pos),pos:" + l2);
        }
        this.checkEmptyLob();
        try {
            return new InputStreamReader(this.getBinaryStream(l2), this.connection.getEncoding().getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
    }

    @Override
    public String getSubString(long l2, int n2) throws SQLException {
        String string;
        this.checkFree();
        this.checkEmptyLob();
        if (l2 <= 0L || n2 < 0) {
            throw new OSQLException("OSCAR-00502", "88888", 502);
        }
        if (n2 == 0) {
            string = "";
        } else {
            try {
                Reader reader = this.getCharacterStream(l2);
                string = StreamHandle.read(reader, n2, this.getBufferSize());
                reader.close();
            }
            catch (IOException iOException) {
                throw new OSQLException("OSCAR-00502", "88888", 502, iOException);
            }
        }
        return string;
    }

    @Override
    public long position(String object, long l2) throws SQLException {
        this.checkFree();
        if (object == null || ((String)object).length() == 0 || l2 <= 0L) {
            throw new OSQLException("OSCAR-00502", "88888", 502);
        }
        if (!this.isEmptyLob()) {
            object = this.connection.getEncoding().encode((String)object);
            return super.positionInternal((byte[])object, l2);
        }
        return -1L;
    }

    @Override
    public long position(Clob clob, long l2) throws SQLException {
        this.checkFree();
        return super.positionInternal((OscarLob)((Object)clob), l2);
    }

    public String toString() {
        String string;
        if (this.isEmptyLob()) {
            string = "";
        } else {
            try {
                long l2 = this.length();
                l2 = l2 > (long)this.getBufferSize() ? (long)this.getBufferSize() : l2;
                string = this.getSubString(1L, (int)l2);
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException);
            }
        }
        return string;
    }

    @Override
    public int setString(long l2, String string) throws SQLException {
        this.checkFree();
        this.checkEmptyLob();
        return this.setString(l2, string, 0, string.length());
    }

    @Override
    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        int n4;
        this.checkFree();
        this.checkEmptyLob();
        if (string == null) {
            string = "";
        }
        if (l2 <= 0L || string.length() < n3 || n2 < 0 || n2 != 0 && n2 >= string.length()) {
            throw new OSQLException("OSCAR-00502", "88888", 502);
        }
        try {
            Writer writer = this.setCharacterStream(l2);
            n4 = StreamHandle.write(writer, string, n2, n3, this.getBufferSize());
            this.lobLength = -1L;
            this.datas = null;
            writer.close();
        }
        catch (IOException iOException) {
            throw new OSQLException("OSCAR-00508", "88888", 508);
        }
        return n4;
    }

    public int setBytes(byte[] byArray) throws SQLException {
        this.checkEmptyLob();
        return this.setBytes(1L, byArray, 0, byArray.length);
    }

    @Override
    public OutputStream setAsciiStream(long l2) throws SQLException {
        this.checkFree();
        this.checkEmptyLob();
        if (l2 <= 0L) {
            throw new IllegalArgumentException("wrong parameter");
        }
        return this.setBinaryStream(l2);
    }

    @Override
    public Writer setCharacterStream(long l2) throws SQLException {
        this.checkFree();
        this.checkEmptyLob();
        if (l2 <= 0L) {
            throw new IllegalArgumentException("wrong parameter");
        }
        Closeable closeable = this.setBinaryStream(l2);
        try {
            closeable = new OutputStreamWriter((OutputStream)closeable, this.connection.getEncoding().getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OSQLException("OSCAR-00507", "88888", 507, this.connection.getEncoding().getEncoding());
        }
        return closeable;
    }

    public Writer setCharacterStream(long l2, int n2) throws SQLException {
        this.checkEmptyLob();
        if (l2 <= 0L) {
            throw new IllegalArgumentException("wrong parameter");
        }
        Closeable closeable = this.setBinaryStream(l2, n2);
        try {
            closeable = new OutputStreamWriter((OutputStream)closeable, this.connection.getEncoding().getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OSQLException("OSCAR-00507", "88888", 507, this.connection.getEncoding().getEncoding());
        }
        return closeable;
    }

    public long write(long l2, Reader reader, long l3) throws SQLException {
        long l4;
        if (reader == null) {
            throw new IllegalArgumentException("reader \u4e0d\u80fd\u4e3a null");
        }
        try {
            Writer writer = this.setCharacterStream(l2);
            l4 = StreamHandle.write(writer, reader, l3, this.getBufferSize());
            writer.close();
        }
        catch (IOException iOException) {
            throw new OSQLException("OSCAR-00508", "88888", 508);
        }
        return l4;
    }

    @Override
    public long write(long l2, InputStream inputStream, long l3) throws SQLException {
        long l4;
        try {
            Writer writer = this.setCharacterStream(l2, (int)l3);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "US-ASCII");
            l4 = StreamHandle.write(writer, inputStreamReader, l3, this.getBufferSize());
            writer.close();
        }
        catch (IOException iOException) {
            throw new OSQLException("OSCAR-00508", "88888", 508);
        }
        return l4;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public byte[] getDataInternal(long l2, int n2) throws SQLException {
        return super.getDataInternal(l2, n2);
    }

    @Override
    public Reader getCharacterStream(long l2, long l3) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog("connid" + this.connection.getSessionID() + ", " + OscarClob.class + " getCharacterStream(long pos,long length), pos:" + l2 + ",length:" + l3);
        }
        this.checkFree();
        if (l2 < 1L) {
            throw new SQLException("");
        }
        this.checkEmptyLob();
        try {
            return new InputStreamReader(this.getBinaryStream(l2, l3), this.connection.getEncoding().getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
    }
}

