/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.core.BaseConnection;
import com.oscar.core.BaseStatement;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.jdbc.OscarSQLXML;
import com.oscar.r2dbc.R2dbcNextPredicate;
import com.oscar.util.OSQLException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class OscarCursorResultSet
implements R2dbcNextPredicate,
ResultSet {
    private String cursorName = null;
    private int fetchSize = 1000;
    private ResultSet resultset = null;
    private BaseConnection conn;
    private Statement stmt = null;
    private String fetchSql = null;
    private int current_row = 0;

    public OscarCursorResultSet(String string, int n2, BaseConnection baseConnection) throws SQLException {
        this.cursorName = this.formatCursor(string);
        this.conn = baseConnection;
        this.fetchSize = n2 == 0 ? 1 : n2;
        this.fetchSql = "fetch forward " + n2 + " in " + this.cursorName;
        this.stmt = baseConnection.createStatement();
        this.fetchNextResultSet();
        baseConnection.addCursor(this.cursorName);
    }

    public String formatCursor(String string) {
        if (!string.startsWith("\"") || !string.endsWith("\"")) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void afterLast() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.resultset.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.resultset.close();
        this.conn.closeCursor(this.cursorName, (BaseStatement)((Object)this.stmt));
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public int findColumn(String string) throws SQLException {
        return this.resultset.findColumn(string);
    }

    @Override
    public boolean first() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getArray(n2);
    }

    @Override
    public Array getArray(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getArray(string);
    }

    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getAsciiStream(n2);
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getAsciiStream(string);
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBigDecimal(n2);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBigDecimal(string);
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBigDecimal(n2, n3);
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBigDecimal(string, n2);
    }

    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBinaryStream(n2);
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBinaryStream(string);
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBlob(n2);
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBlob(string);
    }

    @Override
    public boolean getBoolean(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBoolean(n2);
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBoolean(string);
    }

    @Override
    public byte getByte(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getByte(n2);
    }

    @Override
    public byte getByte(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getByte(string);
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBytes(n2);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getBytes(string);
    }

    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getCharacterStream(n2);
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getCharacterStream(string);
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getClob(n2);
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getClob(string);
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.cursorName;
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getDate(n2);
    }

    @Override
    public Date getDate(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getDate(string);
    }

    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        this.checkResultSet();
        return this.resultset.getDate(n2, calendar);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        this.checkResultSet();
        return this.resultset.getDate(string, calendar);
    }

    @Override
    public double getDouble(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getDouble(n2);
    }

    @Override
    public double getDouble(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getDouble(string);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public float getFloat(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getFloat(n2);
    }

    @Override
    public float getFloat(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getFloat(string);
    }

    @Override
    public int getInt(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getInt(n2);
    }

    @Override
    public int getInt(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getInt(string);
    }

    @Override
    public long getLong(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getLong(n2);
    }

    @Override
    public long getLong(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getLong(string);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkResultSet();
        return this.resultset.getMetaData();
    }

    @Override
    public Object getObject(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getObject(n2);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getObject(string);
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getRef(n2);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getRef(string);
    }

    @Override
    public int getRow() throws SQLException {
        return this.current_row;
    }

    @Override
    public short getShort(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getShort(n2);
    }

    @Override
    public short getShort(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getShort(string);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.stmt;
    }

    @Override
    public String getString(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getString(n2);
    }

    @Override
    public String getString(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getString(string);
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getTime(n2);
    }

    @Override
    public Time getTime(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getTime(string);
    }

    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        this.checkResultSet();
        return this.resultset.getTime(n2, calendar);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        this.checkResultSet();
        return this.resultset.getTime(string, calendar);
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getTimestamp(n2);
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getTimestamp(string);
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        this.checkResultSet();
        return this.resultset.getTimestamp(n2, calendar);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        this.checkResultSet();
        return this.resultset.getTimestamp(string, calendar);
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getURL(n2);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getURL(string);
    }

    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        this.checkResultSet();
        return this.resultset.getUnicodeStream(n2);
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        this.checkResultSet();
        return this.resultset.getUnicodeStream(string);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void insertRow() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.current_row == -1;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.current_row == 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.current_row == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public boolean last() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public boolean next() throws SQLException {
        if (this.resultset.next()) {
            ++this.current_row;
            return true;
        }
        this.fetchNextResultSet();
        if (this.resultset.next()) {
            ++this.current_row;
            return true;
        }
        this.current_row = -1;
        return false;
    }

    private void fetchNextResultSet() throws SQLException {
        if (this.resultset != null) {
            this.resultset.close();
        }
        this.stmt.execute(this.fetchSql);
        this.resultset = this.stmt.getResultSet();
    }

    @Override
    public boolean previous() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public boolean relative(int n2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void setFetchDirection(int n2) throws SQLException {
        if (n2 != 1000) {
            throw new OSQLException("OSCAR-00426", "88888", 426);
        }
    }

    @Override
    public void setFetchSize(int n2) throws SQLException {
        if (n2 < 0) {
            throw new OSQLException("OSCAR-00307", "88888", 307);
        }
        if (n2 > 0) {
            this.fetchSize = n2;
        }
    }

    @Override
    public void updateArray(int n2, Array array) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBlob(int n2, Blob blob) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBoolean(int n2, boolean bl) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateByte(int n2, byte by) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateClob(int n2, Clob clob) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateDate(int n2, Date date) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateDouble(int n2, double d2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateDouble(String string, double d2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateFloat(int n2, float f2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateFloat(String string, float f2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateInt(int n2, int n3) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateInt(String string, int n2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateLong(int n2, long l2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateLong(String string, long l2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNull(int n2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateObject(int n2, Object object) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateObject(int n2, Object object, int n3) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateObject(String string, Object object, int n2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateRef(int n2, Ref ref) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateRow() throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateShort(int n2, short s2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateShort(String string, short s2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateString(int n2, String string) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateTime(int n2, Time time) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.resultset.wasNull();
    }

    public void checkResultSet() throws SQLException {
        if (this.resultset == null) {
            throw new OSQLException("OSCAR-00427", "88888", 427);
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        this.checkResultSet();
        return this.resultset.getObject(n2, map);
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        this.checkResultSet();
        return this.resultset.getObject(string, map);
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateRowId(int n2, RowId rowId) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkResultSet();
        return this.resultset.getHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.checkResultSet();
        return this.resultset.isClosed();
    }

    @Override
    public void updateNString(int n2, String string) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNClob(int n2, NClob nClob) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        String string = this.getString(n2);
        if (string == null) {
            return null;
        }
        return new OscarSQLXML(this.conn, string);
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        OscarCursorResultSet oscarCursorResultSet = this;
        return oscarCursorResultSet.getSQLXML(oscarCursorResultSet.findColumn(string));
    }

    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public String getNString(int n2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public String getNString(String string) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateClob(int n2, Reader reader, long l2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateClob(String string, Reader reader, long l2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNClob(int n2, Reader reader, long l2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l2) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateClob(int n2, Reader reader) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNClob(int n2, Reader reader) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw new OSQLException("OSCAR-00426", "88888", 426);
    }

    @Override
    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        this.checkResultSet();
        return ((OscarResultSet)this.resultset).getObject(n2, clazz);
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        this.checkResultSet();
        return ((OscarResultSet)this.resultset).getObject(string, clazz);
    }

    @Override
    public boolean hasNext() throws SQLException {
        if (((R2dbcNextPredicate)((Object)this.resultset)).hasNext()) {
            return true;
        }
        if (((OscarResultSet)this.resultset).getTupleCount() == 0) {
            return false;
        }
        this.fetchNextResultSet();
        return this.hasNext();
    }
}

