/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.Encoding;
import com.oscar.core.Field;
import com.oscar.jdbc.OscarJdbc2Connection;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.protocol.ProtocolVersion;
import com.oscar.util.OSQLException;
import com.oscar.util.TableNameParser;
import com.oscar.util.converter.NumberConverter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class OscarDatabaseMetaData
implements DatabaseMetaData {
    private static final String keywords = "abort,absolute,access,accessed,action,add,admin,after,aggregate,all,alter,analyse,analyze,analyzer,and,any,archive,archivelog,array,as,asc,assertion,assignment,async,at,attributes,audit,auditfile,authid,authorization,auto_increment,autoextend,backup,backward,basicanalyzer,batchsize,before,begin,between,bigint,binary,binlog,bit,block,body,boolean,both,bpchar,buffer_pool,build,bulk,by,cache,call,called,cascade,cascaded,case,cast,cdc,chain,char,character,characteristics,cheat,check,check_constraints,checkpoint,chineseanalyzer,chunk,cjkanalyzer,class,clean,close,cluster,coalesce,codepage,collate,column,columns,comment,commit,committed,compile,complete,compress,configuration,connect,connect_by_iscycle,connect_by_isleaf,connect_by_root,constraint,constraints,constructor,content,context,controlfile,conversion,convert,copy,create,cross,csv,current,current_time,current_timestamp,current_user,cursor,cycle,data,database,databaselink,datafile,datafiletype,dateformat,day,dba,deallocate,debug,dec,decimal,declare,decode,decrypt,default,deferrable,deferred,definer,delete,delimiter,delimiters,demand,dense_rank,desc,description,deterministic,directory,disable,distinct,do,document,domain,double,drop,dump,each,else,enable,encoding,encrypt,encrypted,end,errors,escalation,escape,events,except,exchange,excluding,exclusive,exec,execute,exists,explain,export,external,externally,extract,false,fast,fetch,fieldterminator,file,filesize,fill,fire_triggers,first,firstrow,flashback,float,following,for,force,foreign,foreignkey_constraints,forever,formatfile,forward,freelists,freepools,from,full,fulltext,function,get,getaconststr,getclobval,global,global_name,globally,grant,greatest,group,guarantee,handler,hash,having,header,heap,hour,identified,if,ignore,ilike,immediate,immutable,implicit,import,import_polcol,in,including,increment,index,indexes,inherits,init,initial,initialized,initially,initrans,inner,inout,input,insensitive,insert,instead,int,integer,intersect,interval,into,invalidate,invisible,invoker,is,isnull,isolation,join,keep,keepidentity,keepnulls,key,kill,kilobytes_per_batch,kstore,lancompiler,language,last,lastrow,lc_collate,lc_ctype,leading,leak,least,left,less,level,lifetime,like,limit,list,listen,load,lob,local,localtime,localtimestamp,location,lock,log,logfile,logging,logical,long,loop,lsn,maintain_index,maintenance,match,matched,materialized,max,maxerrors,maxextends,maxsize,maxtrans,maxvalue,member,merge,min,minextends,minus,minute,minvalue,mod,mode,modify,month,mount,move,multicolumn,multiple,name,names,national,natural,nchar,never,new,next,nextval,no,noarchivelog,noaudit,nocache,nocompress,nocopy,nocycle,node,noguarantee,nologging,nomaxvalue,nominvalue,nomount,none,norecompute,normal,not,nothing,notify,notnull,novalidate,null,nullif,nulls,number,numeric,nvarchar2,nvl,nvl2,object,of,off,offline,offset,oids,old,on,online,only,open,operator,optimize,optimize_kscache,option,or,oracle,order,ordinality,organization,oscar,out,outer,over,overflow,overlaps,overlay,owner,package,pagesize,parameter,paraminfo,partial,partition,partitions,passing,password,path,pctfree,pctincrease,pctthreshold,pctused,pctversion,pendant,percent,petention,pfile,pipelined,placing,pls_integer,port,position,preceding,precision,prepare,preserve,preval,primary,prior,priority,privileges,procedural,procedure,public,purge,qu,query,quick,quote,range,raw,read,reads,real,rebuild,recheck,recovery,recycle,recyclebin,references,referencing,refresh,reject,relative,remove,rename,repeatable,replace,reset,resize,restart,restore,restrict,resume,retention,return,returning,returns,reuse,reverse,revoke,rewrite,right,role,rollback,row,rowdescription,rowid,rows,rows_per_batch,rowterminator,rowtype,rule,savepoint,scan,schema,scroll,second,security,segment,select,sequence,serializable,session,set,setof,share,show,shrink,shrinklog,shutdown,siblings,silently,similar,simple,single,singlerow,size,smallint,some,specification,split,stable,standalone,standardanalyzer,start,startfile,startpos,starttime,startup,statement,static,statistics,stdin,stdout,stopfile,stoppos,stoptime,stopwords,storage,store,strict,subpartition,subpartitions,substring,successful,suspend,switchover,sync,synonym,sys_connect_by_path,sysaux,sysid,system,table,tablespace,tablock,temp,tempfile,template,temporary,than,then,time,times,timestamp,timezone,tinyint,to,toast,top,trace,trail,trailing,transaction,transactional,treat,trigger,triggers,trim,true,truncate,trusted,tuple,type,unbounded,uncommitted,undo,unencrypted,union,unique,unknown,unlimited,unlisten,unlock,unmaintenance,until,unusable,up,update,updatelabel,updatexml,usage,use,user,using,vacuum,valid,validate,validation,validator,value,values,varbinary,varchar,varchar2,varying,verbose,version,view,visible,volatile,weight,when,whenever,where,window,with,without,work,write,xml,xmlattributes,xmlconcat,xmlelement,xmlforest,xmlparse,xmlpi,xmlroot,xmlserialize,xmltable,year,yes,zone,convert,";
    protected OscarJdbc2Connection connection;
    protected Encoding encoding;
    private static String databaseName = "OSCAR";
    private String databaseVersion;
    private static final String JDBC_NAME = "OSCAR JDBC DRIVER";
    private static final int JDBC_MAJOR_VERSION = 4;
    private static final int JDBC_MINOR_VERSION = 0;
    private static final String[] clientDes = new String[]{"The name of the application currently utilizing the connection.", "The name of the user currently utilizing the connection.", "The name of the Host currently utilizing the connection."};
    private Map<String, Integer> dbProps;
    private final int compatableDbms;
    private static final Hashtable<String, Map<String, String>> tableTypeClauses = new Hashtable();
    protected static String[] TYPE_NAME;
    protected static int[] DATA_TYPE;

    public OscarDatabaseMetaData(OscarJdbc2Connection oscarJdbc2Connection) {
        this.connection = oscarJdbc2Connection;
        this.encoding = oscarJdbc2Connection.getEncoding();
        this.dbProps = new HashMap<String, Integer>();
        this.compatableDbms = Integer.parseInt(oscarJdbc2Connection.getConnectionProperties().getProperty("COMPATABLE_DBMS", "0"));
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getUserName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        boolean bl = this.connection.isReadOnly();
        return bl;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return this.getValue("nullsAreSortedLoworHigh") == 1;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return this.getValue("nullsAreSortedLoworHigh") == 0;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return this.getValue("nullsAreSortedAtStartorEnd") == 1;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.getValue("nullsAreSortedAtStartorEnd") == 2;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return databaseName;
    }

    /*
     * Loose catch block
     */
    @Override
    public String getDatabaseProductVersion() throws SQLException {
        block15: {
            if (this.databaseVersion == null) {
                BaseResultSet baseResultSet;
                block14: {
                    baseResultSet = null;
                    baseResultSet = this.connection.execSQL("select version();");
                    if (!baseResultSet.next()) break block14;
                    this.databaseVersion = baseResultSet.getString(1);
                }
                try {
                    if (baseResultSet != null) {
                        baseResultSet.close();
                    }
                    break block15;
                }
                catch (Exception exception) {}
                break block15;
                catch (SQLException sQLException) {
                    try {
                        this.databaseVersion = "7.1";
                    }
                    catch (Throwable throwable) {
                        try {
                            if (baseResultSet != null) {
                                baseResultSet.close();
                            }
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    try {
                        if (baseResultSet != null) {
                            baseResultSet.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return this.databaseVersion;
    }

    @Override
    public String getDriverName() throws SQLException {
        return JDBC_NAME;
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return Driver.getVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return this.connection.getDriver().getMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return this.connection.getDriver().getMinorVersion();
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return this.getValue("usesLocalFiles") != 0;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return this.getValue("usesLocalFilePerTable") != 0;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.getValue("storesUpperCaseIdentifiers") != 0;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.getValue("storesLowerCaseIdentifiers") != 0;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.getValue("storesMixedCaseIdentifiers") != 0;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.getValue("storesUpperCaseQuotedIdentifiers") != 0;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.getValue("storesLowerCaseQuotedIdentifiers") != 0;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.getValue("storesMixedCaseQuotedIdentifiers") != 0;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return keywords;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "ASCII,CHAR,CONCAT,DIFFERENCE,INSERT_TEXT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPEAT,REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,SUBSTRING,UCASE";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "DATABASE,IFNULL,USER";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,WEEK,YEAR";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert(int n2, int n3) throws SQLException {
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                switch (n3) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: {
                        return true;
                    }
                }
                return false;
            }
            case -1: 
            case 1: 
            case 12: {
                switch (n3) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: 
                    case 91: 
                    case 92: 
                    case 93: {
                        return true;
                    }
                }
                return false;
            }
            case -4: 
            case -3: 
            case -2: {
                switch (n3) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 91: {
                switch (n3) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 93: {
                        return true;
                    }
                }
                return false;
            }
            case 92: {
                switch (n3) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 92: 
                    case 93: {
                        return true;
                    }
                }
                return false;
            }
            case 93: {
                switch (n3) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        return true;
                    }
                }
                return false;
            }
            case 2004: {
                switch (n3) {
                    case 2004: {
                        return true;
                    }
                }
                return false;
            }
            case 2005: {
                switch (n3) {
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case 2003: {
                switch (n3) {
                    case 2003: {
                        return true;
                    }
                }
                return false;
            }
            case 2006: {
                switch (n3) {
                    case 2006: {
                        return true;
                    }
                }
                return false;
            }
            case 70: {
                switch (n3) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 70: {
                        return true;
                    }
                }
                return false;
            }
            case 2002: {
                switch (n3) {
                    case 2002: {
                        return true;
                    }
                }
                return false;
            }
            case 1111: {
                switch (n3) {
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 0: {
                return true;
            }
            case 2000: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return this.getValue("isCatalogAtStart") != 0;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.getValue("MaxBinaryLiteralLength");
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return this.getValue("MaxCharLiteralLength");
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.getValue("MaxColumnNameLength");
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.getValue("MaxColumnsInGroupBy");
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return this.getValue("MaxColumnsInIndex");
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.getValue("MaxColumnsInOrderBy");
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return this.getValue("MaxColumnsInSelect");
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return this.getValue("MaxColumnsInTable");
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return this.getValue("MaxCursorNameLength");
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return this.getValue("MaxIndexLength");
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return this.getValue("MaxSchemaNameLength");
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.getValue("MaxProcedureNameLength");
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return this.getValue("MaxCatalogNameLength");
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return this.getValue("MaxRowSize");
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return this.getValue("MaxStatementLength");
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return this.getValue("MaxStatements");
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.getValue("MaxTableNameLength");
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return this.getValue("MaxTablesInSelect");
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.getValue("MaxUserNameLength");
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n2) throws SQLException {
        return n2 == 8 || n2 == 2;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.getValue("dataDefinitionCausesTransactionCommit") != 0;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return this.getValue("dataDefinitionIgnoredInTransactions") != 0;
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("SELECT PROCEDURE_CAT,PROCEDURE_SCHEM,PROCEDURE_NAME,NUM_INPUT_PARAMS,NUM_OUTPUT_PARAMS,NUM_RESULT_SETS,REMARKS,PROCEDURE_TYPE FROM V_SYS_PROCEDURE");
        if (string3 == null) {
            string3 = "%";
        }
        stringBuffer.append(" WHERE PROCEDURE_NAME LIKE ").append(TableNameParser.orgStringToQueryString(string3));
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(" AND PROCEDURE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(string2));
        }
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(" AND PROCEDURE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(string));
        }
        stringBuffer.append(" ORDER BY PROCEDURE_SCHEM");
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(stringBuffer.toString()));
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append("SELECT A.PROCEDURE_CAT,A.PROCEDURE_SCHEM,A.PROCEDURE_NAME,A.COLUMN_NAME,");
        stringBuffer.append("A.COLUMN_TYPE,A.DATA_TYPE,A.TYPE_NAME,");
        stringBuffer.append("A.COLUMN_SIZE AS \"PRECISION\",A.BUFFER_LENGTH AS LENGTH,");
        stringBuffer.append("A.DECIMAL_DIGITS AS SCALE,A.NUM_PREC_RADIX AS RADIX,A.NULLABLE,A.REMARKS");
        stringBuffer.append(" FROM V_SYS_PROCEDURE_PARAMS A");
        stringBuffer.append(" WHERE A.ORDINAL_POSITION >0 AND A.PROCEDURE_NAME LIKE ");
        stringBuffer.append(TableNameParser.orgStringToQueryString(string3));
        if (string4 != null && string4.trim().length() > 0) {
            stringBuffer.append(" AND A.COLUMN_NAME LIKE ").append(TableNameParser.orgStringToQueryString(string4));
        }
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(" AND A.PROCEDURE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(string2));
        }
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(" AND A.PROCEDURE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(string));
        }
        stringBuffer.append(" ORDER BY A.PROCEDURE_SCHEM,A.PROCEDURE_NAME,A.ORDINAL_POSITION");
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(stringBuffer.toString()));
    }

    @Override
    public ResultSet getTables(String object, String object2, String string, String[] stringArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, CASE WHEN (TABLE_TYPE='KSTORE') THEN 'TABLE' ELSE TABLE_TYPE END TABLE_TYPE, REMARKS, TYPE_CAT, NULL TYPE_SCHEM, TYPE_NAME, SELF_REFERENCING_COL_NAME, REF_GENERATION FROM V_SYS_TABLES");
        if (string == null) {
            string = "%";
        }
        stringBuffer.append(" WHERE TABLE_NAME LIKE ").append(TableNameParser.orgStringToQueryString(string));
        if (object2 != null) {
            stringBuffer.append(" AND TABLE_SCHEM LIKE ");
            if (((String)object2).trim().equals("")) {
                stringBuffer.append("NULL");
            } else {
                stringBuffer.append(TableNameParser.orgStringToQueryString((String)object2));
            }
        } else if (this.compatableDbms == 2) {
            stringBuffer.append(" AND TABLE_SCHEM = ").append(TableNameParser.orgStringToQueryString(this.getUserName()));
        }
        if (object != null && ((String)object).trim().length() != 0) {
            stringBuffer.append(" AND TABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString((String)object));
        }
        if (stringArray != null && stringArray.length > 0) {
            int n2;
            object = this.connection.getProtocolVersion();
            object2 = new ArrayList<String>();
            object2.addAll(Arrays.asList(stringArray));
            if ((((ProtocolVersion)object).isKstore() || ((ProtocolVersion)object).isMpp5()) && object2.contains("TABLE")) {
                object2.add("KSTORE");
            }
            stringBuffer.append(" AND (");
            for (n2 = 0; n2 < object2.size() - 1; ++n2) {
                stringBuffer.append(" TABLE_TYPE LIKE ").append(TableNameParser.orgStringToQueryString((String)object2.get(n2))).append(" OR");
            }
            stringBuffer.append(" TABLE_TYPE LIKE ").append(TableNameParser.orgStringToQueryString((String)object2.get(n2))).append(")");
        }
        stringBuffer.append(" ORDER BY TABLE_TYPE,TABLE_SCHEM,TABLE_NAME");
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(stringBuffer.toString()));
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        String string = "SELECT * FROM V_SYS_SCHEMAS";
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(string));
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        String string = " SELECT (CURRENT_DATABASE())::character varying(64) AS TABLE_CAT;";
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(string));
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        String string = "SELECT * FROM V_SYS_TABLE_TYPES";
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(string));
    }

    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("SELECT A.TABLE_CAT, A.TABLE_SCHEM, A.TABLE_NAME, A.COLUMN_NAME,");
        stringBuffer.append(" B.SQL_CONCISE_TYPE as DATA_TYPE, B.TYPE_NAME, A.COLUMN_SIZE, A.BUFFER_LENGTH,");
        stringBuffer.append(" A.DECIMAL_DIGITS, A.NUM_PREC_RADIX, A.NULLABLE, A.REMARKS, A.COLUMN_DEF,");
        stringBuffer.append(" B.SQL_DATA_TYPE, B.SQL_DATETIME_SUB, A.CHAR_OCTET_LENGTH,");
        stringBuffer.append(" A.ORDINAL_POSITION, A.IS_NULLABLE, A.SCOPE_CATALOG AS SCOPE_CATLOG, A.SCOPE_SHEMA SCOPE_SCHEMA, A.SCOPE_TABLE, A.SOURCE_DATA_TYPE,");
        String string5 = "CASE WHEN (SELECT ATTISAUTO FROM V_SYS_ATTRIBUTE WHERE A.COLUMN_NAME = ATTNAME AND ATTRELID = sys_get_relid(A.TABLE_SCHEM, A.TABLE_NAME)) then 'YES' else 'NO' end IS_AUTOINCREMENT ";
        ProtocolVersion protocolVersion = this.connection.getProtocolVersion();
        if (!protocolVersion.isMpp5() && !protocolVersion.isKstore() && this.connection.isSupportAuto()) {
            stringBuffer.append(string5).append(" , ");
        } else {
            stringBuffer.append(" 'NO' IS_AUTOINCREMENT,");
        }
        String string6 = "CASE WHEN (SELECT ATTGENERATED FROM V_SYS_ATTRIBUTE WHERE A.COLUMN_NAME = ATTNAME AND ATTRELID = sys_get_relid(A.TABLE_SCHEM, A.TABLE_NAME))  in ('v','s') then 'YES' else 'NO' end  IS_GENERATEDCOLUMN ";
        if (!protocolVersion.isMpp5() && !protocolVersion.isKstore() && this.connection.isSupportGenerated()) {
            stringBuffer.append(string6);
        } else {
            stringBuffer.append(" 'NO' IS_GENERATEDCOLUMN ");
        }
        stringBuffer.append(" FROM INFO_SCHEM.V_SYS_COLUMNS A ");
        stringBuffer.append(" LEFT JOIN INFO_SCHEM.V_SYS_TYPE_INFO B ON A.DATA_TYPE = B.DATA_TYPE");
        stringBuffer.append(" WHERE A.ORDINAL_POSITION > 0");
        if (string3 != null && string3.trim().length() > 0) {
            stringBuffer.append(" AND A.TABLE_NAME LIKE ").append(TableNameParser.orgStringToQueryString(string3));
        }
        if (string4 != null && string4.trim().length() > 0) {
            stringBuffer.append(" AND A.COLUMN_NAME LIKE ").append(TableNameParser.orgStringToQueryString(string4));
        }
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(" AND A.TABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(string2));
        } else if (this.compatableDbms == 2) {
            stringBuffer.append(" AND A.TABLE_SCHEM = ").append(TableNameParser.orgStringToQueryString(this.getUserName()));
        }
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(" AND A.TABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(string));
        }
        stringBuffer.append(" ORDER BY A.TABLE_SCHEM,A.TABLE_NAME,A.ORDINAL_POSITION");
        try {
            OscarDatabaseMetaData oscarDatabaseMetaData = this;
            return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(stringBuffer.toString()));
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            string2 = stringBuffer.toString();
            if (sQLException.getMessage().contains("ATTISAUTO")) {
                this.connection.setSupportAuto(false);
                string2 = string2.replace(string5, "'NO' IS_AUTOINCREMENT ");
                try {
                    OscarDatabaseMetaData oscarDatabaseMetaData = this;
                    return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(string2));
                }
                catch (SQLException sQLException3) {
                    sQLException2 = sQLException3;
                    sQLException2 = sQLException3;
                }
            }
            if (sQLException2.getMessage().contains("ATTGENERATED")) {
                this.connection.setSupportGenerated(false);
                string2 = string2.replace(string6, "'NO' IS_GENERATEDCOLUMN ");
                OscarDatabaseMetaData oscarDatabaseMetaData = this;
                return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(string2));
            }
            throw sQLException2;
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("SELECT TABLE_CAT,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,GRANTOR,GRANTEE,PRIVILEGE,IS_GRANTABLE FROM V_SYS_COLUMN_PRIVILEGES");
        stringBuffer.append(" WHERE TABLE_NAME LIKE ");
        if (string3 == null || string3.trim().length() == 0) {
            stringBuffer.append("'%'");
        } else {
            stringBuffer.append(TableNameParser.orgStringToQueryString(string3));
        }
        stringBuffer.append(" AND COLUMN_NAME LIKE ");
        if (string4 == null || string4.trim().length() == 0) {
            stringBuffer.append("'%'");
        } else {
            stringBuffer.append(TableNameParser.orgStringToQueryString(string4));
        }
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(" AND TABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(string2));
        }
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(" AND TABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(string));
        }
        stringBuffer.append(" ORDER BY COLUMN_NAME,PRIVILEGE");
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(stringBuffer.toString()));
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append("SELECT TABLE_CAT,TABLE_SCHEM,TABLE_NAME,GRANTOR,GRANTEE,");
        stringBuffer.append("PRIVILEGE,IS_GRANTABLE FROM V_SYS_TABLE_PRIVILEGES");
        stringBuffer.append(" WHERE TABLE_NAME LIKE ");
        if (string3 == null) {
            stringBuffer.append("'%'");
        } else {
            stringBuffer.append(TableNameParser.orgStringToQueryString(string3));
        }
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(" AND TABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(string2));
        }
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(" AND TABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(string));
        }
        stringBuffer.append(" ORDER BY TABLE_SCHEM,TABLE_NAME,PRIVILEGE");
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(stringBuffer.toString()));
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n2, boolean bl) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("SELECT SCOPE, A.COLUMN_NAME, B.DATA_TYPE, B.TYPE_NAME, ");
        stringBuffer.append(" A.COLUMN_SIZE, A.BUFFER_LENGTH, A.DECIMAL_DIGITS, A.PSEUDO_COLUMN");
        stringBuffer.append(" FROM V_SYS_BESTROWIDENTIFIER A, V_SYS_TYPE_INFO B, V_SYS_TABLES C");
        stringBuffer.append(" WHERE A.DATA_TYPE = B.DATA_TYPE");
        stringBuffer.append(" AND TABLE_NAME LIKE ");
        if (string3 == null) {
            stringBuffer.append("'%'");
        } else {
            stringBuffer.append(TableNameParser.orgStringToQueryString(string3));
        }
        stringBuffer.append(" AND SCOPE =").append(n2);
        stringBuffer.append(" AND TABLE_TYPE IN ('TABLE', 'SYSTEM TABLE')");
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(" AND TABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(string2));
        }
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(" AND TABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(string));
        }
        stringBuffer.append(" ORDER BY SCOPE");
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(stringBuffer.toString()));
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("SELECT SCOPE, A.COLUMN_NAME, B.DATA_TYPE, B.TYPE_NAME, ");
        stringBuffer.append(" A.COLUMN_SIZE, A.BUFFER_LENGTH, A.DECIMAL_DIGITS, A.PSEUDO_COLUMN");
        stringBuffer.append(" FROM V_SYS_VERSIONCOLUMNS A, V_SYS_TYPE_INFO B, V_SYS_TABLES C");
        stringBuffer.append(" WHERE A.DATA_TYPE = B.DATA_TYPE");
        stringBuffer.append(" AND TABLE_NAME LIKE ").append(TableNameParser.orgStringToQueryString(string3));
        stringBuffer.append(" AND TABLE_TYPE IN ('TABLE', 'SYSTEM TABLE')");
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(" AND TABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(string2));
        }
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(" AND TABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(string));
        }
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(stringBuffer.toString()));
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, KEY_SEQ, PK_NAME FROM V_SYS_PRIMARY_KEYS");
        stringBuffer.append(" WHERE TABLE_NAME LIKE ");
        if (string3 == null || string3.trim().length() == 0) {
            stringBuffer.append("'%'");
        } else {
            stringBuffer.append(TableNameParser.orgStringToQueryString(string3));
        }
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(" AND TABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(string2));
        } else if (this.compatableDbms == 2) {
            stringBuffer.append(" AND TABLE_SCHEM = ").append(TableNameParser.orgStringToQueryString(this.getUserName()));
        }
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(" AND TABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(string));
        }
        stringBuffer.append(" ORDER BY KEY_SEQ");
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(stringBuffer.toString()));
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("SELECT PKTABLE_CAT,PKTABLE_SCHEM,PKTABLE_NAME,PKCOLUMN_NAME,FKTABLE_CAT,FKTABLE_SCHEM,FKTABLE_NAME,FKCOLUMN_NAME,KEY_SEQ,UPDATE_RULE,DELETE_RULE,FK_NAME,PK_NAME,DEFERRABILITY");
        stringBuffer.append("  FROM V_SYS_FOREIGN_KEYS WHERE FKTABLE_NAME LIKE ");
        if (string3 == null) {
            stringBuffer.append("'%'");
        } else {
            stringBuffer.append(TableNameParser.orgStringToQueryString(string3));
        }
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(" AND FKTABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(string2));
        }
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(" AND FKTABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(string));
        }
        stringBuffer.append(" ORDER BY KEY_SEQ");
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(stringBuffer.toString()));
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("SELECT PKTABLE_CAT,PKTABLE_SCHEM,PKTABLE_NAME,PKCOLUMN_NAME,FKTABLE_CAT,FKTABLE_SCHEM,FKTABLE_NAME,FKCOLUMN_NAME,KEY_SEQ,UPDATE_RULE,DELETE_RULE,FK_NAME,PK_NAME,DEFERRABILITY ");
        stringBuffer.append(" FROM V_SYS_FOREIGN_KEYS WHERE PKTABLE_NAME LIKE ");
        if (string3 == null) {
            stringBuffer.append("'%'");
        } else {
            stringBuffer.append(TableNameParser.orgStringToQueryString(string3));
        }
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(" AND PKTABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(string2));
        }
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(" AND PKTABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(string));
        }
        stringBuffer.append(" ORDER BY KEY_SEQ");
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(stringBuffer.toString()));
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("SELECT PKTABLE_CAT,PKTABLE_SCHEM,PKTABLE_NAME,PKCOLUMN_NAME,FKTABLE_CAT,FKTABLE_SCHEM,FKTABLE_NAME,FKCOLUMN_NAME,KEY_SEQ,UPDATE_RULE,DELETE_RULE,FK_NAME,PK_NAME,DEFERRABILITY ");
        stringBuffer.append(" FROM V_SYS_FOREIGN_KEYS WHERE PKTABLE_NAME LIKE ");
        if (string3 == null) {
            stringBuffer.append("'%'");
        } else {
            stringBuffer.append(TableNameParser.orgStringToQueryString(string3));
        }
        stringBuffer.append(" AND FKTABLE_NAME LIKE ");
        if (string6 == null) {
            stringBuffer.append("'%'");
        } else {
            stringBuffer.append(TableNameParser.orgStringToQueryString(string6));
        }
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(" AND PKTABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(string2));
        }
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(" AND PKTABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(string));
        }
        if (string5 != null && string5.trim().length() > 0) {
            stringBuffer.append(" AND FKTABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(string5));
        }
        if (string4 != null && string4.trim().length() > 0) {
            stringBuffer.append(" AND FKTABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString(string4));
        }
        stringBuffer.append(" ORDER BY KEY_SEQ");
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(stringBuffer.toString()));
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        String string = "SELECT TYPE_NAME,SQL_CONCISE_TYPE AS DATA_TYPE,\"PRECISION\",LITERAL_PREFIX,LITERAL_SUFFIX,CREATE_PARAMS,NULLABLE,CASE_SENSITIVE,SEARCHABLE,UNSIGNED_ATTRIBUTE,FIXED_PREC_SCALE,AUTO_INCREMENT,LOCAL_TYPE_NAME,MINIMUM_SCALE,MAXIMUM_SCALE,SQL_DATA_TYPE,SQL_DATETIME_SUB,NUM_PREC_RADIX FROM V_SYS_TYPE_INFO ORDER BY DATA_TYPE";
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(string));
    }

    @Override
    public ResultSet getIndexInfo(String object, String string, String string2, boolean bl, boolean bl2) throws SQLException {
        if (string2 == null) {
            throw new OSQLException("OSCAR-00904", "88888", 904);
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("SELECT * FROM V_SYS_INDEX_STATISTICS");
        stringBuffer.append(" WHERE TABLE_NAME LIKE ").append(TableNameParser.orgStringToQueryString(string2));
        if (bl) {
            stringBuffer.append(" AND (NON_UNIQUE = 0 OR NON_UNIQUE IS NULL)");
        }
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(" AND TABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(string));
        } else if (this.compatableDbms == 2) {
            stringBuffer.append(" AND TABLE_SCHEM = ").append(TableNameParser.orgStringToQueryString(this.getUserName()));
        }
        if (object != null && ((String)object).trim().length() > 0) {
            stringBuffer.append(" AND TABLE_CAT LIKE ").append(TableNameParser.orgStringToQueryString((String)object));
        }
        stringBuffer.append(" ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION");
        object = this.connection.execSQL(stringBuffer.toString());
        this.resetColumnName((BaseResultSet)object);
        return (ResultSet)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new ResultSetInvocationHandler((OscarResultSet)object));
    }

    protected BaseResultSet resetColumnName(BaseResultSet baseResultSet) {
        Field[] fieldArray = baseResultSet.getFields();
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            fieldArray[i2].resetName();
        }
        return baseResultSet;
    }

    @Override
    public boolean supportsResultSetType(int n2) throws SQLException {
        return true;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n2, int n3) throws SQLException {
        if (n2 == 1005) {
            return false;
        }
        if (n3 == 1008) {
            return true;
        }
        return true;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n2) throws SQLException {
        return true;
    }

    @Override
    public boolean ownDeletesAreVisible(int n2) throws SQLException {
        return n2 != 1003;
    }

    @Override
    public boolean ownInsertsAreVisible(int n2) throws SQLException {
        return true;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n2) throws SQLException {
        if (n2 == 1003) {
            return Boolean.valueOf(this.connection.getConnectionProperties().getProperty("USESENSITIVECURSOR", "true"));
        }
        return n2 == 1005;
    }

    @Override
    public boolean othersDeletesAreVisible(int n2) throws SQLException {
        return n2 != 1003;
    }

    @Override
    public boolean othersInsertsAreVisible(int n2) throws SQLException {
        return true;
    }

    @Override
    public boolean updatesAreDetected(int n2) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int n2) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int n2) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String charSequence, String string, String string2, int[] objectArray) throws SQLException {
        charSequence = new StringBuffer(200);
        ((StringBuffer)charSequence).append("SELECT NULL AS TYPE_CAT, NSPNAME AS TYPE_SCHEM, NAME AS TYPE_NAME, NULL AS CLASS_NAME, '2002' AS DATA_TYPE, '2002' AS BASE_TYPE\uff0c NULL AS REMARKS  FROM INFO_SCHEM.SYS_PL_OBJ T LEFT JOIN INFO_SCHEM.V_SYS_NAMESPACE N  ON N.OID = TYPNAMESPACE WHERE 1 = 1");
        objectArray = new String[1];
        String[] stringArray = new String[1];
        if (string2 != null && string2.trim().length() != 0) {
            if (TableNameParser.parse(string2, (String[])objectArray, stringArray)) {
                ((StringBuffer)charSequence).append(" AND NAME LIKE ").append(TableNameParser.orgStringToQueryString(stringArray[0]));
                ((StringBuffer)charSequence).append(" AND N.NSPNAME LIKE ").append(TableNameParser.orgStringToQueryString((String)objectArray[0]));
            } else {
                ((StringBuffer)charSequence).append(" AND NAME LIKE ").append(TableNameParser.orgStringToQueryString(stringArray[0]));
            }
        }
        if (objectArray[0] == null && string != null && string.trim().length() != 0) {
            ((StringBuffer)charSequence).append(" AND N.NSPNAME LIKE ").append(TableNameParser.orgStringToQueryString(string));
        }
        ((StringBuffer)charSequence).append(" ORDER BY TYPE_SCHEM, TYPE_NAME");
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(((StringBuffer)charSequence).toString()));
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean rowChangesAreDetected(int n2) throws SQLException {
        return false;
    }

    public boolean rowChangesAreVisible(int n2) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL("select * from v_sys_super_types"));
    }

    @Override
    public ResultSet getSuperTables(String fieldArray, String string, String string2) throws SQLException {
        Field[] fieldArray2 = new Field[4];
        fieldArray = fieldArray2;
        fieldArray2[0] = new Field((BaseConnection)this.connection, "", 1042, 32, 0, "TABLE_CAT", "", "", 0);
        fieldArray[1] = new Field((BaseConnection)this.connection, "", 1042, 32, 0, "TABLE_SCHEM", "", "", 0);
        fieldArray[2] = new Field((BaseConnection)this.connection, "", 1042, 32, 0, "TABLE_NAME", "", "", 0);
        fieldArray[3] = new Field((BaseConnection)this.connection, "", 1042, 32, 0, "SUPERTABLE_NAME", "", "", 0);
        return this.connection.getDefaultStatement().createResultSet(fieldArray, new ArrayList<byte[][]>(), null, 0L, 0L);
    }

    @Override
    public ResultSet getAttributes(String fieldArray, String string, String string2, String string3) throws SQLException {
        Field[] fieldArray2 = new Field[21];
        fieldArray = fieldArray2;
        fieldArray2[0] = new Field((BaseConnection)this.connection, "", 1042, 32, 0, "TYPE_CAT", "", "", 0);
        fieldArray[1] = new Field((BaseConnection)this.connection, "", 1042, 32, 0, "TYPE_SCHEM", "", "", 0);
        fieldArray[2] = new Field((BaseConnection)this.connection, "", 1042, 32, 0, "TYPE_NAME", "", "", 0);
        fieldArray[3] = new Field((BaseConnection)this.connection, "", 1042, 32, 0, "ATTR_NAME", "", "", 0);
        fieldArray[4] = new Field((BaseConnection)this.connection, "", 21, 32, 0, "DATA_TYPE", "", "", 0);
        fieldArray[5] = new Field((BaseConnection)this.connection, "", 1042, 32, 0, "ATTR_TYPE_NAME", "", "", 0);
        fieldArray[6] = new Field((BaseConnection)this.connection, "", 23, 32, 0, "ATTR_SIZE", "", "", 0);
        fieldArray[7] = new Field((BaseConnection)this.connection, "", 23, 32, 0, "DECIMAL_DIGITS", "", "", 0);
        fieldArray[8] = new Field((BaseConnection)this.connection, "", 23, 32, 0, "NUM_PREC_RADIX", "", "", 0);
        fieldArray[9] = new Field((BaseConnection)this.connection, "", 23, 32, 0, "NULLABLE", "", "", 0);
        fieldArray[10] = new Field((BaseConnection)this.connection, "", 1042, 32, 0, "REMARKS", "", "", 0);
        fieldArray[11] = new Field((BaseConnection)this.connection, "", 1042, 32, 0, "ATTR_DEF", "", "", 0);
        fieldArray[12] = new Field((BaseConnection)this.connection, "", 23, 32, 0, "SQL_DATA_TYPE", "", "", 0);
        fieldArray[13] = new Field((BaseConnection)this.connection, "", 23, 32, 0, "SQL_DATETIME_SUB", "", "", 0);
        fieldArray[14] = new Field((BaseConnection)this.connection, "", 23, 32, 0, "CHAR_OCTET_LENGTH", "", "", 0);
        fieldArray[15] = new Field((BaseConnection)this.connection, "", 23, 32, 0, "ORDINAL_POSITION", "", "", 0);
        fieldArray[16] = new Field((BaseConnection)this.connection, "", 1042, 32, 0, "IS_NULLABLE", "", "", 0);
        fieldArray[17] = new Field((BaseConnection)this.connection, "", 1042, 32, 0, "SCOPE_CATALOG", "", "", 0);
        fieldArray[18] = new Field((BaseConnection)this.connection, "", 1042, 32, 0, "SCOPE_SCHEMA", "", "", 0);
        fieldArray[19] = new Field((BaseConnection)this.connection, "", 1042, 32, 0, "SCOPE_TABLE", "", "", 0);
        fieldArray[20] = new Field((BaseConnection)this.connection, "", 21, 32, 0, "SOURCE_DATA_TYPE", "", "", 0);
        return this.connection.getDefaultStatement().createResultSet(fieldArray, new ArrayList<byte[][]>(), null, 0L, 0L);
    }

    @Override
    public boolean supportsResultSetHoldability(int n2) throws SQLException {
        return true;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.connection.getVersion().getDBMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.connection.getVersion().getDBMinorVersion();
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 1;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    private Integer getValue(String string) throws SQLException {
        if (this.dbProps.get(string) == null) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.connection.prepareStatement("select NAME, VALUE  from v_sys_limits");
                preparedStatement.setFetchSize(0);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    if (resultSet.getString(1).equalsIgnoreCase("MaxKstoreDPDataSize")) continue;
                    this.dbProps.put(resultSet.getString(1), resultSet.getInt(2));
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        return this.dbProps.get(string);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT TABLE_SCHEM, TABLE_CATALOG FROM V_SYS_SCHEMAS");
        if (string2 == null) {
            string2 = "%";
        }
        stringBuffer.append(" WHERE TABLE_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(string2));
        if (string != null && !string.trim().isEmpty()) {
            stringBuffer.append(" AND TABLE_CATALOG LIKE ").append(TableNameParser.orgStringToQueryString(string));
        }
        stringBuffer.append(" order by TABLE_CATALOG ,TABLE_SCHEM");
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(stringBuffer.toString()));
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        Field[] fieldArray = new Field[4];
        Field[] fieldArray2 = fieldArray;
        fieldArray[0] = new Field(this.connection, "NAME", this.connection.getDBTypeOid("VARCHAR"), 127, "NAME");
        fieldArray2[1] = new Field(this.connection, "MAX_LEN", this.connection.getDBTypeOid("INT4"), 4, "MAX_LEN");
        fieldArray2[2] = new Field(this.connection, "DEFAULT_VALUE", this.connection.getDBTypeOid("VARCHAR"), 127, "DEFAULT_VALUE");
        fieldArray2[3] = new Field(this.connection, "DESCRIPTION", this.connection.getDBTypeOid("VARCHAR"), 127, "DESCRIPTION");
        ArrayList<byte[][]> arrayList = new ArrayList<byte[][]>();
        String[] stringArray = this.connection.getClientpro();
        String[] stringArray2 = stringArray;
        stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray2[i2];
            byte[][] byArrayArray = new byte[4][];
            byte[][] byArrayArray2 = byArrayArray;
            byArrayArray[0] = this.connection.getEncoding().encode(string);
            byArrayArray2[1] = this.connection.getEncoding().encode(Integer.toString(127));
            byArrayArray2[2] = this.connection.getEncoding().encode("");
            byArrayArray2[3] = this.connection.getEncoding().encode(clientDes[arrayList.size()]);
            arrayList.add(byArrayArray2);
        }
        return this.connection.getDefaultStatement().createResultSet(fieldArray2, arrayList, "OK", 3L, 0L);
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select * from (SELECT (CURRENT_DATABASE())::character varying(128) AS FUNCTION_CAT, N.NSPNAME AS FUNCTION_SCHEM, P.PRONAME AS FUNCTION_NAME, D.\"DESCRIPTION\" AS REMARKS,CASE WHEN (P.PRORETTYPE = (2278)::OID) THEN 1 ELSE 2 END AS FUNCTION_TYPE, NULL as SPECIFIC_NAME   FROM ((INFO_SCHEM.V_SYS_PROC P ").append("LEFT JOIN INFO_SCHEM.V_SYS_DESCRIPTION D ON ((P.OID = D.OBJOID))) JOIN INFO_SCHEM.V_SYS_LANGUAGE L ON ((L.OID = P.PROLANG))), INFO_SCHEM.V_SYS_NAMESPACE N WHERE (((L.LANNAME = 'ploscar'::\"NAME\") AND (N.OID = P.PRONAMESPACE)) AND (P.PROISFUNC = 1)))");
        if (string3 == null) {
            string3 = "%";
        }
        stringBuffer.append(" WHERE FUNCTION_NAME  LIKE ").append(TableNameParser.orgStringToQueryString(string3));
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(" AND FUNCTION_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(string2));
        }
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(" AND FUNCTION_CAT LIKE ").append(TableNameParser.orgStringToQueryString(string));
        }
        stringBuffer.append(" order by FUNCTION_CAT, FUNCTION_SCHEM ,FUNCTION_NAME");
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(stringBuffer.toString()));
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select * from (SELECT (CURRENT_DATABASE())::character varying(128) AS FUNCTION_CAT, N.NSPNAME AS FUNCTION_SCHEM, PROC.PRONAME AS FUNCTION_NAME, IFNULL(PARAMS.PARAMNAME, ' '::\"NAME\") AS COLUMN_NAME, ").append("CASE WHEN (PARAMS.PARAMINOUT = 0) THEN 0 WHEN (PARAMS.PARAMINOUT = 1) THEN 1 WHEN (PARAMS.PARAMINOUT = 2) THEN 4 WHEN (PARAMS.PARAMINOUT = 3) THEN 2 ELSE NULL END AS COLUMN_TYPE, PARAMS.PARAMTYP AS DATA_TYPE, T.TYPNAME AS TYPE_NAME,").append("CASE WHEN (PARAMS.PARAMTYP = (16)::OID) THEN 1 WHEN (PARAMS.PARAMTYP = (17)::OID) THEN 8000 WHEN (PARAMS.PARAMTYP = (18)::OID) THEN 1 WHEN (PARAMS.PARAMTYP = (19)::OID) THEN 128 WHEN (PARAMS.PARAMTYP = (20)::OID) THEN 19 WHEN (PARAMS.PARAMTYP = (21)::OID) THEN 5 WHEN (PARAMS.PARAMTYP = (23)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (25)::OID) THEN 8000 WHEN (PARAMS.PARAMTYP = (26)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (700)::OID) THEN 24 WHEN (PARAMS.PARAMTYP = (701)::OID) THEN 53 WHEN (PARAMS.PARAMTYP = (702)::OID) THEN 22 WHEN (PARAMS.PARAMTYP = (972)::OID) THEN 3 WHEN (PARAMS.PARAMTYP = (1042)::OID) THEN (PARAMS.TYPMOD - 4) WHEN (PARAMS.PARAMTYP = (1043)::OID) THEN (PARAMS.TYPMOD - 4) WHEN (PARAMS.PARAMTYP = (1082)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (1083)::OID) THEN 8 WHEN (PARAMS.PARAMTYP = (1114)::OID) THEN 19 WHEN (PARAMS.PARAMTYP = (1184)::OID) THEN 22 WHEN (PARAMS.PARAMTYP = (1186)::OID) THEN 33 WHEN (PARAMS.PARAMTYP = (1365)::OID) THEN (PARAMS.TYPMOD - 4) WHEN (PARAMS.PARAMTYP = (1700)::OID) THEN (PARAMS.TYPMOD >> 16) WHEN (PARAMS.PARAMTYP = (2174)::OID) THEN 24 WHEN (PARAMS.PARAMTYP = (2175)::OID) THEN 53 WHEN (PARAMS.PARAMTYP = (2315)::OID) THEN (PARAMS.TYPMOD >> 16) WHEN (PARAMS.PARAMTYP = (3100)::OID) THEN (PARAMS.TYPMOD - 4) ELSE NULL END AS PRECISION, CASE WHEN (PARAMS.PARAMTYP = (16)::OID) THEN 1 WHEN (PARAMS.PARAMTYP = (17)::OID) THEN 8000 WHEN (PARAMS.PARAMTYP = (18)::OID) THEN 1 WHEN (PARAMS.PARAMTYP = (19)::OID) THEN 128 WHEN (PARAMS.PARAMTYP = (20)::OID) THEN 8 WHEN (PARAMS.PARAMTYP = (21)::OID) THEN 2 WHEN (PARAMS.PARAMTYP = (23)::OID) THEN 4 WHEN (PARAMS.PARAMTYP = (25)::OID) THEN 8000 WHEN (PARAMS.PARAMTYP = (26)::OID) THEN 4 WHEN (PARAMS.PARAMTYP = (700)::OID) THEN 4 WHEN (PARAMS.PARAMTYP = (701)::OID) THEN 8 WHEN (PARAMS.PARAMTYP = (702)::OID) THEN 22 WHEN (PARAMS.PARAMTYP = (972)::OID) THEN 1 WHEN (PARAMS.PARAMTYP = (1042)::OID) THEN (PARAMS.TYPMOD - 4) WHEN (PARAMS.PARAMTYP = (1043)::OID) THEN (PARAMS.TYPMOD - 4) WHEN").append("(PARAMS.PARAMTYP = (1082)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (1083)::OID) THEN 8 WHEN (PARAMS.PARAMTYP = (1114)::OID) THEN 19 WHEN (PARAMS.PARAMTYP = (1184)::OID) THEN 22 WHEN (PARAMS.PARAMTYP = (1186)::OID) THEN 33 WHEN (PARAMS.PARAMTYP = (1365)::OID) THEN (PARAMS.TYPMOD - 4) WHEN (PARAMS.PARAMTYP = (1700)::OID) THEN (PARAMS.TYPMOD >> 16) WHEN (PARAMS.PARAMTYP = (2174)::OID) THEN 4 WHEN (PARAMS.PARAMTYP = (2175)::OID) THEN 8 WHEN (PARAMS.PARAMTYP = (2315)::OID) THEN (PARAMS.TYPMOD >> 16) WHEN (PARAMS.PARAMTYP = (3100)::OID) THEN (PARAMS.TYPMOD - 4) ELSE NULL END AS LENGTH, CASE WHEN (PARAMS.PARAMTYP = (1700)::OID) THEN ((PARAMS.TYPMOD & 65535) - 4) WHEN (PARAMS.PARAMTYP = (2315)::OID) THEN ((PARAMS.TYPMOD & 65535) - 4) ELSE NULL END AS SCALE,").append("CASE WHEN (PARAMS.PARAMTYP = (20)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (21)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (23)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (26)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (700)::OID) THEN 2 WHEN (PARAMS.PARAMTYP = (701)::OID) THEN 2 WHEN (PARAMS.PARAMTYP = (972)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (1700)::OID) THEN 10 WHEN (PARAMS.PARAMTYP = (2174)::OID) THEN 2 WHEN (PARAMS.PARAMTYP = (2175)::OID) THEN 2 WHEN (PARAMS.PARAMTYP = (2315)::OID) THEN 10 ELSE NULL END AS RADIX, CASE WHEN (PARAMS.NULLABLE = TRUE) THEN 1::smallint WHEN (PARAMS.NULLABLE = FALSE) THEN 0::smallint ELSE 2::smallint END AS NULLABLE, ").append("D.\"DESCRIPTION\" AS REMARKS, CASE WHEN (PARAMS.PARAMTYP = (17)::OID) THEN 8000 WHEN (PARAMS.PARAMTYP = (18)::OID) THEN 1 WHEN (PARAMS.PARAMTYP = (25)::OID) THEN 8000 WHEN (PARAMS.PARAMTYP = (1042)::OID) THEN (PARAMS.TYPMOD - 4) WHEN (PARAMS.PARAMTYP = (1043)::OID) THEN (PARAMS.TYPMOD - 4) ELSE NULL END AS CHAR_OCTET_LENGTH, PARAMS.\"SEQUENCE\" AS ORDINAL_POSITION, (CASE WHEN (PARAMS.NULLABLE = TRUE) THEN 'YES' WHEN (PARAMS.NULLABLE = FALSE) THEN 'NO' ELSE '' END)::character varying(3) AS IS_NULLABLE, NULL AS SPECIFIC_NAME").append(" FROM ((INFO_SCHEM.V_SYS_PROC PROC JOIN INFO_SCHEM.V_SYS_PROC_PARAMS PARAMS ON ((PROC.OID = PARAMS.PROCOID))) LEFT JOIN INFO_SCHEM.V_SYS_DESCRIPTION D ON (((PARAMS.PROCOID = D.OBJOID) AND (PARAMS.\"SEQUENCE\" = D.OBJSUBID)))), INFO_SCHEM.V_SYS_NAMESPACE N, INFO_SCHEM.V_SYS_TYPE T WHERE ((PROC.PRONAMESPACE = N.OID) AND (T.OID = PARAMS.PARAMTYP) AND (PROC.PROISFUNC = 1)))");
        if (string3 == null) {
            string3 = "%";
        }
        stringBuffer.append(" WHERE FUNCTION_NAME  LIKE ").append(TableNameParser.orgStringToQueryString(string3));
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(" AND FUNCTION_SCHEM LIKE ").append(TableNameParser.orgStringToQueryString(string2));
        }
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(" AND FUNCTION_CAT LIKE ").append(TableNameParser.orgStringToQueryString(string));
        }
        if (string4 != null && string4.trim().length() > 0) {
            stringBuffer.append(" AND COLUMN_NAME LIKE ").append(TableNameParser.orgStringToQueryString(string4));
        }
        stringBuffer.append(" order by FUNCTION_CAT, FUNCTION_SCHEM ,FUNCTION_NAME,ORDINAL_POSITION");
        OscarDatabaseMetaData oscarDatabaseMetaData = this;
        return oscarDatabaseMetaData.resetColumnName(oscarDatabaseMetaData.connection.execSQL(stringBuffer.toString()));
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        return null;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    static {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        tableTypeClauses.put("TABLE", hashtable);
        hashtable.put("SCHEMAS", "c.relkind = 'r' AND n.nspname NOT LIKE 'pg\\\\_%'");
        hashtable.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname NOT LIKE 'pg\\\\_%'");
        hashtable = new Hashtable();
        tableTypeClauses.put("VIEW", hashtable);
        hashtable.put("SCHEMAS", "c.relkind = 'v' AND n.nspname <> 'INFO_SCHEM'");
        hashtable.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname NOT LIKE 'pg\\\\_%'");
        hashtable = new Hashtable();
        tableTypeClauses.put("INDEX", hashtable);
        hashtable.put("SCHEMAS", "c.relkind = 'i' AND n.nspname NOT LIKE 'pg\\\\_%'");
        hashtable.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname NOT LIKE 'pg\\\\_%'");
        hashtable = new Hashtable();
        tableTypeClauses.put("SEQUENCE", hashtable);
        hashtable.put("SCHEMAS", "c.relkind = 'S'");
        hashtable.put("NOSCHEMAS", "c.relkind = 'S'");
        hashtable = new Hashtable();
        tableTypeClauses.put("SYSTEM TABLE", hashtable);
        hashtable.put("SCHEMAS", "c.relkind = 'r' AND n.nspname = 'INFO_SCHEM'");
        hashtable.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'pg\\\\_%' AND c.relname NOT LIKE 'pg\\\\_toast\\\\_%' AND c.relname NOT LIKE 'pg\\\\_temp\\\\_%'");
        hashtable = new Hashtable();
        tableTypeClauses.put("SYSTEM TOAST TABLE", hashtable);
        hashtable.put("SCHEMAS", "c.relkind = 'r' AND n.nspname = 'sys_toast'");
        hashtable.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'pg\\\\_toast\\\\_%'");
        hashtable = new Hashtable();
        tableTypeClauses.put("SYSTEM TOAST INDEX", hashtable);
        hashtable.put("SCHEMAS", "c.relkind = 'i' AND n.nspname = 'sys_toast'");
        hashtable.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname LIKE 'pg\\\\_toast\\\\_%'");
        hashtable = new Hashtable();
        tableTypeClauses.put("SYSTEM VIEW", hashtable);
        hashtable.put("SCHEMAS", "c.relkind = 'v' AND n.nspname = 'INFO_SCHEM' ");
        hashtable.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname LIKE 'pg\\\\_%'");
        hashtable = new Hashtable();
        tableTypeClauses.put("SYSTEM INDEX", hashtable);
        hashtable.put("SCHEMAS", "c.relkind = 'i' AND n.nspname = 'INFO_SCHEM'");
        hashtable.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname LIKE 'pg\\\\_%' AND c.relname NOT LIKE 'pg\\\\_toast\\\\_%' AND c.relname NOT LIKE 'pg\\\\_temp\\\\_%'");
        hashtable = new Hashtable();
        tableTypeClauses.put("TEMPORARY TABLE", hashtable);
        hashtable.put("SCHEMAS", "c.relkind = 'r' AND n.nspname LIKE 'pg\\\\_temp\\\\_%' ");
        hashtable.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'pg\\\\_temp\\\\_%' ");
        hashtable = new Hashtable();
        tableTypeClauses.put("TEMPORARY INDEX", hashtable);
        hashtable.put("SCHEMAS", "c.relkind = 'i' AND n.nspname LIKE 'pg\\\\_temp\\\\_%' ");
        hashtable.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname LIKE 'pg\\\\_temp\\\\_%' ");
        TYPE_NAME = new String[]{"ARRAY", "BIGINT", "BINARY", "BIT", "BLOB", "BOOLEAN", "CHAR", "CLOB", "DATALINK", "DATE", "DECIMAL", "DISTINCT", "DOUBLE", "FLOAT", "INTEGER", "JAVA_OBJECT", "LONBINARY", "LONGVARCHAR", "NULL", "NUMERIC", "OTHER", "REAL", "REF", "SMALLINT", "STRUCT", "TIME", "TIMESTAMP", "TINYINT", "VARBINARY", "VARCHAR"};
        DATA_TYPE = new int[]{2003, -5, -2, -7, 2004, 16, 1, 2005, 70, 91, 3, 2001, 8, 6, 4, 2000, -4, -1, 0, 2, 1111, 7, 2006, 5, 2002, 92, 93, -6, -3, 12};
    }

    private class ResultSetInvocationHandler
    implements InvocationHandler {
        private static final int indexNonunique = 3;
        private final OscarResultSet resultSet;

        ResultSetInvocationHandler(OscarResultSet oscarResultSet) {
            this.resultSet = oscarResultSet;
            try {
                ResultSetInvocationHandler resultSetInvocationHandler = this;
                resultSetInvocationHandler.convertValue(resultSetInvocationHandler.resultSet);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                OscarDatabaseMetaData.this = numberFormatException;
                numberFormatException.printStackTrace();
                return;
            }
            catch (SQLException sQLException) {
                OscarDatabaseMetaData.this = sQLException;
                sQLException.printStackTrace();
                return;
            }
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (objectArray != null && objectArray.length == 1 && ("NON_UNIQUE".equalsIgnoreCase(objectArray[0].toString()) || "3".equals(objectArray[0].toString())) && "getBoolean".equals(method.getName()) && this.resultSet.this_row[3] == null) {
                return Boolean.TRUE;
            }
            object = method.invoke((Object)this.resultSet, objectArray);
            return object;
        }

        private void convertValue(BaseResultSet baseResultSet) throws NumberFormatException, SQLException {
            Object object = baseResultSet.getTuples();
            object = object.iterator();
            while (object.hasNext()) {
                int n2;
                byte[][] byArray = (byte[][])object.next();
                if (byArray[3] == null || (n2 = OscarDatabaseMetaData.this.connection.compatibleOldProtocol || OscarDatabaseMetaData.this.connection.netDataByStr ? Integer.parseInt(OscarDatabaseMetaData.this.encoding.decode(byArray[3])) : NumberConverter.convertBytesToInt(byArray[3])) < 0) continue;
                byArray[3] = OscarDatabaseMetaData.this.encoding.encode(String.valueOf(n2 == 1));
            }
            baseResultSet.getFields()[3].setOID(16);
        }
    }
}

