/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.core.BaseConnection;
import com.oscar.core.ExportBinlogHandler;
import com.oscar.jdbc.BlogResultSet;
import com.oscar.jdbc.ExceptionUtil;
import com.oscar.protocol.a.N;
import com.oscar.util.OSQLException;
import java.sql.SQLException;

public class OscarExportBinlogHandler
implements ExportBinlogHandler {
    BaseConnection conn = null;
    String startFile = null;
    long startPos;
    String stopFile = null;
    long stopPos;
    int exportFileSize = 10;
    String exportSQL = "BINLOG EXPORT";
    String exportFile = "tmp.txt";

    public OscarExportBinlogHandler(BaseConnection baseConnection) {
        this.conn = baseConnection;
    }

    public OscarExportBinlogHandler(BaseConnection baseConnection, String string, int n2) {
        this.conn = baseConnection;
        this.exportFile = string;
        this.exportFileSize = n2;
    }

    public OscarExportBinlogHandler(BaseConnection baseConnection, String string, long l2, String string2, long l3, int n2) {
        this.conn = baseConnection;
        this.startFile = string;
        this.startPos = l2;
        this.stopFile = string2;
        this.stopPos = l3;
        this.exportFileSize = n2;
    }

    public OscarExportBinlogHandler(BaseConnection baseConnection, String string, long l2, String string2, long l3, String string3, int n2) {
        this.conn = baseConnection;
        this.startFile = string;
        this.startPos = l2;
        this.stopFile = string2;
        this.stopPos = l3;
        this.exportFile = string3;
        this.exportFileSize = n2;
    }

    @Override
    public BlogResultSet exportBinlogData() throws OSQLException, Exception {
        Object object;
        this.initParams();
        try {
            this.conn.getProtocol().a(this);
            object = new N(this.exportSQL.getBytes(), 0);
            object = this.conn.getProtocol().c((N)object);
        }
        catch (OSQLException oSQLException) {
            this.checkConnectionClosed(oSQLException);
            throw oSQLException;
        }
        catch (Exception exception) {
            this.checkConnectionClosed(exception);
            throw exception;
        }
        return object;
    }

    private void initParams() {
        if (this.startFile != null) {
            this.exportSQL = this.exportSQL + " STARTFILE '" + this.startFile + "'";
        }
        if (this.startPos != 0L) {
            this.exportSQL = this.exportSQL + " STARTPOS " + this.startPos;
        }
        if (this.stopFile != null) {
            this.exportSQL = this.exportSQL + " STOPFILE '" + this.stopFile + "'";
        }
        if (this.stopPos != 0L) {
            this.exportSQL = this.exportSQL + " STOPPOS " + this.stopPos;
        }
        this.exportSQL = this.exportSQL + " FILESIZE " + this.exportFileSize + "M";
    }

    @Override
    public BaseConnection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public void setStartFile(String string) {
        this.startFile = string;
    }

    @Override
    public void setStartPos(int n2) {
        this.startPos = n2;
    }

    @Override
    public void setStopFile(String string) {
        this.stopFile = string;
    }

    @Override
    public void setStopPos(int n2) {
        this.stopPos = n2;
    }

    @Override
    public String getExportFile() {
        return this.exportFile;
    }

    @Override
    public long getStartPos() {
        return this.startPos;
    }

    @Override
    public void close() {
        this.exportFile = null;
        this.exportSQL = null;
        this.startFile = null;
        this.stopFile = null;
        this.startPos = 0L;
        this.stopPos = 0L;
    }

    void checkConnectionClosed(Exception exception) {
        switch (ExceptionUtil.isConnectionClosed(exception)) {
            case 1: {
                this.close();
                try {
                    this.conn.close();
                    return;
                }
                catch (SQLException sQLException) {
                    exception = sQLException;
                    sQLException.printStackTrace();
                    return;
                }
            }
            case 2: {
                try {
                    if (this.conn.isClosed()) {
                        return;
                    }
                }
                catch (SQLException sQLException) {
                    exception = sQLException;
                    sQLException.printStackTrace();
                }
                this.close();
                try {
                    this.conn.close();
                    return;
                }
                catch (SQLException sQLException) {
                    exception = sQLException;
                    sQLException.printStackTrace();
                }
            }
        }
    }
}

