/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.core.ExportDistribute;
import com.oscar.core.ExportHandler;
import com.oscar.jdbc.CSVExportStringCallback;
import com.oscar.jdbc.MetaData;
import com.oscar.jdbc.OscarJdbc2Connection;
import com.oscar.util.Bucket;
import com.oscar.util.HashPartitionMap;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OscarExportDistribute
implements ExportDistribute {
    private MetaData metadata;
    private HashPartitionMap hashPartitionMap;
    private HashMap distributeHandlers;
    private HashMap realHandlers;
    private HashMap buckets;
    private Connection conn;
    private String tableName;
    private String userName;
    private String password;
    private int exportSize = 1000;

    public OscarExportDistribute(Connection connection, String string, String string2, String string3) throws SQLException {
        this.conn = connection;
        this.tableName = string;
        this.userName = string2;
        this.password = string3;
        this.initExportHandlers();
        this.initExportBuckets();
    }

    public void initExportHandlers() throws SQLException {
        this.metadata = new MetaData(this.conn);
        this.hashPartitionMap = new HashPartitionMap(8);
        int n2 = this.hashPartitionMap.getTableId(this.metadata, this.tableName);
        this.hashPartitionMap.initBucketCount(this.metadata, n2);
        this.hashPartitionMap.readMapFromMetadataDB(this.metadata, n2);
        this.realHandlers = new HashMap();
        this.distributeHandlers = new HashMap();
        ArrayList[] arrayListArray = this.hashPartitionMap.getMappingTable();
        int n3 = arrayListArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            ArrayList<Object> arrayList = new ArrayList<Object>(0);
            Iterator iterator = arrayListArray[i2].iterator();
            while (iterator.hasNext()) {
                Object object;
                String string = this.metadata.getUrl((Integer)iterator.next());
                if (this.realHandlers.containsKey(string)) {
                    object = (ExportHandler)this.realHandlers.get(string);
                } else {
                    object = DriverManager.getConnection(string, this.userName, this.password);
                    object.setAutoCommit(false);
                    object = ((OscarJdbc2Connection)object).createExportHandler();
                    object.setFetchSize(this.exportSize);
                    this.realHandlers.put(string, object);
                }
                arrayList.add(object);
            }
            this.distributeHandlers.put(i2, arrayList);
        }
    }

    public void initExportBuckets() {
        this.buckets = new HashMap();
        ArrayList[] arrayListArray = this.hashPartitionMap.getMappingTable();
        int n2 = arrayListArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Bucket bucket = new Bucket(i2, arrayListArray[i2].size());
            this.buckets.put(i2, bucket);
        }
    }

    @Override
    public void close() throws SQLException {
        Object object = this.realHandlers.entrySet();
        object = object.iterator();
        while (object.hasNext()) {
            ExportHandler exportHandler = (ExportHandler)((Map.Entry)object.next()).getValue();
            exportHandler.close();
        }
    }

    @Override
    public long getExportCount() {
        long l2 = 0L;
        Object object = this.realHandlers.entrySet();
        object = object.iterator();
        while (object.hasNext()) {
            ExportHandler exportHandler = (ExportHandler)((Map.Entry)object.next()).getValue();
            long l3 = exportHandler.getExportCount();
            if (l3 <= 0L) continue;
            l2 += l3;
        }
        return l2;
    }

    @Override
    public void setFetchSize(int n2) {
        this.exportSize = n2;
    }

    @Override
    public void executeExport(String string, String string2, String string3, Character c2, boolean bl) throws SQLException {
        try {
            boolean bl2 = true;
            Object object = this.realHandlers.entrySet();
            object = object.iterator();
            while (object.hasNext()) {
                ExportHandler exportHandler = (ExportHandler)((Map.Entry)object.next()).getValue();
                exportHandler.prepareExport("select * from " + this.tableName);
                if (bl2) {
                    bl2 = false;
                    exportHandler.executeExport(new CSVExportStringCallback(string, string2, string3, c2, bl));
                    continue;
                }
                exportHandler.executeExport(new CSVExportStringCallback(string, string2, string3, c2, true));
            }
            return;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    @Override
    public void executeExport(String string, String string2, String string3, boolean bl) throws SQLException {
        try {
            boolean bl2 = true;
            Object object = this.realHandlers.entrySet();
            object = object.iterator();
            while (object.hasNext()) {
                ExportHandler exportHandler = (ExportHandler)((Map.Entry)object.next()).getValue();
                exportHandler.prepareExport("select * from " + this.tableName);
                if (bl2) {
                    bl2 = false;
                    exportHandler.executeExport(new CSVExportStringCallback(string, string2, string3, bl));
                    continue;
                }
                exportHandler.executeExport(new CSVExportStringCallback(string, string2, string3, true));
            }
            return;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }
}

