/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.core.BaseConnection;
import com.oscar.core.ExportBinaryCallback;
import com.oscar.core.ExportHandler;
import com.oscar.core.ExportObjectCallback;
import com.oscar.core.ExportStringCallback;
import com.oscar.jdbc.OscarJdbc2Connection;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.util.OSQLException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class OscarExportHandler
implements ExportHandler {
    protected BaseConnection conn;
    protected PreparedStatement pstmt;
    private int fetchSize = 0;
    private int exportCount = 0;

    public OscarExportHandler(BaseConnection baseConnection) {
        this.conn = baseConnection;
    }

    @Override
    public void prepareExport(String string) throws SQLException {
        this.pstmt = ((OscarJdbc2Connection)this.conn).prepareStatement(string);
        this.pstmt.setFetchSize(this.fetchSize);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeExport(ExportBinaryCallback exportBinaryCallback) throws SQLException {
        this.exportCount = 0;
        ResultSet resultSet = null;
        int n2 = 0;
        int n3 = 0;
        try {
            this.checkExport();
            resultSet = this.pstmt.executeQuery();
            if (exportBinaryCallback.hasHeadColumn()) {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                for (int i2 = 1; i2 <= resultSetMetaData.getColumnCount(); ++i2) {
                    String string = resultSetMetaData.getColumnName(i2);
                    exportBinaryCallback.processColumn(++n2, 1, string.getBytes());
                    exportBinaryCallback.processEndColumn();
                }
                ++n3;
                exportBinaryCallback.processEndRow(1L);
            }
            while (true) {
                int n4;
                if (!resultSet.next()) break;
                byte[][] byArray = ((OscarResultSet)resultSet).getCurrentRow();
                int n5 = byArray.length;
                for (n4 = 0; n4 < n5 - 1; ++n4) {
                    if (byArray[n4] != null) {
                        exportBinaryCallback.processColumn(++n2, 1, byArray[n4]);
                    }
                    exportBinaryCallback.processEndColumn();
                }
                if (byArray[n4] != null) {
                    exportBinaryCallback.processColumn(++n2, 1, byArray[n4]);
                }
                exportBinaryCallback.processEndRow(++n3);
                n2 = 0;
                ++this.exportCount;
            }
            exportBinaryCallback.processEnd();
        }
        catch (Exception exception) {
            try {
                throw new OSQLException("OSCAR-00806", "88888", 107, exception);
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (this.pstmt == null) throw throwable;
                    this.pstmt.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (this.pstmt == null) return;
            this.pstmt.close();
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    public void checkExport() throws SQLException {
        if (this.pstmt == null) {
            throw new OSQLException("OSCAR-00805", "88888", 107);
        }
        this.exportCount = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeExport(ExportStringCallback exportStringCallback) throws SQLException {
        this.exportCount = 0;
        ResultSet resultSet = null;
        int n2 = 0;
        int n3 = 0;
        try {
            this.checkExport();
            resultSet = this.pstmt.executeQuery();
            if (exportStringCallback.hasHeadColumn()) {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                for (int i2 = 1; i2 <= resultSetMetaData.getColumnCount(); ++i2) {
                    String string = resultSetMetaData.getColumnName(i2);
                    exportStringCallback.processColumn(++n2, 2, string);
                    exportStringCallback.processEndColumn();
                }
                ++n3;
                exportStringCallback.processEndRow(1L);
            }
            while (true) {
                int n4;
                if (!resultSet.next()) break;
                byte[][] byArray = ((OscarResultSet)resultSet).getCurrentRow();
                int n5 = byArray.length;
                for (n4 = 0; n4 < n5 - 1; ++n4) {
                    if (byArray[n4] != null) {
                        if (this.conn.getProtocolVersion().getProtocolType() >= 2) {
                            exportStringCallback.processColumn(++n2, 2, resultSet.getObject(n4 + 1).toString());
                        } else {
                            exportStringCallback.processColumn(++n2, 2, this.conn.getEncoding().decode(byArray[n4]));
                        }
                    }
                    exportStringCallback.processEndColumn();
                }
                if (byArray[n4] != null) {
                    if (this.conn.getProtocolVersion().getProtocolType() >= 2) {
                        exportStringCallback.processColumn(++n2, 2, resultSet.getObject(n4 + 1).toString());
                    } else {
                        exportStringCallback.processColumn(++n2, 2, this.conn.getEncoding().decode(byArray[n4]));
                    }
                }
                exportStringCallback.processEndRow(++n3);
                n2 = 0;
                ++this.exportCount;
            }
            exportStringCallback.processEnd();
        }
        catch (Exception exception) {
            try {
                throw new OSQLException("OSCAR-00806", "88888", 107, exception);
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (this.pstmt == null) throw throwable;
                    this.pstmt.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (this.pstmt == null) return;
            this.pstmt.close();
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    @Override
    public void executeExport(ExportObjectCallback exportObjectCallback) {
    }

    @Override
    public void close() throws SQLException {
        this.conn = null;
        this.pstmt.close();
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int n2) {
        this.fetchSize = n2;
    }

    @Override
    public long getExportCount() {
        return this.exportCount;
    }
}

