/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.core.BaseConnection;
import com.oscar.core.ImportBinlogHandler;
import com.oscar.jdbc.ExceptionUtil;
import com.oscar.protocol.a.N;
import java.sql.SQLException;

public class OscarImportBinlogHandler
implements ImportBinlogHandler {
    BaseConnection conn = null;
    int curBinlogPos = 0;
    String curBinlogFile = null;
    boolean isBegin = false;
    byte[] dataBuffer;
    int defaultBufferSize = 51200;
    String importSQL = "BINLOG IMPORT";
    N qp = null;
    int repeatCount = 0;

    public OscarImportBinlogHandler(BaseConnection baseConnection) {
        this.conn = baseConnection;
    }

    public OscarImportBinlogHandler(BaseConnection baseConnection, String string, int n2) {
        this.conn = baseConnection;
        this.curBinlogFile = string;
        this.curBinlogPos = n2;
    }

    @Override
    public BaseConnection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public void importBinlogBegin() throws SQLException {
        if (!this.isBegin) {
            this.qp = new N(this.importSQL.getBytes(), 0);
            this.isBegin = true;
        }
        this.conn.getProtocol();
        this.conn.getProtocol().b(this.qp);
    }

    @Override
    public void execute() throws Exception {
        try {
            this.importBinlogBegin();
            this.importBinlog();
            this.importBinlogEnd();
            return;
        }
        catch (Exception exception) {
            this.checkConnectionClosed(exception);
            throw exception;
        }
    }

    /*
     * Exception decompiling
     */
    public void importBinlog() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int importBinlogData(byte[] byArray, int n2, int n3) throws SQLException {
        return this.conn.getProtocol().b(byArray, n2, n3);
    }

    @Override
    public void importBinlogEnd() throws SQLException {
        this.conn.getProtocol().f();
    }

    @Override
    public void setRepeatCount(int n2) {
        this.repeatCount = n2;
    }

    @Override
    public void close() {
        this.isBegin = false;
        this.curBinlogFile = null;
        this.importSQL = null;
        this.curBinlogPos = 0;
        this.dataBuffer = null;
        this.repeatCount = 0;
        this.qp = null;
    }

    void checkConnectionClosed(Exception exception) {
        switch (ExceptionUtil.isConnectionClosed(exception)) {
            case 1: {
                this.close();
                try {
                    this.conn.close();
                    return;
                }
                catch (SQLException sQLException) {
                    exception = sQLException;
                    sQLException.printStackTrace();
                    return;
                }
            }
            case 2: {
                try {
                    if (this.conn.isClosed()) {
                        return;
                    }
                }
                catch (SQLException sQLException) {
                    exception = sQLException;
                    sQLException.printStackTrace();
                }
                this.close();
                try {
                    this.conn.close();
                    return;
                }
                catch (SQLException sQLException) {
                    exception = sQLException;
                    sQLException.printStackTrace();
                }
            }
        }
    }
}

