/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseStatement;
import com.oscar.core.Encoding;
import com.oscar.core.ImportHandler;
import com.oscar.jdbc.OscarResultSetMetaData;
import com.oscar.util.ByteData;
import com.oscar.util.ColumnData;
import com.oscar.util.ColumnDataFactory;
import com.oscar.util.EscapeTools;
import com.oscar.util.ImportStream;
import com.oscar.util.ImportStream2;
import com.oscar.util.NullData;
import com.oscar.util.OSCARbyte;
import com.oscar.util.OSQLException;
import com.oscar.util.ShareImportStream;
import com.oscar.util.StreamData;
import com.oscar.util.TableNameParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class OscarImportHandler
implements ImportHandler {
    protected volatile BaseConnection connection;
    protected SQLWarning warnings = null;
    protected OscarResultSetMetaData dbTableInfo;
    private long updateCount = -2L;
    protected String tableName;
    protected String schemName;
    private String hintParam;
    private int nullDataProcessMode = -1;
    private ColumnData[] rowData;
    private Map<Integer, String> columnIndexTypesMap = new LinkedHashMap<Integer, String>(16);
    private Map<String, String> columnNameTypeMap = new LinkedHashMap<String, String>(16);
    public ImportStream importStream;
    private StringBuffer insertBulkStr;
    private String columnOrder;
    private boolean isClosed = false;
    private ColumnDataFactory factory = new ColumnDataFactory();
    protected Encoding encoding;
    protected boolean isBegin = false;
    private boolean hasStreamData = false;
    private ByteData byteData = null;
    private StreamData streamData = null;
    private boolean writeWithoutRowCache = false;
    public static final int BUFFER_SIZE_DEFAULT = 0x500000;
    private int defaultBufferSize = 0x500000;
    private int multiexectuples = 0;
    protected boolean logFlag = Driver.getLogLevel() > 0;
    public static final int BULK_FLOW = 0;
    public static final int BULK_BATCH = 1;
    private int bulkKind = 1;
    private static final String PUBLIC_SCHEMA = "PUBLIC";
    private boolean hasNotSubmittedNullValueOfRow = false;
    private long currentUpdateCount = -2L;
    private final int waitTimeout;

    public OscarImportHandler(BaseConnection baseConnection, String string) throws SQLException {
        this(baseConnection, null, string);
    }

    public OscarImportHandler(BaseConnection baseConnection, String string, String string2) throws SQLException {
        BaseConnection baseConnection2 = this.connection = baseConnection;
        synchronized (baseConnection2) {
            this.encoding = this.connection.getEncoding();
            this.initImportTable(string, string2);
        }
        this.waitTimeout = Integer.parseInt(baseConnection.getConnectionProperties().getProperty("IMPORTHANDLERWAITTIMEOUT", "300"));
    }

    public OscarImportHandler(BaseConnection baseConnection) throws SQLException {
        this.connection = baseConnection;
        this.encoding = this.connection.getEncoding();
        this.waitTimeout = Integer.parseInt(baseConnection.getConnectionProperties().getProperty("IMPORTHANDLERWAITTIMEOUT", "300"));
    }

    public void initImportTable(String string, String string2) throws SQLException {
        this.initImportTable(string, string2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initImportTable(String object, String object2, List<String[]> object3) throws SQLException {
        Iterator iterator;
        String string;
        if (object2 == null || ((String)object2).length() == 0) {
            throw new SQLException("\u8868\u540d\u4e0d\u80fd\u662fnull");
        }
        this.tableName = string = TableNameParser.dbStringToOrgString((String)object2);
        if (object == null) {
            object = this.fetchSchema(string);
            if (object == null || ((String)object).length() <= 0) throw new SQLException("\u83b7\u53d6\u5230\u6a21\u5f0f\u540d\u662fnull\u6216\u8005\u4e0d\u5b58\u5728\u8be5\u8868:" + string);
            this.schemName = object;
        } else {
            this.schemName = object = TableNameParser.dbStringToOrgString((String)object);
        }
        this.connection.getProtocol().a(this);
        this.insertBulkStr = object == null ? new StringBuffer("INSERT BULK " + EscapeTools.quotationWrapper(string) + " (") : new StringBuffer("INSERT BULK " + EscapeTools.quotationWrapper((String)object) + "." + EscapeTools.quotationWrapper(string) + " (");
        int n2 = 0;
        if (iterator == null || iterator.size() == 0) {
            this.initColumns((String)object, string);
            for (Map.Entry<String, String> entry : this.columnNameTypeMap.entrySet()) {
                String string2 = entry.getKey();
                this.insertBulkStr.append(" " + EscapeTools.quotationWrapper(string2) + " " + entry.getValue());
                this.insertBulkStr.append(",");
            }
            this.insertBulkStr.deleteCharAt(this.insertBulkStr.length() - 1);
            n2 = this.columnNameTypeMap.size();
        } else {
            HashSet<Object> hashSet = new HashSet<Object>();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                String[] stringArray = (String[])iterator.next();
                if (stringArray == null || stringArray.length != 2) continue;
                object = stringArray[0];
                String string3 = stringArray[1];
                if (hashSet.contains(object)) continue;
                hashSet.add(object);
                this.columnIndexTypesMap.put(n2, string3);
                this.columnNameTypeMap.put(TableNameParser.dbStringToOrgString((String)object), string3);
                ++n2;
                this.insertBulkStr.append(" " + EscapeTools.quotationWrapper((String)object) + " " + string3);
                this.insertBulkStr.append(",");
            }
            this.insertBulkStr.deleteCharAt(this.insertBulkStr.length() - 1);
        }
        this.insertBulkStr.append(")");
        if (n2 == 0) {
            throw new SQLException("Relation " + this.tableName + " does not exist.");
        }
        this.rowData = new ColumnData[n2];
        if (!this.logFlag) return;
        object = new StringBuffer();
        ((StringBuffer)object).append(OscarImportHandler.class).append(", initImportTable(String schemName, String tableName)\n").append("bulkSql: " + this.insertBulkStr.toString());
        Driver.writeLog(this.connection.getSessionID(), this.connection.getPlanID(), ((StringBuffer)object).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initColumns(String object, String object2) throws SQLException {
        Object object3 = new StringBuffer();
        ((StringBuffer)object3).append("select A.ATTNAME AS NAME , T.TYPNAME AS TYPE_NAME, CASE WHEN (A.ATTTYPID = 16) THEN 1 WHEN (A.ATTTYPID = 17) THEN 8000  WHEN (A.ATTTYPID = 18) THEN 1 WHEN (A.ATTTYPID = 19) THEN 128 WHEN (A.ATTTYPID = 20) THEN 19 WHEN (A.ATTTYPID = 21) ").append(" THEN 5 WHEN (A.ATTTYPID = 23) THEN 10 WHEN (A.ATTTYPID = 25) THEN 64000 WHEN (A.ATTTYPID = 26) THEN 10  WHEN (A.ATTTYPID = 700) THEN 24 WHEN (A.ATTTYPID = 701) THEN 53 WHEN (A.ATTTYPID = 702) THEN 22 ").append(" WHEN (A.ATTTYPID = 972) THEN 3 WHEN (A.ATTTYPID = 1042) THEN (A.ATTTYPMOD - 4) WHEN (A.ATTTYPID = 1043) THEN (A.ATTTYPMOD - 4)  WHEN (A.ATTTYPID = 1082) THEN 10 WHEN (A.ATTTYPID = 1083) THEN 8 WHEN (A.ATTTYPID = 1114) THEN 26 WHEN (A.ATTTYPID = (1184)) THEN 22 ").append(" WHEN (A.ATTTYPID = 1186) THEN 33 WHEN (A.ATTTYPID = 1188) THEN 21 WHEN (A.ATTTYPID = 1365) THEN (A.ATTTYPMOD - 4) WHEN (A.ATTTYPID = 1560)  THEN A.ATTTYPMOD WHEN (A.ATTTYPID = 1562) THEN A.ATTTYPMOD WHEN (A.ATTTYPID = 1700) THEN (A.ATTTYPMOD >> 16) WHEN (A.ATTTYPID = 2174) THEN 24 WHEN (A.ATTTYPID = 2175) ").append(" THEN 53 WHEN (A.ATTTYPID = 2315) THEN (A.ATTTYPMOD >> 16) WHEN (A.ATTTYPID = 3000) THEN 2147483647 WHEN (A.ATTTYPID = 3001)  THEN 2147483647 WHEN (A.ATTTYPID = 3002) THEN 2147483647 WHEN (A.ATTTYPID = 3100) THEN (A.ATTTYPMOD - 4) ELSE NULL END AS COLUMN_SIZE ").append(" from INFO_SCHEM.V_SYS_ATTRIBUTE A  left join INFO_SCHEM.V_SYS_TYPE T on(A.ATTTYPID = T.OID)  where A.ATTNUM >0 and A.ATTISDROPPED = false ");
        object = object == null || ((String)object).length() == 0 ? "CURRENT_SCHEMA()" : EscapeTools.toSingleQuotationMarks((String)object);
        ((StringBuffer)object3).append("and  A.ATTRELID =  INFO_SCHEM.sys_get_relid(" + (String)object + "," + EscapeTools.toSingleQuotationMarks((String)object2) + ") ");
        ((StringBuffer)object3).append("order by A.ATTNUM;");
        object = ((StringBuffer)object3).toString();
        object2 = this.connection.createStatement();
        ((BaseStatement)object2).setPrint(true);
        object3 = null;
        try {
            object2.setFetchSize(0);
            object3 = object2.executeQuery((String)object);
            int n2 = 0;
            HashSet<Object> hashSet = new HashSet<Object>();
            while (object3.next()) {
                object = object3.getString(1);
                object2 = object3.getString(2);
                if (hashSet.contains(object)) continue;
                hashSet.add(object);
                if (((String)object2).equalsIgnoreCase("interval") || ((String)object2).equalsIgnoreCase("INTERVALYTM") || ((String)object2).equalsIgnoreCase("numeric") || ((String)object2).equalsIgnoreCase("decimal") || ((String)object2).equalsIgnoreCase("TIMESTAMP") || ((String)object2).equalsIgnoreCase("INTERVALDTS")) {
                    object2 = "TEXT";
                }
                int n3 = object3.getInt(3);
                if (((String)object2).equalsIgnoreCase("char") || ((String)object2).equalsIgnoreCase("varchar") || ((String)object2).equalsIgnoreCase("bit") || ((String)object2).equalsIgnoreCase("binary") || ((String)object2).equalsIgnoreCase("varbinary") || ((String)object2).equalsIgnoreCase("bpchar") || ((String)object2).equalsIgnoreCase("varbit")) {
                    object2 = (String)object2 + "(" + n3 + ")";
                }
                this.columnNameTypeMap.put((String)object, (String)object2);
                this.columnIndexTypesMap.put(n2, (String)object2);
                ++n2;
            }
            if (object3 == null) return;
        }
        catch (SQLException sQLException) {
            try {
                object = sQLException;
                throw sQLException;
            }
            catch (Throwable throwable) {
                if (object3 == null) throw throwable;
                object3.close();
                throw throwable;
            }
        }
        object3.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String fetchSchema(String object) throws SQLException {
        PreparedStatement preparedStatement;
        ResultSet resultSet;
        block11: {
            block12: {
                block9: {
                    block10: {
                        String string = "SELECT TABLE_SCHEM FROM V_SYS_TABLES WHERE TABLE_SCHEM IN('PUBLIC',CURRENT_SCHEMA()) AND TABLE_TYPE NOT IN('VIEW','SYSTEM TABLE') AND TABLE_NAME=?";
                        resultSet = null;
                        preparedStatement = null;
                        try {
                            preparedStatement = this.connection.prepareStatement(string);
                            preparedStatement.setString(1, (String)object);
                            preparedStatement.setFetchSize(0);
                            resultSet = preparedStatement.executeQuery();
                            if (resultSet.next()) {
                                object = resultSet.getString(1);
                                if (PUBLIC_SCHEMA.equals(object)) {
                                    object = resultSet.next() ? resultSet.getString(1) : object;
                                    return object;
                                }
                                if (preparedStatement == null) break block9;
                                break block10;
                            }
                            if (preparedStatement == null) break block11;
                            break block12;
                        }
                        catch (SQLException sQLException) {
                            object = sQLException;
                            throw sQLException;
                        }
                    }
                    preparedStatement.close();
                }
                if (resultSet == null) return object;
                resultSet.close();
                return object;
            }
            preparedStatement.close();
        }
        if (resultSet == null) return null;
        resultSet.close();
        return null;
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    @Override
    public void setHintParam(String string) throws SQLException {
        this.hintParam = string;
    }

    @Override
    public void setNullDataProcessMode(int n2) throws SQLException {
        this.nullDataProcessMode = n2;
    }

    public boolean isBegin() {
        return this.isBegin;
    }

    @Override
    public void setColumnOrder(String string) throws SQLException {
        this.checkColumn(string);
        this.columnOrder = string;
    }

    public String getColumnOrder() {
        return this.columnOrder;
    }

    public String getDBColumnType(String string) throws SQLException {
        if ((string = this.columnNameTypeMap.get(string)) == null) {
            throw new OSQLException("OSCAR-00807", "88888", 107);
        }
        return string;
    }

    public void checkColumn(String object) throws SQLException {
        this.insertBulkStr = new StringBuffer("INSERT BULK ");
        if (this.schemName != null) {
            this.insertBulkStr.append(EscapeTools.quotationWrapper(this.schemName)).append(".");
        }
        this.insertBulkStr.append(EscapeTools.quotationWrapper(this.tableName)).append(" (");
        object = new StringTokenizer((String)object, ",");
        int n2 = ((StringTokenizer)object).countTokens();
        this.rowData = new ColumnData[n2];
        int n3 = 0;
        this.columnIndexTypesMap.clear();
        int n4 = 0;
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string = ((StringTokenizer)object).nextToken();
            this.insertBulkStr.append(EscapeTools.quotationWrapper(string));
            string = this.getDBColumnType(string);
            this.columnIndexTypesMap.put(n4, string);
            ++n4;
            this.insertBulkStr.append(" " + string);
            if (++n3 == n2) continue;
            this.insertBulkStr.append(",");
        }
        this.insertBulkStr.append(")");
    }

    public int getBufferSize() {
        return this.defaultBufferSize;
    }

    @Override
    public void setBufferSize(int n2) {
        this.defaultBufferSize = n2 << 10 << 10;
        if (this.defaultBufferSize <= 0) {
            this.defaultBufferSize = 0x500000;
        }
    }

    @Override
    public void setArray(int n2, Array object) throws SQLException {
        if (object == null) {
            this.setNull(n2);
            return;
        }
        Array array = object;
        object = this.connection.getEncoding();
        Array array2 = array;
        this.setRowDataByIndex(n2 - 1, ((Encoding)object).encode(array2.toString()));
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setNull(n2);
            return;
        }
        this.setRowDataByIndex(n2 - 1, inputStream);
    }

    @Override
    public void setBigDecimal(int n2, BigDecimal object) throws SQLException {
        if (object == null) {
            this.setNull(n2);
            return;
        }
        BigDecimal bigDecimal = object;
        object = this.connection.getEncoding();
        BigDecimal bigDecimal2 = bigDecimal;
        this.setRowDataByIndex(n2 - 1, ((Encoding)object).encode(bigDecimal2.toString()));
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setNull(n2);
            return;
        }
        this.setRowDataByIndex(n2 - 1, inputStream);
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n2);
            return;
        }
        this.setRowDataByIndex(n2 - 1, inputStream, l2);
    }

    @Override
    public void setBlob(int n2, Blob blob) throws SQLException {
        if (blob == null) {
            this.setNull(n2);
            return;
        }
        this.setRowDataByIndex(n2 - 1, blob.getBinaryStream());
    }

    @Override
    public void setBoolean(int n2, boolean bl) throws SQLException {
        int n3 = n2 - 1;
        Encoding encoding = this.encoding;
        n2 = bl ? 1 : 0;
        this.setRowDataByIndex(n3, encoding.encode(String.valueOf(n2 != 0)));
    }

    @Override
    public void setByte(int n2, byte by) throws SQLException {
        int n3 = n2 - 1;
        n2 = by;
        this.setRowDataByIndex(n3, new byte[]{n2});
    }

    @Override
    public void setBytes(int n2, byte[] byArray) throws SQLException {
        if (this.multiexectuples == 1) {
            if (byArray == null) {
                NullData.preWirte(this.importStream, this.nullDataProcessMode);
                return;
            }
            this.importStream.write(byArray, 8, byArray.length - 8);
            return;
        }
        if (this.writeWithRowCache()) {
            this.setRowDataByIndex(n2 - 1, byArray);
            return;
        }
        if (byArray == null) {
            NullData.preWirte(this.importStream, this.nullDataProcessMode);
            return;
        }
        this.importStream.writeInteger(byArray.length + 2, 2);
        this.importStream.write(byArray);
    }

    @Override
    public void setNull(int n2) throws SQLException {
        this.hasNotSubmittedNullValueOfRow = true;
    }

    @Override
    public void setClob(int n2, Clob clob) throws SQLException {
        if (clob == null) {
            this.setNull(n2);
            return;
        }
        this.setRowDataByIndex(n2 - 1, clob.getCharacterStream());
    }

    @Override
    public void setDate(int n2, Date object) throws SQLException {
        if (object == null) {
            this.setNull(n2);
            return;
        }
        Date date = object;
        object = this.encoding;
        Date date2 = date;
        this.setRowDataByIndex(n2 - 1, ((Encoding)object).encode(date2.toString()));
    }

    @Override
    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        throw new SQLException("oscarJDBC does not support this method of setDate(int, Date, Calendar).");
    }

    @Override
    public void setDouble(int n2, double d2) throws SQLException {
        Encoding encoding = this.encoding;
        double d3 = d2;
        this.setRowDataByIndex(n2 - 1, encoding.encode(String.valueOf(d3)));
    }

    @Override
    public void setFloat(int n2, float f2) throws SQLException {
        Encoding encoding = this.encoding;
        float f3 = f2;
        this.setRowDataByIndex(n2 - 1, encoding.encode(String.valueOf(f3)));
    }

    @Override
    public void setInt(int n2, int n3) throws SQLException {
        int n4 = n2 - 1;
        Encoding encoding = this.encoding;
        n2 = n3;
        this.setRowDataByIndex(n4, encoding.encode(String.valueOf(n2)));
    }

    @Override
    public void setLong(int n2, long l2) throws SQLException {
        Encoding encoding = this.encoding;
        long l3 = l2;
        this.setRowDataByIndex(n2 - 1, encoding.encode(String.valueOf(l3)));
    }

    @Override
    public void setNull(int n2, int n3) throws SQLException {
        this.hasNotSubmittedNullValueOfRow = true;
    }

    @Override
    public void setNull(int n2, int n3, String string) throws SQLException {
        this.hasNotSubmittedNullValueOfRow = true;
    }

    @Override
    public void setObject(int n2, Object object) throws SQLException {
        if (object == null) {
            this.setNull(n2, 1111);
            return;
        }
        if (object instanceof Byte) {
            this.setByte(n2, (Byte)object);
            return;
        }
        if (object instanceof String) {
            this.setString(n2, (String)object);
            return;
        }
        if (object instanceof BigDecimal) {
            this.setBigDecimal(n2, (BigDecimal)object);
            return;
        }
        if (object instanceof Short) {
            this.setShort(n2, (Short)object);
            return;
        }
        if (object instanceof Integer) {
            this.setInt(n2, (Integer)object);
            return;
        }
        if (object instanceof Long) {
            this.setLong(n2, (Long)object);
            return;
        }
        if (object instanceof Float) {
            this.setFloat(n2, ((Float)object).floatValue());
            return;
        }
        if (object instanceof Double) {
            this.setDouble(n2, (Double)object);
            return;
        }
        if (object instanceof byte[]) {
            this.setBytes(n2, (byte[])object);
            return;
        }
        if (object instanceof Date) {
            this.setDate(n2, (Date)object);
            return;
        }
        if (object instanceof Time) {
            this.setTime(n2, (Time)object);
            return;
        }
        if (object instanceof Timestamp) {
            this.setTimestamp(n2, (Timestamp)object);
            return;
        }
        if (object instanceof Boolean) {
            this.setBoolean(n2, (Boolean)object);
            return;
        }
        if (object instanceof InputStream) {
            this.setBinaryStream(n2, (InputStream)object);
            return;
        }
        if (object instanceof Blob) {
            this.setBlob(n2, (Blob)object);
            return;
        }
        if (object instanceof Clob) {
            this.setClob(n2, (Clob)object);
            return;
        }
        this.setString(n2, object.toString());
    }

    @Override
    public void setObject(int n2, Object object, int n3) throws SQLException {
    }

    @Override
    public void setShort(int n2, short s2) throws SQLException {
        int n3 = n2 - 1;
        Encoding encoding = this.encoding;
        n2 = s2;
        this.setRowDataByIndex(n3, encoding.encode(String.valueOf(n2)));
    }

    @Override
    public void setString(int n2, char[] cArray) throws SQLException {
        if (cArray == null) {
            this.setNull(n2);
            return;
        }
        this.setString(n2, String.valueOf(cArray));
    }

    @Override
    public void setString(int n2, String object) throws SQLException {
        if (object == null) {
            this.setNull(n2);
            return;
        }
        String string = object;
        object = this.encoding;
        String string2 = string;
        this.setRowDataByIndex(n2 - 1, ((Encoding)object).encode(string2));
    }

    @Override
    public void setTime(int n2, Time object) throws SQLException {
        if (object == null) {
            this.setNull(n2);
            return;
        }
        Time time = object;
        object = this.encoding;
        Time time2 = time;
        this.setRowDataByIndex(n2 - 1, ((Encoding)object).encode(time2.toString()));
    }

    @Override
    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        this.setTime(n2, time);
    }

    @Override
    public void setTimestamp(int n2, Timestamp object) throws SQLException {
        if (object == null) {
            this.setNull(n2);
            return;
        }
        Timestamp timestamp = object;
        object = this.encoding;
        Timestamp timestamp2 = timestamp;
        this.setRowDataByIndex(n2 - 1, ((Encoding)object).encode(timestamp2.toString()));
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(n2, timestamp);
    }

    @Override
    public void setUnicodeStream(int n2, InputStream inputStream) throws SQLException {
        throw new SQLException("oscarJDBC does not support this method of setUnicodeStream(int, InputStream).");
    }

    public boolean checkIndexAndSQLType(int n2, int n3) {
        return true;
    }

    @Override
    public void cancel() throws SQLException {
        this.connection.cancelQuery();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.connection = null;
        this.dbTableInfo = null;
        this.hintParam = null;
        this.nullDataProcessMode = -1;
        this.rowData = null;
        this.tableName = null;
        this.updateCount = -2L;
        this.warnings = null;
        this.isClosed = true;
        if (this.importStream != null) {
            if (!this.importStream.isFinished()) {
                this.importStream.finished();
            }
            this.importStream.close();
        }
        this.importStream = null;
    }

    @Override
    public BaseConnection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public long getUpdateCount() throws SQLException {
        return this.updateCount;
    }

    public void setUpdateCount(long l2) {
        this.updateCount = l2;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public void begin() throws SQLException {
        this.isBegin = true;
        if (this.importStream == null) {
            if (this.writeWithRowCache()) {
                try {
                    this.importStream = new ShareImportStream(this);
                    return;
                }
                catch (Exception exception) {
                    throw new SQLException(exception.getMessage());
                }
            }
            this.importStream = new ImportStream2(this);
            return;
        }
        this.importStream.reInit();
    }

    public void checkImportStreamException() throws SQLException {
        if (this.importStream == null) {
            return;
        }
        Throwable throwable = this.importStream.getThreadException();
        if (throwable != null) {
            if (throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            throw new OSQLException("OSCAR-00804", "88888", 804, throwable);
        }
    }

    @Override
    public void clearExceptionDuringImport() {
        if (this.importStream != null) {
            if (this.importStream.isFinishExceptionally()) {
                this.isBegin = false;
                this.importStream.setFinishExceptionally(false);
            }
            this.importStream.setThreadException(null);
        }
    }

    @Override
    public void beginRow() throws SQLException {
        throw new SQLException("JDBC do not support beginRow().");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void endRow() throws SQLException {
        try {
            int n2;
            if (!this.isBegin) {
                this.begin();
            }
            this.checkImportStreamException();
            if (this.multiexectuples != 1) {
                this.importStream.writeChar(68);
                for (n2 = 0; n2 < this.rowData.length; ++n2) {
                    if (this.rowData[n2] == null) {
                        NullData.preWirte(this.importStream, this.nullDataProcessMode);
                        continue;
                    }
                    this.rowData[n2].preWrite(this.importStream);
                }
            }
            if (this.hasStreamData) {
                for (n2 = 0; n2 < this.rowData.length; ++n2) {
                    if (this.rowData[n2] != null) {
                        this.rowData[n2].endWrite(this.importStream);
                    }
                    this.hasStreamData = false;
                }
            }
            this.importStream.setRowPosition();
        }
        catch (SQLException sQLException) {
            try {
                SQLException sQLException2 = sQLException;
                throw sQLException;
                catch (Exception exception) {
                    Exception exception2 = exception;
                    Driver.writeLog(exception);
                    if (exception2.getMessage() != null && exception2.getMessage().contains("OutOfMemoryError")) {
                        throw new OSQLException("OSCAR-00800", "88888", 800, exception2.getMessage(), exception2);
                    }
                    if (exception2.getCause() == null) throw new OSQLException("OSCAR-00804", "88888", 804, exception2.toString(), exception2);
                    if (!(exception2.getCause() instanceof SQLException)) throw new OSQLException("OSCAR-00804", "88888", 804, exception2.toString(), exception2);
                    throw (SQLException)exception2.getCause();
                }
            }
            catch (Throwable throwable) {
                try {
                    this.clearRow();
                    throw throwable;
                }
                catch (SQLException sQLException3) {
                    throw new OSQLException("OSCAR-00804", "88888", 804, sQLException3);
                }
            }
        }
        try {
            this.clearRow();
            return;
        }
        catch (SQLException sQLException) {
            throw new OSQLException("OSCAR-00804", "88888", 804, sQLException);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.hasRowNotSubmitted()) {
            try {
                this.endRow();
            }
            catch (SQLException sQLException) {
                if (this.importStream != null && !this.importStream.isFinished()) {
                    this.importStream.finished();
                }
                throw sQLException;
            }
        }
        return this.endExecute();
    }

    protected boolean endExecute() throws SQLException {
        if (this.importStream != null) {
            this.importStream.flush();
            this.importStream.finished();
        }
        this.checkImportStreamException();
        this.isBegin = false;
        return true;
    }

    public void setRowDataByIndex(int n2, ColumnData columnData) {
        this.rowData[n2] = columnData;
    }

    public void setRowDataByIndex(int n2, byte[] object) throws SQLException {
        if (object == null) {
            this.setNull(n2);
            return;
        }
        byte[] byArray = object;
        if (this.useHexForSendingBinaryType(n2)) {
            byArray = OSCARbyte.getOscarHexBytes(object);
        }
        if (byArray.length > 32765) {
            object = new BufferedInputStream(new ByteArrayInputStream(byArray));
            this.setRowDataByIndex(n2, (InputStream)object, byArray.length, false);
            return;
        }
        this.byteData = (ByteData)this.factory.getByteData();
        this.byteData.setBuffer(byArray);
        this.rowData[n2] = this.byteData;
    }

    public void setRowDataByIndex(int n2, InputStream inputStream, long l2) throws SQLException {
        this.setRowDataByIndex(n2, inputStream, l2, this.useHexForSendingBinaryType(n2));
    }

    public void setRowDataByIndex(int n2, InputStream inputStream) throws SQLException {
        this.setRowDataByIndex(n2, inputStream, 0L, this.useHexForSendingBinaryType(n2));
    }

    public void setRowDataByIndex(int n2, InputStream inputStream, long l2, boolean bl) throws SQLException {
        this.declareHasStreamData();
        this.streamData = (StreamData)this.factory.getStreamData();
        if (l2 > 32765L) {
            if (bl) {
                this.streamData.read(inputStream, 0, true);
            } else {
                this.streamData.read(inputStream, 0);
            }
        } else if (bl) {
            this.streamData.read(inputStream, (int)l2, true);
        } else {
            this.streamData.read(inputStream, (int)l2);
        }
        this.rowData[n2] = this.streamData;
    }

    public void setRowDataByIndex(int n2, Reader reader, long l2) throws SQLException {
        this.declareHasStreamData();
        this.streamData = (StreamData)this.factory.getStreamData();
        if (l2 > Integer.MAX_VALUE) {
            this.streamData.read(reader, 0, this.connection.getEncoding().getEncoding());
        } else {
            this.streamData.read(reader, (int)l2, this.connection.getEncoding().getEncoding());
        }
        this.rowData[n2] = this.streamData;
    }

    public void setRowDataByIndex(int n2, Reader reader) throws SQLException {
        this.declareHasStreamData();
        this.streamData = (StreamData)this.factory.getStreamData();
        this.streamData.read(reader, 0, this.connection.getEncoding().getEncoding());
        this.rowData[n2] = this.streamData;
    }

    private void declareHasStreamData() {
        if (!this.hasStreamData) {
            this.hasStreamData = true;
        }
    }

    public ColumnData getRowDataByIndex(int n2) {
        return this.rowData[n2];
    }

    public void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new OSQLException("OSCAR-00409", "88888", 409);
        }
    }

    @Override
    public void clearRow() throws SQLException {
        for (int i2 = 0; i2 < this.rowData.length; ++i2) {
            if (this.rowData[i2] == null) continue;
            this.rowData[i2].clear();
            this.rowData[i2] = null;
        }
        this.factory.reset();
        this.hasNotSubmittedNullValueOfRow = false;
    }

    @Override
    public void addWarning(String string, String string2) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(new SQLWarning(string, string2));
            return;
        }
        this.warnings = new SQLWarning(string);
    }

    @Override
    public void addWarning(SQLWarning sQLWarning) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(sQLWarning);
            return;
        }
        this.warnings = sQLWarning;
    }

    public StringBuffer getInsertBulkStr() {
        return this.insertBulkStr;
    }

    public void setInsertBulkInfo(StringBuffer stringBuffer, int n2) {
        this.insertBulkStr = stringBuffer;
        this.rowData = new ColumnData[n2];
    }

    public String getHintParam() {
        return this.hintParam;
    }

    @Override
    public ImportStream getImportStream() {
        return this.importStream;
    }

    @Override
    public void setBufferProcessMode(boolean bl) {
        this.writeWithoutRowCache = bl;
    }

    @Override
    public boolean writeWithRowCache() {
        return !this.writeWithoutRowCache;
    }

    public int getBatchRowsOffset() {
        return this.importStream.getBatchRowsOffset();
    }

    public int getBatchRowsEnd() {
        return this.importStream.getBatchRowsEnd();
    }

    public String getCurrentSchema() throws SQLException {
        Object object = "select current_schema();";
        ResultSet resultSet = null;
        String string = null;
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            statement.setFetchSize(0);
            resultSet = statement.executeQuery((String)object);
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        catch (SQLException sQLException) {
            object = sQLException;
            throw sQLException;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return string;
    }

    @Override
    public int getImportBlockParam() {
        return this.multiexectuples;
    }

    @Override
    public void setImportBlockParam(int n2) {
        this.multiexectuples = n2;
    }

    private boolean useHexForSendingBinaryType(int n2) throws SQLException {
        if (!this.connection.sendBinaryTypeAsHex()) {
            return false;
        }
        return this.isBinaryColumn(n2);
    }

    private boolean isBinaryColumn(int n2) throws SQLException {
        String string = this.columnIndexTypesMap.get(n2);
        if (string == null) {
            throw new SQLException("\u627e\u4e0d\u5230\u5bf9\u5e94\u5217\uff0c\u5217\u7d22\u5f15\uff1a" + n2);
        }
        return (string = string.toLowerCase()).startsWith("varbinary") || string.startsWith("binary");
    }

    public int getBulkKind() {
        return this.bulkKind;
    }

    public void setBulkKind(int n2) {
        this.bulkKind = n2;
    }

    @Override
    public void setBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n2);
            return;
        }
        this.setRowDataByIndex(n2 - 1, inputStream, l2);
    }

    protected boolean hasRowNotSubmitted() {
        if (this.hasNotSubmittedNullValueOfRow) {
            return true;
        }
        if (this.rowData != null) {
            ColumnData[] columnDataArray = this.rowData;
            int n2 = this.rowData.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ColumnData columnData = columnDataArray[i2];
                if (columnData == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public long getCurrentUpdateCount() throws SQLException {
        return this.currentUpdateCount;
    }

    public void setCurrentUpdateCount(long l2) {
        this.currentUpdateCount = l2;
    }

    @Override
    public void setCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        if (reader == null) {
            this.setNull(n2);
            return;
        }
        this.setRowDataByIndex(n2 - 1, reader, l2);
    }

    @Override
    public void setCharacterStream(int n2, Reader reader) throws SQLException {
        if (reader == null) {
            this.setNull(n2);
            return;
        }
        this.setRowDataByIndex(n2 - 1, reader);
    }

    public int getWaitTimeout() {
        return this.waitTimeout;
    }

    @Override
    public void setColumnOrder(String[] stringArray) throws SQLException {
        this.checkColumnList(stringArray);
    }

    public void checkColumnList(String[] stringArray) throws SQLException {
        this.insertBulkStr = new StringBuffer("INSERT BULK ");
        if (this.schemName != null) {
            this.insertBulkStr.append(EscapeTools.quotationWrapper(this.schemName)).append(".");
        }
        this.insertBulkStr.append(EscapeTools.quotationWrapper(this.tableName)).append(" (");
        this.rowData = new ColumnData[stringArray.length];
        int n2 = 0;
        this.columnIndexTypesMap.clear();
        int n3 = 0;
        String[] stringArray2 = stringArray;
        int n4 = stringArray.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            String string = stringArray2[i2];
            this.insertBulkStr.append(EscapeTools.quotationWrapper(string));
            string = this.getDBColumnType(string);
            this.columnIndexTypesMap.put(n3, string);
            ++n3;
            this.insertBulkStr.append(" " + string);
            if (++n2 == stringArray.length) continue;
            this.insertBulkStr.append(",");
        }
        this.insertBulkStr.append(")");
    }

    @Override
    public void setExecuteBufferSize(int n2) {
    }

    public int getNullDataProcessMode() {
        return this.nullDataProcessMode;
    }
}

