/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.jdbc.OscarBulkInsertPrepareStatement;
import com.oscar.jdbc.OscarJdbc2Connection;
import com.oscar.util.OscarSqlProcessor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;

public class OscarJdbc2BulkConnection
extends OscarJdbc2Connection
implements BaseConnection,
Connection {
    private int bufferSize = 30;

    @Override
    public void openConnection(String string, int n2, Properties properties, String string2, String string3, Driver driver) throws SQLException {
        super.openConnection(string, n2, properties, string2, string3, driver);
    }

    @Override
    public PreparedStatement prepareStatement(String object, int n2, int n3, int n4) throws SQLException {
        String string = ((String)object).trim();
        OscarSqlProcessor.ParseResult parseResult = OscarSqlProcessor.parsingWithCheck(string = string.replaceAll("\r\n", " ").replaceAll("\n", " "), true);
        if (this.isInsertSql(parseResult, string)) {
            string = parseResult.getTransSql();
            object = new OscarBulkInsertPrepareStatement(this, (String)object, n2, n3, n4, parseResult, string);
            return object;
        }
        return super.prepareStatement((String)object, n2, n3, n4);
    }

    private boolean isInsertSql(OscarSqlProcessor.ParseResult object, String string) {
        if (string == null || string.length() <= 0) {
            return false;
        }
        if (object != null) {
            return ((OscarSqlProcessor.ParseResult)object).isInsertSql();
        }
        object = string.trim().toUpperCase();
        return ((String)object).matches("^\\s*INSERT\\s+INTO\\s+.+VALUES.+");
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int n2) {
        this.bufferSize = n2;
    }
}

