/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.cluster.Cluster;
import com.oscar.cluster.ClusterImportHandler;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.BaseStatement;
import com.oscar.core.DistributeImportHandler;
import com.oscar.core.Encoding;
import com.oscar.core.ExportHandler;
import com.oscar.core.FieldMetadata;
import com.oscar.core.ImportHandler;
import com.oscar.core.ProviderImportHandler;
import com.oscar.core.QueryExecutor;
import com.oscar.dispatcher.entity.DispatchConnection;
import com.oscar.fastpath.Fastpath;
import com.oscar.gis.OscarBox;
import com.oscar.gis.OscarBox2d;
import com.oscar.gis.OscarBox3d;
import com.oscar.gis.OscarCircle;
import com.oscar.gis.OscarGeography;
import com.oscar.gis.OscarGeometry;
import com.oscar.gis.OscarLine;
import com.oscar.gis.OscarLseg;
import com.oscar.gis.OscarObject;
import com.oscar.gis.OscarPath;
import com.oscar.gis.OscarPoint;
import com.oscar.gis.OscarPolygon;
import com.oscar.jdbc.ConnectionArray;
import com.oscar.jdbc.EscapeProcessor;
import com.oscar.jdbc.EscapeProcessorResult;
import com.oscar.jdbc.ExceptionUtil;
import com.oscar.jdbc.OSCARSavepoint;
import com.oscar.jdbc.OSCARTransfer;
import com.oscar.jdbc.OscarBfile;
import com.oscar.jdbc.OscarBlob;
import com.oscar.jdbc.OscarCallableStatement;
import com.oscar.jdbc.OscarCallableStatementV2;
import com.oscar.jdbc.OscarClob;
import com.oscar.jdbc.OscarDatabaseMetaData;
import com.oscar.jdbc.OscarExportHandler;
import com.oscar.jdbc.OscarImportHandler;
import com.oscar.jdbc.OscarPreparedStatement;
import com.oscar.jdbc.OscarPreparedStatementV2;
import com.oscar.jdbc.OscarProviderImportHandle;
import com.oscar.jdbc.OscarSQLXML;
import com.oscar.jdbc.OscarStatement;
import com.oscar.jdbc.OscarStatementV2;
import com.oscar.jdbcx.optional.PooledConnectionImpl;
import com.oscar.protocol.ProtocolVersion;
import com.oscar.protocol.a;
import com.oscar.protocol.a.k;
import com.oscar.protocol.b;
import com.oscar.protocol.d;
import com.oscar.util.ImportBufferManager;
import com.oscar.util.LRUStatementCache;
import com.oscar.util.LRUStatementCacheV2;
import com.oscar.util.OSQLException;
import com.oscar.util.VersionConfig;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import javax.sql.StatementEventListener;

public class OscarJdbc2Connection
implements BaseConnection,
Connection {
    public Integer sessionID = -1;
    protected BaseStatement stmt;
    protected a protocol;
    protected boolean compressTransfer = false;
    private Connection masterConnection = null;
    protected final Properties _clientInfo;
    private final String[] clientPro = new String[]{"ApplicationName", "ClientUser", "ClientHostname"};
    protected long randNum;
    protected static final int KEY1 = 1103515245;
    protected static final int KEY2 = 12345;
    protected static final int KEY_MAX = 0x40000000;
    protected ProtocolVersion version = null;
    protected int pid = -1;
    protected int ckey = -1;
    private Encoding clientEncoding = Encoding.defaultEncoding();
    private Encoding dbEncoding = null;
    protected boolean autoCommit = true;
    private boolean readOnly = false;
    private boolean inTransaction = false;
    private Driver this_driver;
    private String this_url;
    private String cursor = null;
    private Fastpath fastpath = null;
    protected int holdability = 2;
    protected Vector<byte[]> planIDVec;
    protected Vector<String> cursorVec;
    protected DatabaseMetaData metadata;
    protected volatile boolean closed;
    public SQLWarning warnings = null;
    private int isolationLevel = 2;
    protected int preparedCacheSize = 0;
    protected boolean compatibleOracle = false;
    protected boolean notRealPrepare = false;
    protected boolean verifyPoolConnection = false;
    protected boolean compatibleOldDateFormat = false;
    d protocolManager = null;
    protected int statementFetchSize = 16;
    private Properties connectionProperty = null;
    private static ConcurrentMap<Integer, Integer> sqlTypeCache = new ConcurrentHashMap<Integer, Integer>();
    private static ConcurrentMap<Integer, String> DBTypeCache = new ConcurrentHashMap<Integer, String>();
    private static ConcurrentMap<String, Integer> typeOidCache = new ConcurrentHashMap<String, Integer>();
    private static ConcurrentMap<String, Integer> jdbcTypes = new ConcurrentHashMap<String, Integer>();
    private static ConcurrentMap<Integer, Integer> oscarTypeCache = new ConcurrentHashMap<Integer, Integer>();
    private static ConcurrentMap<String, Class<? extends OscarObject>> DBTypeClassCache = new ConcurrentHashMap<String, Class<? extends OscarObject>>();
    private byte[] hdSymEncryptKey;
    protected int timeOut_MilliSecond = 0;
    private final QueryExecutor executor;
    private int batchBufferSize = 0;
    private int endianType = 1;
    protected boolean netDataByStr = false;
    protected boolean numericKeepPrecision = true;
    protected boolean compatibleOldProtocol = false;
    protected boolean receiveStringByLen = true;
    protected boolean prepareSimpleExecute = true;
    protected LRUStatementCache statementCache = null;
    protected int lobDisplayMaxSize = -1;
    protected boolean logFlag = Driver.getLogLevel() >= 2;
    protected boolean stLogFlag = Driver.getLogLevel() > 0;
    protected int batchCount = 0;
    protected boolean useAsynBatch = false;
    protected List<Statement> stList;
    private boolean isClearSt = false;
    private long lsnValue = 0L;
    private int transStatus;
    private DispatchConnection dispatchConn = null;
    private String validTestString;
    protected boolean isSlave = false;
    private boolean checkDBLinkSql = false;
    private List<StatementEventListener> statementListeners = new LinkedList<StatementEventListener>();
    private PooledConnectionImpl pc;
    private boolean sendBinaryTypeAsHex = false;
    private int clusterImportNodeRetryTime = 0;
    private Cluster cluster = null;
    private long sleepEndTime = 0L;
    private static final SQLPermission SET_NETWORK_TIMEOUT_PERM = new SQLPermission("setNetworkTimeout");
    private static final SQLPermission ABORT_PERM = new SQLPermission("abort");
    private String[] searchPath = null;
    private boolean supportAuto = true;
    private boolean supportGenerated = true;
    private final Map<FieldMetadata.Key, FieldMetadata> fieldMetadataCache = new HashMap<FieldMetadata.Key, FieldMetadata>();
    private Calendar calendar;
    private static final int AUTO_GENERATED_OID = 1;
    private static final int AUTO_GENERATED_COLINDEX = 2;
    private static final int AUTO_GENERATED_COLNAME = 3;
    private boolean enableCe;
    protected Map<String, Class<?>> typemap;

    @Override
    public a getProtocol() throws SQLException {
        if (this.protocol == null) {
            throw new OSQLException("OSCAR-00211", "08003", 211);
        }
        return this.protocol;
    }

    public void openConnection(String string, int n2, Properties properties, String string2, String string3, Driver driver) throws SQLException {
        String string4;
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", openConnection()");
        }
        this.connectionProperty = properties;
        int n3 = 0;
        ImportBufferManager.setMaxUsingBufferSize(Integer.parseInt(properties.getProperty("MAXUSINGBUFFERSIZE", "5120")));
        if (properties.getProperty("REQUESTTIMEOUT") != null) {
            n3 = Integer.parseInt(properties.getProperty("REQUESTTIMEOUT"));
        }
        if ((string4 = properties.getProperty("SOCKETTIMEOUT")) != null) {
            n3 = Integer.parseInt(string4);
        }
        if (n3 > 0 && n3 != this.timeOut_MilliSecond) {
            this.timeOut_MilliSecond = n3;
        }
        n3 = 0;
        if (properties.getProperty("BATCHCOUNT") != null) {
            n3 = Integer.parseInt(properties.getProperty("BATCHCOUNT"));
        }
        if (n3 > 0) {
            this.batchCount = n3;
        }
        this.useAsynBatch = Boolean.valueOf(properties.getProperty("USEASYNBATCH", "false"));
        String string5 = properties.getProperty("AUTH_TYPE", "PW");
        if (properties.getProperty("OSAUTHEN", "f").equalsIgnoreCase("t")) {
            properties.setProperty("AUTH_TYPE", "OS");
            string5 = "OS";
        }
        if (!(string5.equalsIgnoreCase("PW") || string5.equalsIgnoreCase("OS") || string5.equalsIgnoreCase("RA") || string5.equalsIgnoreCase("FP"))) {
            throw new OSQLException("OSCAR-00118", "08001", 118);
        }
        if (string5.equalsIgnoreCase("FP") && (properties.get("FINGERPRINT") == null || !(properties.get("FINGERPRINT") instanceof byte[]))) {
            throw new OSQLException("OSCAR-00110", "08001", 110);
        }
        if (!string5.equalsIgnoreCase("OS") && properties.getProperty("USER") == null) {
            throw new OSQLException("OSCAR-00119", "08001", 119);
        }
        this.this_driver = driver;
        this.this_url = string3;
        this.validTestString = properties.getProperty("VALIDTESTSTRING", "select 1");
        this.checkDBLinkSql = Boolean.valueOf(properties.getProperty("CHECKDBLINKSQL", "false"));
        this.sendBinaryTypeAsHex = Boolean.valueOf(properties.getProperty("SENDBINARYTYPEASHEX", "false"));
        this.clientEncoding = Encoding.getEncoding(System.getProperty("file.encoding"));
        this.compatibleOldProtocol = Boolean.valueOf(properties.getProperty("COMPATIBLEOLDPROTOCOL", "false"));
        this.receiveStringByLen = Boolean.valueOf(properties.getProperty("RECEIVESTRINGBYLEN", "true"));
        this.verifyPoolConnection = Boolean.valueOf(properties.getProperty("VERIFYPOOLCONNECTION", "false"));
        try {
            this.protocolManager = this.timeOut_MilliSecond > 0 ? new d(this, string, n2, string2, properties.getProperty("USER"), properties, this.timeOut_MilliSecond) : new d(this, string, n2, string2, properties.getProperty("USER"), properties);
            boolean bl = false;
            if (properties.getProperty("SSL", "f").equals("t") && Driver.sslEnabled()) {
                bl = true;
            }
            this.protocolManager.a(bl, this.compatibleOldProtocol);
            this.protocol = this.protocolManager.a(this.compatibleOldProtocol);
            this.enableCe = Boolean.valueOf(this.connectionProperty.getProperty("ENABLE_CE")) != false && this.version.getProtocolType() >= 5;
        }
        catch (ConnectException connectException) {
            Driver.writeLog("create socket timeout,", connectException);
            throw new OSQLException("OSCAR-00201", "08001", 201, connectException.getMessage(), connectException);
        }
        catch (IOException iOException) {
            Driver.writeLog("new connection failed,", iOException);
            throw new OSQLException("OSCAR-00201", "08001", 201, iOException.getMessage(), iOException);
        }
        catch (SQLException sQLException) {
            if (this.protocolManager.a() != null) {
                try {
                    this.protocolManager.a().close();
                }
                catch (IOException iOException) {}
            }
            throw sQLException;
        }
        try {
            this.openConnectionV2(string, n2, properties, string2, string3, driver);
            return;
        }
        catch (SQLException sQLException) {
            try {
                if (this.protocol != null) {
                    this.protocol.c();
                }
            }
            catch (SQLException sQLException2) {
            }
            catch (IOException iOException) {
            }
            finally {
                this.protocol = null;
            }
            throw sQLException;
        }
    }

    private void openConnectionV2(String string, int n2, Properties properties, String string2, String string3, Driver driver) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", openConnectionV2()");
        }
        if (this.protocol != null) {
            boolean bl;
            this.pid = this.protocol.a();
            this.ckey = this.protocol.b();
            this.setDBEncoding();
            this.prepareSimpleExecute = Boolean.valueOf(properties.getProperty("PREPARESIMPLEEXECUTE", "true"));
            if (this.getProtocolVersion().getProtocolType() >= 2) {
                this.netDataByStr = Boolean.valueOf(properties.getProperty("NETDATABYSTR", "false"));
                if (this.netDataByStr) {
                    this.execSQL("SET NET_DATA_BY_STR=TRUE");
                } else {
                    this.execSQL("SET NET_DATA_BY_STR=FALSE");
                }
                if (!this.netDataByStr) {
                    this.numericKeepPrecision = Boolean.valueOf(properties.getProperty("NUMERICKEEPPRECISION", "true"));
                    if (this.numericKeepPrecision) {
                        this.execSQL("SET SEND_FLOATINGNUMBER_KEEP_PRECISION=TRUE");
                    } else {
                        this.execSQL("SET SEND_FLOATINGNUMBER_KEEP_PRECISION=FALSE");
                    }
                }
            }
            this.setTransactionIsolation(2);
            this.execSQL("SET AUTOCOMMIT TO TRUE");
            this.execSQL("SET DISPLAY_LOBLOCATOR=ON");
            this.batchBufferSize = Integer.parseInt(properties.getProperty("BATCHBUFFERSIZE", "128"));
            if (this.batchBufferSize > 0x100000) {
                this.batchBufferSize = 0x100000;
            } else if (this.batchBufferSize <= 0) {
                this.batchBufferSize = 1;
            }
            this.preparedCacheSize = Integer.parseInt(properties.getProperty("PREPARECACHESIZE", "0"));
            if (this.preparedCacheSize > 0) {
                OscarJdbc2Connection oscarJdbc2Connection = this;
                oscarJdbc2Connection.setStatementCacheSize(oscarJdbc2Connection.preparedCacheSize);
                this.setImplicitCachingEnabled(true);
            }
            this.compatibleOracle = Boolean.valueOf(properties.getProperty("COMPATIBLEORACLE", "false"));
            this.notRealPrepare = Boolean.valueOf(properties.getProperty("NOTREALPREPARE", "false"));
            this.compatibleOldDateFormat = Boolean.valueOf(properties.getProperty("COMPATIBLEOLDDATEFORMAT", "false"));
            boolean bl2 = Boolean.valueOf(properties.getProperty("STMTROLLBACK", "true"));
            try {
                if (bl2) {
                    this.execSQL("SET STMT_ROLLBACK=1");
                } else {
                    this.execSQL("SET STMT_ROLLBACK=0");
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
            String string4 = properties.getProperty("CURRENTSCHEMA");
            if (string4 != null) {
                this.setSchema(string4);
            }
            this.statementFetchSize = Integer.parseInt(properties.getProperty("FETCHSIZE", "16"));
            if (this.statementFetchSize > 5000) {
                this.statementFetchSize = 5000;
            }
            if (this.statementFetchSize < 0) {
                this.statementFetchSize = 0;
            }
            if ((bl = Boolean.valueOf(properties.getProperty("EXTENTEDQUERYPROTOCOL", "false")).booleanValue()) && this.version.isMpp5()) {
                try {
                    this.execSQL("SET ENABLE_EXTENTED_QUERY_PROTOCOL=TRUE");
                }
                catch (SQLException sQLException) {}
            }
            this.lobDisplayMaxSize = this.getLobDisplayMaxSize();
            this.isClearSt = Boolean.valueOf(properties.getProperty("CLEANSTATEMENT", "false"));
            String string5 = properties.getProperty("SERVERTIMEZONE", "GMT+8");
            this.calendar = Calendar.getInstance(TimeZone.getTimeZone(string5));
            this.closed = false;
        }
    }

    @Override
    public boolean isPrepareSimpleExecute() {
        return this.prepareSimpleExecute;
    }

    public OscarJdbc2Connection() {
        this.executor = new QueryExecutor();
        this._clientInfo = new Properties();
    }

    public Driver getDriver() {
        return this.this_driver;
    }

    @Override
    public void addWarning(String string, String string2) {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", addWarning()");
        }
        if (this.warnings != null) {
            this.warnings.setNextWarning(new SQLWarning(string, string2));
            return;
        }
        this.warnings = new SQLWarning(string);
    }

    @Override
    public BaseResultSet execSQL(String string) throws SQLException {
        if (this.stLogFlag || this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", execSQL(String s), paras: " + string);
        }
        return this.execSQL(string, this.getDefaultStatement());
    }

    @Override
    public BaseResultSet execSQL(String string, BaseStatement baseStatement) throws SQLException {
        BaseStatement baseStatement2 = baseStatement;
        return this.execSQL(string, baseStatement2, (BaseResultSet)baseStatement2.getRealResultSet());
    }

    @Override
    public BaseResultSet execSQL(String string, BaseStatement baseStatement, BaseResultSet baseResultSet) throws SQLException {
        try {
            if (this.stLogFlag || this.logFlag) {
                Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", execSQL(String s, BaseStatement stmt)" + string);
            }
            if (this.protocol == null) {
                throw new OSQLException("OSCAR-00211", "08003", 211);
            }
            int n2 = baseStatement.getMaxRows();
            return this.protocol.a(string, n2, baseStatement, baseResultSet);
        }
        catch (SQLException sQLException) {
            this.checkConnectionClosed(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.cursor = string;
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.cursor;
    }

    public String getURL() {
        return this.this_url;
    }

    public String getUserName() throws SQLException {
        String string = this.connectionProperty.getProperty("USER");
        if (string.length() > 1 && string.charAt(0) == '\"') {
            String string2 = string;
            if (string2.charAt(string2.length() - 1) == '\"') {
                return string.substring(1, string.length() - 1);
            }
        }
        return string.toUpperCase();
    }

    @Override
    public Encoding getClientEncoding() {
        return this.clientEncoding;
    }

    @Override
    public void setClientEncoding(String string) {
        if (string == null || "".equals(string)) {
            return;
        }
        this.clientEncoding = Encoding.getEncoding(string);
    }

    @Override
    public Encoding getEncoding() {
        return this.dbEncoding;
    }

    @Override
    public Fastpath getFastpathAPI() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", getFastpathAPI()");
        }
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this);
        }
        return this.fastpath;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", close()");
        }
        if (this.closed) {
            return;
        }
        if (this.getImplicitCachingEnabled() && this.getStatementCacheSize() > 0) {
            this.statementCache.close();
        }
        if (this.stList != null && this.stList.size() > 0) {
            for (int i2 = 0; i2 < this.stList.size(); ++i2) {
                if (this.stList.get(i2) == null) continue;
                this.stList.get(i2).close();
            }
        }
        this.stmt = null;
        this.clientEncoding = null;
        this.dbEncoding = null;
        this.planIDVec = null;
        this.this_url = null;
        this.cursor = null;
        this.fastpath = null;
        this.metadata = null;
        this.stList = null;
        if (this.protocol != null) {
            try {
                this.protocol.c();
            }
            catch (IOException iOException) {
            }
            finally {
                this.protocol = null;
            }
        } else if (this.protocolManager != null && this.protocolManager.a() != null) {
            try {
                this.protocolManager.a().close();
            }
            catch (IOException iOException) {}
        }
        if (this.cluster != null) {
            this.cluster.close();
        }
        this.cluster = null;
        this.closed = true;
    }

    @Override
    public String nativeSQL(String object) throws SQLException {
        if (object == null) {
            return null;
        }
        if ((object = EscapeProcessor.escapeSQL((String)object, true)) instanceof String) {
            return (String)object;
        }
        return ((EscapeProcessorResult)object).escapedSql;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.checkClosed();
        this.readOnly = bl;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.readOnly;
    }

    @Override
    public void setInTranscation(boolean bl) {
        this.inTransaction = bl;
    }

    @Override
    public boolean isInTransaction() {
        return this.inTransaction;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", setAutoCommit(boolean autoCommit), parameters: " + bl);
        }
        if (this.inTransaction) {
            if (bl) {
                this.execSQL("commit");
            }
        } else if (!bl) {
            this.execSQL("begin");
        }
        this.autoCommit = bl;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", commit() autoCommit=" + this.autoCommit);
        }
        if (!this.autoCommit) {
            this.closeCursor();
            if (this.holdability == 2) {
                this.releasePlanID();
            }
            this.execSQL("commit");
            try {
                this.execSQL("begin");
                return;
            }
            catch (OSQLException oSQLException) {
                OSQLException oSQLException2 = oSQLException;
                oSQLException.setExtraState(1);
                throw oSQLException2;
            }
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", rollback()");
        }
        if (!this.autoCommit) {
            this.closeCursor();
            if (this.holdability == 2) {
                this.releasePlanID();
            }
            this.execSQL("rollback");
            this.execSQL("begin");
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return this.isolationLevel;
    }

    @Override
    public void setTransactionIsolation(int n2) throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", setTransactionIsolation(int level), paras: " + n2);
        }
        String string = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL ";
        switch (n2) {
            case 1: {
                string = string + "READ UNCOMMITTED";
                this.isolationLevel = 1;
                break;
            }
            case 2: {
                string = string + "READ COMMITTED";
                this.isolationLevel = 2;
                break;
            }
            case 4: {
                string = string + "REPEATABLE READ";
                this.isolationLevel = 4;
                break;
            }
            case 8: {
                string = string + "SERIALIZABLE";
                this.isolationLevel = 8;
                break;
            }
            default: {
                throw new OSQLException("OSCAR-00204", "88888", 204);
            }
        }
        this.execSQL(string);
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.checkClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public synchronized int getSQLType(int n2) throws SQLException {
        Object object = (Integer)sqlTypeCache.get(n2);
        if (object == null) {
            object = "SELECT typname FROM INFO_SCHEM.sys_type WHERE oid = " + n2;
            if ((object = this.execSQL((String)object)).getColumnCount() != 1 || object.getTupleCount() != 1) {
                throw new OSQLException("OSCAR-00205", "88888", 205);
            }
            object.next();
            String string = object.getString(1);
            object.close();
            Integer n3 = n2;
            object = this.getSQLType(string);
            sqlTypeCache.put(n3, (Integer)object);
            DBTypeCache.put(n3, string);
        }
        return (Integer)object;
    }

    @Override
    public int getOscarType(int n2) throws SQLException {
        Integer n3 = (Integer)oscarTypeCache.get(n2);
        if (n3 == null) {
            return 0;
        }
        return n3;
    }

    @Override
    public int getDBTypeOid(String string) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", getDBTypeOid(String typeName), paras: " + string);
        }
        int n2 = -1;
        if (string != null) {
            Object object = (Integer)typeOidCache.get(string);
            if (object != null) {
                n2 = (Integer)object;
            } else {
                object = "SELECT oid FROM INFO_SCHEM.sys_type WHERE typname='" + string + "'";
                BaseResultSet baseResultSet = this.execSQL((String)object);
                if (baseResultSet.getColumnCount() != 1 || baseResultSet.getTupleCount() != 1) {
                    throw new OSQLException("OSCAR-00205", "88888", 205);
                }
                baseResultSet.next();
                n2 = Integer.parseInt(baseResultSet.getString(1));
                typeOidCache.put(string, n2);
                baseResultSet.close();
            }
        }
        return n2;
    }

    @Override
    public synchronized String getDBType(int n2) throws SQLException {
        String string;
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", getDBType(int oid), paras: " + n2);
        }
        if ((string = (String)DBTypeCache.get(n2)) == null) {
            string = "SELECT typname FROM INFO_SCHEM.sys_type WHERE oid = " + n2;
            BaseResultSet baseResultSet = this.execSQL(string);
            if (baseResultSet.getColumnCount() != 1 || baseResultSet.getTupleCount() != 1) {
                throw new OSQLException("OSCAR-00205", "88888", 205);
            }
            baseResultSet.next();
            string = baseResultSet.getString(1);
            baseResultSet.close();
            DBTypeCache.put(n2, string);
            sqlTypeCache.put(n2, 12);
        }
        return string;
    }

    @Override
    public synchronized Class<? extends OscarObject> getOscarObject(String string) {
        if (this.logFlag) {
            Driver.writeLog("session: " + this.sessionID + ", " + OscarJdbc2Connection.class + ", getOscarObject(String type), paras: " + string);
        }
        return (Class)DBTypeClassCache.get(string);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public synchronized int getSQLType(String string) {
        int n2 = 12;
        if (jdbcTypes.get(string) != null) {
            n2 = (Integer)jdbcTypes.get(string);
        }
        return n2;
    }

    @Override
    public void cancelQuery() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", cancelQuery()");
        }
        if (this.protocol == null) {
            return;
        }
        try {
            this.protocol.a(this.pid, this.ckey);
            return;
        }
        catch (IOException iOException) {
            throw new OSQLException("OSCAR-00206", "08001", 206, iOException.getMessage(), iOException);
        }
    }

    @Override
    public void addCursor(String string) {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", addCursor(String cursorName), paras: " + string);
        }
        if (this.cursorVec == null) {
            this.cursorVec = new Vector();
        }
        if (string != null && !"".equals(string)) {
            this.cursorVec.add(string);
        }
    }

    @Override
    public void addPlanID(byte[] byArray) {
        int n2;
        if (this.logFlag && byArray != null) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", addCursor(String cursorName), paras: " + byArray[0] + byArray[1]);
        }
        if (this.planIDVec == null) {
            this.planIDVec = new Vector();
        }
        if (byArray != null && (n2 = this.checkPlanID(byArray)) == -1) {
            this.planIDVec.add(byArray);
        }
    }

    @Override
    public void removePlanID(int n2) {
        if (this.planIDVec != null && n2 >= 0 && n2 < this.planIDVec.size()) {
            this.planIDVec.remove(n2);
        }
    }

    private synchronized void closeCursor() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", closeCursor()");
        }
        if (this.cursorVec != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = this.cursorVec.size();
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                String string = this.cursorVec.remove(i2);
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append("CLOSE ").append(string).append(";DEALLOCATE ").append(string);
                if (this.isClosed()) continue;
                this.execSQL(stringBuffer.toString(), this.stmt);
            }
        }
    }

    @Override
    public synchronized void closeCursor(String string, BaseStatement object) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", closeCursor(cursorName,statement)");
        }
        if (this.cursorVec != null && this.cursorVec.contains(string)) {
            this.cursorVec.remove(string);
            object = new StringBuffer();
            ((StringBuffer)object).delete(0, ((StringBuffer)object).length());
            ((StringBuffer)object).append("CLOSE ").append(string).append(";DEALLOCATE ").append(string);
            if (!this.isClosed()) {
                this.execSQL(((StringBuffer)object).toString(), this.stmt);
            }
        }
    }

    private void releasePlanID() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", releasePlanID()");
        }
        if (this.planIDVec != null) {
            int n2 = this.planIDVec.size();
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                byte[] byArray = this.planIDVec.remove(i2);
                ((b)this.getProtocol()).a(null, null, null, null, byArray, 0, 0, true, false, this.getDefaultStatement(), false);
            }
        }
    }

    @Override
    public void removeCursor(String string) {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", removeCursor(String cursorName), paras: " + string);
        }
        if (this.cursorVec != null) {
            this.cursorVec.remove(string);
        }
    }

    @Override
    public boolean hasCursor(String string) {
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ", hasCursor(String cursorName), paras: " + string);
        }
        if (this.cursorVec == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        boolean bl = this.cursorVec.contains(string);
        return bl;
    }

    @Override
    public BaseStatement getDefaultStatement() throws SQLException {
        if (this.stmt == null) {
            this.stmt = (BaseStatement)((Object)this.createStatement(1003, 1007, this.holdability));
        }
        return this.stmt;
    }

    @Override
    public int getPreapredCacheSize() {
        return this.preparedCacheSize;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.typemap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.typemap = map;
    }

    @Override
    public void setHoldability(int n2) throws SQLException {
        this.checkClosed();
        if (n2 != 2 && n2 != 1) {
            return;
        }
        this.holdability = n2;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.holdability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new OSQLException("OSCAR-00208", "25000", 208);
        }
        return OSCARSavepoint.setSavepoint(this);
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new OSQLException("OSCAR-00208", "25000", 208);
        }
        return OSCARSavepoint.setSavepoint(string, this);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new OSQLException("OSCAR-00209", "25000", 209);
        }
        OSCARSavepoint.rollbackSavepoint(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new OSQLException("OSCAR-00209", "25000", 209);
        }
        OSCARSavepoint.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int n2, int n3) throws SQLException {
        return this.createStatement(n2, n3, this.getHoldability());
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n2, int n3) throws SQLException {
        return this.prepareStatement(string, n2, n3, this.getHoldability());
    }

    @Override
    public CallableStatement prepareCall(String string, int n2, int n3) throws SQLException {
        return this.prepareCall(string, n2, n3, this.getHoldability());
    }

    @Override
    public PreparedStatement prepareStatement(String object, int n2) throws SQLException {
        if (n2 == 2) {
            n2 = -1;
        } else if (n2 == 1) {
            n2 = 1;
        } else {
            throw new OSQLException("OSCAR-00210", "88888", 210);
        }
        object = this.prepareStatement((String)object);
        ((OscarStatement)object).setAutoGeneratedInfo(n2);
        return object;
    }

    @Override
    public PreparedStatement prepareStatement(String object, int[] nArray) throws SQLException {
        object = this.prepareStatement((String)object);
        ((OscarStatement)object).setAutoGeneratedInfo(2);
        ((OscarStatement)object).setAutoGeneratedIndexes(nArray);
        return object;
    }

    @Override
    public PreparedStatement prepareStatement(String object, String[] stringArray) throws SQLException {
        object = this.prepareStatement((String)object);
        ((OscarStatement)object).setAutoGeneratedInfo(3);
        ((OscarStatement)object).setAutoGeneratedNames(stringArray);
        return object;
    }

    @Override
    public OscarBfile getBfileInstance(String string) throws SQLException {
        return OscarBfile.createByLocator(this, string);
    }

    @Override
    public OscarBlob getBlobInstance(String string) throws SQLException {
        return OscarBlob.createByLocator(this, string);
    }

    @Override
    public OscarClob getClobInstance(String string) throws SQLException {
        return OscarClob.createByLocator(this, string);
    }

    @Override
    public OscarBlob createBlob() throws SQLException {
        return this.createTempBlob(true, 0);
    }

    @Override
    public OscarBlob createTempBlob(boolean bl, int n2) throws SQLException {
        return OscarBlob.createTemporary(this, bl, n2);
    }

    @Override
    public OscarClob createClob() throws SQLException {
        return this.createTempClob(true, 0);
    }

    @Override
    public OscarClob createTempClob(boolean bl, int n2) throws SQLException {
        return OscarClob.createTemporary(this, bl, n2);
    }

    @Override
    public OSCARTransfer getTransfer() {
        return new OSCARTransfer(this);
    }

    @Override
    public Statement createStatement(int n2, int n3, int n4) throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ",createStatement, paras: resultSetType: " + n2 + ", concurrency: " + n3 + ", holdability: " + n4);
        }
        if (n2 != 1003 && n2 != 1004 && n2 != 1005) {
            throw new OSQLException("OSCAR-00422", "88888", 422);
        }
        if (n3 != 1007 && n3 != 1008) {
            throw new OSQLException("OSCAR-00423", "88888", 423);
        }
        if (n4 != 2 && n4 != 1) {
            throw new OSQLException("OSCAR-00207", "88888", 207);
        }
        if (this.stList == null) {
            this.stList = new LinkedList<Statement>();
        }
        if (this.version.getProtocolType() == 1) {
            OscarStatement oscarStatement = new OscarStatement(this);
            oscarStatement.setResultSetType(n2);
            oscarStatement.setResultSetConcurrency(n3);
            oscarStatement.setResultSetHoldability(n4);
            oscarStatement.setFetchSize(this.statementFetchSize);
            this.setHoldability(n4);
            if (this.isClearSt) {
                this.stList.add(oscarStatement);
            }
            return oscarStatement;
        }
        OscarStatementV2 oscarStatementV2 = new OscarStatementV2(this);
        oscarStatementV2.setResultSetType(n2);
        oscarStatementV2.setResultSetConcurrency(n3);
        oscarStatementV2.setResultSetHoldability(n4);
        oscarStatementV2.setFetchSize(this.statementFetchSize);
        this.setHoldability(n4);
        if (this.isClearSt) {
            this.stList.add(oscarStatementV2);
        }
        return oscarStatementV2;
    }

    boolean isValidPrepare(String object) throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        int[] nArray = new int[1];
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object.getBytes();
        nArray[0] = ((byte[])objectArray2[0]).length;
        object = this.getProtocol().a(4638, 1, nArray, objectArray2);
        if (!((Boolean)object[0]).booleanValue()) {
            int n2 = (Integer)object[1];
            object = k.a((byte[])object[2], n2);
            return object.equals(1);
        }
        return false;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n2, int n3, int n4) throws SQLException {
        this.checkClosed();
        string = string.trim();
        if (this.stLogFlag || this.logFlag) {
            Driver.writeLog(this.sessionID, this.pid, OscarJdbc2Connection.class + ",prepareStatement, paras: sql: " + string + ", resultSetType: " + n2 + ", concurrency: " + n3 + ", holdability: " + n4);
        }
        if (n2 != 1003 && n2 != 1004 && n2 != 1005) {
            throw new OSQLException("OSCAR-00422", "88888", 422);
        }
        if (n3 != 1007 && n3 != 1008) {
            throw new OSQLException("OSCAR-00423", "88888", 423);
        }
        if (n4 != 2 && n4 != 1) {
            n4 = 2;
        }
        if (this.stList == null) {
            this.stList = new LinkedList<Statement>();
        }
        if (this.version.getProtocolType() == 1) {
            OscarPreparedStatement oscarPreparedStatement = null;
            if (this.statementCache != null) {
                oscarPreparedStatement = (OscarPreparedStatement)this.statementCache.searchImplicitCache(string, 1, n2);
            }
            if (oscarPreparedStatement == null) {
                oscarPreparedStatement = OscarStatement.getPreparedInstance(this, string);
                if (n3 == 1008) {
                    oscarPreparedStatement.setUseTid(true);
                }
                if (oscarPreparedStatement.isNotSupportPrePare()) {
                    if (this.isClearSt) {
                        this.stList.add(oscarPreparedStatement);
                    }
                    return oscarPreparedStatement;
                }
                oscarPreparedStatement.prepare();
            }
            oscarPreparedStatement.setFetchSize(this.statementFetchSize);
            oscarPreparedStatement.setResultSetType(n2);
            oscarPreparedStatement.setResultSetConcurrency(n3);
            oscarPreparedStatement.setResultSetHoldability(n4);
            if (this.isClearSt) {
                this.stList.add(oscarPreparedStatement);
            }
            return oscarPreparedStatement;
        }
        OscarPreparedStatementV2 oscarPreparedStatementV2 = null;
        if (this.statementCache != null) {
            oscarPreparedStatementV2 = (OscarPreparedStatementV2)this.statementCache.searchImplicitCache(string, 1, n2);
        }
        if (oscarPreparedStatementV2 == null) {
            oscarPreparedStatementV2 = OscarStatement.getPreparedInstanceV2(this, string);
            if (n3 == 1008) {
                oscarPreparedStatementV2.setUseTid(true);
            }
            if (oscarPreparedStatementV2.isNotSupportPrePare()) {
                if (this.isClearSt) {
                    this.stList.add(oscarPreparedStatementV2);
                }
                return oscarPreparedStatementV2;
            }
            oscarPreparedStatementV2.prepare();
        }
        oscarPreparedStatementV2.setFetchSize(this.statementFetchSize);
        oscarPreparedStatementV2.setResultSetType(n2);
        oscarPreparedStatementV2.setResultSetConcurrency(n3);
        oscarPreparedStatementV2.setResultSetHoldability(n4);
        oscarPreparedStatementV2.setLobDisplayMaxSize(this.lobDisplayMaxSize);
        if (this.isClearSt) {
            this.stList.add(oscarPreparedStatementV2);
        }
        return oscarPreparedStatementV2;
    }

    @Override
    public CallableStatement prepareCall(String object, int n2, int n3, int n4) throws SQLException {
        this.checkClosed();
        if (n2 != 1003 && n2 != 1004 && n2 != 1005) {
            throw new OSQLException("OSCAR-00422", "88888", 422);
        }
        if (n3 != 1007 && n3 != 1008) {
            throw new OSQLException("OSCAR-00423", "88888", 423);
        }
        if (n4 != 2 && n4 != 1) {
            throw new OSQLException("OSCAR-00207", "88888", 207);
        }
        if (this.stList == null) {
            this.stList = new LinkedList<Statement>();
        }
        if (this.version.getProtocolType() == 1) {
            object = new OscarCallableStatement(this, (String)object);
            ((OscarStatement)object).setResultSetType(n2);
            ((OscarStatement)object).setResultSetConcurrency(n3);
            ((OscarStatement)object).setResultSetHoldability(n4);
            ((OscarStatement)object).setFetchSize(this.statementFetchSize);
            this.setHoldability(n4);
            ((OscarPreparedStatement)object).prepare();
            if (this.isClearSt) {
                this.stList.add((Statement)object);
            }
            return object;
        }
        object = new OscarCallableStatementV2(this, (String)object);
        ((OscarStatement)object).setResultSetType(n2);
        ((OscarStatement)object).setResultSetConcurrency(n3);
        ((OscarStatement)object).setResultSetHoldability(n4);
        ((OscarStatement)object).setFetchSize(this.statementFetchSize);
        this.setHoldability(n4);
        ((OscarPreparedStatementV2)object).prepare();
        ((OscarStatementV2)object).setLobDisplayMaxSize(this.lobDisplayMaxSize);
        if (this.isClearSt) {
            this.stList.add((Statement)object);
        }
        return object;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.metadata == null) {
            this.metadata = new OscarDatabaseMetaData(this);
        }
        return this.metadata;
    }

    @Override
    public long getAccessHandle() {
        this.randNum = (this.randNum * 1103515245L + 12345L) % 0x40000000L;
        return this.randNum;
    }

    @Override
    public void setSeed(long l2) {
        this.randNum = l2 % 0x40000000L;
    }

    @Override
    public VersionConfig getVersion() {
        return this.version.getVersion();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.version;
    }

    @Override
    public void setVersion(ProtocolVersion protocolVersion) {
        this.version = protocolVersion;
    }

    @Override
    public boolean isUsePrepareCache() {
        return this.preparedCacheSize > 0;
    }

    @Override
    public boolean isCompatibleOracle() {
        return this.compatibleOracle;
    }

    public void setCompatibleOracle(boolean bl) {
        this.compatibleOracle = bl;
    }

    @Override
    public boolean isNotRealPrepare() {
        return this.notRealPrepare;
    }

    @Override
    public QueryExecutor getQueryExecutor() {
        return this.executor;
    }

    public int getStatementFetchSize() {
        return this.statementFetchSize;
    }

    @Override
    public boolean isCompressTransfer() {
        return this.compressTransfer;
    }

    @Override
    public void setCompressTransfer(boolean bl) {
    }

    @Override
    public ImportHandler createImportHandler(String string) throws SQLException {
        if (this.getProtocolVersion().isMpp5()) {
            return this.createDistributeImportHandler(string);
        }
        return new OscarImportHandler(this, null, string);
    }

    @Override
    public ImportHandler createImportHandler() throws SQLException {
        return new OscarImportHandler(this);
    }

    @Override
    public ImportHandler createImportHandler(String string, String string2) throws SQLException {
        if (this.getProtocolVersion().isMpp5()) {
            return this.createDistributeImportHandler(string, string2);
        }
        return new OscarImportHandler(this, string, string2);
    }

    @Override
    public ProviderImportHandler createProviderImportHandler(String string) throws SQLException {
        return new OscarProviderImportHandle(this, string);
    }

    @Override
    public ProviderImportHandler createProviderImportHandler(String string, String string2) throws SQLException {
        return new OscarProviderImportHandle(this, string, string2);
    }

    @Override
    public ExportHandler createExportHandler() throws SQLException {
        return new OscarExportHandler(this);
    }

    @Override
    public int getBatchBufferSize() {
        return this.batchBufferSize;
    }

    @Override
    public void setBatchBufferSize(int n2) {
        if (n2 > 0x100000) {
            n2 = 0x100000;
        } else if (n2 <= 0) {
            n2 = 1;
        }
        this.batchBufferSize = n2;
    }

    @Override
    public int getEndianType() {
        return this.endianType;
    }

    @Override
    public void setEndianType(int n2) {
        this.endianType = n2;
    }

    @Override
    public int checkPlanID(byte[] byArray) {
        if (this.planIDVec != null) {
            for (int i2 = 0; i2 < this.planIDVec.size(); ++i2) {
                byte[] byArray2 = this.planIDVec.get(i2);
                if (!Arrays.equals(byArray, byArray2)) continue;
                return i2;
            }
        }
        return -1;
    }

    @Override
    public Integer getSessionID() {
        return this.sessionID;
    }

    @Override
    public int getPlanID() {
        return this.pid;
    }

    public int getCkey() {
        return this.ckey;
    }

    @Override
    public boolean isNetDataByStr() {
        return this.netDataByStr;
    }

    @Override
    public boolean isNumericKeepPrecision() {
        return this.numericKeepPrecision;
    }

    public int getStatementCacheSize() throws SQLException {
        return this.statementCache.getCacheSize();
    }

    public void setStatementCacheSize(int n2) throws SQLException {
        if (this.statementCache == null) {
            if (this.version.getProtocolType() == 1) {
                this.statementCache = new LRUStatementCache(n2);
                return;
            }
            this.statementCache = new LRUStatementCacheV2(n2);
            return;
        }
        this.statementCache.resize(n2);
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        if (this.statementCache == null) {
            return false;
        }
        return this.statementCache.getImplicitCachingEnabled();
    }

    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        if (this.statementCache == null) {
            this.statementCache = this.version.getProtocolType() == 1 ? new LRUStatementCache(0) : new LRUStatementCacheV2(0);
        }
        this.statementCache.setImplicitCachingEnabled(bl);
    }

    public boolean isStatementCacheInitialized() {
        if (this.statementCache == null) {
            return false;
        }
        return this.statementCache.getCacheSize() != 0;
    }

    public final void purgeStatementCache() throws SQLException {
        if (this.isStatementCacheInitialized()) {
            this.statementCache.purgeImplicitCache();
        }
    }

    public final void closeStatementCache() throws SQLException {
        if (this.isStatementCacheInitialized()) {
            this.statementCache.close();
            this.statementCache = null;
        }
    }

    public synchronized void cacheImplicitStatement(OscarPreparedStatement oscarPreparedStatement, String string, int n2, int n3) throws SQLException {
        if (this.statementCache == null) {
            throw new SQLException("The statement cache is not enabled.", "");
        }
        this.statementCache.addToImplicitCache(oscarPreparedStatement, string, n2, n3);
    }

    public synchronized void cacheImplicitStatement(OscarPreparedStatementV2 oscarPreparedStatementV2, String string, int n2, int n3) throws SQLException {
        if (this.statementCache == null) {
            throw new SQLException("The statement cache is not enabled.", "");
        }
        this.statementCache.addToImplicitCache(oscarPreparedStatementV2, string, n2, n3);
    }

    /*
     * Loose catch block
     */
    protected int getLobDisplayMaxSize() {
        block31: {
            if (this.lobDisplayMaxSize == -1) {
                Statement statement;
                ResultSet resultSet;
                block28: {
                    resultSet = null;
                    statement = null;
                    statement = this.createStatement();
                    resultSet = this.execSQL("show LOB_DISPLAY_MAX_SIZE", (BaseStatement)((Object)statement));
                    this.lobDisplayMaxSize = resultSet.next() ? resultSet.getInt(2) : 4000;
                    if (resultSet == null) break block28;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
                break block31;
                catch (SQLException sQLException) {
                    block29: {
                        this.lobDisplayMaxSize = 4000;
                        if (resultSet == null) break block29;
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception) {
                    block30: {
                        this.lobDisplayMaxSize = 4000;
                        if (resultSet == null) break block30;
                        {
                            catch (Throwable throwable) {
                                if (resultSet != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Exception exception2) {}
                                }
                                if (statement != null) {
                                    try {
                                        statement.close();
                                    }
                                    catch (Exception exception3) {}
                                }
                                throw throwable;
                            }
                        }
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception4) {}
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception5) {}
                    }
                }
            }
        }
        return this.lobDisplayMaxSize;
    }

    @Override
    public boolean isTcpKeepAlive() {
        boolean bl = false;
        Object object = this.protocol.a.e();
        if (object != null) {
            try {
                bl = ((Socket)object).getKeepAlive();
            }
            catch (SocketException socketException) {
                object = socketException;
                Driver.writeLog(socketException.getMessage());
            }
        }
        return bl;
    }

    @Override
    public void setTcpKeepAlive(boolean bl) {
        Socket socket = this.protocol.a.e();
        if (socket != null) {
            try {
                socket.setKeepAlive(bl);
                return;
            }
            catch (SocketException socketException) {
                SocketException socketException2 = socketException;
                Driver.writeLog(socketException.getMessage());
            }
        }
    }

    @Override
    public boolean isValidate() {
        return this.isValidate(1000);
    }

    @Override
    public boolean isValid(int n2) throws SQLException {
        if (n2 < 0) {
            throw new OSQLException("OSCAR-00124", "88888", 124);
        }
        if (this.logFlag) {
            Driver.writeLog("isValid(int timeout) start, timeout=" + n2);
        }
        return this.isValidate(n2 * 1000);
    }

    @Override
    public boolean isValid() throws SQLException {
        return this.isValid(10);
    }

    @Override
    public boolean isValidate(int n2) {
        if (this.closed) {
            return false;
        }
        Statement statement = null;
        boolean bl = false;
        try {
            if (this.logFlag) {
                Driver.writeLog("isValidate(int timeout) start, timeout(ms)=" + n2);
            }
            this.protocol.a.a(n2);
            statement = this.createStatement();
            statement.execute(this.validTestString);
            this.protocol.a.a(this.timeOut_MilliSecond);
            bl = true;
            if (this.logFlag) {
                Driver.writeLog("isValidate(int timeout): connection is valid");
            }
        }
        catch (SocketException socketException) {
            if (this.logFlag) {
                Driver.writeLog("isValidate(int timeout): SocketException " + socketException.getMessage());
            }
        }
        catch (SQLException sQLException) {
            if (this.logFlag) {
                Driver.writeLog("isValidate(int timeout): SQLException" + sQLException.getMessage());
            }
        }
        finally {
            block22: {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!this.logFlag) break block22;
                    Driver.writeLog("isValidate(int timeout):close statement SQLException" + sQLException.getMessage());
                }
            }
        }
        return bl;
    }

    @Override
    public boolean isVerifyPoolConnection() {
        return this.verifyPoolConnection;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setDBEncoding() throws SQLException {
        Statement statement;
        block15: {
            ResultSet resultSet = null;
            statement = null;
            try {
                statement = this.createStatement();
                resultSet = this.execSQL("select ENCODING from v_sys_database ", (BaseStatement)((Object)statement));
                this.dbEncoding = resultSet != null && resultSet.next() ? Encoding.getEncoding(resultSet.getInt(1)) : this.clientEncoding;
                if (resultSet == null) break block15;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    throw new OSQLException("OSCAR-00903", "88888", 903);
                    catch (SQLException sQLException) {
                        SQLException sQLException2 = sQLException;
                        throw sQLException;
                    }
                    catch (Exception exception) {
                        throw new SQLException(exception.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (statement == null) throw throwable;
                    try {
                        statement.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
            }
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
        }
        if (statement == null) return;
        try {
            statement.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public int getBatchCount() {
        return this.batchCount;
    }

    @Override
    public boolean isUseAsynBatch() {
        return this.useAsynBatch;
    }

    @Override
    public boolean isReceiveStringByLen() {
        return this.receiveStringByLen;
    }

    @Override
    public void setMasterConnection(Connection connection) {
        this.masterConnection = connection;
    }

    @Override
    public Connection getMasterConnection() {
        if (this.masterConnection == null) {
            return this;
        }
        return this.masterConnection;
    }

    @Override
    public Properties getConnectionProperties() {
        return this.connectionProperty;
    }

    public long getLsnValue() {
        return this.lsnValue;
    }

    public void setLsnValue(long l2) {
        this.lsnValue = l2;
    }

    @Override
    public void setTransStatus(int n2) {
        this.transStatus = n2;
    }

    @Override
    public int getTransStatus() {
        return this.transStatus;
    }

    public DispatchConnection getDispatchConn() {
        return this.dispatchConn;
    }

    public void setDispatchConn(DispatchConnection dispatchConnection) {
        this.dispatchConn = dispatchConnection;
    }

    @Override
    public boolean isCompatibleOldDateFormat() {
        return this.compatibleOldDateFormat;
    }

    @Override
    public boolean isSlave() {
        return this.isSlave;
    }

    @Override
    public void setIsSlave(boolean bl) {
        this.isSlave = bl;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        return new ConnectionArray(this, string, objectArray);
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("This connection has been closed.");
        }
        return new OscarSQLXML(this);
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("This connection has been closed.");
        }
        throw Driver.notImplemented();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("This connection has been closed.");
        }
        return this._clientInfo;
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("This connection has been closed.");
        }
        return this._clientInfo.getProperty(string);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (properties != null) {
            String[] stringArray = this.clientPro;
            int n2 = this.clientPro.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray[i2];
                this.setClientInfo(string, properties.getProperty(string, null));
            }
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException("This connection has been closed.", null);
        }
        if (this.clientPro[0].equals(string) || this.clientPro[1].equals(string) || this.clientPro[2].equals(string)) {
            if (string2 == null) {
                this._clientInfo.remove(string);
                return;
            }
            this._clientInfo.put(string, string2);
            return;
        }
        this.addWarning("ClientInfo property not supported.", "0A000");
    }

    public void setStatementListeners(List<StatementEventListener> list) {
        this.statementListeners = list;
    }

    @Override
    public List<StatementEventListener> getStatementListeners() {
        return this.statementListeners;
    }

    @Override
    public PooledConnectionImpl getPc() {
        return this.pc;
    }

    public void setPc(PooledConnectionImpl pooledConnectionImpl) {
        this.pc = pooledConnectionImpl;
    }

    @Override
    public boolean checkDBLinkSql() {
        return this.checkDBLinkSql;
    }

    @Override
    public boolean sendBinaryTypeAsHex() {
        return this.sendBinaryTypeAsHex;
    }

    void checkConnectionClosed(Exception exception) {
        switch (ExceptionUtil.isConnectionClosed(exception)) {
            case 1: {
                try {
                    this.close();
                    return;
                }
                catch (SQLException sQLException) {
                    if (this.stLogFlag) {
                        Driver.writeLog("OscarJdbc2Connection checkConnectionClosed() ::" + sQLException.getMessage());
                    }
                    this.closed = true;
                    return;
                }
            }
            case 2: {
                this.closed = true;
            }
        }
    }

    @Override
    public void setSchema(String object) throws SQLException {
        Object object2;
        this.checkClosed();
        if (object == null) {
            throw new SQLException("Schema name can not be null!");
        }
        if (this.searchPath == null && (object2 = this.execSQL("SHOW SEARCH_PATH")).next()) {
            this.searchPath = object2.getString(2).split(",");
        }
        object2 = new ArrayList<String[]>();
        object2.add(object);
        if (this.searchPath != null) {
            object = this.searchPath;
            int n2 = this.searchPath.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = object[i2];
                if (object2.contains(string)) continue;
                object2.add(string);
            }
        }
        object = new StringBuilder("SET SEARCH_PATH=");
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || string.length() <= 0) continue;
            ((StringBuilder)object).append("'").append(string.trim()).append("'");
            ((StringBuilder)object).append(",");
        }
        Object object3 = object;
        this.execSQL(((StringBuilder)object3).deleteCharAt(((StringBuilder)object3).length() - 1).toString());
    }

    @Override
    public byte[] getHdSymEncryptKey() {
        return this.hdSymEncryptKey;
    }

    @Override
    public void setHdSymEncryptKey(byte[] byArray) {
        this.hdSymEncryptKey = byArray;
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        Object object = "select current_schema();";
        String string = null;
        try (BaseResultSet baseResultSet = null;){
            baseResultSet = this.execSQL((String)object);
            if (baseResultSet.next()) {
                string = baseResultSet.getString(1);
            }
        }
        return string;
    }

    @Override
    public DistributeImportHandler createDistributeImportHandler(String string, String string2) throws SQLException {
        return new ClusterImportHandler(this, string, string2);
    }

    @Override
    public DistributeImportHandler createDistributeImportHandler(String string) throws SQLException {
        return new ClusterImportHandler(this, null, string);
    }

    @Override
    public void setClusterImportNodeRetryTime(int n2) {
        this.clusterImportNodeRetryTime = n2;
    }

    @Override
    public int getClusterImportNodeRetryTime() {
        return this.clusterImportNodeRetryTime;
    }

    public long getSleepEndTime() {
        return this.sleepEndTime;
    }

    @Override
    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public Cluster getCluster() {
        return this.cluster;
    }

    public void setSleepEndTime(long l2) {
        this.sleepEndTime = l2;
    }

    public List<Statement> getStList() {
        return this.stList;
    }

    /*
     * Loose catch block
     */
    public boolean isMaster() {
        boolean bl;
        block14: {
            Object object;
            block13: {
                bl = false;
                object = null;
                object = this.execSQL("select * from info_schem.v_sys_ha_slave_info");
                if (!object.next()) break block13;
                bl = true;
            }
            try {
                if (object != null) {
                    object.close();
                }
                break block14;
            }
            catch (SQLException sQLException) {
                SQLException sQLException2 = sQLException;
                sQLException.printStackTrace();
            }
            break block14;
            catch (SQLException sQLException) {
                SQLException sQLException3;
                try {
                    sQLException3 = sQLException;
                    sQLException.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        if (object != null) {
                            object.close();
                        }
                    }
                    catch (SQLException sQLException4) {
                        object = sQLException4;
                        sQLException4.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    if (object != null) {
                        object.close();
                    }
                }
                catch (SQLException sQLException5) {
                    sQLException3 = sQLException5;
                    sQLException5.printStackTrace();
                }
            }
        }
        return bl;
    }

    @Override
    public final void abort(Executor executor) throws SQLException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ABORT_PERM);
        }
        if (executor == null) {
            throw new SQLException("Executor can not be null");
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    OscarJdbc2Connection.this.close();
                    return;
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
            }
        });
    }

    @Override
    public final void setNetworkTimeout(Executor object, int n2) throws SQLException {
        this.checkClosed();
        if (n2 < 0) {
            throw new OSQLException("OSCAR-00124", "88888", 124);
        }
        object = System.getSecurityManager();
        if (object != null) {
            ((SecurityManager)object).checkPermission(SET_NETWORK_TIMEOUT_PERM);
        }
        try {
            this.protocol.a.e().setSoTimeout(n2);
            this.timeOut_MilliSecond = n2;
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.timeOut_MilliSecond;
    }

    /*
     * Loose catch block
     */
    public Map<String, Map<String, String>> initSlavesInfo(Properties properties) {
        HashMap<String, Map<String, String>> hashMap;
        block19: {
            ResultSet resultSet;
            block18: {
                hashMap = new HashMap();
                resultSet = null;
                StringBuilder stringBuilder = new StringBuilder(OscarJdbc2Connection.class + ", initSlavesInfo(), ");
                boolean bl = Boolean.valueOf(properties.getProperty("USEASYNCHRONOUSNODE", "false"));
                boolean bl2 = Boolean.valueOf(properties.getProperty("USENONSYNCHRONIZED", "true"));
                StringBuilder stringBuilder2 = new StringBuilder("SELECT ADDRESS, PORT FROM INFO_SCHEM.V_SYS_HA_SLAVE_INFO WHERE READABLE = TRUE ");
                if (bl2) {
                    stringBuilder.append(" useNonSynchronized=true, ");
                } else {
                    stringBuilder2.append(" AND SYNCHRONIZED = TRUE");
                    stringBuilder.append(" useNonSynchronized=false, ");
                }
                if (bl) {
                    stringBuilder.append(" useAsynchronousNode=true, slave nodes: ");
                } else {
                    stringBuilder2.append(" AND SYNCLOG = TRUE");
                    stringBuilder.append(" useAsynchronousNode=false, slave nodes:");
                }
                resultSet = this.execSQL(stringBuilder2.toString());
                int n2 = 0;
                while (resultSet.next()) {
                    String string = "slave" + n2;
                    HashMap<String, String> hashMap2 = new HashMap<String, String>();
                    hashMap.put(string, hashMap2);
                    hashMap2.put("ADDRESS", resultSet.getString("ADDRESS"));
                    hashMap2.put("PORT", resultSet.getString("PORT"));
                    stringBuilder.append(string + ":" + ((Object)hashMap2).toString() + "  ");
                    ++n2;
                }
                if (!this.logFlag) break block18;
                Driver.writeLog(this.sessionID, this.pid, stringBuilder.toString());
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                break block19;
            }
            catch (SQLException sQLException) {
                SQLException sQLException2 = sQLException;
                sQLException.printStackTrace();
            }
            break block19;
            catch (SQLException sQLException) {
                SQLException sQLException3;
                try {
                    sQLException3 = sQLException;
                    sQLException.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException4) {
                        hashMap = sQLException4;
                        sQLException4.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException5) {
                    sQLException3 = sQLException5;
                    sQLException5.printStackTrace();
                }
            }
        }
        return hashMap;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new OSQLException("OSCAR-00211", "08003", 211);
        }
    }

    public boolean isSupportAuto() {
        return this.supportAuto;
    }

    public boolean isSupportGenerated() {
        return this.supportGenerated;
    }

    public void setSupportAuto(boolean bl) {
        this.supportAuto = bl;
    }

    public void setSupportGenerated(boolean bl) {
        this.supportGenerated = bl;
    }

    public Map<FieldMetadata.Key, FieldMetadata> getFieldMetadataCache() {
        return this.fieldMetadataCache;
    }

    @Override
    public boolean enableCe() {
        return this.enableCe;
    }

    @Override
    public Calendar getCalendar() {
        return this.calendar;
    }

    public String[] getClientpro() {
        return this.clientPro;
    }

    static {
        Integer n2 = 972;
        Integer n3 = 21;
        Integer n4 = 23;
        Integer n5 = 26;
        Integer n6 = 20;
        Integer n7 = 1560;
        Integer n8 = 16;
        Integer n9 = 1700;
        Integer n10 = 2315;
        Integer n11 = 700;
        Integer n12 = 2174;
        Integer n13 = 2175;
        Integer n14 = 701;
        Integer n15 = 1042;
        Integer n16 = 1043;
        Integer n17 = 25;
        Integer n18 = 19;
        Integer n19 = 1365;
        Integer n20 = 3100;
        Integer n21 = 1082;
        Integer n22 = 1083;
        Integer n23 = 1114;
        Integer n24 = 1266;
        Integer n25 = 1184;
        Integer n26 = 3000;
        Integer n27 = 3001;
        Integer n28 = 3002;
        Integer n29 = 1034;
        Integer n30 = 1790;
        Integer n31 = 17;
        Integer n32 = 2278;
        Integer n33 = 1009;
        Integer n34 = 1188;
        Integer n35 = 1186;
        Integer n36 = 18;
        Integer n37 = 21;
        Integer n38 = 22;
        Integer n39 = 23;
        Integer n40 = 24;
        Integer n41 = 30;
        Integer n42 = 32;
        Integer n43 = 71;
        Integer n44 = 75;
        Integer n45 = 81;
        Integer n46 = 83;
        Integer n47 = 702;
        Integer n48 = 705;
        Integer n49 = 972;
        Integer n50 = 1000;
        Integer n51 = 1001;
        Integer n52 = 1002;
        Integer n53 = 1003;
        Integer n54 = 1005;
        Integer n55 = 1006;
        Integer n56 = 1007;
        Integer n57 = 1008;
        Integer n58 = 1009;
        Integer n59 = 1028;
        Integer n60 = 1013;
        Integer n61 = 1014;
        Integer n62 = 1015;
        Integer n63 = 1016;
        Integer n64 = 1021;
        Integer n65 = 1022;
        Integer n66 = 1033;
        Integer n67 = 1115;
        Integer n68 = 1182;
        Integer n69 = 1183;
        Integer n70 = 1185;
        Integer n71 = 1187;
        Integer n72 = 1189;
        Integer n73 = 1200;
        Integer n74 = 1231;
        Integer n75 = 1270;
        Integer n76 = 1561;
        Integer n77 = 1562;
        Integer n78 = 1563;
        Integer n79 = 2097;
        Integer n80 = 2176;
        Integer n81 = 2177;
        Integer n82 = 2201;
        Integer n83 = 2202;
        Integer n84 = 2203;
        Integer n85 = 2204;
        Integer n86 = 2205;
        Integer n87 = 2206;
        Integer n88 = 2207;
        Integer n89 = 2208;
        Integer n90 = 2209;
        Integer n91 = 2210;
        Integer n92 = 2211;
        Integer n93 = 2249;
        Integer n94 = 2275;
        Integer n95 = 2276;
        Integer n96 = 2277;
        Integer n97 = 2279;
        Integer n98 = 2280;
        Integer n99 = 2281;
        Integer n100 = 3101;
        Integer n101 = 3200;
        Integer n102 = 3300;
        Integer n103 = 3301;
        Integer n104 = 3302;
        Integer n105 = 3303;
        Integer n106 = 3304;
        Integer n107 = 3305;
        Integer n108 = 85;
        Integer n109 = 86;
        Integer n110 = 87;
        Integer n111 = 88;
        Integer n112 = 89;
        Integer n113 = 90;
        Integer n114 = 91;
        Integer n115 = 92;
        Integer n116 = 94;
        Integer n117 = 600;
        Integer n118 = 601;
        Integer n119 = 602;
        Integer n120 = 603;
        Integer n121 = 604;
        Integer n122 = 628;
        Integer n123 = 718;
        DBTypeCache.put(n2, "tinyint");
        DBTypeCache.put(n3, "smallint");
        DBTypeCache.put(n4, "int");
        DBTypeCache.put(n5, "OID");
        DBTypeCache.put(n6, "bigint");
        DBTypeCache.put(n7, "bit");
        DBTypeCache.put(n8, "boolean");
        DBTypeCache.put(n9, "numeric");
        DBTypeCache.put(n10, "decimal");
        DBTypeCache.put(n11, "real");
        DBTypeCache.put(n12, "float");
        DBTypeCache.put(n13, "float");
        DBTypeCache.put(n14, "double precision");
        DBTypeCache.put(n15, "char");
        DBTypeCache.put(n16, "varchar");
        DBTypeCache.put(n17, "text");
        DBTypeCache.put(n18, "name");
        DBTypeCache.put(n19, "binary");
        DBTypeCache.put(n20, "varbinary");
        DBTypeCache.put(n21, "date");
        DBTypeCache.put(n22, "time");
        DBTypeCache.put(n23, "timestamp");
        DBTypeCache.put(n24, "timetz");
        DBTypeCache.put(n25, "timestamptz");
        DBTypeCache.put(n26, "blob");
        DBTypeCache.put(n27, "clob");
        DBTypeCache.put(n28, "bfile");
        DBTypeCache.put(n29, "_ACLITEM");
        DBTypeCache.put(n30, "REFCURSOR");
        DBTypeCache.put(n31, "BYTEA");
        DBTypeCache.put(n32, "VOID");
        DBTypeCache.put(n34, "INTERVALDTS");
        DBTypeCache.put(n35, "INTERVALYTM");
        DBTypeCache.put(n36, "\"CHAR\"");
        DBTypeCache.put(n37, "int2");
        DBTypeCache.put(n38, "int2vector");
        DBTypeCache.put(n39, "int4");
        DBTypeCache.put(n40, "regproc");
        DBTypeCache.put(n41, "oidvector");
        DBTypeCache.put(n42, "set");
        DBTypeCache.put(n43, "sys_type");
        DBTypeCache.put(n44, "sys_attribute");
        DBTypeCache.put(n45, "sys_proc");
        DBTypeCache.put(n46, "sys_class");
        DBTypeCache.put(n47, "abstime");
        DBTypeCache.put(n48, "unknown");
        DBTypeCache.put(n49, "int1");
        DBTypeCache.put(n50, "_bool");
        DBTypeCache.put(n51, "_bytea");
        DBTypeCache.put(n52, "_char");
        DBTypeCache.put(n53, "_name");
        DBTypeCache.put(n54, "_int2");
        DBTypeCache.put(n55, "_int2vector");
        DBTypeCache.put(n56, "_int4");
        DBTypeCache.put(n57, "_regproc");
        DBTypeCache.put(n58, "_text");
        DBTypeCache.put(n59, "_oid");
        DBTypeCache.put(n60, "_oidvector");
        DBTypeCache.put(n61, "_bpchar");
        DBTypeCache.put(n62, "_varchar");
        DBTypeCache.put(n63, "_int8");
        DBTypeCache.put(n64, "_float4");
        DBTypeCache.put(n65, "_float8");
        DBTypeCache.put(n66, "aclitem");
        DBTypeCache.put(n67, "_timestamp");
        DBTypeCache.put(n68, "_date");
        DBTypeCache.put(n69, "_time");
        DBTypeCache.put(n70, "_timestamptz");
        DBTypeCache.put(n71, "_intervalytm");
        DBTypeCache.put(n72, "_intervaldts");
        DBTypeCache.put(n73, "_int1");
        DBTypeCache.put(n74, "_numeric");
        DBTypeCache.put(n75, "_timetz");
        DBTypeCache.put(n76, "_bit");
        DBTypeCache.put(n77, "varbit");
        DBTypeCache.put(n78, "_varbit");
        DBTypeCache.put(n79, "_binary");
        DBTypeCache.put(n80, "_lpfloat");
        DBTypeCache.put(n81, "_hpfloat");
        DBTypeCache.put(n82, "_refcursor");
        DBTypeCache.put(n83, "regprocedure");
        DBTypeCache.put(n84, "regoper");
        DBTypeCache.put(n85, "regoperator");
        DBTypeCache.put(n86, "regclass");
        DBTypeCache.put(n87, "regtype");
        DBTypeCache.put(n88, "_regprocedure");
        DBTypeCache.put(n89, "_regoper");
        DBTypeCache.put(n90, "_regoperator");
        DBTypeCache.put(n91, "_regclass");
        DBTypeCache.put(n92, "_regtype");
        DBTypeCache.put(n93, "record");
        DBTypeCache.put(n94, "cstring");
        DBTypeCache.put(n95, "any");
        DBTypeCache.put(n96, "anyarray");
        DBTypeCache.put(n97, "trigger");
        DBTypeCache.put(n98, "language_handler");
        DBTypeCache.put(n99, "internal");
        DBTypeCache.put(n100, "_varbinary");
        DBTypeCache.put(n101, "label");
        DBTypeCache.put(n102, "xml");
        DBTypeCache.put(n103, "_xml");
        DBTypeCache.put(n104, "collection");
        DBTypeCache.put(n105, "plsql_record");
        DBTypeCache.put(n106, "json");
        DBTypeCache.put(n107, "_json");
        DBTypeCache.put(n117, "point");
        DBTypeCache.put(n120, "box");
        DBTypeCache.put(n119, "path");
        DBTypeCache.put(n121, "polygon");
        DBTypeCache.put(n118, "lseg");
        DBTypeCache.put(n122, "line");
        DBTypeCache.put(n123, "circle");
        DBTypeCache.put(n108, "spheroid");
        DBTypeCache.put(n111, "box2d");
        DBTypeCache.put(n112, "box2df");
        DBTypeCache.put(n110, "box3d");
        DBTypeCache.put(n113, "gidx");
        DBTypeCache.put(n114, "geometry_dump");
        DBTypeCache.put(n115, "valid_detail");
        DBTypeCache.put(n109, "geometry");
        DBTypeCache.put(n116, "geography");
        DBTypeClassCache.put("point", OscarPoint.class);
        DBTypeClassCache.put("box", OscarBox.class);
        DBTypeClassCache.put("path", OscarPath.class);
        DBTypeClassCache.put("polygon", OscarPolygon.class);
        DBTypeClassCache.put("lseg", OscarLseg.class);
        DBTypeClassCache.put("line", OscarLine.class);
        DBTypeClassCache.put("circle", OscarCircle.class);
        DBTypeClassCache.put("geometry", OscarGeometry.class);
        DBTypeClassCache.put("box3d", OscarBox3d.class);
        DBTypeClassCache.put("gidx", OscarBox3d.class);
        DBTypeClassCache.put("box2d", OscarBox2d.class);
        DBTypeClassCache.put("box2df", OscarBox2d.class);
        DBTypeClassCache.put("geography", OscarGeography.class);
        oscarTypeCache.put(n2, 23);
        oscarTypeCache.put(n3, 23);
        oscarTypeCache.put(n4, 23);
        oscarTypeCache.put(n6, 23);
        oscarTypeCache.put(n8, 33);
        oscarTypeCache.put(n9, 34);
        oscarTypeCache.put(n10, 34);
        oscarTypeCache.put(n11, 34);
        oscarTypeCache.put(n13, 34);
        oscarTypeCache.put(n12, 34);
        oscarTypeCache.put(n14, 34);
        oscarTypeCache.put(n15, 24);
        oscarTypeCache.put(n16, 24);
        oscarTypeCache.put(n17, 24);
        oscarTypeCache.put(n18, 24);
        oscarTypeCache.put(n5, 24);
        oscarTypeCache.put(n7, 24);
        oscarTypeCache.put(n19, 35);
        oscarTypeCache.put(n20, 35);
        oscarTypeCache.put(n21, 25);
        oscarTypeCache.put(n22, 26);
        oscarTypeCache.put(n23, 28);
        oscarTypeCache.put(n24, 27);
        oscarTypeCache.put(n25, 29);
        oscarTypeCache.put(n26, 50);
        oscarTypeCache.put(n27, 51);
        oscarTypeCache.put(n28, 52);
        oscarTypeCache.put(n34, 31);
        oscarTypeCache.put(n35, 30);
        oscarTypeCache.put(n29, 2003);
        oscarTypeCache.put(n30, 24);
        oscarTypeCache.put(n31, 24);
        oscarTypeCache.put(n32, 24);
        oscarTypeCache.put(n33, 2003);
        oscarTypeCache.put(n106, 24);
        oscarTypeCache.put(n117, 24);
        oscarTypeCache.put(n120, 24);
        oscarTypeCache.put(n119, 24);
        oscarTypeCache.put(n121, 24);
        oscarTypeCache.put(n118, 24);
        oscarTypeCache.put(n122, 24);
        oscarTypeCache.put(n123, 24);
        oscarTypeCache.put(n108, 24);
        oscarTypeCache.put(n109, 24);
        oscarTypeCache.put(n110, 24);
        oscarTypeCache.put(n111, 24);
        oscarTypeCache.put(n112, 24);
        oscarTypeCache.put(n113, 24);
        oscarTypeCache.put(n114, 24);
        oscarTypeCache.put(n115, 24);
        oscarTypeCache.put(n116, 24);
        sqlTypeCache.put(n2, -6);
        sqlTypeCache.put(n3, 5);
        sqlTypeCache.put(n4, 4);
        sqlTypeCache.put(n5, -5);
        sqlTypeCache.put(n6, -5);
        sqlTypeCache.put(n7, -7);
        sqlTypeCache.put(n8, 16);
        sqlTypeCache.put(n9, 2);
        sqlTypeCache.put(n10, 3);
        sqlTypeCache.put(n11, 7);
        sqlTypeCache.put(n13, 6);
        sqlTypeCache.put(n12, 6);
        sqlTypeCache.put(n14, 8);
        sqlTypeCache.put(n15, 1);
        sqlTypeCache.put(n16, 12);
        sqlTypeCache.put(n36, 1);
        sqlTypeCache.put(n17, 12);
        sqlTypeCache.put(n18, 12);
        sqlTypeCache.put(n19, -2);
        sqlTypeCache.put(n20, -3);
        sqlTypeCache.put(n21, 91);
        sqlTypeCache.put(n22, 92);
        sqlTypeCache.put(n23, 93);
        sqlTypeCache.put(n24, 92);
        sqlTypeCache.put(n25, 93);
        sqlTypeCache.put(n26, 2004);
        sqlTypeCache.put(n27, 2005);
        sqlTypeCache.put(n28, -11);
        sqlTypeCache.put(n29, 2003);
        sqlTypeCache.put(n80, 2003);
        sqlTypeCache.put(n30, 12);
        sqlTypeCache.put(n31, 12);
        sqlTypeCache.put(n32, 0);
        sqlTypeCache.put(n106, -1);
        sqlTypeCache.put(n108, 1111);
        sqlTypeCache.put(n109, 1111);
        sqlTypeCache.put(n111, 1111);
        sqlTypeCache.put(n112, 1111);
        sqlTypeCache.put(n110, 1111);
        sqlTypeCache.put(n113, 1111);
        sqlTypeCache.put(n114, 1111);
        sqlTypeCache.put(n115, 1111);
        sqlTypeCache.put(n116, 1111);
        sqlTypeCache.put(n117, 1111);
        sqlTypeCache.put(n120, 1111);
        sqlTypeCache.put(n119, 1111);
        sqlTypeCache.put(n121, 1111);
        sqlTypeCache.put(n118, 1111);
        sqlTypeCache.put(n122, 1111);
        sqlTypeCache.put(n123, 1111);
        jdbcTypes.put("TINYINT", -6);
        jdbcTypes.put("SMALLINT", 5);
        jdbcTypes.put("INTEGER", 4);
        jdbcTypes.put("OID", 4);
        jdbcTypes.put("BIGINT", -5);
        jdbcTypes.put("BIT", -7);
        jdbcTypes.put("NUMERIC", 2);
        jdbcTypes.put("DECIMAL", 3);
        jdbcTypes.put("REAL", 7);
        jdbcTypes.put("MONEY", 7);
        jdbcTypes.put("FLOAT", 6);
        jdbcTypes.put("DOUBLE", 8);
        jdbcTypes.put("CHAR", 1);
        jdbcTypes.put("VARCHAR", 12);
        jdbcTypes.put("TEXT", -1);
        jdbcTypes.put("NAME", 12);
        jdbcTypes.put("BINARY", -2);
        jdbcTypes.put("VARBINARY", -3);
        jdbcTypes.put("BOOLEAN", 16);
        jdbcTypes.put("DATE", 91);
        jdbcTypes.put("TIME", 92);
        jdbcTypes.put("TIMESTAMP", 93);
        jdbcTypes.put("TIMESTAMPTZ", 93);
        jdbcTypes.put("BLOB", 2004);
        jdbcTypes.put("CLOB", 2005);
        jdbcTypes.put("BYTEA", -3);
        jdbcTypes.put("LABEL", 1111);
        jdbcTypes.put("INT1", -6);
        jdbcTypes.put("_INT1", 2003);
        jdbcTypes.put("INT2", 5);
        jdbcTypes.put("_INT2", 2003);
        jdbcTypes.put("INT4", 4);
        jdbcTypes.put("_INT4", 2003);
        jdbcTypes.put("INT8", -5);
        jdbcTypes.put("_INT8", 2003);
        jdbcTypes.put("_VARCHAR", 2003);
        jdbcTypes.put("_varchar", 2003);
        jdbcTypes.put("_BOOL", 2003);
        jdbcTypes.put("_bool", 2003);
        jdbcTypes.put("_HPFLOAT", 2003);
        jdbcTypes.put("_hpfloat", 2003);
        jdbcTypes.put("_FLOAT4", 2003);
        jdbcTypes.put("_float4", 2003);
        jdbcTypes.put("_FLOAT8", 2003);
        jdbcTypes.put("_float8", 2003);
        jdbcTypes.put("_TEXT", 2003);
        jdbcTypes.put("_text", 2003);
        jdbcTypes.put("_BPCHAR", 2003);
        jdbcTypes.put("_bpchar", 2003);
        jdbcTypes.put("_BIT", 2003);
        jdbcTypes.put("_bit", 2003);
        jdbcTypes.put("_NUMERIC", 2003);
        jdbcTypes.put("_numeric", 2003);
        jdbcTypes.put("_BINARY", 2003);
        jdbcTypes.put("_binary", 2003);
        jdbcTypes.put("_VARBINARY", 2003);
        jdbcTypes.put("_varbinary", 2003);
        jdbcTypes.put("_DATE", 2003);
        jdbcTypes.put("_date", 2003);
        jdbcTypes.put("_INTERVALYTM", 2003);
        jdbcTypes.put("_intervalytm", 2003);
        jdbcTypes.put("_INTERVALDTS", 2003);
        jdbcTypes.put("_intervaldts", 2003);
        jdbcTypes.put("_XML", 2003);
        jdbcTypes.put("_xml", 2003);
        jdbcTypes.put("_bytea", 2003);
        jdbcTypes.put("_BYTEA", 2003);
        jdbcTypes.put("_name", 2003);
        jdbcTypes.put("_NAME", 2003);
        jdbcTypes.put("_oid", 2003);
        jdbcTypes.put("_OID", 2003);
        jdbcTypes.put("int1", -6);
        jdbcTypes.put("_int1", 2003);
        jdbcTypes.put("int2", 5);
        jdbcTypes.put("_int2", 2003);
        jdbcTypes.put("int4", 4);
        jdbcTypes.put("_int4", 2003);
        jdbcTypes.put("int8", -5);
        jdbcTypes.put("_int8", 2003);
        jdbcTypes.put("tinyint", -6);
        jdbcTypes.put("smallint", 5);
        jdbcTypes.put("integer", 4);
        jdbcTypes.put("oid", 4);
        jdbcTypes.put("bigint", -5);
        jdbcTypes.put("bit", -7);
        jdbcTypes.put("numeric", 2);
        jdbcTypes.put("decimal", 3);
        jdbcTypes.put("real", 7);
        jdbcTypes.put("money", 7);
        jdbcTypes.put("float", 6);
        jdbcTypes.put("double", 8);
        jdbcTypes.put("char", 1);
        jdbcTypes.put("varchar", 12);
        jdbcTypes.put("text", -1);
        jdbcTypes.put("name", 12);
        jdbcTypes.put("binary", -2);
        jdbcTypes.put("varbinary", -3);
        jdbcTypes.put("boolean", 16);
        jdbcTypes.put("date", 91);
        jdbcTypes.put("time", 92);
        jdbcTypes.put("timestamp", 93);
        jdbcTypes.put("timestamptz", 93);
        jdbcTypes.put("blob", 2004);
        jdbcTypes.put("clob", 2005);
        jdbcTypes.put("bytea", -3);
        jdbcTypes.put("label", 1111);
        jdbcTypes.put("json", -1);
        jdbcTypes.put("_json", 2003);
        jdbcTypes.put("JSON", -1);
        jdbcTypes.put("_JSON", 2003);
        jdbcTypes.put("GEOMETRY_DUMP", 1111);
        jdbcTypes.put("VALID_DETAIL", 1111);
    }
}

