/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseResultSet;
import com.oscar.jdbc.ExceptionUtil;
import com.oscar.jdbc.OscarCallableStatement;
import com.oscar.jdbc.OscarJdbc2Connection;
import com.oscar.jdbc.OscarPreparedStatement;
import com.oscar.jdbc.OscarPreparedStatementV2;
import com.oscar.jdbc.OscarStatement;
import com.oscar.jdbc.OscarStatementV2;
import com.oscar.rac.executor.RacCallableStatementV2;
import com.oscar.rac.executor.RacPreparedStatementV2;
import com.oscar.rac.executor.RacStatementV2;
import com.oscar.util.OSQLException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class OscarJdbc2RacConnection
extends OscarJdbc2Connection {
    private volatile boolean retryConnect = true;

    @Override
    public void openConnection(String iterator, int n2, Properties properties, String string, String string2, Driver driver) throws SQLException {
        this.closed = false;
        super.openConnection((String)((Object)iterator), n2, properties, string, string2, driver);
        iterator = this.initRacInfo();
        if (iterator.size() > 0) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                Driver.getHostSet().add(string3);
            }
        }
    }

    @Override
    public Statement createStatement(int n2, int n3, int n4) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog("session: " + this.sessionID + ", " + OscarJdbc2Connection.class + ",createStatement, paras: resultSetType: " + n2 + ", concurrency: " + n3 + ", holdability: " + n4);
        }
        if (n2 != 1003 && n2 != 1004 && n2 != 1005) {
            throw new OSQLException("OSCAR-00422", "88888", 422);
        }
        if (n3 != 1007 && n3 != 1008) {
            throw new OSQLException("OSCAR-00423", "88888", 423);
        }
        if (n4 != 2 && n4 != 1) {
            throw new OSQLException("OSCAR-00207", "88888", 207);
        }
        if (this.stList == null) {
            this.stList = new LinkedList<Statement>();
        }
        if (this.version.getProtocolType() == 1) {
            OscarStatement oscarStatement = new OscarStatement(this);
            oscarStatement.setResultSetType(n2);
            oscarStatement.setResultSetConcurrency(n3);
            oscarStatement.setResultSetHoldability(n4);
            oscarStatement.setFetchSize(this.statementFetchSize);
            this.setHoldability(n4);
            this.stList.add(oscarStatement);
            return oscarStatement;
        }
        RacStatementV2 racStatementV2 = new RacStatementV2(this);
        racStatementV2.setResultSetType(n2);
        racStatementV2.setResultSetConcurrency(n3);
        racStatementV2.setResultSetHoldability(n4);
        racStatementV2.setFetchSize(this.statementFetchSize);
        this.setHoldability(n4);
        this.stList.add(racStatementV2);
        return racStatementV2;
    }

    @Override
    public CallableStatement prepareCall(String object, int n2, int n3, int n4) throws SQLException {
        if (n2 != 1003 && n2 != 1004 && n2 != 1005) {
            throw new OSQLException("OSCAR-00422", "88888", 422);
        }
        if (n3 != 1007 && n3 != 1008) {
            throw new OSQLException("OSCAR-00423", "88888", 423);
        }
        if (n4 != 2 && n4 != 1) {
            throw new OSQLException("OSCAR-00207", "88888", 207);
        }
        if (this.stList == null) {
            this.stList = new LinkedList<Statement>();
        }
        if (this.version.getProtocolType() == 1) {
            object = new OscarCallableStatement(this, (String)object);
            ((OscarStatement)object).setResultSetType(n2);
            ((OscarStatement)object).setResultSetConcurrency(n3);
            ((OscarStatement)object).setResultSetHoldability(n4);
            ((OscarStatement)object).setFetchSize(this.statementFetchSize);
            this.setHoldability(n4);
            ((OscarPreparedStatement)object).prepare();
            this.stList.add((Statement)object);
            return object;
        }
        object = new RacCallableStatementV2(this, (String)object);
        ((OscarStatement)object).setResultSetType(n2);
        ((OscarStatement)object).setResultSetConcurrency(n3);
        ((OscarStatement)object).setResultSetHoldability(n4);
        ((OscarStatement)object).setFetchSize(this.statementFetchSize);
        this.setHoldability(n4);
        ((OscarPreparedStatementV2)object).prepare();
        ((OscarStatementV2)object).setLobDisplayMaxSize(this.lobDisplayMaxSize);
        this.stList.add((Statement)object);
        return object;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n2, int n3, int n4) throws SQLException {
        string = string.trim();
        if (this.stLogFlag || this.logFlag) {
            Driver.writeLog("session: " + this.sessionID + ", " + OscarJdbc2Connection.class + ",prepareStatement, paras: sql: " + string + ", resultSetType: " + n2 + ", concurrency: " + n3 + ", holdability: " + n4);
        }
        if (n2 != 1003 && n2 != 1004 && n2 != 1005) {
            throw new OSQLException("OSCAR-00422", "88888", 422);
        }
        if (n3 != 1007 && n3 != 1008) {
            throw new OSQLException("OSCAR-00423", "88888", 423);
        }
        if (n4 != 2 && n4 != 1) {
            throw new OSQLException("OSCAR-00207", "88888", 207);
        }
        if (this.stList == null) {
            this.stList = new LinkedList<Statement>();
        }
        if (this.version.getProtocolType() == 1) {
            OscarStatement oscarStatement = null;
            if (this.statementCache != null) {
                oscarStatement = (OscarPreparedStatement)this.statementCache.searchImplicitCache(string, 1, n2);
            }
            if (oscarStatement == null) {
                oscarStatement = new OscarPreparedStatement(this, string);
                if (n3 == 1008) {
                    oscarStatement.setUseTid(true);
                }
                if (oscarStatement.isNotSupportPrePare()) {
                    this.stList.add(oscarStatement);
                    return oscarStatement;
                }
                ((OscarPreparedStatement)oscarStatement).prepare();
            }
            oscarStatement.setFetchSize(this.statementFetchSize);
            oscarStatement.setResultSetType(n2);
            oscarStatement.setResultSetConcurrency(n3);
            oscarStatement.setResultSetHoldability(n4);
            this.stList.add(oscarStatement);
            return oscarStatement;
        }
        OscarStatement oscarStatement = null;
        if (this.statementCache != null) {
            oscarStatement = (RacPreparedStatementV2)this.statementCache.searchImplicitCache(string, 1, n2);
        }
        if (oscarStatement == null) {
            oscarStatement = new RacPreparedStatementV2(this, string);
            if (n3 == 1008) {
                oscarStatement.setUseTid(true);
            }
            if (oscarStatement.isNotSupportPrePare()) {
                this.stList.add(oscarStatement);
                return oscarStatement;
            }
            ((OscarPreparedStatementV2)oscarStatement).prepare();
        }
        oscarStatement.setFetchSize(this.statementFetchSize);
        oscarStatement.setResultSetType(n2);
        oscarStatement.setResultSetConcurrency(n3);
        oscarStatement.setResultSetHoldability(n4);
        ((OscarStatementV2)oscarStatement).setLobDisplayMaxSize(this.lobDisplayMaxSize);
        this.stList.add(oscarStatement);
        return oscarStatement;
    }

    @Override
    void checkConnectionClosed(Exception exception) {
        switch (ExceptionUtil.isConnectionClosed(exception)) {
            case 1: {
                try {
                    this.retryConnect = true;
                    OscarJdbc2RacConnection oscarJdbc2RacConnection = this;
                    oscarJdbc2RacConnection.reConnect(oscarJdbc2RacConnection.getConnectionProperties());
                    return;
                }
                catch (SQLException sQLException) {
                    this.retryConnect = true;
                    return;
                }
            }
            case 2: {
                this.closed = true;
            }
        }
    }

    public boolean isRetryConnect() {
        return this.retryConnect;
    }

    public void setRetryConnect(boolean bl) {
        this.retryConnect = bl;
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        super.commit();
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.checkClosed();
        super.rollback();
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkClosed();
        super.setAutoCommit(bl);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        super.rollback(savepoint);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        return super.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        this.checkClosed();
        return super.setSavepoint(string);
    }

    public synchronized void reConnect(Properties properties) throws SQLException {
        if (!this.retryConnect) {
            return;
        }
        this.closed = true;
        this.resetStatement();
        if (!this.autoCommit) {
            this.planIDVec = null;
            this.cursorVec = null;
        }
        this.getDriver().connect(properties.getProperty("URL"), properties, this);
        if (!this.autoCommit) {
            this.autoCommit = true;
            super.setAutoCommit(false);
        }
        this.retryConnect = false;
        this.closed = false;
        Driver.writeLog("rac change connection success");
    }

    public void resetStatement() {
        if (this.stList != null && this.stList.size() > 0) {
            for (Statement statement : this.stList) {
                if (!(statement instanceof OscarStatement)) continue;
                ((OscarStatement)statement).initParams();
            }
        }
    }

    public List<String> initRacInfo() {
        ArrayList<String> arrayList = new ArrayList<String>();
        BaseResultSet baseResultSet = null;
        StringBuilder stringBuilder = new StringBuilder("session: " + this.sessionID + ", " + OscarJdbc2RacConnection.class + ", initRacInfo(), ");
        try {
            baseResultSet = this.execSQL("select * from info_schem.v_sys_rac_node_info where dead='f' and JOINED = 't'");
            while (baseResultSet.next()) {
                String string = baseResultSet.getString("ADDRESS");
                long l2 = baseResultSet.getLong("PORT");
                string = string + ":" + l2;
                arrayList.add(string);
                stringBuilder.append(string).append(",");
            }
        }
        catch (SQLException sQLException) {
            stringBuilder.append(" error: ").append(sQLException.getMessage());
        }
        finally {
            try {
                if (baseResultSet != null) {
                    baseResultSet.close();
                }
            }
            catch (SQLException sQLException) {
                stringBuilder.append(" error: ").append(sQLException.getMessage());
            }
        }
        if (this.logFlag) {
            Driver.writeLog(stringBuilder.toString());
        }
        return arrayList;
    }
}

