/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.fastpath.Fastpath;
import com.oscar.fastpath.FastpathArg;
import com.oscar.util.Hex;
import com.oscar.util.OSQLException;
import com.oscar.util.StreamHandle;
import com.oscar.util.ZipCompressUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public abstract class OscarLob {
    protected boolean logFlag = Driver.getLogLevel() >= 2;
    protected static final long COMPARE_BLOCK_SIZE = 64000L;
    protected static final int DEFAULT_BUFFER_SIZE = 633600;
    protected static final int WRITE = 131072;
    protected static final int READ = 262144;
    protected static final int READWRITE = 393216;
    public static final int MODE_READONLY = 1;
    public static final int MODE_READWRITE = 0;
    public static final int DURATION_CALL = 1;
    public static final int DURATION_SESSION = 0;
    protected Fastpath fastpath;
    protected byte[] locator = new byte[0];
    protected String locatorStr = "";
    protected boolean tempLob = false;
    protected boolean tableIdLob = false;
    protected BaseConnection connection;
    protected boolean emptyLob = false;
    public static final int BLOB_TYPE = 1;
    public static final int CLOB_TYPE = 2;
    public static final int BFILE_TYPE = 3;
    private boolean free = false;
    protected long lobLength = -1L;
    private int chunkSize = -1;
    private int type;
    protected byte[] datas;
    private long nextFetchPos = -1L;

    protected OscarLob() {
        this.emptyLob = true;
    }

    public OscarLob(BaseConnection baseConnection, String string, int n2) throws SQLException {
        this(baseConnection);
        try {
            if (baseConnection.getProtocolVersion().getProtocolType() < 4) {
                this.setLocatorStr(string);
                return;
            }
            this.analyzeLocator(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (n2 == 1) {
                if (string.startsWith("0x")) {
                    string = string.substring(2);
                }
                this.datas = Hex.parserStringToByte(string);
            } else {
                this.datas = this.connection.getEncoding().encode(string);
            }
            this.lobLength = this.datas.length;
        }
    }

    private OscarLob(BaseConnection baseConnection) throws SQLException {
        this.connection = baseConnection;
        this.fastpath = this.connection.getFastpathAPI();
    }

    public OscarLob(BaseConnection object, boolean bl, int n2) throws SQLException {
        this((BaseConnection)object);
        FastpathArg[] fastpathArgArray = null;
        switch (object.getVersion().getMainVersion()) {
            case 1: 
            case 2: 
            case 3: {
                fastpathArgArray = new FastpathArg[]{};
                break;
            }
            case 4: {
                FastpathArg[] fastpathArgArray2 = new FastpathArg[2];
                fastpathArgArray = fastpathArgArray2;
                fastpathArgArray2[0] = new FastpathArg(bl ? 1 : 0);
                fastpathArgArray[1] = new FastpathArg(n2);
            }
        }
        if (fastpathArgArray != null) {
            object = this.fastpath.getData(this.getType(), "CREATETEMP", fastpathArgArray);
            this.setLocator((byte[])object);
        }
        this.tempLob = true;
    }

    protected OscarLob(BaseConnection object, long l2, int n2) throws SQLException {
        this((BaseConnection)object);
        FastpathArg[] fastpathArgArray = null;
        switch (object.getVersion().getMainVersion()) {
            case 1: {
                this.tempLob = true;
                fastpathArgArray = new FastpathArg[]{};
                break;
            }
            case 2: 
            case 3: {
                if (object.getVersion().isHaveEmptyXlobWithOid()) {
                    FastpathArg[] fastpathArgArray2 = new FastpathArg[1];
                    fastpathArgArray = fastpathArgArray2;
                    fastpathArgArray2[0] = new FastpathArg((int)l2);
                    break;
                }
                this.tempLob = true;
                fastpathArgArray = new FastpathArg[]{};
                this.tempLob = true;
                break;
            }
            case 4: {
                FastpathArg[] fastpathArgArray3 = new FastpathArg[2];
                fastpathArgArray = fastpathArgArray3;
                fastpathArgArray3[0] = new FastpathArg((int)l2);
                fastpathArgArray[1] = new FastpathArg(n2);
            }
        }
        if (fastpathArgArray != null) {
            object = this.fastpath.getData(this.getType(), "CREATE_WITH_TABLE_OID", fastpathArgArray);
            this.setLocator((byte[])object);
        }
        this.tableIdLob = true;
    }

    public InputStream getBinaryStream(long l2) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog("connid" + this.connection.getSessionID() + ", " + OscarLob.class + " getBinaryStream(long pos), pos:" + l2);
        }
        if (this.datas != null) {
            if (this.nextFetchPos > 0L || this.nextFetchPos == 0L && this.lobLength > 0L) {
                if (l2 > this.nextFetchPos) {
                    return new LobInputStream(this, l2);
                }
                OscarLob oscarLob = this;
                return new LobInputStream(oscarLob, oscarLob.nextFetchPos + 1L, this.datas, (int)l2 - 1);
            }
            return new ByteArrayInputStream(this.datas, (int)l2 - 1, this.datas.length);
        }
        return new LobInputStream(this, l2);
    }

    public InputStream getBinaryStream(long l2, long l3) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog("connid" + this.connection.getSessionID() + ", " + OscarLob.class + " getBinaryStream(long pos, long length), pos:" + l2 + ",length:" + l3);
        }
        if (this.datas != null) {
            return new ByteArrayInputStream(this.datas, (int)l2 - 1, (int)l3);
        }
        return new LobInputStream(this, l2, l3);
    }

    public OutputStream setBinaryStream(long l2) throws SQLException {
        this.checkFree();
        this.checkEmptyLob();
        if (l2 <= 0L) {
            throw new IllegalArgumentException("wrong parameter");
        }
        return new LobOutputStream(l2);
    }

    public OutputStream setBinaryStream(long l2, int n2) throws SQLException {
        this.checkEmptyLob();
        if (l2 <= 0L) {
            throw new IllegalArgumentException("wrong parameter");
        }
        return new LobOutputStream(l2, n2);
    }

    public byte[] getBytes(long l2, int n2) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog("connid" + this.connection.getSessionID() + ", " + OscarLob.class + " getBytes(long pos, int length) ,pos:" + l2 + "length:" + n2);
        }
        this.checkFree();
        if (l2 <= 0L || n2 < 0) {
            throw new IllegalArgumentException("wrong parameter");
        }
        Object object = this.getBinaryStream(l2);
        try {
            object = StreamHandle.read((InputStream)object, n2, this.getBufferSize());
        }
        catch (IOException iOException) {
            throw new OSQLException("OSCAR-00510", "88888", 510, iOException);
        }
        return object;
    }

    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        int n4;
        this.checkFree();
        if (l2 <= 0L) {
            throw new IllegalArgumentException("wrong parameter");
        }
        try {
            OutputStream outputStream = this.setBinaryStream(l2);
            n4 = StreamHandle.write(outputStream, byArray, n2, n3, this.getBufferSize());
            this.lobLength = -1L;
            this.datas = null;
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new OSQLException("OSCAR-00508", "88888", 508, iOException);
        }
        return n4;
    }

    public abstract long write(long var1, InputStream var3, long var4) throws SQLException;

    public long length() throws SQLException {
        this.checkFree();
        if (this.lobLength < 0L) {
            if (this.isEmptyLob()) {
                this.lobLength = 0L;
            } else {
                long l2 = 0L;
                FastpathArg[] fastpathArgArray = new FastpathArg[1];
                FastpathArg[] fastpathArgArray2 = fastpathArgArray;
                fastpathArgArray[0] = new FastpathArg(this.locator);
                switch (this.connection.getVersion().getMainVersion()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        l2 = this.fastpath.getInteger(this.getType(), "GETPRECISELENGTH", fastpathArgArray2);
                        break;
                    }
                    case 4: {
                        l2 = this.fastpath.getLong(this.getType(), "GETPRECISELENGTH", fastpathArgArray2);
                    }
                }
                this.lobLength = l2;
            }
        }
        return this.lobLength;
    }

    public synchronized void freeTemporary() throws SQLException {
        this.checkEmptyLob();
        if (this.isTempLob()) {
            FastpathArg[] fastpathArgArray = new FastpathArg[1];
            Object[] objectArray = fastpathArgArray;
            fastpathArgArray[0] = new FastpathArg(this.locator);
            switch (this.connection.getVersion().getMainVersion()) {
                case 2: 
                case 3: {
                    this.fastpath.getInteger(this.getType(), "FREETEMP", (FastpathArg[])objectArray);
                    return;
                }
                case 4: {
                    objectArray = this.fastpath.getData(this.getType(), "FREETEMP", (FastpathArg[])objectArray);
                    this.setLocator((byte[])objectArray);
                }
            }
        }
    }

    public synchronized void freePersist() throws SQLException {
        this.checkEmptyLob();
        FastpathArg[] fastpathArgArray = new FastpathArg[1];
        Object[] objectArray = fastpathArgArray;
        fastpathArgArray[0] = new FastpathArg(this.locator);
        switch (this.connection.getVersion().getMainVersion()) {
            case 4: {
                objectArray = this.fastpath.getData(this.getType(), "FREE_WITH_TABLE_OID", (FastpathArg[])objectArray);
                this.setLocator((byte[])objectArray);
            }
        }
    }

    public byte[] getLocator() {
        return this.locator;
    }

    public String getLocatorStr() {
        return this.locatorStr;
    }

    public boolean isEmptyLob() {
        return this.emptyLob;
    }

    public boolean isTempLob() {
        return this.tempLob;
    }

    public void checkEmptyLob() throws OSQLException {
        if (this.isEmptyLob()) {
            throw new OSQLException("OSCAR-00506", "88888", 506);
        }
    }

    public boolean isTableIdLob() {
        return this.tableIdLob;
    }

    public void setLocator(byte[] byArray) throws OSQLException {
        switch (this.connection.getVersion().getMainVersion()) {
            case 1: 
            case 2: 
            case 3: {
                long l2 = 0L;
                for (int i2 = 0; i2 < byArray.length - 4; ++i2) {
                    l2 = (l2 << 8) + (long)(byArray[i2] & 0xFF);
                }
                this.locatorStr = "" + l2 + (char)byArray[byArray.length - 4];
                break;
            }
            case 4: {
                this.locatorStr = Hex.hexPrintToString(byArray);
                break;
            }
            default: {
                throw new OSQLException("OSCAR-00504", "88888", 504);
            }
        }
        this.locator = byArray;
    }

    public void setLocatorStr(String string) throws OSQLException {
        switch (this.connection.getVersion().getMainVersion()) {
            case 1: 
            case 2: 
            case 3: {
                int n2;
                byte[] byArray;
                try {
                    byArray = string.getBytes("US-ASCII");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new OSQLException("OSCAR-00504", "88888", 504, unsupportedEncodingException);
                }
                long l2 = 0L;
                for (int i2 = 0; i2 < byArray.length - 4; ++i2) {
                    if (byArray[i2] == 32) continue;
                    l2 = l2 * 10L + (long)(byArray[i2] - 48);
                }
                switch (byArray.length) {
                    case 20: {
                        this.locator = new byte[8];
                        break;
                    }
                    case 30: {
                        this.locator = new byte[12];
                        break;
                    }
                    default: {
                        throw new OSQLException("OSCAR-00504", "88888", 504);
                    }
                }
                long l3 = l2;
                for (n2 = this.locator.length - 5; n2 >= 0; --n2) {
                    this.locator[n2] = (byte)(l3 & 0xFFL);
                    l3 >>= 8;
                }
                for (n2 = 0; n2 < 4; ++n2) {
                    this.locator[this.locator.length - 4 + n2] = byArray[byArray.length - 4 + n2];
                }
                string = string.trim();
                break;
            }
            case 4: {
                this.locator = Hex.parserStringToByte(string);
                break;
            }
            default: {
                throw new OSQLException("OSCAR-00504", "88888", 504);
            }
        }
        this.locatorStr = string;
    }

    public void open(int n2) throws SQLException {
        this.checkEmptyLob();
        FastpathArg[] fastpathArgArray = new FastpathArg[2];
        FastpathArg[] fastpathArgArray2 = fastpathArgArray;
        fastpathArgArray[0] = new FastpathArg(this.locator);
        switch (this.connection.getVersion().getMainVersion()) {
            case 1: 
            case 2: 
            case 3: {
                throw new OSQLException("OSCAR-00509", "88888", 509);
            }
            case 4: {
                fastpathArgArray2[1] = new FastpathArg(n2);
            }
        }
        byte[] byArray = this.fastpath.getData(this.getType(), "OPEN", fastpathArgArray2);
        this.setLocator(byArray);
    }

    public boolean isOpen() throws SQLException {
        this.checkEmptyLob();
        FastpathArg[] fastpathArgArray = new FastpathArg[1];
        FastpathArg[] fastpathArgArray2 = fastpathArgArray;
        fastpathArgArray[0] = new FastpathArg(this.locator);
        switch (this.connection.getVersion().getMainVersion()) {
            case 1: 
            case 2: 
            case 3: {
                throw new OSQLException("OSCAR-00509", "88888", 509);
            }
        }
        int n2 = this.fastpath.getInteger(this.getType(), "ISOPEN", fastpathArgArray2);
        return n2 != 0;
    }

    public void close() throws SQLException {
        this.checkEmptyLob();
        FastpathArg[] fastpathArgArray = new FastpathArg[1];
        Object[] objectArray = fastpathArgArray;
        fastpathArgArray[0] = new FastpathArg(this.locator);
        switch (this.connection.getVersion().getMainVersion()) {
            case 1: 
            case 2: 
            case 3: {
                throw new OSQLException("OSCAR-00509", "88888", 509);
            }
        }
        objectArray = this.fastpath.getData(this.getType(), "CLOSE", (FastpathArg[])objectArray);
        this.setLocator((byte[])objectArray);
    }

    public void trim(long l2) throws SQLException {
        this.checkEmptyLob();
        if (l2 < 0L) {
            throw new IllegalArgumentException("parameter less than 0");
        }
        long l3 = this.length();
        if (l3 <= l2) {
            return;
        }
        switch (this.connection.getVersion().getMainVersion()) {
            case 1: 
            case 2: 
            case 3: {
                FastpathArg[] fastpathArgArray = new FastpathArg[3];
                FastpathArg[] fastpathArgArray2 = fastpathArgArray;
                fastpathArgArray[0] = new FastpathArg(this.locator);
                fastpathArgArray2[1] = new FastpathArg((int)(l3 - l2));
                fastpathArgArray2[2] = new FastpathArg((int)l2);
                this.fastpath.getInteger(this.getType(), "ERASE", fastpathArgArray2);
                return;
            }
            case 4: {
                FastpathArg[] fastpathArgArray = new FastpathArg[2];
                FastpathArg[] fastpathArgArray3 = fastpathArgArray;
                fastpathArgArray[0] = new FastpathArg(this.locator);
                fastpathArgArray3[1] = new FastpathArg(l2);
                this.fastpath.getInteger(this.getType(), "TRIM", fastpathArgArray3);
            }
        }
    }

    public void truncate(long l2) throws SQLException {
        this.checkFree();
        this.trim(l2);
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof OscarLob) || ((OscarLob)object).getType() != this.getType()) {
            bl = false;
        } else {
            try {
                object = (OscarLob)object;
                bl = !this.isEmptyLob() ? (((OscarLob)object).getLocatorStr().equalsIgnoreCase(this.getLocatorStr()) ? true : (this.length() != ((OscarLob)object).length() ? false : this.positionInternal((OscarLob)object, 1L) == 1L)) : ((OscarLob)object).isEmptyLob();
            }
            catch (SQLException sQLException) {
                bl = false;
            }
        }
        return bl;
    }

    public abstract int getType();

    public int getBufferSize() throws SQLException {
        int n2;
        if (this.getType() == 3) {
            n2 = 633600;
        } else {
            if (this.chunkSize < 0) {
                this.chunkSize = this.getChunkSize();
            }
            n2 = this.chunkSize;
        }
        return n2;
    }

    public int getChunkSize() throws SQLException {
        int n2 = 0;
        switch (this.connection.getVersion().getMainVersion()) {
            case 1: 
            case 2: 
            case 3: {
                n2 = 633600;
                break;
            }
            case 4: {
                FastpathArg[] fastpathArgArray = new FastpathArg[1];
                FastpathArg[] fastpathArgArray2 = fastpathArgArray;
                fastpathArgArray[0] = new FastpathArg(this.getLocator());
                n2 = this.fastpath.getInteger(this.getType(), "GET_CHUNKSIZE", fastpathArgArray2);
            }
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long positionInternal(byte[] byArray, long l2) throws SQLException {
        this.checkFree();
        long l3 = -1L;
        if (byArray == null) throw new OSQLException("OSCAR-00502", "88888", 502);
        if (byArray.length == 0) throw new OSQLException("OSCAR-00502", "88888", 502);
        if (l2 <= 0L) {
            throw new OSQLException("OSCAR-00502", "88888", 502);
        }
        if (this.isEmptyLob()) {
            return -1L;
        }
        long l4 = this.length();
        if (l4 < l2 + (long)byArray.length - 1L) {
            return -1L;
        }
        FastpathArg[] fastpathArgArray = new FastpathArg[4];
        FastpathArg[] fastpathArgArray2 = fastpathArgArray;
        fastpathArgArray[0] = new FastpathArg(this.locator);
        fastpathArgArray2[1] = new FastpathArg(byArray);
        switch (this.connection.getVersion().getMainVersion()) {
            case 1: 
            case 2: 
            case 3: {
                fastpathArgArray2[2] = new FastpathArg((int)(l2 - 1L));
                fastpathArgArray2[3] = new FastpathArg(1);
                l3 = this.fastpath.getInteger(this.getType(), "INSTR", fastpathArgArray2);
                if (l3 == 0L) {
                    return -1L;
                }
                long l5 = l3 + l2 - 1L;
                return l5;
            }
            case 4: {
                fastpathArgArray2[2] = new FastpathArg(l2);
                fastpathArgArray2[3] = new FastpathArg(1L);
                l3 = this.fastpath.getLong(this.getType(), "INSTR", fastpathArgArray2);
                if (l3 == 0L) {
                    return -1L;
                }
                long l6 = l3;
                return l6;
            }
        }
        return l3;
    }

    protected long positionInternal(OscarLob oscarLob, long l2) throws SQLException {
        this.checkFree();
        if (oscarLob == null || l2 <= 0L) {
            return -1L;
        }
        long l3 = this.length();
        long l4 = oscarLob.length();
        if (l3 == 0L || l4 > l3 - l2 + 1L) {
            return -1L;
        }
        if (l3 <= 64000L) {
            byte[] byArray = oscarLob.getBytes(1L, (int)l3);
            return this.positionInternal(byArray, l2);
        }
        long l5 = l2;
        boolean bl = false;
        long l6 = -1L;
        while (!bl) {
            if (l3 < l4 + l5 - 1L) {
                return -1L;
            }
            int n2 = (int)Math.min(64000L, l3 - 1L);
            byte[] byArray = oscarLob.getBytes(1L, n2);
            long l7 = this.positionInternal(byArray, l5);
            if (l7 == -1L) {
                return -1L;
            }
            l6 = l7;
            n2 = 1 + byArray.length;
            l5 = l7 + (long)byArray.length;
            boolean bl2 = true;
            while (bl2) {
                if (l4 - (long)n2 <= 0L) {
                    return l6;
                }
                int n3 = (int)Math.min(64000L, l4 - (long)n2);
                byte[] byArray2 = oscarLob.getBytes(n2, n3);
                long l8 = this.positionInternal(byArray2, l5);
                if (l8 == l5) {
                    l5 += (long)n3;
                    if ((long)(n2 += n3) != l4) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l8 == -1L) {
                    return -1L;
                }
                l5 = l8 - (long)n2;
                bl2 = false;
            }
        }
        return l6;
    }

    protected int setDataInternal(long l2, byte[] byArray, int n2) throws SQLException {
        this.checkEmptyLob();
        FastpathArg[] fastpathArgArray = new FastpathArg[4];
        FastpathArg[] fastpathArgArray2 = fastpathArgArray;
        fastpathArgArray[0] = new FastpathArg(this.locator);
        fastpathArgArray2[1] = new FastpathArg(n2);
        switch (this.connection.getVersion().getMainVersion()) {
            case 1: 
            case 2: 
            case 3: {
                fastpathArgArray2[2] = new FastpathArg((int)(l2 - 1L));
                break;
            }
            case 4: {
                fastpathArgArray2[2] = new FastpathArg(l2);
            }
        }
        if (this.connection.isCompressTransfer() && this.getType() == 1) {
            byte[] byArray2 = ZipCompressUtil.compress(byArray, n2);
            fastpathArgArray2[3] = new FastpathArg(byArray2);
            return this.fastpath.getInteger(1, "WRITECOMPRESS", fastpathArgArray2);
        }
        fastpathArgArray2[3] = new FastpathArg(byArray);
        return this.fastpath.getInteger(this.getType(), "WRITE", fastpathArgArray2);
    }

    protected byte[] getDataInternal(long l2, int n2) throws SQLException {
        this.checkEmptyLob();
        FastpathArg[] fastpathArgArray = new FastpathArg[3];
        FastpathArg[] fastpathArgArray2 = fastpathArgArray;
        fastpathArgArray[0] = new FastpathArg(this.locator);
        fastpathArgArray2[1] = new FastpathArg(n2);
        switch (this.connection.getVersion().getMainVersion()) {
            case 1: 
            case 2: 
            case 3: {
                fastpathArgArray2[2] = new FastpathArg((int)(l2 - 1L));
                break;
            }
            case 4: {
                fastpathArgArray2[2] = new FastpathArg(l2);
            }
        }
        if (this.connection.isCompressTransfer() && this.getType() == 1) {
            byte[] byArray = this.fastpath.getData(1, "READCOMPRESS", fastpathArgArray2);
            return ZipCompressUtil.decompress(byArray);
        }
        return this.fastpath.getData(this.getType(), "READ", fastpathArgArray2);
    }

    public void free() throws SQLException {
        this.locator = null;
        this.locatorStr = null;
        this.free = true;
    }

    public void checkFree() throws OSQLException {
        if (this.free) {
            throw new OSQLException("OSCAR-00512", "88888", 512);
        }
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.setBinaryStream(1L);
    }

    public void setTempLob(boolean bl) {
        this.tempLob = bl;
    }

    private void analyzeLocator(String string) throws SQLException {
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(",");
        if (stringArray.length > 1) {
            this.setLocatorStr(stringArray[0]);
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                String string3 = string2.substring(2);
                if (string2.startsWith("S=")) {
                    this.lobLength = Long.parseLong(string3, 10);
                    continue;
                }
                if (string2.startsWith("C=")) {
                    this.chunkSize = Integer.parseInt(string3, 10);
                    continue;
                }
                if (string2.startsWith("t=")) {
                    this.tempLob = !string3.equals("0");
                    continue;
                }
                if (string2.startsWith("D=") || string2.startsWith("d=")) {
                    this.datas = Hex.parserStringToByte(string3);
                    if (!string2.startsWith("d=")) continue;
                    this.nextFetchPos = this.datas.length;
                    continue;
                }
                if (!string2.startsWith("T=")) continue;
                if ("0".equals(string3)) {
                    this.type = 1;
                    continue;
                }
                if ("1".equals(string3)) {
                    this.type = 2;
                    continue;
                }
                if (!"2".equals(string3)) continue;
                this.type = 3;
            }
            return;
        }
        this.setLocatorStr(string);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected class LobInputStream
    extends InputStream {
        private byte[] buffer;
        private int bufferPos;
        private int bufferSize;
        private long markPos;
        private long nextReadPos;
        private boolean closed;
        private long length;
        final /* synthetic */ OscarLob this$0;

        public LobInputStream(OscarLob oscarLob) throws SQLException {
            OscarLob oscarLob2 = oscarLob;
            this(oscarLob2, oscarLob2.getBufferSize(), 1L);
        }

        public LobInputStream(OscarLob oscarLob, long l2) throws SQLException {
            OscarLob oscarLob2 = oscarLob;
            this(oscarLob2, oscarLob2.getBufferSize(), l2);
        }

        public LobInputStream(OscarLob oscarLob, int n2, long l2) throws SQLException {
            this.this$0 = oscarLob;
            this.markPos = 0L;
            this.nextReadPos = 1L;
            this.closed = false;
            this.length = -1L;
            this.buffer = new byte[0];
            this.bufferPos = 0;
            this.bufferSize = n2;
            this.nextReadPos = l2;
        }

        public LobInputStream(OscarLob oscarLob, long l2, long l3) throws SQLException {
            this.this$0 = oscarLob;
            this.markPos = 0L;
            this.nextReadPos = 1L;
            this.closed = false;
            this.length = -1L;
            this.buffer = null;
            this.bufferPos = 0;
            this.bufferSize = oscarLob.getBufferSize();
            this.nextReadPos = l2;
            this.length = l3;
        }

        public LobInputStream(OscarLob oscarLob, long l2, byte[] byArray, int n2) throws SQLException {
            this.this$0 = oscarLob;
            this.markPos = 0L;
            this.nextReadPos = 1L;
            this.closed = false;
            this.length = -1L;
            this.buffer = byArray;
            this.bufferPos = n2;
            this.bufferSize = oscarLob.getBufferSize();
            this.nextReadPos = l2;
        }

        @Override
        public int read() throws IOException {
            if (this.closed) {
                throw new IOException("oscar.lobstream.closed");
            }
            try {
                int n2;
                if (this.checkBuffer()) {
                    n2 = -1;
                } else {
                    n2 = this.buffer[this.bufferPos] & 0xFF;
                    ++this.bufferPos;
                }
                return n2;
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.toString());
            }
        }

        private boolean checkBuffer() throws SQLException {
            boolean bl = false;
            long l2 = this.this$0.length();
            if ((this.buffer == null || this.buffer.length == 0 || this.bufferPos >= this.buffer.length) && this.nextReadPos <= l2) {
                this.buffer = this.length > 0L ? this.this$0.getDataInternal(this.nextReadPos, (int)Math.min((long)this.bufferSize, this.length)) : this.this$0.getDataInternal(this.nextReadPos, (int)Math.min((long)this.bufferSize, l2 + 1L - this.nextReadPos));
                if (this.buffer != null) {
                    this.nextReadPos += (long)this.buffer.length;
                }
                this.bufferPos = 0;
            }
            if (this.buffer == null || this.bufferPos >= this.buffer.length) {
                bl = true;
            }
            return bl;
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            boolean bl = false;
            int n4 = 0;
            if (this.closed) {
                throw new IOException("oscar.lobstream.closed");
            }
            try {
                if (this.length > 1L && (long)n3 > this.length) {
                    n3 = (int)this.length;
                }
                while (n4 < n3 && !bl) {
                    if (this.checkBuffer()) {
                        bl = true;
                        continue;
                    }
                    int n5 = Math.min(n3 - n4, this.buffer.length - this.bufferPos);
                    System.arraycopy(this.buffer, this.bufferPos, byArray, n2 + n4, n5);
                    this.bufferPos += n5;
                    n4 += n5;
                }
                if (n4 == 0) {
                    n4 = -1;
                }
                return n4;
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.toString());
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.buffer = null;
        }

        @Override
        public synchronized void mark(int n2) {
            this.markPos = this.nextReadPos - (long)this.buffer.length + (long)this.bufferPos;
        }

        @Override
        public synchronized void reset() throws IOException {
            if (this.closed) {
                throw new IOException("oscar.blobstream.closed");
            }
            if (this.markPos == 0L) {
                throw new IOException("oscar.blobstream.notmarked");
            }
            this.nextReadPos = this.markPos;
            this.buffer = new byte[0];
            this.bufferPos = 0;
        }

        @Override
        public boolean markSupported() {
            return true;
        }
    }

    protected class LobOutputStream
    extends OutputStream {
        private byte[] buffer;
        private int bufferSize;
        private int bufferPos;
        private long nextWritePos;
        private boolean closed = false;

        public LobOutputStream(long l2) throws SQLException {
            this(l2, oscarLob.getBufferSize());
        }

        public LobOutputStream(long l2, int n2) throws SQLException {
            this.nextWritePos = l2;
            this.bufferSize = Math.min(n2, OscarLob.this.getBufferSize());
            this.buffer = new byte[this.bufferSize];
            this.bufferPos = 0;
        }

        @Override
        public void write(int n2) throws IOException {
            if (this.closed) {
                throw new IOException("com.blobstream.closed");
            }
            try {
                this.checkBuffer();
                this.buffer[this.bufferPos++] = (byte)n2;
                return;
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.toString());
            }
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            try {
                int n4 = n2;
                n2 += n3;
                while (n4 < n2) {
                    this.checkBuffer();
                    n3 = Math.min(n2 - n4, this.bufferSize - this.bufferPos);
                    System.arraycopy(byArray, n4, this.buffer, this.bufferPos, n3);
                    this.bufferPos += n3;
                    n4 += n3;
                }
                return;
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.toString());
            }
        }

        private void checkBuffer() throws SQLException {
            if (this.bufferPos >= this.bufferSize) {
                int n2 = OscarLob.this.setDataInternal(this.nextWritePos, this.buffer, this.bufferSize);
                if (this.bufferSize > n2) {
                    if (n2 == 0) {
                        throw new SQLException("OSCAR-00511", "88888", 511);
                    }
                    byte[] byArray = new byte[this.bufferSize - n2];
                    System.arraycopy(this.buffer, n2, byArray, 0, this.bufferSize - n2);
                    System.arraycopy(byArray, 0, this.buffer, 0, byArray.length);
                    this.bufferPos = byArray.length;
                } else {
                    this.bufferPos = 0;
                }
                this.nextWritePos += (long)n2;
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("com.blobstream.closed");
            }
            try {
                if (this.bufferPos > 0) {
                    byte[] byArray;
                    if (this.bufferPos < this.buffer.length) {
                        byArray = new byte[this.bufferPos];
                        System.arraycopy(this.buffer, 0, byArray, 0, this.bufferPos);
                    } else {
                        byArray = this.buffer;
                    }
                    int n2 = OscarLob.this.setDataInternal(this.nextWritePos, byArray, this.bufferPos);
                    if (n2 < this.bufferPos) {
                        throw new IOException("\u7f13\u51b2\u533a\u4e2d\u7684\u6570\u636e\u53d1\u751f\u4e22\u5931");
                    }
                    this.nextWritePos += (long)this.bufferPos;
                }
                this.bufferPos = 0;
                return;
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.toString());
            }
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.closed = true;
            this.buffer = null;
        }
    }
}

