/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.Field;
import com.oscar.jdbc.OscarParaMetaData;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.jdbc.OscarResultSetMetaData;
import com.oscar.jdbc.OscarStatement;
import com.oscar.util.OSQLException;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class OscarPreparedStatement
extends OscarStatement
implements PreparedStatement {
    public OscarPreparedStatement(BaseConnection baseConnection, String string) throws SQLException {
        super(baseConnection, string);
        this.setStatementType(1);
    }

    @Override
    public BaseResultSet createResultSet(Field[] fieldArray, List<byte[][]> list, String string, long l2, long l3) throws SQLException {
        return OscarResultSet.getInstance(this, fieldArray, list, string, l2, l3, this.fetchSize, this.maxrows);
    }

    public void exitImplicitCacheToClose() throws SQLException {
        this.cacheState = (short)3;
        this.hardClose();
    }

    public void exitImplicitCacheToActive() throws SQLException {
        this.cacheState = 1;
        this.isClosed = false;
    }

    public void prepare() throws SQLException {
        Object[] objectArray;
        Object object;
        if (this.ddlSql) {
            object = this.m_sqlFragments[0];
            this.m_executeSqlFragments = new String[this.fragmentsCount];
            this.m_executeSqlFragments[0] = this.m_sqlFragments[0];
        } else {
            this.m_statementName = "J" + this.getNextPreparedCount();
            this.m_origSqlFragments = new String[this.m_sqlFragments.length];
            System.arraycopy(this.m_sqlFragments, 0, this.m_origSqlFragments, 0, this.m_sqlFragments.length);
            this.setSqlFragments();
            objectArray = this.sbuf;
            synchronized (objectArray) {
                this.sbuf.setLength(0);
                this.sbuf.append("PREPARE ");
                this.sbuf.append(this.m_statementName);
                this.sbuf.append(" AS ");
                this.sbuf.append(this.m_origSqlFragments[0]);
                object = this.sbuf.toString();
            }
        }
        if (this.connection.getVersion().isSendQueryNumForNotRealPrepare() && this.isNotRealPrepare() && !this.ddlSql) {
            this.setPrepareAndNotRealPrepare(true);
        }
        try {
            this.connection.execSQL((String)object, this);
        }
        catch (SQLException sQLException) {
            this.m_statementName = null;
            throw sQLException;
        }
        this.setPrepareAndNotRealPrepare(false);
        if (this.fragmentsCount > 1) {
            objectArray = "GET PARAMINFO FOR " + this.m_statementName;
            this.connection.execSQL((String)objectArray);
            object = (OscarParaMetaData)this.connection.getDefaultStatement().getParamInfo();
            this.pMetaData = new OscarParaMetaData(((OscarParaMetaData)object).getParamInfor(), this);
            if (this instanceof CallableStatement && this.isResultNeeded) {
                object = (OscarResultSetMetaData)this.getMetaData();
                if (object == null || ((OscarResultSetMetaData)object).getColumnCount() == 0) {
                    throw new OSQLException("OSCAR-00401", "88888", 401);
                }
                object = ((OscarResultSetMetaData)object).getField(1);
                objectArray = this.connection.getVersion().isNewParamInfoPacket() ? new Object[6] : new Object[8];
                objectArray[0] = this.encoding.encode(((Field)object).getAliasName());
                objectArray[1] = ((Field)object).getOID();
                objectArray[2] = (short)((Field)object).getLength();
                objectArray[3] = ((Field)object).getMod();
                objectArray[4] = (byte)((Field)object).isNullable();
                objectArray[5] = (byte)2;
                this.pMetaData.addReturnParam(objectArray);
            }
        } else {
            this.pMetaData = new OscarParaMetaData(new Object[0][0], this);
        }
        this.m_sqlFragments = this.m_executeSqlFragments;
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null) {
            StatementEventListener[] statementEventListenerArray = this.connection.getStatementListeners();
            StatementEvent statementEvent = null;
            statementEventListenerArray = statementEventListenerArray.toArray(new StatementEventListener[statementEventListenerArray.size()]);
            for (int i2 = 0; i2 < statementEventListenerArray.length; ++i2) {
                StatementEventListener statementEventListener = statementEventListenerArray[i2];
                if (statementEvent == null) {
                    statementEvent = new StatementEvent(this.connection.getPc(), this);
                }
                statementEventListener.statementClosed(statementEvent);
            }
        }
        super.close();
    }

    @Override
    public void setNString(int n2, String string) throws SQLException {
        this.setString(n2, string);
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.setCharacterStream(n2, reader, l2);
    }

    @Override
    public void setNClob(int n2, NClob nClob) throws SQLException {
        this.setClob(n2, (Clob)nClob);
    }

    @Override
    public void setNClob(int n2, Reader reader, long l2) throws SQLException {
        this.setClob(n2, reader, l2);
    }

    @Override
    public void setNClob(int n2, Reader reader) throws SQLException {
        this.setCharacterStream(n2, reader);
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader) throws SQLException {
        this.setCharacterStream(n2, reader);
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.checkClosed();
        throw new OSQLException("OSCAR_00435", "88888", 435);
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.checkClosed();
        throw new OSQLException("OSCAR_00435", "88888", 435);
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.checkClosed();
        throw new OSQLException("OSCAR_00435", "88888", 435);
    }

    @Override
    public void addBatch(String string) throws SQLException {
        this.checkClosed();
        throw new OSQLException("OSCAR_00435", "88888", 435);
    }
}

