/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.BaseStatement;
import com.oscar.core.Field;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.jdbc.OscarStatement;
import com.oscar.jdbc.OscarStatementV2;
import com.oscar.jdbc.ae.ParameterEncryptionDesc;
import com.oscar.jdbc.ae.valuehandler.BoolValueHandler;
import com.oscar.jdbc.ae.valuehandler.ByteValueHandler;
import com.oscar.jdbc.ae.valuehandler.BytesValueHandler;
import com.oscar.jdbc.ae.valuehandler.DateValueHandler;
import com.oscar.jdbc.ae.valuehandler.DoubleValueHandler;
import com.oscar.jdbc.ae.valuehandler.StringValueHandler;
import com.oscar.jdbc.ae.valuehandler.TimeValueHandler;
import com.oscar.jdbc.ae.valuehandler.TimestampValueHandler;
import com.oscar.jdbc.ae.valuehandler.ValueHandler;
import com.oscar.protocol.a.m;
import com.oscar.util.BatchDataStream;
import com.oscar.util.CommonUtil;
import com.oscar.util.EscapeTools;
import com.oscar.util.OSQLException;
import com.oscar.util.OscarSqlProcessor;
import com.oscar.util.converter.BindConverter;
import java.io.Reader;
import java.sql.BatchUpdateException;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class OscarPreparedStatementV2
extends OscarStatementV2
implements PreparedStatement {
    private final int compatableDbms;
    private static volatile Map<Integer, ValueHandler<?>> TYPE_NEED_ENCRYPT_MAP = null;
    private Map<Integer, ParameterEncryptionDesc> encryptionParameterMap;

    public OscarPreparedStatementV2(BaseConnection object, String object2) throws SQLException {
        super((BaseConnection)object, (String)object2);
        this.setStatementType(1);
        this.compatableDbms = Integer.parseInt(object.getConnectionProperties().getProperty("COMPATABLE_DBMS", "0"));
        if (object.enableCe() && TYPE_NEED_ENCRYPT_MAP == null) {
            object = OscarPreparedStatementV2.class;
            synchronized (OscarPreparedStatementV2.class) {
                if (TYPE_NEED_ENCRYPT_MAP == null) {
                    object2 = new HashMap<Integer, StringValueHandler>();
                    object2.put(24, new StringValueHandler());
                    object2.put(33, new BoolValueHandler());
                    object2.put(23, new DoubleValueHandler());
                    object2.put(2003, new BytesValueHandler());
                    object2.put(35, new ByteValueHandler());
                    object2.put(25, new DateValueHandler());
                    object2.put(28, new TimestampValueHandler());
                    object2.put(26, new TimeValueHandler());
                    TYPE_NEED_ENCRYPT_MAP = object2;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    @Override
    public BaseResultSet createResultSet(Field[] fieldArray, List<byte[][]> object, String string, long l2, long l3) throws SQLException {
        OscarPreparedStatementV2 oscarPreparedStatementV2 = this;
        object = OscarResultSet.getInstanceV2(oscarPreparedStatementV2, oscarPreparedStatementV2.connection, this.netDataByStr, this.numericKeepPrecision, this.resultSetType, this.resultSetConcurrency, this.resultSetCanUpdateable, this.fetchdirection, this.encoding, this.m_cursorName, fieldArray, object, string, l2, l3, this.fetchSize, this.maxrows);
        return this.wrapUpResultSetIfCe((BaseResultSet)object, fieldArray);
    }

    public void prepare() throws SQLException {
        if (this.ddlSql) {
            this.m_prepareSqlStatement = this.m_sqlFragments[0];
            this.m_executeSqlFragments = new String[this.fragmentsCount];
            this.m_executeSqlFragments[0] = this.m_sqlFragments[0];
        } else {
            this.m_statementName = "J" + this.getNextPreparedCount();
            this.m_origSqlFragments = new String[this.m_sqlFragments.length];
            System.arraycopy(this.m_sqlFragments, 0, this.m_origSqlFragments, 0, this.m_sqlFragments.length);
            this.setSqlFragments();
            StringBuffer stringBuffer = this.sbuf;
            synchronized (stringBuffer) {
                this.sbuf.setLength(0);
                this.sbuf.append("PREPARE ");
                this.sbuf.append(this.m_statementName);
                this.sbuf.append(" AS ");
                this.sbuf.append(this.m_origSqlFragments[0]);
                this.m_prepareSqlStatement = this.sbuf.toString();
            }
        }
        if (this.connection.getVersion().isSendQueryNumForNotRealPrepare() && this.isNotRealPrepare() && !this.ddlSql) {
            this.setPrepareAndNotRealPrepare(true);
        }
        this.setPrepareAndNotRealPrepare(false);
        this.m_sqlFragments = this.m_executeSqlFragments;
    }

    public void exitImplicitCacheToClose() throws SQLException {
        this.cacheState = (short)3;
        this.hardClose();
    }

    public void exitImplicitCacheToActive() throws SQLException {
        this.cacheState = 1;
        this.isClosed = false;
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null) {
            StatementEventListener[] statementEventListenerArray = this.connection.getStatementListeners();
            StatementEvent statementEvent = null;
            statementEventListenerArray = statementEventListenerArray.toArray(new StatementEventListener[statementEventListenerArray.size()]);
            for (int i2 = 0; i2 < statementEventListenerArray.length; ++i2) {
                StatementEventListener statementEventListener = statementEventListenerArray[i2];
                if (statementEvent == null) {
                    statementEvent = new StatementEvent(this.connection.getPc(), this);
                }
                statementEventListener.statementClosed(statementEvent);
            }
        }
        super.close();
    }

    @Override
    public void setNString(int n2, String string) throws SQLException {
        ((OscarStatement)this).setString(n2, string);
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        ((OscarStatement)this).setCharacterStream(n2, reader, l2);
    }

    @Override
    public void setNClob(int n2, NClob nClob) throws SQLException {
        ((OscarStatement)this).setClob(n2, (Clob)nClob);
    }

    @Override
    public void setNClob(int n2, Reader reader, long l2) throws SQLException {
        this.setClob(n2, reader, l2);
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader) throws SQLException {
        this.setCharacterStream(n2, reader);
    }

    @Override
    public void setNClob(int n2, Reader reader) throws SQLException {
        this.setClob(n2, reader);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return CommonUtil.convertToInt(((OscarStatement)this).executeLargeBatch());
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        int n2;
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", executeBatch()");
        }
        this.checkClosed();
        this.checkConnClose();
        if (this.useAsynBatch) {
            if (this.batchDataStream != null) {
                this.batchDataStream.finshed();
            }
            this.isBegin = false;
            return null;
        }
        if (this.batch == null) {
            return new long[0];
        }
        if (this.m_bindTypes != null) {
            n2 = this.m_bindTypes.length;
            int n3 = this.connection.getProtocolVersion().getProtocolType();
            if (n2 >= 256 && n3 < 4) {
                throw new OSQLException("OSCAR-00430", "88888", 430);
            }
            if (this.m_bindTypes.length > Short.MAX_VALUE && n3 >= 4) {
                throw new OSQLException("OSCAR-00434", "88888", 430);
            }
        }
        n2 = this.batch.size();
        if (this.statementType == 2 && !this.outParameterType.isEmpty()) {
            throw new BatchUpdateException("oscar.call.outparam", "HY065", 1, new int[0]);
        }
        if (this.result != null) {
            this.result.close();
            this.result = null;
        }
        this.updateBatchCount = 0;
        long[] lArray = new long[n2];
        int n4 = 0;
        try {
            if (n2 > 0) {
                if (this.addBatchUseSql) {
                    String[] stringArray = this.m_sqlFragments;
                    Object[] objectArray = this.m_binds;
                    for (Object object : this.batch) {
                        this.m_sqlFragments = (String[])object[0];
                        this.m_binds = (Object[])object[1];
                        if (this.m_sqlFragments != null && this.m_sqlFragments.length == 1) {
                            object = OscarSqlProcessor.parsingWithCheck(this.m_sqlFragments[0]);
                            this.selectSql = ((OscarSqlProcessor.ParseResult)object).isSelectSql();
                            this.insertSql = ((OscarSqlProcessor.ParseResult)object).isInsertSql();
                        }
                        lArray[n4] = this.executeUpdate();
                        ++n4;
                    }
                    this.m_sqlFragments = stringArray;
                    this.m_binds = objectArray;
                } else {
                    if (this.m_bindTypes.length == 0) {
                        this.execute();
                        lArray[0] = this.getUpdateCount();
                    } else {
                        n2 = 0;
                        if (this.isDDLSql()) {
                            n2 = 3;
                            this.resetDDLSql(false);
                        } else if (this.isPrepareAndNotRealPrepare()) {
                            n2 = 4;
                        } else if (this.getAutoGeneratedInfo() != -1) {
                            n2 = 2;
                            if (this.m_prepareSqlStatement != null) {
                                OscarPreparedStatementV2 oscarPreparedStatementV2 = this;
                                String string = oscarPreparedStatementV2.generatedKeySqlTransform(oscarPreparedStatementV2.m_prepareSqlStatement);
                                if (!string.equals(this.m_prepareSqlStatement)) {
                                    this.m_prepareSqlStatement = string;
                                    n2 = 0;
                                }
                            }
                        } else if (this.useTid()) {
                            n2 = 1;
                        }
                        boolean bl = this.checkBindTypes();
                        if (!this.bindTypeBackuped) {
                            if (this.m_preBindTypes.length != this.m_bindTypes.length) {
                                this.m_preBindTypes = new int[this.m_bindTypes.length];
                            }
                            System.arraycopy(this.m_bindTypes, 0, this.m_preBindTypes, 0, this.m_bindTypes.length);
                            this.bindTypeBackuped = true;
                        }
                        if (this.batchPacketV2 != null) {
                            this.batchPacketV2.a(this.batch, this.m_statementName, this.connection.getEncoding(), this.connection.getBatchBufferSize(), this.m_prepareSqlStatement, n2, bl);
                        } else {
                            this.batchPacketV2 = new m(this.batch, this.m_statementName, this.connection.getEncoding(), this.connection.getBatchBufferSize(), this.m_prepareSqlStatement, n2, bl, this.connection, this.localCalendar);
                        }
                        this.markPrepared(false);
                        this.getDBConnection().getQueryExecutor().executeBatch(this.batchPacketV2, (BaseStatement)this, lArray);
                        this.markPrepared(true);
                        if (this.m_prepareSqlStatement != null) {
                            this.m_prepareSqlStatement = null;
                        }
                        if (this.compatableDbms == 1) {
                            for (int i2 = 0; i2 < lArray.length; ++i2) {
                                lArray[i2] = -2L;
                            }
                        }
                    }
                    if (this.result != null && this.result.reallyResultSet() && !this.isCallable && this.autoGeneratedInfo == -1) {
                        throw new OSQLException("OSCAR-00403", "88888", 403);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            long[] lArray2;
            if (this.addBatchUseSql) {
                lArray2 = new long[n4];
                if (n4 > 1) {
                    System.arraycopy(lArray, 0, lArray2, 0, n4);
                }
            } else {
                lArray2 = new long[this.updateBatchCount];
                System.arraycopy(lArray, 0, lArray2, 0, this.updateBatchCount);
            }
            if (this.logFlag) {
                Driver.writeLog(this.sessionId, this.pid, sQLException.getMessage());
            }
            this.checkConnectionClosed(sQLException);
            throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), CommonUtil.convertToInt(lArray2));
        }
        catch (Exception exception) {
            if (this.logFlag) {
                Driver.writeLog(this.sessionId, this.pid, exception.getMessage());
            }
        }
        finally {
            this.handleBatch();
            this.cleanEnvTemp();
        }
        this.addBatchUseSql = false;
        this.warnings = null;
        return lArray;
    }

    public void handleBatch() {
        if (this.batch != null) {
            this.batch.clear();
        }
    }

    @Override
    public void executeBatchAsyn(List list) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", executeBatchAsyn(List asynBatch)");
        }
        this.checkClosed();
        if (list == null) {
            return;
        }
        int n2 = list.size();
        if (this.statementType == 2 && !this.outParameterType.isEmpty()) {
            throw new BatchUpdateException("oscar.call.outparam", "HY065", 1, new int[0]);
        }
        long[] lArray = new long[n2];
        try {
            if (n2 > 0) {
                int n3 = 0;
                if (this.isDDLSql()) {
                    n3 = 3;
                    this.resetDDLSql(false);
                } else if (this.isPrepareAndNotRealPrepare()) {
                    n3 = 4;
                } else if (this.getAutoGeneratedInfo() != -1) {
                    n3 = 2;
                    if (this.m_prepareSqlStatement != null) {
                        OscarPreparedStatementV2 oscarPreparedStatementV2 = this;
                        String string = oscarPreparedStatementV2.generatedKeySqlTransform(oscarPreparedStatementV2.m_prepareSqlStatement);
                        if (!string.equals(this.m_prepareSqlStatement)) {
                            this.m_prepareSqlStatement = string;
                            n3 = 0;
                        }
                    }
                } else if (this.useTid()) {
                    n3 = 1;
                }
                boolean bl = this.checkBindTypes();
                if (!this.bindTypeBackuped) {
                    if (this.m_preBindTypes.length != this.m_bindTypes.length) {
                        this.m_preBindTypes = new int[this.m_bindTypes.length];
                    }
                    System.arraycopy(this.m_bindTypes, 0, this.m_preBindTypes, 0, this.m_bindTypes.length);
                    this.bindTypeBackuped = true;
                }
                if (this.batchPacketV2 != null) {
                    this.batchPacketV2.a(list, this.m_statementName, this.connection.getEncoding(), this.connection.getBatchBufferSize(), this.m_prepareSqlStatement, n3, bl);
                } else {
                    this.batchPacketV2 = new m(list, this.m_statementName, this.connection.getEncoding(), this.connection.getBatchBufferSize(), this.m_prepareSqlStatement, n3, bl, this.connection, this.localCalendar);
                }
                this.markPrepared(false);
                this.getDBConnection().getQueryExecutor().executeBatch(this.batchPacketV2, (BaseStatement)this, lArray);
                this.markPrepared(true);
                if (this.m_prepareSqlStatement != null) {
                    this.m_prepareSqlStatement = null;
                }
                if (this.result != null && this.result.reallyResultSet() && !this.isCallable && this.autoGeneratedInfo == -1) {
                    throw new OSQLException("OSCAR-00403", "88888", 403);
                }
            }
        }
        catch (SQLException sQLException) {
            int[] nArray = new int[n2];
            if (this.logFlag) {
                Driver.writeLog(this.sessionId, this.pid, sQLException.getMessage());
            }
            this.checkConnectionClosed(sQLException);
            throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
        }
        catch (Exception exception) {
            if (this.logFlag) {
                Driver.writeLog(this.sessionId, this.pid, exception.getMessage());
            }
        }
        finally {
            list.clear();
            this.cleanEnvTemp();
        }
        this.result = null;
        this.warnings = null;
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarPreparedStatementV2.class + ", addBatch()");
        }
        this.checkClosed();
        this.updateBatchBindType();
        Object[] objectArray = new Object[this.m_binds.length];
        System.arraycopy(this.m_binds, 0, objectArray, 0, this.m_binds.length);
        Object object = new int[this.m_bindTypes.length];
        System.arraycopy(this.m_bindTypes, 0, object, 0, this.m_bindTypes.length);
        if (this.useAsynBatch) {
            this.convertBindDatas(false);
            Object[] objectArray2 = new Object[this.m_binds.length];
            System.arraycopy(this.m_binds, 0, objectArray2, 0, this.m_binds.length);
            object = new OscarStatement.BatchRowData(objectArray2, (int[])object, this.hasEscapeChar);
            this.m_binds = objectArray;
            if (!this.isBegin) {
                this.isBegin = true;
                if (this.batchDataStream == null) {
                    this.batchDataStream = new BatchDataStream(this);
                } else {
                    this.batchDataStream.reInit();
                }
            }
            this.batchDataStream.addBatchData((OscarStatement.BatchRowData)object);
            return;
        }
        OscarStatement.BatchRowData batchRowData = new OscarStatement.BatchRowData(objectArray, (int[])object, this.hasEscapeChar);
        if (this.batch == null) {
            this.batch = new LinkedList();
        }
        this.batch.add(batchRowData);
        this.hasEscapeChar = false;
        if (this.addBatchUseSql) {
            this.addBatchUseSql = false;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        Object object = this.getResultSet();
        if (object != null) {
            return object.getMetaData();
        }
        if (this.m_statementName == null || this.insertSql) {
            return null;
        }
        if (this.m_prepareSqlStatement != null && !this.isMarkPrepared()) {
            try {
                this.markPrepared(false);
                this.connection.execSQL(this.m_prepareSqlStatement, this);
                this.markPrepared(true);
            }
            catch (SQLException sQLException) {
                this.m_statementName = null;
                throw sQLException;
            }
        }
        object = "GET ROWDESCRIPTION FOR " + this.m_statementName;
        if ((object = this.connection.execSQL((String)object)) != null && object.reallyResultSet()) {
            return object.getMetaData();
        }
        return null;
    }

    private void updateBatchBindType() throws SQLException {
        if (this.batch != null && this.batch.size() > 0) {
            StringBuilder stringBuilder = null;
            OscarStatement.BatchRowData batchRowData = (OscarStatement.BatchRowData)this.batch.get(0);
            for (int i2 = 0; i2 < this.m_bindTypes.length; ++i2) {
                boolean bl;
                int n2 = this.m_bindTypes[i2];
                if (this.logFlag) {
                    stringBuilder = new StringBuilder(200);
                    stringBuilder.append(OscarStatementV2.class + ", bind(int paramIndex, Object s, int type) ,param: " + (i2 + 1) + ", type: " + n2);
                }
                int n3 = batchRowData.getTypes()[i2];
                if (this.logFlag) {
                    stringBuilder.append(", pre type: " + n3);
                }
                boolean bl2 = bl = n3 == 50 || n2 == 50 || n3 == 51 || n2 == 51;
                if (n2 != n3 && !bl) {
                    if (!(n2 != 23 && n2 != 28 || n3 != 24 && n3 != 34)) {
                        n2 = n3;
                    } else {
                        batchRowData.getTypes()[i2] = n2;
                        Object object = batchRowData.getData()[i2];
                        batchRowData.getData()[i2] = BindConverter.convertBindValueByType(object, n3, n2);
                    }
                    this.m_bindTypes[i2] = n2;
                }
                if (!this.logFlag) continue;
                if (this.m_binds[i2] == null) {
                    stringBuilder.append(",data: null");
                } else {
                    stringBuilder.append(", data: " + this.m_binds[i2].toString());
                }
                Driver.writeLog(this.sessionId, this.pid, stringBuilder.toString());
            }
        }
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.checkClosed();
        throw new OSQLException("OSCAR_00435", "88888", 435);
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.checkClosed();
        throw new OSQLException("OSCAR_00435", "88888", 435);
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.checkClosed();
        throw new OSQLException("OSCAR_00435", "88888", 435);
    }

    @Override
    public void addBatch(String string) throws SQLException {
        this.checkClosed();
        throw new OSQLException("OSCAR_00435", "88888", 435);
    }

    @Override
    protected void bind(int n2, Object object, int n3) throws SQLException {
        if (object == null) {
            super.bind(n2, null, n3);
            return;
        }
        if (this.connection.enableCe() && TYPE_NEED_ENCRYPT_MAP.get(n3) != null) {
            this.getParameterEncryptionMetadata();
            ParameterEncryptionDesc parameterEncryptionDesc = this.encryptionParameterMap.get(n2 - 1);
            if (parameterEncryptionDesc != null) {
                try {
                    object = TYPE_NEED_ENCRYPT_MAP.get(n3).encrypt(parameterEncryptionDesc, object, n3);
                }
                catch (Exception exception) {
                    if (this.logFlag) {
                        Driver.writeLog(exception);
                    }
                    throw new SQLException(exception);
                }
                n3 = 24;
            }
        }
        super.bind(n2, object, n3);
    }

    private void getParameterEncryptionMetadata() throws SQLException {
        if (this.encryptionParameterMap != null) {
            return;
        }
        OscarPreparedStatementV2 oscarPreparedStatementV2 = this;
        synchronized (oscarPreparedStatementV2) {
            Object object = EscapeTools.toSingleQuotationMarks(this.m_prepareSqlStatement);
            object = "EXEC INFO_SCHEM.PARSE_ENCRYPTED_PREPARE(" + (String)object + ")";
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = this.getConnection().createStatement();
                statement.execute((String)object);
                resultSet = statement.getResultSet();
                object = new HashMap();
                while (resultSet.next()) {
                    ParameterEncryptionDesc parameterEncryptionDesc = new ParameterEncryptionDesc();
                    parameterEncryptionDesc.setCekAlgorithm(resultSet.getString("CEKENCMOD"));
                    parameterEncryptionDesc.setCekEncryptedValue(resultSet.getBytes("CEKENCVALUE"));
                    parameterEncryptionDesc.setCekOid(resultSet.getLong("CEKOID"));
                    parameterEncryptionDesc.setCekVersion(resultSet.getInt("CEKVERSION"));
                    parameterEncryptionDesc.setCmkKeyStoreName(resultSet.getString("CMKKEYSTORENAME"));
                    parameterEncryptionDesc.setCmkPath(resultSet.getString("CMKKEYPATH"));
                    parameterEncryptionDesc.setEncryptMode(resultSet.getString("ENCMOD"));
                    parameterEncryptionDesc.setEncryptType(resultSet.getInt("ENCTYPE"));
                    parameterEncryptionDesc.setParameterIndex(resultSet.getInt("PARAMNUM"));
                    object.put(parameterEncryptionDesc.getParameterIndex(), parameterEncryptionDesc);
                }
                this.encryptionParameterMap = object;
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            return;
        }
    }
}

