/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.core.BaseConnection;
import com.oscar.core.ImportDataProvider;
import com.oscar.core.ImportHandler;
import com.oscar.core.ProviderImportHandler;
import com.oscar.util.ImportDataContainer;
import com.oscar.util.OSQLException;
import java.io.IOException;
import java.sql.SQLException;

public class OscarProviderImportHandle
implements ProviderImportHandler {
    protected BaseConnection conn;
    protected ImportHandler handler;

    public OscarProviderImportHandle(BaseConnection baseConnection, String string, String string2) throws SQLException {
        BaseConnection baseConnection2 = this.conn = baseConnection;
        synchronized (baseConnection2) {
            this.handler = string == null ? baseConnection.createImportHandler(string2) : baseConnection.createImportHandler(string, string2);
            return;
        }
    }

    public void setColumnOrder(String string) throws SQLException {
        this.handler.setColumnOrder(string);
    }

    public void setNullDataProcessMode(int n2) throws SQLException {
        this.handler.setNullDataProcessMode(n2);
    }

    public OscarProviderImportHandle(BaseConnection baseConnection, String string) throws SQLException {
        this(baseConnection, null, string);
    }

    @Override
    public long executeImport(ImportDataProvider importDataProvider) throws SQLException {
        int n2;
        int n3 = 0;
        ImportDataContainer importDataContainer = new ImportDataContainer();
        try {
            if (importDataProvider.hasHeadColumn() && importDataProvider.nextRow()) {
                StringBuffer stringBuffer = null;
                block10: do {
                    n2 = importDataProvider.setNextColumnData(importDataContainer);
                    switch (n2) {
                        case 1: {
                            if (importDataContainer.getData() == null) continue block10;
                            if (stringBuffer == null) {
                                stringBuffer = new StringBuffer();
                            } else {
                                stringBuffer.append(",");
                            }
                            if (importDataContainer.getDataType() == 2) {
                                stringBuffer.append(new String((byte[])importDataContainer.getData(), importDataProvider.getFileEncoding()));
                                break;
                            }
                            if (importDataContainer.getDataType() != 1) continue block10;
                            stringBuffer.append((char[])importDataContainer.getData());
                            break;
                        }
                        case 4: {
                            break;
                        }
                        default: {
                            throw new OSQLException("OSCAR-00809", "88888", 107);
                        }
                    }
                } while (n2 != 4);
                if (stringBuffer != null) {
                    this.handler.setColumnOrder(stringBuffer.toString());
                }
            }
            while (importDataProvider.nextRow()) {
                block12: do {
                    n2 = importDataProvider.setNextColumnData(importDataContainer);
                    switch (n2) {
                        case 1: {
                            if (importDataContainer.getData() == null) {
                                ++n3;
                                break;
                            }
                            if (importDataContainer.getDataType() == 2) {
                                this.handler.setBytes(++n3, this.conn.getEncoding().encode(new String((byte[])importDataContainer.getData(), importDataProvider.getFileEncoding())));
                                break;
                            }
                            if (importDataContainer.getDataType() != 1) continue block12;
                            this.handler.setString(++n3, (char[])importDataContainer.getData());
                            break;
                        }
                        case 4: {
                            this.handler.endRow();
                            n3 = 0;
                            break;
                        }
                        default: {
                            throw new OSQLException("OSCAR-00809", "88888", 107);
                        }
                    }
                } while (n2 != 4);
            }
            importDataProvider.close();
        }
        catch (IOException iOException) {
            throw new SQLException("dataProvider occur error " + iOException.getMessage());
        }
        boolean bl = this.handler.execute();
        n2 = bl ? 1 : 0;
        if (bl) {
            return this.handler.getUpdateCount();
        }
        return 0L;
    }

    @Override
    public void close() throws SQLException {
        this.handler.close();
        this.conn = null;
    }
}

