/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.BaseStatement;
import com.oscar.core.Encoding;
import com.oscar.core.Field;
import com.oscar.gis.OscarObject;
import com.oscar.jdbc.OscarBfile;
import com.oscar.jdbc.OscarBlob;
import com.oscar.jdbc.OscarClob;
import com.oscar.jdbc.OscarJdbc2Connection;
import com.oscar.jdbc.OscarResultSetMetaData;
import com.oscar.jdbc.OscarResultSetV2;
import com.oscar.jdbc.OscarSQLXML;
import com.oscar.jdbc.OscarStatement;
import com.oscar.jdbc.OscarStringClob;
import com.oscar.jdbc.ResultArray;
import com.oscar.jdbc.handler.NClobInvocationHandler;
import com.oscar.r2dbc.R2dbcNextPredicate;
import com.oscar.util.OSCARbyte;
import com.oscar.util.OSQLException;
import com.oscar.util.OscarJDBCUtil;
import com.oscar.util.OtherType;
import com.oscar.util.TypeConverter;
import com.oscar.util.converter.BooleanConverter;
import com.oscar.util.converter.DateConverter;
import com.oscar.util.converter.NumberConverter;
import com.oscar.util.converter.TimeConverter;
import com.oscar.util.converter.TimestampConverter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class OscarResultSet
implements BaseResultSet,
R2dbcNextPredicate {
    protected Encoding encoding;
    protected Encoding clientEncoding;
    protected List<byte[][]> rows;
    protected BaseStatement statement;
    protected Field[] fields;
    protected String status;
    protected long updateCount;
    protected long insertRowid;
    protected int current_row;
    protected byte[][] this_row;
    protected int lastColumn;
    protected boolean resultTid;
    protected List<byte[]> tidList;
    protected Field tidField;
    protected BaseConnection connection;
    protected SQLWarning warnings;
    protected BaseResultSet next;
    protected BaseResultSet previous;
    protected BaseResultSet lastResult;
    protected StringBuffer sbuf;
    protected byte[][] rowBuffer;
    protected int type;
    protected int concurrency;
    protected boolean canUpdateable;
    protected int statementType;
    protected int fetchSize;
    protected int fetchDirection;
    protected int maxRows;
    protected boolean closed;
    protected boolean cursorUsed;
    protected int moveSize;
    protected String cursorName;
    protected int cursorPosition;
    protected Hashtable<String, Object> updateValues;
    protected boolean nullResult;
    protected boolean doingUpdates;
    protected boolean onInsertRow;
    protected String tableName;
    protected String schemaName;
    protected PreparedStatement updateStatement;
    protected PreparedStatement insertStatement;
    protected Statement deleteStatement;
    protected static final BigInteger INTMAX = new BigInteger(Integer.toString(Integer.MAX_VALUE));
    protected static final BigInteger INTMIN = new BigInteger(Integer.toString(Integer.MIN_VALUE));
    protected HashMap<Object, Object> columnNameIndexMap;
    protected byte[] planID;
    protected boolean encodingFlag;
    protected boolean logFlag;
    protected int datakind;
    protected boolean isRowDeleted;
    protected boolean isRowinserted;
    protected boolean isRowupdated;
    protected boolean isOldProtocolResult;
    protected int maxRowsCopy;
    protected boolean objectToString;
    protected boolean rsDateWithHMS;
    protected int sessionId;
    protected int pid;
    protected Calendar localCalendar;
    private static final Constructor<?> JDBC_4_RS_1_ARG;
    private static final Constructor<?> JDBC_4_RS_2_ARG;
    private static final Constructor<?> JDBC_4_RS_1_ARG_V2;
    private static final Constructor<?> JDBC_4_RS_2_ARG_V2;

    public OscarResultSet(BaseStatement baseStatement, Field[] fieldArray, List<byte[][]> list, String string, long l2, long l3, int n2, int n3) throws SQLException {
        BaseStatement baseStatement2 = baseStatement;
        this(baseStatement2, baseStatement2.getDBConnection(), baseStatement.getResultSetType(), baseStatement.getResultSetConcurrency(), baseStatement.getResultSetCanUpdateable(), baseStatement.getFetchDirection(), baseStatement.getCursorName(), fieldArray, list, string, l2, l3, n2, n3);
    }

    public OscarResultSet(BaseStatement baseStatement, Field[] fieldArray, List<byte[][]> list, String string, long l2, long l3, int n2, int n3, int n4) throws SQLException {
        this(baseStatement, fieldArray, list, string, l2, l3, n3, 0);
        this.datakind = n4;
        this.fields = new Field[3];
        if (this.rows != null && this.rows.size() == 0) {
            this.cursorPosition = 1;
            return;
        }
        this.cursorPosition = 0;
    }

    OscarResultSet(BaseStatement object, BaseConnection baseConnection, int n2, int n3, boolean bl, int n4, String string, Field[] fieldArray, List<byte[][]> list, String string2, long l2, long l3, int n5, int n6) {
        this.current_row = -1;
        this.next = null;
        this.previous = null;
        this.lastResult = null;
        this.sbuf = null;
        this.rowBuffer = null;
        this.type = 1003;
        this.concurrency = 1007;
        this.canUpdateable = true;
        this.statementType = 0;
        this.fetchSize = 0;
        this.fetchDirection = 1000;
        this.maxRows = 0;
        this.closed = false;
        this.cursorUsed = false;
        this.moveSize = 0;
        this.cursorName = null;
        this.cursorPosition = 0;
        this.updateValues = new Hashtable();
        this.doingUpdates = false;
        this.onInsertRow = false;
        this.tableName = null;
        this.schemaName = null;
        this.updateStatement = null;
        this.insertStatement = null;
        this.deleteStatement = null;
        this.encodingFlag = false;
        this.logFlag = Driver.getLogLevel() >= 2;
        this.datakind = 0;
        this.isRowDeleted = false;
        this.isRowinserted = false;
        this.isRowupdated = false;
        this.isOldProtocolResult = false;
        this.maxRowsCopy = 0;
        this.objectToString = false;
        this.rsDateWithHMS = false;
        this.connection = baseConnection;
        this.statement = object;
        this.type = n2;
        this.concurrency = n3;
        this.canUpdateable = bl;
        this.fetchSize = n5;
        this.fetchDirection = n4;
        this.encoding = baseConnection.getEncoding();
        this.clientEncoding = baseConnection.getClientEncoding();
        if (this.encoding == null) {
            this.encodingFlag = true;
            this.encoding = this.clientEncoding;
        } else {
            this.encodingFlag = this.encoding.equals(this.clientEncoding);
        }
        this.fields = fieldArray;
        this.rows = list;
        this.status = string2;
        this.updateCount = l2;
        this.insertRowid = l3;
        this.cursorName = string;
        if (n5 > this.rows.size()) {
            this.cursorPosition = 1;
        }
        if (this.rows.size() == 0) {
            this.nullResult = true;
        }
        OscarResultSet oscarResultSet = this;
        oscarResultSet.maxRows = oscarResultSet.maxRowsCopy = n6;
        if (fieldArray != null && fieldArray.length > 0 && fieldArray[0] != null) {
            this.tableName = fieldArray[0].getTableName();
            this.schemaName = fieldArray[0].getSchemaName();
        }
        object = baseConnection.getConnectionProperties();
        this.objectToString = Boolean.valueOf(((Properties)object).getProperty("OBJECTTOSTRING", "false"));
        this.rsDateWithHMS = Boolean.valueOf(((Properties)object).getProperty("RSDATEWITHHMS", "false"));
        this.sessionId = baseConnection.getSessionID();
        this.pid = baseConnection.getPlanID();
        this.localCalendar = baseConnection.getCalendar();
    }

    @Override
    public void reInit(Field[] fieldArray, List<byte[][]> list, String string, long l2, long l3) {
        this.fields = fieldArray;
        this.rows = list;
        this.status = string;
        this.updateCount = l2;
        this.insertRowid = l3;
        this.this_row = null;
        this.current_row = -1;
        this.columnNameIndexMap = null;
    }

    @Override
    public Field[] getFields() {
        return this.fields;
    }

    @Override
    public List<byte[][]> getTuples() {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", getTuples(), rows: " + this.rows.size());
        }
        return this.rows;
    }

    @Override
    public byte[][] getCurrentRow() {
        return this.this_row;
    }

    @Override
    public synchronized boolean next() throws SQLException {
        if (this.logFlag && this.connection != null) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", next()");
        }
        this.checkClosed();
        if (this.maxRows > 0 && this.maxRowsCopy <= 0) {
            this.cursorPosition = 1;
            return false;
        }
        this.updateValues.clear();
        if (!this.cursorUsed && this.current_row == this.rows.size()) {
            this.this_row = null;
            return false;
        }
        if (this.cursorPosition == 1 && this.current_row == this.rows.size()) {
            this.this_row = null;
            return false;
        }
        if (++this.current_row >= this.rows.size()) {
            if (!this.cursorUsed) {
                this.this_row = null;
                return false;
            }
            if (this.cursorPosition == 1) {
                this.this_row = null;
                return false;
            }
            String string = "FETCH FORWARD " + this.fetchSize + " IN " + this.cursorName;
            this.connection.execSQL(string, this.statement, this);
            this.cursorPosition = this.moveSize < this.fetchSize ? 1 : 0;
            this.current_row = 0;
            if (this.rows.size() == 0) {
                this.this_row = null;
                this.rowBuffer = null;
                return false;
            }
        }
        if (this.maxRows > 0) {
            --this.maxRowsCopy;
        }
        this.this_row = this.rows.get(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        try {
            if (this.cursorUsed) {
                try {
                    this.connection.closeCursor(this.cursorName, this.statement);
                }
                catch (Exception exception) {}
            }
            this.rows = null;
            this.encoding = null;
            this.fields = null;
            this.status = null;
            this.this_row = null;
            this.tidList = null;
            this.tidField = null;
            this.warnings = null;
            this.next = null;
            this.sbuf = null;
            this.rowBuffer = null;
            this.updateValues = null;
            this.connection = null;
            this.cursorName = null;
            this.closed = true;
            this.deleteStatement = null;
            this.columnNameIndexMap = null;
            return;
        }
        finally {
            if (this.statement != null) {
                this.statement.checkAndPerformCloseOnCompletionAction();
            }
            this.statement = null;
        }
    }

    @Override
    public void setTidValues(Field field, List<byte[]> list) {
        this.resultTid = true;
        this.tidField = field;
        this.tidList = list;
        if (field != null && this.statement instanceof OscarStatement) {
            ((OscarStatement)this.statement).firstField = field;
        }
        if (this.schemaName == null || this.schemaName.length() == 0) {
            this.schemaName = field.getSchemaName();
        }
        if (this.tableName == null || this.tableName.length() == 0) {
            this.tableName = field.getTableName();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkNull();
        if (this.lastColumn == 0) {
            throw new OSQLException("OSCAR-00301", "88888", 301);
        }
        return this.this_row[this.lastColumn - 1] == null;
    }

    @Override
    public String getString(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        switch (this.getFieldType(n2)) {
            case -4: 
            case -3: 
            case -2: {
                return OSCARbyte.toOSCARString(this.getBytes(n2));
            }
            case 2005: {
                OscarClob oscarClob = this.connection.getClobInstance(this.connection.getEncoding().decode(this.this_row[n2 - 1]));
                long l2 = oscarClob.length();
                if (l2 > Integer.MAX_VALUE) {
                    throw new OSQLException("OSCAR-00316", "22000", 316);
                }
                return oscarClob.getSubString(1L, (int)l2);
            }
            case 16: {
                return String.valueOf(this.getBoolean(n2));
            }
        }
        return this.encoding.decode(this.this_row[n2 - 1]);
    }

    protected String getFixedString(int n2) throws SQLException {
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        return this.encoding.decode(this.this_row[n2 - 1]);
    }

    @Override
    public boolean getBoolean(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        return TypeConverter.toBoolean(this.getFixedString(n2), this.getFieldType(n2));
    }

    @Override
    public byte getByte(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        return TypeConverter.toByte(this.getFixedString(n2), this.getFieldType(n2));
    }

    @Override
    public short getShort(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        return TypeConverter.toShort(this.getFixedString(n2), this.getFieldType(n2));
    }

    @Override
    public int getInt(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.encoding.hasAsciiNumbers()) {
            try {
                return this.getFastInt(n2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String string = this.fields[n2 - 1].getDBType();
        String string2 = this.getFixedString(n2);
        if (string.equalsIgnoreCase("float") || string.startsWith("double")) {
            double d2 = Double.parseDouble(string2);
            if (d2 < -2.147483648E9 || d2 > 2.147483647E9) {
                throw new OSQLException("OSCAR-00719", "88888", 719);
            }
            return (int)d2;
        }
        if (string.equalsIgnoreCase("decimal") || string.equalsIgnoreCase("numeric")) {
            BigDecimal bigDecimal = new BigDecimal(string2);
            if (bigDecimal.compareTo(BIG_DECIMAL_MIN_INTEGER_VALUE) < 0 || bigDecimal.compareTo(BIG_DECIMAL_MAX_INTEGER_VALUE) > 0) {
                throw new OSQLException("OSCAR-00719", "88888", 719);
            }
            return bigDecimal.intValue();
        }
        return OscarResultSet.toInt(string2);
    }

    public static int toInt(String object) throws SQLException {
        if (object != null) {
            try {
                object = ((String)object).trim();
                if (((String)object).length() > 0) {
                    return Integer.parseInt((String)object);
                }
                return 0;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    object = new BigDecimal((String)object);
                    object = ((BigDecimal)object).toBigInteger();
                    int n2 = ((BigInteger)object).compareTo(INTMAX);
                    int n3 = ((BigInteger)object).compareTo(INTMIN);
                    if (n2 > 0 || n3 < 0) {
                        throw new OSQLException("OSCAR-00719", "88888", 719, numberFormatException);
                    }
                    return ((BigInteger)object).intValue();
                }
                catch (NumberFormatException numberFormatException2) {
                    throw new OSQLException("OSCAR-00703", "88888", 703, numberFormatException2);
                }
            }
        }
        return 0;
    }

    private int getFastInt(int n2) throws SQLException, NumberFormatException {
        int n3;
        boolean bl;
        byte[] byArray = this.this_row[n2 - 1];
        if (byArray == null) {
            return 0;
        }
        if (byArray.length == 0) {
            return 0;
        }
        int n4 = 0;
        if (byArray[0] == 45) {
            bl = true;
            n3 = 1;
            if (byArray.length == 1 || byArray.length > 10) {
                throw new NumberFormatException();
            }
        } else {
            n3 = 0;
            bl = false;
            if (byArray.length > 9) {
                throw new NumberFormatException();
            }
        }
        while (n3 < byArray.length) {
            byte by;
            if ((by = byArray[n3++]) < 48 || by > 57) {
                throw new NumberFormatException();
            }
            n4 *= 10;
            n4 += by - 48;
        }
        if (bl) {
            n4 = -n4;
        }
        return n4;
    }

    @Override
    public long getLong(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        return TypeConverter.toLong(this.getFixedString(n2), this.getFieldType(n2));
    }

    @Override
    public float getFloat(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        return TypeConverter.toFloat(this.getFixedString(n2), this.getFieldType(n2));
    }

    @Override
    public double getDouble(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        return TypeConverter.toDouble(this.getFixedString(n2), this.getFieldType(n2));
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        return TypeConverter.toBigDecimal(this.getFixedString(n2), this.getFieldType(n2), n3);
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        if (this.getFieldType(n2) == 2004) {
            OscarBlob oscarBlob = this.connection.getBlobInstance(new String(this.this_row[n2 - 1]));
            long l2 = oscarBlob.length();
            if (l2 > Integer.MAX_VALUE) {
                throw new OSQLException("OSCAR-00316", "22000", 316);
            }
            if (this.encodingFlag) {
                return oscarBlob.getBytes(1L, (int)l2);
            }
            return this.clientEncoding.encode(this.encoding.decode(oscarBlob.getBytes(1L, (int)l2)));
        }
        if (this.encodingFlag) {
            return TypeConverter.toBytes(this.connection, this.this_row[n2 - 1], this.getFieldType(n2));
        }
        return TypeConverter.toBytes(this.connection, this.clientEncoding.encode(this.encoding.decode(this.this_row[n2 - 1])), this.getFieldType(n2));
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        return TypeConverter.toDate(this.getFixedString(n2), this.getFieldType(n2));
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        return TypeConverter.toTime(this.getFixedString(n2), this.getFieldType(n2), this.localCalendar);
    }

    protected int getOscarType(int n2) throws SQLException {
        return this.fields[n2 - 1].getOscarType();
    }

    protected Time getOscarTime(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        switch (this.getOscarType(n2)) {
            case 27: {
                return TypeConverter.convertToTime(this.getFixedString(n2), this.localCalendar.getTimeZone());
            }
        }
        return TypeConverter.toTime(this.getFixedString(n2), this.getFieldType(n2), this.localCalendar);
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        return TypeConverter.toTimestamp(this.getFixedString(n2), this.getFieldType(n2), this.localCalendar);
    }

    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(this.getFixedString(n2).getBytes("UTF-16BE"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OSQLException("OSCAR-00303", "88888", 303, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    @Override
    public String getString(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getString(oscarResultSet.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getBoolean(oscarResultSet.findColumn(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getByte(oscarResultSet.findColumn(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getShort(oscarResultSet.findColumn(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getInt(oscarResultSet.findColumn(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getLong(oscarResultSet.findColumn(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getFloat(oscarResultSet.findColumn(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getDouble(oscarResultSet.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getBigDecimal(oscarResultSet.findColumn(string), n2);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getBytes(oscarResultSet.findColumn(string));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getDate(oscarResultSet.findColumn(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getTime(oscarResultSet.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getTimestamp(oscarResultSet.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getAsciiStream(oscarResultSet.findColumn(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getUnicodeStream(oscarResultSet.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getBinaryStream(oscarResultSet.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warnings = null;
    }

    public void addWarnings(SQLWarning sQLWarning) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(sQLWarning);
            return;
        }
        this.warnings = sQLWarning;
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkClosed();
        return this.cursorName;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getObject(oscarResultSet.findColumn(string));
    }

    @Override
    public int findColumn(String object) throws SQLException {
        this.checkClosed();
        if (this.columnNameIndexMap == null) {
            this.initalizeColNames();
        }
        if ((object = (Integer)this.columnNameIndexMap.get(((String)object).toUpperCase())) == null) {
            throw new OSQLException("OSCAR-00304", "88888", 304);
        }
        return (Integer)object;
    }

    private void initalizeColNames() {
        int n2 = this.fields.length;
        this.columnNameIndexMap = new HashMap(n2 << 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.columnNameIndexMap.put(this.fields[i2].getAliasName().toUpperCase(), i2 + 1);
        }
    }

    @Override
    public boolean reallyResultSet() {
        boolean bl = false;
        if (this.fields == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            if (this.fields[i2] == null) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public ResultSet getNext() {
        return this.next;
    }

    @Override
    public BaseResultSet getLastResult() {
        return this.lastResult;
    }

    @Override
    public void append(BaseResultSet baseResultSet) {
        if (this.next == null) {
            this.next = baseResultSet;
            baseResultSet.setPrevious(this);
            this.lastResult = baseResultSet;
        } else {
            this.lastResult.append(baseResultSet);
        }
        this.lastResult = baseResultSet;
    }

    @Override
    public void setPrevious(BaseResultSet baseResultSet) {
        this.previous = baseResultSet;
    }

    @Override
    public ResultSet getPrevious() {
        return this.previous;
    }

    @Override
    public long getResultCount() {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", getResultCount()" + this.updateCount);
        }
        return this.updateCount;
    }

    @Override
    public int getTupleCount() {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", getTupleCount()" + this.rows.size());
        }
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        if (this.fields == null) {
            return 0;
        }
        return this.fields.length;
    }

    @Override
    public String getStatusString() {
        return this.status;
    }

    @Override
    public long getInsertRowid() {
        return this.insertRowid;
    }

    public void checkIndex(int n2) throws SQLException {
        if (n2 <= 0 || n2 > this.fields.length) {
            throw new OSQLException("OSCAR-00305", "88888", 305);
        }
        this.lastColumn = n2;
    }

    protected void checkNull() throws SQLException {
        if (this.this_row == null) {
            throw new OSQLException("OSCAR-00301", "88888", 301);
        }
    }

    protected final int getFieldType(int n2) throws SQLException {
        return this.fields[n2 - 1].getSQLType();
    }

    @Override
    public final boolean isCursorUsed() {
        return this.cursorUsed;
    }

    @Override
    public void setCursorUsed(boolean bl) {
        this.cursorUsed = bl;
    }

    @Override
    public void setCursorMoveSize(int n2) {
        this.moveSize = n2;
    }

    protected void checkClosed() throws SQLException {
        if (this.closed) {
            throw new OSQLException("OSCAR-00306", "88888", 306);
        }
    }

    protected boolean checkResultClosed() throws SQLException {
        return !this.closed;
    }

    @Override
    public List<byte[]> getTidValues() {
        return this.tidList;
    }

    @Override
    public Field getTidField() {
        return this.tidField;
    }

    @Override
    public Object getObject(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        Object object = this.fields[n2 - 1];
        switch (((Field)object).getSQLType()) {
            case -6: 
            case 4: 
            case 5: {
                return this.getInt(n2);
            }
            case -5: {
                return this.getLong(n2);
            }
            case 7: {
                return new Float(this.getFloat(n2));
            }
            case 6: 
            case 8: {
                return new Double(this.getDouble(n2));
            }
            case 2: 
            case 3: {
                object = this.getFixedString(n2);
                if ("NaN".equals(object)) {
                    return Double.NaN;
                }
                return this.getBigDecimal(n2);
            }
            case 16: {
                return this.getBoolean(n2);
            }
            case -7: 
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n2);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(n2);
            }
            case 91: {
                if (this.rsDateWithHMS) {
                    return this.getTimestamp(n2);
                }
                return this.getDate(n2);
            }
            case 92: {
                return this.getTime(n2);
            }
            case 93: {
                if (this.objectToString) {
                    return this.getString(n2);
                }
                return this.getTimestamp(n2);
            }
            case 2003: {
                return this.getArray(n2);
            }
            case 2004: {
                if (this.objectToString) {
                    return ((OscarBlob)this.getBlob(n2)).getSubString(1L, 8000);
                }
                return this.getBlob(n2);
            }
            case 2005: {
                return this.getClob(n2);
            }
            case -11: {
                return this.getBfile(n2);
            }
            case 1111: {
                object = this.getFields()[n2 - 1].getDBType();
                Serializable serializable = this.connection.getOscarObject((String)object);
                try {
                    serializable = serializable != null ? ((Class)serializable).newInstance() : new OscarObject();
                    ((OscarObject)serializable).setType((String)object);
                    ((OscarObject)serializable).setValue(this.getString(n2));
                }
                catch (Exception exception) {
                    serializable = exception;
                    Driver.writeLog(exception);
                    serializable = new OscarObject();
                    ((OscarObject)serializable).setType((String)object);
                    ((OscarObject)serializable).setValue(this.getString(n2));
                }
                return serializable;
            }
        }
        return this.getString(n2);
    }

    @Override
    public synchronized boolean absolute(int n2) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", absolute(int index), params: " + n2);
        }
        this.checkClosed();
        this.checkMovable();
        if (this.maxRows > 0) {
            if (n2 > 0) {
                if (n2 > this.maxRows) {
                    this.maxRowsCopy = this.maxRows - n2;
                    return false;
                }
                this.maxRowsCopy = this.maxRows - n2;
                if (this.maxRowsCopy == 0) {
                    return true;
                }
            } else if (n2 < 0) {
                int n3 = -n2;
                if (n3 > this.maxRows) {
                    return false;
                }
                this.maxRowsCopy = n3 - 1;
            } else {
                this.maxRowsCopy = this.maxRows;
            }
        }
        this.updateValues.clear();
        if (!this.cursorUsed) {
            if (n2 == 0) {
                this.current_row = -1;
                this.this_row = null;
                return false;
            }
            if (n2 > 0) {
                if (n2 > this.rows.size()) {
                    this.current_row = this.rows.size();
                    this.this_row = null;
                    return false;
                }
                this.current_row = n2 - 1;
            } else {
                if (-n2 > this.rows.size()) {
                    this.current_row = -1;
                    this.this_row = null;
                    return false;
                }
                this.current_row = n2 + this.rows.size();
            }
        } else if (n2 == 0 || n2 == 1) {
            String string = "MOVE BACKWARD ALL IN " + this.cursorName;
            this.connection.execSQL(string, this.statement);
            string = "FETCH FORWARD " + this.fetchSize + " IN " + this.cursorName;
            this.connection.execSQL(string, this.statement);
            this.cursorPosition = this.moveSize < this.fetchSize ? 1 : 0;
            if (n2 == 0) {
                this.current_row = -1;
                this.this_row = null;
                this.rowBuffer = null;
                return false;
            }
            this.current_row = 0;
        } else if (n2 > 1) {
            String string = "MOVE BACKWARD ALL IN " + this.cursorName;
            this.connection.execSQL(string, this.statement);
            string = "MOVE FORWARD " + (n2 - 1) + " IN " + this.cursorName;
            this.connection.execSQL(string, this.statement);
            if (this.moveSize < n2 - 1) {
                this.cursorPosition = 1;
                this.rows.clear();
                this.current_row = 0;
                this.rowBuffer = null;
                this.this_row = null;
                return false;
            }
            if (this.moveSize == n2 - 1) {
                string = "FETCH FORWARD " + this.fetchSize + " IN " + this.cursorName;
                this.connection.execSQL(string, this.statement);
                this.current_row = 0;
                this.cursorPosition = this.moveSize < this.fetchSize ? 1 : 0;
            }
        } else {
            String string;
            int n4 = -n2;
            if (this.maxRows > 0) {
                string = "MOVE BACKWARD ALL IN " + this.cursorName;
                this.connection.execSQL(string, this.statement);
                if (this.maxRows != n4) {
                    string = "MOVE FORWARD " + this.maxRows + "IN " + this.cursorName;
                    this.connection.execSQL(string, this.statement);
                    string = "MOVE BACKWARD " + (this.maxRowsCopy + 1) + " IN " + this.cursorName;
                    this.connection.execSQL(string, this.statement);
                }
            } else {
                string = "MOVE FORWARD ALL IN " + this.cursorName;
                this.connection.execSQL(string, this.statement);
                string = "MOVE BACKWARD " + (n4 + 1) + " IN " + this.cursorName;
                this.connection.execSQL(string, this.statement);
            }
            if (this.moveSize < n4) {
                string = "FETCH FORWARD " + this.fetchSize + " IN " + this.cursorName;
                this.connection.execSQL(string, this.statement);
                this.cursorPosition = this.moveSize < this.fetchSize ? 1 : 0;
                this.this_row = null;
                this.rowBuffer = null;
                this.current_row = -1;
                return false;
            }
            if (this.moveSize == n4 + 1 || this.moveSize == n4) {
                string = "FETCH FORWARD " + this.fetchSize + " IN " + this.cursorName;
                this.connection.execSQL(string, this.statement);
                this.current_row = 0;
                this.cursorPosition = this.moveSize < this.fetchSize ? 1 : 0;
            }
        }
        if (this.rows.size() == 0) {
            this.current_row = n2 > 0 ? n2 : -1;
            this.this_row = null;
            this.rowBuffer = null;
            return false;
        }
        this.this_row = this.rows.get(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", absolute(int index), rows: " + this.rows.size());
        }
        return true;
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", afterLast ");
        }
        this.checkClosed();
        this.checkMovable();
        this.updateValues.clear();
        this.this_row = null;
        if (this.isAfterLast()) {
            return;
        }
        if (!this.cursorUsed) {
            this.current_row = this.rows.size();
            return;
        }
        String string = "MOVE FORWARD ALL IN " + this.cursorName;
        this.connection.execSQL(string, this.statement);
        this.current_row = 0;
        this.rows.clear();
        this.this_row = null;
        this.rowBuffer = null;
        this.cursorPosition = 1;
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", beforeFirst ");
        }
        this.checkClosed();
        this.checkMovable();
        this.updateValues.clear();
        this.this_row = null;
        if (this.isBeforeFirst()) {
            return;
        }
        if (!this.cursorUsed) {
            this.current_row = -1;
            return;
        }
        String string = "MOVE BACKWARD ALL IN " + this.cursorName;
        this.connection.execSQL(string, this.statement);
        string = "FETCH FORWARD " + this.fetchSize + " IN " + this.cursorName;
        this.connection.execSQL(string, this.statement);
        this.cursorPosition = this.moveSize < this.fetchSize ? 1 : 0;
        this.this_row = null;
        this.rowBuffer = null;
        this.current_row = -1;
    }

    @Override
    public boolean first() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", first ");
        }
        return this.absolute(1);
    }

    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        try {
            int n3 = this.getFieldType(n2);
            if (n3 == 2004) {
                throw new SQLException("OSCAR-00302", "88888", 302);
            }
            if (n3 == 2005) {
                return this.getClob(n2).getAsciiStream();
            }
            return new ByteArrayInputStream(this.getFixedString(n2).getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OSQLException("OSCAR-00302", "88888", 302, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        int n3 = this.getFieldType(n2);
        if (n3 == 2004) {
            return this.getBlob(n2).getBinaryStream();
        }
        byte[] byArray = this.getBytes(n2);
        return new ByteArrayInputStream(byArray);
    }

    @Override
    public Array getArray(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getArray(oscarResultSet.findColumn(string));
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        return new ResultArray(this.connection, n2, this.fields[n2 - 1], this);
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        return TypeConverter.toBigDecimal(this.getFixedString(n2), this.getFieldType(n2));
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        int n2 = this.findColumn(string);
        return this.getBigDecimal(n2);
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.getFieldType(n2) != 2004) {
            throw new OSQLException("OSCAR-00714", "88888", 714);
        }
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        return this.connection.getBlobInstance(new String(this.this_row[n2 - 1]));
    }

    public OscarBfile getBfile(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.getFieldType(n2) != -11) {
            throw new OSQLException("OSCAR-00714", "88888", 714);
        }
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        return this.connection.getBfileInstance(new String(this.this_row[n2 - 1]));
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getBlob(oscarResultSet.findColumn(string));
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        if (this.getFieldType(n2) == 2005) {
            return this.connection.getClobInstance(this.connection.getEncoding().decode(this.this_row[n2 - 1]));
        }
        return new OscarStringClob(this.getString(n2));
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getClob(oscarResultSet.findColumn(string));
    }

    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        int n3 = this.getFieldType(n2);
        if (n3 == 2004) {
            throw new SQLException("OSCAR-00302", "88888", 302);
        }
        if (n3 == 2005) {
            return this.getClob(n2).getCharacterStream();
        }
        return new CharArrayReader(this.getFixedString(n2).toCharArray());
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getCharacterStream(oscarResultSet.findColumn(string));
    }

    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        return TypeConverter.toDate(this.getFixedString(n2), this.getFieldType(n2), calendar, Calendar.getInstance());
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getDate(oscarResultSet.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        return TypeConverter.toTime(this.getFixedString(n2), this.getFieldType(n2), calendar, Calendar.getInstance());
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getTime(oscarResultSet.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        return TypeConverter.toTimestamp(this.getFixedString(n2), this.getFieldType(n2), calendar, Calendar.getInstance());
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getTimestamp(oscarResultSet.findColumn(string), calendar);
    }

    @Override
    public int getConcurrency() throws SQLException {
        if (this.statement == null) {
            return 1007;
        }
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getRef(oscarResultSet.findColumn(string));
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        throw new SQLException("oscar.osqlnotimp", "HY000", -1);
    }

    @Override
    public int getRow() throws SQLException {
        int n2;
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", getRow()");
        }
        this.checkClosed();
        int n3 = this.rows.size();
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", rows_size: " + n3);
        }
        if (this.current_row < 0 || this.current_row >= n3) {
            return 0;
        }
        if (!this.cursorUsed || this.cursorName == null) {
            return this.current_row + 1;
        }
        String string = "MOVE BACKWARD ALL IN " + this.cursorName;
        this.connection.execSQL(string, this.statement);
        int n4 = this.moveSize;
        if (this.cursorPosition != 1) {
            string = "MOVE FORWARD " + (this.moveSize + 1) + " IN " + this.cursorName;
            n2 = this.current_row + 2 - this.rows.size();
        } else {
            string = "MOVE FORWARD ALL IN " + this.cursorName;
            n2 = this.current_row + 1 - this.rows.size();
        }
        this.connection.execSQL(string, this.statement);
        return n4 + n2;
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return (Statement)((Object)this.statement);
    }

    @Override
    public int getType() throws SQLException {
        return this.type;
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException {
        this.checkClosed();
        if (this.maxRows > 0 && this.maxRowsCopy < 0) {
            return true;
        }
        if (!this.cursorUsed) {
            return this.current_row >= this.rows.size();
        }
        return this.current_row >= this.rows.size() && this.cursorPosition == 1;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        if (this.nullResult && this.rows.size() == 0) {
            return false;
        }
        if (this.maxRows > 0 && this.maxRowsCopy < 0) {
            return false;
        }
        return this.current_row == -1;
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", isFirst() ");
        }
        this.checkClosed();
        if (!this.cursorUsed) {
            return this.current_row == 0 && this.rows.size() > 0;
        }
        if (this.maxRows > 0 && this.maxRowsCopy <= 0) {
            return false;
        }
        if (this.current_row == -1) {
            return false;
        }
        if (this.current_row == 0 && this.rows.size() > 0) {
            if (this.cursorPosition == 1) {
                String string = "MOVE BACKWARD " + (this.rows.size() + 1) + " IN " + this.cursorName;
                this.connection.execSQL(string, this.statement);
                int n2 = this.moveSize;
                string = "MOVE FORWARD ALL IN " + this.cursorName;
                this.connection.execSQL(string, this.statement);
                return n2 < this.rows.size() + 1;
            }
            String string = "MOVE BACKWARD " + this.rows.size() + " IN " + this.cursorName;
            this.connection.execSQL(string, this.statement);
            int n3 = this.moveSize;
            if (n3 < this.rows.size()) {
                string = "MOVE FORWARD " + (n3 + 1) + " IN " + this.cursorName;
                this.connection.execSQL(string, this.statement);
                return true;
            }
            string = "MOVE FORWARD " + n3 + " IN " + this.cursorName;
            this.connection.execSQL(string, this.statement);
            return false;
        }
        return false;
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", isLast() ");
        }
        if (!this.cursorUsed) {
            return this.current_row == this.rows.size() - 1 && this.rows.size() != 0;
        }
        if (this.maxRows > 0 && this.maxRowsCopy < 0) {
            return false;
        }
        if (this.maxRows > 0 && this.maxRowsCopy - 1 <= 0) {
            return true;
        }
        if (this.current_row == this.rows.size() - 1) {
            if (this.cursorPosition == 1) {
                return true;
            }
            String string = "MOVE FORWARD 1 IN " + this.cursorName;
            this.connection.execSQL(string, this.statement);
            int n2 = this.moveSize;
            string = "MOVE BACKWARD 1 IN " + this.cursorName;
            this.connection.execSQL(string, this.statement);
            return n2 <= 0;
        }
        return false;
    }

    @Override
    public synchronized boolean last() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", last()");
        }
        return this.absolute(-1);
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", previous()");
        }
        this.checkClosed();
        this.checkMovable();
        this.updateValues.clear();
        if (this.current_row == -1) {
            this.this_row = null;
            return false;
        }
        if (--this.current_row < 0) {
            if (!this.cursorUsed) {
                this.this_row = null;
                return false;
            }
            int n2 = this.rows.size();
            if (this.cursorPosition == 0) {
                String string = "MOVE BACKWARD " + (this.fetchSize + n2) + " IN " + this.cursorName;
                this.connection.execSQL(string, this.statement);
                if (this.moveSize < n2) {
                    this.current_row = -1;
                    this.rows.clear();
                    this.cursorPosition = -1;
                    this.rowBuffer = null;
                    this.this_row = null;
                    return false;
                }
                int n3 = this.moveSize - n2;
                if (this.moveSize < this.fetchSize + n2) {
                    ++n3;
                }
                String string2 = "FETCH FORWARD " + n3 + " IN " + this.cursorName;
                this.connection.execSQL(string2, this.statement);
                this.current_row = this.rows.size() - 1;
                this.cursorPosition = 0;
            } else if (this.cursorPosition == 1) {
                String string = "MOVE BACKWARD " + (this.fetchSize + (n2 + 1)) + " IN " + this.cursorName;
                this.connection.execSQL(string, this.statement);
                if (this.moveSize <= n2) {
                    this.current_row = -1;
                    this.cursorPosition = -1;
                    this.rows.clear();
                    this.rowBuffer = null;
                    this.this_row = null;
                    return false;
                }
                int n4 = this.moveSize - (n2 + 1);
                if (this.moveSize < this.fetchSize + (n2 + 1)) {
                    ++n4;
                }
                String string3 = "FETCH FORWARD " + n4 + " IN " + this.cursorName;
                this.connection.execSQL(string3, this.statement);
                this.current_row = this.rows.size() - 1;
                this.cursorPosition = 0;
            }
        }
        this.this_row = this.rows.get(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    @Override
    public synchronized boolean relative(int n2) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSet.class + ", relative(int relativeSize)(), params: " + n2);
        }
        this.checkClosed();
        this.checkMovable();
        if (n2 == 0) {
            if (this.isAfterLast() || this.isBeforeFirst()) {
                this.this_row = null;
                return false;
            }
            return true;
        }
        this.updateValues.clear();
        n2 += this.current_row;
        if (!this.cursorUsed) {
            if (n2 < 0) {
                this.current_row = -1;
                this.this_row = null;
                return false;
            }
            if (n2 >= this.rows.size()) {
                this.current_row = this.rows.size();
                this.this_row = null;
                return false;
            }
            this.current_row = n2;
        } else if (n2 < 0) {
            if (this.isBeforeFirst()) {
                this.this_row = null;
                return false;
            }
            n2 = this.cursorPosition == 1 ? this.rows.size() - n2 + 1 : this.rows.size() - n2;
            String string = "MOVE BACKWARD " + n2 + " IN " + this.cursorName;
            this.connection.execSQL(string, this.statement);
            if (this.moveSize < n2 - 1) {
                this.current_row = -1;
                this.rows.clear();
                this.rowBuffer = null;
                this.this_row = null;
                this.cursorPosition = -1;
                return false;
            }
            string = "FETCH FORWARD " + this.fetchSize + " IN " + this.cursorName;
            this.connection.execSQL(string, this.statement);
            this.cursorPosition = this.moveSize < this.fetchSize ? 1 : 0;
            this.current_row = 0;
        } else if (n2 >= this.rows.size()) {
            if (this.cursorPosition == 1) {
                this.current_row = this.rows.size();
                this.this_row = null;
                this.rowBuffer = null;
                return false;
            }
            if ((n2 -= this.rows.size()) > 0) {
                String string = "MOVE FORWARD " + n2 + " IN " + this.cursorName;
                this.connection.execSQL(string, this.statement);
                if (this.moveSize < n2) {
                    this.rows.clear();
                    this.current_row = 0;
                    this.this_row = null;
                    this.rowBuffer = null;
                    this.cursorPosition = 1;
                    return false;
                }
                if (this.moveSize == n2) {
                    string = "FETCH FORWARD " + this.fetchSize + " IN " + this.cursorName;
                    this.connection.execSQL(string, this.statement);
                    this.current_row = 0;
                    if (this.moveSize < this.fetchSize) {
                        this.cursorPosition = 1;
                        if (this.rows.size() == 0) {
                            this.this_row = null;
                            this.rowBuffer = null;
                            return false;
                        }
                    } else {
                        this.cursorPosition = 0;
                    }
                }
            } else {
                String string = "FETCH FORWARD " + this.fetchSize + " IN " + this.cursorName;
                this.connection.execSQL(string, this.statement);
                this.current_row = 0;
                if (this.moveSize < this.fetchSize) {
                    this.cursorPosition = 1;
                    if (this.rows.size() == 0) {
                        this.this_row = null;
                        this.rowBuffer = null;
                        return false;
                    }
                } else {
                    this.cursorPosition = 0;
                }
            }
        } else {
            this.current_row = n2;
        }
        this.this_row = this.rows.get(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    @Override
    public void setFetchDirection(int n2) throws SQLException {
        this.checkClosed();
        if (n2 != 1000 && n2 != 1001 && n2 != 1002) {
            throw new OSQLException("OSCAR-00418", "88888", 408);
        }
        if (this.type == 1003 && n2 != 1000) {
            throw new OSQLException("OSCAR-00418", "88888", 408);
        }
        this.fetchDirection = n2;
    }

    @Override
    public void setFetchSize(int n2) throws SQLException {
        this.checkClosed();
        if (n2 < 0) {
            throw new OSQLException("OSCAR-00307", "88888", 307);
        }
        if (this.maxRows != 0 && n2 > this.maxRows) {
            throw new OSQLException("OSCAR-00307", "88888", 307);
        }
        if (n2 > 0) {
            this.fetchSize = n2;
        }
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        this.checkClosed();
        if (this.doingUpdates) {
            this.doingUpdates = false;
            this.clearRowBuffer();
        }
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        this.checkUpdatable();
        this.checkClosed();
        if (this.onInsertRow) {
            throw new OSQLException("OSCAR-00308", "88888", 308);
        }
        if (this.rows.size() == 0 || this.isBeforeFirst() || this.isAfterLast()) {
            throw new OSQLException("OSCAR-00301", "88888", 301);
        }
        if (this.deleteStatement == null) {
            this.deleteStatement = this.connection.getMasterConnection().createStatement();
        }
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM ").append(this.schemaName).append(".").append(this.tableName).append(" where rowid = ");
        byte[] byArray = this.tidList.get(this.current_row);
        if (this.connection.getProtocolVersion().getProtocolType() >= 2) {
            long l2 = NumberConverter.convertBytesToLong(byArray);
            stringBuffer.append(l2);
        } else {
            stringBuffer.append(this.encoding.decode(byArray));
        }
        int n2 = this.deleteStatement.executeUpdate(stringBuffer.toString());
        if (n2 > 0) {
            this.rows.remove(this.current_row);
            this.tidList.remove(this.current_row);
            --this.current_row;
            this.this_row = null;
        }
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        this.checkUpdatable();
        this.checkClosed();
        if (!this.onInsertRow) {
            throw new OSQLException("OSCAR-00309", "88888", 309);
        }
        Object object = new StringBuilder("INSERT INTO ").append(this.schemaName).append(".").append(this.tableName).append(" (");
        StringBuilder stringBuilder = new StringBuilder(") values (");
        Enumeration<String> enumeration = this.updateValues.keys();
        int n2 = this.updateValues.size();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            ((StringBuilder)object).append(string);
            if (n3 < n2 - 1) {
                ((StringBuilder)object).append(", ");
                stringBuilder.append("?,");
            } else {
                stringBuilder.append("?)");
            }
            ++n3;
        }
        ((StringBuilder)object).append(stringBuilder.toString());
        this.insertStatement = this.connection.getMasterConnection().prepareStatement(((StringBuilder)object).toString());
        Enumeration<String> enumeration2 = this.updateValues.keys();
        int n4 = 1;
        while (enumeration2.hasMoreElements()) {
            object = enumeration2.nextElement();
            if ((object = this.updateValues.get(object)) instanceof NullObject) {
                this.insertStatement.setNull(n4, 0);
            } else {
                this.insertStatement.setObject(n4, object);
            }
            ++n4;
        }
        n4 = this.insertStatement.executeUpdate();
        this.isRowinserted = n4 > 0;
        this.updateRowBuffer();
        if (!this.cursorUsed) {
            int n5 = ((OscarStatement)((Object)this.insertStatement)).getInsertRowid();
            this.tidList.add(this.encoding.encode(String.valueOf(n5)));
            this.rows.add(this.rowBuffer);
        }
        this.insertStatement.close();
        this.this_row = this.rowBuffer;
        this.clearRowBuffer();
        this.onInsertRow = false;
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        this.checkUpdatable();
        this.checkClosed();
        if (this.current_row < 0 || this.current_row >= this.rows.size()) {
            this.this_row = null;
            this.rowBuffer = null;
        } else {
            this.this_row = this.rows.get(this.current_row);
            this.rowBuffer = new byte[this.this_row.length][];
            System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        }
        this.onInsertRow = false;
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        this.checkUpdatable();
        this.checkClosed();
        if (this.insertStatement != null) {
            this.insertStatement = null;
        }
        this.clearRowBuffer();
        this.onInsertRow = true;
    }

    private synchronized void clearRowBuffer() throws SQLException {
        this.rowBuffer = new byte[this.fields.length][];
        this.updateValues.clear();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.isRowDeleted;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.isRowinserted;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.isRowupdated;
    }

    @Override
    public synchronized void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        this.checkUpdatable();
        if (inputStream == null) {
            this.updateNull(n2);
            return;
        }
        byte[] byArray = new byte[n3];
        try {
            inputStream.read(byArray, 0, n3);
            this.updateValue(n2, new String(byArray, "US-ASCII"));
            return;
        }
        catch (IOException iOException) {
            throw new OSQLException("OSCAR-00310", "88888", 310, iOException.getMessage(), iOException);
        }
        catch (Exception exception) {
            throw new OSQLException("OSCAR-00310", "88888", 310, exception);
        }
    }

    @Override
    public synchronized void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.updateValue(n2, bigDecimal);
    }

    @Override
    public synchronized void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkUpdatable();
        if (inputStream == null) {
            this.updateNull(n2);
            return;
        }
        byte[] byArray = new byte[n3];
        try {
            inputStream.read(byArray, 0, n3);
        }
        catch (IOException iOException) {
            throw new OSQLException("OSCAR-00103", "88888", 103, iOException.getMessage(), iOException);
        }
        this.updateBytes(n2, byArray);
    }

    @Override
    public synchronized void updateBoolean(int n2, boolean bl) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.updateValue(n2, bl);
    }

    @Override
    public synchronized void updateByte(int n2, byte by) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.updateValue(n2, by);
    }

    @Override
    public synchronized void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.updateValue(n2, byArray);
    }

    @Override
    public synchronized void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        String string;
        this.checkClosed();
        this.checkIndex(n2);
        this.checkUpdatable();
        if (reader == null) {
            this.updateNull(n2);
            return;
        }
        char[] cArray = new char[n3];
        try {
            int n4 = reader.read(cArray, 0, n3);
            string = new String(cArray, 0, n4);
        }
        catch (IOException iOException) {
            throw new OSQLException("OSCAR-00311", "88888", 311, iOException.getMessage(), iOException);
        }
        this.updateValue(n2, string);
    }

    @Override
    public synchronized void updateDate(int n2, Date date) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.updateValue(n2, date);
    }

    @Override
    public synchronized void updateDouble(int n2, double d2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.updateValue(n2, d2);
    }

    @Override
    public synchronized void updateFloat(int n2, float f2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.updateValue(n2, Float.valueOf(f2));
    }

    @Override
    public synchronized void updateInt(int n2, int n3) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.updateValue(n2, n3);
    }

    @Override
    public synchronized void updateLong(int n2, long l2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.updateValue(n2, l2);
    }

    @Override
    public synchronized void updateNull(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.updateValue(n2, new NullObject());
    }

    @Override
    public synchronized void updateObject(int n2, Object object) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.updateValue(n2, object);
    }

    @Override
    public synchronized void updateObject(int n2, Object object, int n3) throws SQLException {
        if (this.fields[n2 - 1].getSQLType() == 2 || this.fields[n2 - 1].getSQLType() == 3) {
            try {
                if (n3 < -1) {
                    throw new OSQLException("OSCAR-00312", "88888", 312);
                }
                object = new BigDecimal(object.toString()).setScale(n3);
                this.updateObject(n2, object);
                return;
            }
            catch (Exception exception) {
                throw new OSQLException("OSCAR-00707", "88888", 707, exception);
            }
        }
        this.updateObject(n2, object);
    }

    @Override
    public synchronized void refreshRow() throws SQLException {
        this.checkClosed();
        this.checkUpdatable();
        if (this.onInsertRow) {
            throw new OSQLException("OSCAR-00308", "88888", 308);
        }
        if (this.rows.size() == 0 || this.isBeforeFirst() || this.isAfterLast()) {
            throw new OSQLException("OSCAR-00301", "88888", 301);
        }
        try {
            this.updateRowBuffer();
            System.arraycopy(this.rowBuffer, 0, this.this_row, 0, this.rowBuffer.length);
            this.rows.set(this.current_row, this.rowBuffer);
            this.this_row = this.rowBuffer;
            return;
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        this.checkClosed();
        this.checkUpdatable();
        if (this.onInsertRow) {
            throw new OSQLException("OSCAR-00308", "88888", 308);
        }
        if (this.updateValues.isEmpty()) {
            return;
        }
        try {
            Object object2 = new StringBuffer("UPDATE ").append(this.schemaName).append(".").append(this.tableName).append(" SET ");
            int n2 = this.updateValues.size();
            Enumeration<String> enumeration = this.updateValues.keys();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n3 = 0;
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (this.updateValues.get(string) instanceof NullObject) {
                    int n4 = this.findColumn(string) - 1;
                    arrayList.add(n4);
                }
                ((StringBuffer)object2).append(string);
                ((StringBuffer)object2).append(" = ?");
                if (n3 < n2 - 1) {
                    ((StringBuffer)object2).append(", ");
                }
                ++n3;
            }
            if (this.tidList == null) {
                throw new OSQLException("OSCAR-00317", "88888", 317);
            }
            byte[] byArray = this.tidList.get(this.current_row);
            if (this.connection.getProtocolVersion().getProtocolType() >= 2) {
                long l2 = NumberConverter.convertBytesToLong(byArray);
                ((StringBuffer)object2).append(" WHERE rowid = " + l2);
            } else {
                ((StringBuffer)object2).append(" WHERE rowid = " + this.encoding.decode(byArray));
            }
            this.updateStatement = this.connection.getMasterConnection().prepareStatement(((StringBuffer)object2).toString());
            int n5 = 0;
            for (Object object2 : this.updateValues.values()) {
                if (object2 instanceof NullObject) {
                    this.updateStatement.setNull(n5 + 1, 0);
                } else {
                    this.updateStatement.setObject(n5 + 1, object2);
                }
                ++n5;
            }
            int n6 = this.updateStatement.executeUpdate();
            this.isRowupdated = n6 > 0;
            this.updateStatement.close();
            this.updateStatement = null;
            this.updateRowBuffer();
            for (n6 = 0; n6 < this.rowBuffer.length; ++n6) {
                if (this.rowBuffer[n6] != null || arrayList.size() > 0 && arrayList.contains(n6)) continue;
                this.rowBuffer[n6] = this.this_row[n6];
            }
            System.arraycopy(this.rowBuffer, 0, this.this_row, 0, this.rowBuffer.length);
            this.rows.set(this.current_row, this.rowBuffer);
            this.updateValues.clear();
            this.doingUpdates = false;
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            throw sQLException;
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    @Override
    public synchronized void updateShort(int n2, short s2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.updateValue(n2, s2);
    }

    @Override
    public synchronized void updateString(int n2, String string) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.updateValue(n2, string);
    }

    @Override
    public synchronized void updateTime(int n2, Time time) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.updateValue(n2, time);
    }

    @Override
    public synchronized void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.updateValue(n2, timestamp);
    }

    @Override
    public synchronized void updateNull(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateNull(oscarResultSet.findColumn(string));
    }

    @Override
    public synchronized void updateBoolean(String string, boolean bl) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateBoolean(oscarResultSet.findColumn(string), bl);
    }

    @Override
    public synchronized void updateByte(String string, byte by) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateByte(oscarResultSet.findColumn(string), by);
    }

    @Override
    public synchronized void updateShort(String string, short s2) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateShort(oscarResultSet.findColumn(string), s2);
    }

    @Override
    public synchronized void updateInt(String string, int n2) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateInt(oscarResultSet.findColumn(string), n2);
    }

    @Override
    public synchronized void updateLong(String string, long l2) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateLong(oscarResultSet.findColumn(string), l2);
    }

    @Override
    public synchronized void updateFloat(String string, float f2) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateFloat(oscarResultSet.findColumn(string), f2);
    }

    @Override
    public synchronized void updateDouble(String string, double d2) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateDouble(oscarResultSet.findColumn(string), d2);
    }

    @Override
    public synchronized void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateBigDecimal(oscarResultSet.findColumn(string), bigDecimal);
    }

    @Override
    public synchronized void updateString(String string, String string2) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateString(oscarResultSet.findColumn(string), string2);
    }

    @Override
    public synchronized void updateBytes(String string, byte[] byArray) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateBytes(oscarResultSet.findColumn(string), byArray);
    }

    @Override
    public synchronized void updateDate(String string, Date date) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateDate(oscarResultSet.findColumn(string), date);
    }

    @Override
    public synchronized void updateTime(String string, Time time) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateTime(oscarResultSet.findColumn(string), time);
    }

    @Override
    public synchronized void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateTimestamp(oscarResultSet.findColumn(string), timestamp);
    }

    @Override
    public synchronized void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateAsciiStream(oscarResultSet.findColumn(string), inputStream, n2);
    }

    @Override
    public synchronized void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateBinaryStream(oscarResultSet.findColumn(string), inputStream, n2);
    }

    @Override
    public synchronized void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateCharacterStream(oscarResultSet.findColumn(string), reader, n2);
    }

    @Override
    public synchronized void updateObject(String string, Object object, int n2) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateObject(oscarResultSet.findColumn(string), object, n2);
    }

    @Override
    public synchronized void updateObject(String string, Object object) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateObject(oscarResultSet.findColumn(string), object);
    }

    private void updateRowBuffer() throws SQLException {
        Enumeration<String> enumeration = this.updateValues.keys();
        block21: while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            int n2 = this.findColumn((String)object) - 1;
            if ((object = this.updateValues.get(object)) instanceof NullObject) {
                this.rowBuffer[n2] = null;
                continue;
            }
            if (this.connection.getProtocolVersion().getProtocolType() >= 2) {
                boolean bl = this.connection.isNetDataByStr();
                switch (this.connection.getSQLType(this.fields[n2].getDBType())) {
                    case -6: 
                    case 5: {
                        this.rowBuffer[n2] = NumberConverter.convertIntToBytes(((Short)object).intValue());
                        continue block21;
                    }
                    case 4: {
                        this.rowBuffer[n2] = NumberConverter.convertIntToBytes((Integer)object);
                        continue block21;
                    }
                    case -5: {
                        this.rowBuffer[n2] = NumberConverter.convertLongToBytes(((Long)object).intValue());
                        continue block21;
                    }
                    case -7: 
                    case 16: {
                        this.rowBuffer[n2] = BooleanConverter.convertBooleanToBytes(Boolean.parseBoolean(String.valueOf(object)));
                        continue block21;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        object = this.encoding.encode(String.valueOf(object));
                        this.rowBuffer[n2] = this.convertByteArr((byte[])object);
                        continue block21;
                    }
                    case 91: {
                        if (bl) {
                            this.rowBuffer[n2] = this.encoding.encode(String.valueOf(((Date)object).getTime()));
                            continue block21;
                        }
                        this.rowBuffer[n2] = DateConverter.convertDateToBytes((Date)object, this.localCalendar);
                        continue block21;
                    }
                    case 92: {
                        this.rowBuffer[n2] = TimeConverter.convertTimeToBytes((Time)object, this.localCalendar);
                        continue block21;
                    }
                    case 93: {
                        if (bl) {
                            if (object instanceof Timestamp) {
                                this.rowBuffer[n2] = this.encoding.encode(String.valueOf(((Timestamp)object).getTime()));
                                continue block21;
                            }
                            this.rowBuffer[n2] = this.encoding.encode(String.valueOf(((Date)object).getTime()));
                            continue block21;
                        }
                        if (object instanceof Timestamp) {
                            this.rowBuffer[n2] = TimestampConverter.convertTimestampToBytes((Timestamp)object, this.localCalendar);
                            continue block21;
                        }
                        this.rowBuffer[n2] = TimestampConverter.convertTimestampToBytes(new Timestamp(((Date)object).getTime()), this.localCalendar);
                        continue block21;
                    }
                    case 2004: 
                    case 2005: {
                        this.encoding.encode(String.valueOf(object));
                        continue block21;
                    }
                    case 0: {
                        continue block21;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        if (object instanceof byte[]) {
                            this.rowBuffer[n2] = this.connection.getEncoding().encode(OSCARbyte.toOSCARString((byte[])object));
                            continue block21;
                        }
                        this.rowBuffer[n2] = this.connection.getEncoding().encode(String.valueOf(object));
                        continue block21;
                    }
                }
                throw new OSQLException("OSCAR-00411", "88888", 411);
            }
            switch (this.connection.getSQLType(this.fields[n2].getDBType())) {
                case -7: 
                case -6: 
                case -5: 
                case -1: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 16: 
                case 92: {
                    this.rowBuffer[n2] = this.connection.getEncoding().encode(String.valueOf(object));
                    continue block21;
                }
                case 2004: 
                case 2005: {
                    continue block21;
                }
                case 91: {
                    this.rowBuffer[n2] = this.connection.getEncoding().encode(String.valueOf(((Date)object).getTime()));
                    continue block21;
                }
                case 93: {
                    if (object instanceof Timestamp) {
                        this.rowBuffer[n2] = this.connection.getEncoding().encode(String.valueOf(((Timestamp)object).getTime()));
                        continue block21;
                    }
                    this.rowBuffer[n2] = this.connection.getEncoding().encode(String.valueOf(((Date)object).getTime()));
                    continue block21;
                }
                case 0: {
                    continue block21;
                }
                case -4: 
                case -3: 
                case -2: {
                    if (object instanceof byte[]) {
                        this.rowBuffer[n2] = this.connection.getEncoding().encode(OSCARbyte.toOSCARString((byte[])object));
                        continue block21;
                    }
                    this.rowBuffer[n2] = this.connection.getEncoding().encode(String.valueOf(object));
                    continue block21;
                }
            }
            throw new OSQLException("OSCAR-00411", "88888", 411);
        }
    }

    protected byte[] convertByteArr(byte[] byArray) {
        if (byArray != null && byArray.length > 240) {
            byArray = this.convertVarcharData(byArray);
            return byArray;
        }
        return byArray;
    }

    public byte[] convertVarcharData(byte[] byArray) {
        int n2 = byArray.length + 1 + (byArray.length + 240 - 1) / 240 + 1;
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = byArray2;
        byArray2[0] = -2;
        int n3 = 0;
        int n4 = 1;
        int n5 = byArray.length;
        while (true) {
            if (n5 == 240) {
                byArray3[n4] = -16;
                System.arraycopy(byArray, n3, byArray3, ++n4, 240);
                break;
            }
            if (n5 > 240) {
                byArray3[n4] = -16;
                System.arraycopy(byArray, n3, byArray3, ++n4, 240);
                n4 += 240;
            } else {
                byArray3[n4] = (byte)n5;
                System.arraycopy(byArray, n3, byArray3, ++n4, n5);
                break;
            }
            n5 = byArray.length - (n3 += 240);
        }
        byArray3[n2 - 1] = 0;
        return byArray3;
    }

    protected void updateValue(int n2, Object object) throws SQLException {
        this.checkClosed();
        this.checkUpdatable();
        this.checkIndex(n2);
        if (!this.onInsertRow) {
            this.checkNull();
        }
        boolean bl = this.doingUpdates = !this.onInsertRow;
        if (object == null) {
            this.updateNull(n2);
            return;
        }
        this.updateValues.put(this.fields[n2 - 1].getName(), object);
    }

    protected void checkMovable() throws SQLException {
        if (this.type == 1003) {
            throw new OSQLException("OSCAR-00313", "88888", 313);
        }
    }

    protected void checkUpdatable() throws SQLException {
        if (this.concurrency == 1007 || !this.canUpdateable) {
            throw new OSQLException("OSCAR-00314", "88888", 314);
        }
    }

    @Override
    public boolean hasNext() throws SQLException {
        return !this.isLast() && !this.isAfterLast() && this.getTupleCount() > 0;
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateRef(int n2, Ref ref) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public synchronized void updateBlob(int n2, Blob blob) throws SQLException {
        this.updateObject(n2, (Object)blob);
    }

    @Override
    public synchronized void updateBlob(String string, Blob blob) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateBlob(oscarResultSet.findColumn(string), blob);
    }

    @Override
    public synchronized void updateClob(int n2, Clob clob) throws SQLException {
        this.updateObject(n2, (Object)clob);
    }

    @Override
    public synchronized void updateClob(String string, Clob clob) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateClob(oscarResultSet.findColumn(string), clob);
    }

    @Override
    public synchronized void updateArray(int n2, Array array) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public synchronized void updateArray(String string, Array array) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new OscarResultSetMetaData(this.fields, (OscarJdbc2Connection)this.connection);
    }

    @Override
    public void setPlanID(byte[] byArray) {
        this.planID = byArray;
    }

    @Override
    public byte[] getPlanID() {
        return this.planID;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public byte[] getCurrentBlock() {
        System.arraycopy(this.this_row[0], 0, this.this_row[2], 0, 4);
        System.arraycopy(this.this_row[1], 0, this.this_row[2], 4, 4);
        return this.this_row[2];
    }

    @Override
    public void setResultType(boolean bl) {
        this.isOldProtocolResult = bl;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.statement.getResultSetHoldability();
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        return this.getCharacterStream(n2);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(string);
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        Clob clob = this.getClob(n2);
        if (clob == null) {
            return null;
        }
        return (NClob)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{NClob.class}, (InvocationHandler)new NClobInvocationHandler(clob));
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getNClob(oscarResultSet.findColumn(string));
    }

    @Override
    public String getNString(int n2) throws SQLException {
        return this.getString(n2);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getString(string);
    }

    @Override
    public Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        if (map == null || map.isEmpty()) {
            return this.getObject(n2);
        }
        throw Driver.notImplemented();
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        if (map == null || map.isEmpty()) {
            OscarResultSet oscarResultSet = this;
            return oscarResultSet.getObject(oscarResultSet.findColumn(string));
        }
        throw Driver.notImplemented();
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getRowId(oscarResultSet.findColumn(string));
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        String string = this.getString(n2);
        if (string == null) {
            return null;
        }
        return new OscarSQLXML(this.connection, string);
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getSQLXML(oscarResultSet.findColumn(string));
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.updateObject(n2, (Object)new OtherType(inputStream, -1L));
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateAsciiStream(oscarResultSet.findColumn(string), inputStream);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.updateObject(n2, (Object)new OtherType(inputStream, l2));
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateAsciiStream(oscarResultSet.findColumn(string), inputStream, l2);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.updateObject(n2, (Object)new OtherType(inputStream, -1L));
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateBinaryStream(oscarResultSet.findColumn(string), inputStream);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.updateObject(n2, (Object)new OtherType(inputStream, l2));
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateBinaryStream(oscarResultSet.findColumn(string), inputStream, l2);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream) throws SQLException {
        this.updateObject(n2, (Object)new OtherType(inputStream, -1L));
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateBlob(oscarResultSet.findColumn(string), inputStream);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        this.updateObject(n2, (Object)new OtherType(inputStream, l2));
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l2) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateBlob(oscarResultSet.findColumn(string), inputStream, l2);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader) throws SQLException {
        this.updateObject(n2, (Object)new OtherType(reader, -1L));
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateCharacterStream(oscarResultSet.findColumn(string), reader);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.updateObject(n2, (Object)new OtherType(reader, l2));
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l2) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateCharacterStream(oscarResultSet.findColumn(string), reader, l2);
    }

    @Override
    public void updateClob(int n2, Reader reader) throws SQLException {
        this.updateObject(n2, (Object)new OtherType(reader, -1L));
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateClob(oscarResultSet.findColumn(string), reader);
    }

    @Override
    public void updateClob(int n2, Reader reader, long l2) throws SQLException {
        this.updateObject(n2, (Object)new OtherType(reader, l2));
    }

    @Override
    public void updateClob(String string, Reader reader, long l2) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateClob(oscarResultSet.findColumn(string), reader, l2);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNClob(int n2, NClob nClob) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNClob(int n2, Reader reader) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNClob(int n2, Reader reader, long l2) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNClob(String string, Reader reader, long l2) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNString(int n2, String string) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateRowId(int n2, RowId rowId) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        this.updateString(n2, sQLXML.getString());
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        OscarResultSet oscarResultSet = this;
        oscarResultSet.updateSQLXML(oscarResultSet.findColumn(string), sQLXML);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }

    @Override
    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (clazz == null) {
            throw new OSQLException("OSCAR-00319", "88888", 319);
        }
        if (clazz.equals(String.class)) {
            return (T)this.getString(n2);
        }
        if (clazz.equals(BigDecimal.class)) {
            return (T)this.getBigDecimal(n2);
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(this.getBoolean(n2));
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(this.getInt(n2));
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return (T)Long.valueOf(this.getLong(n2));
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return (T)Float.valueOf(this.getFloat(n2));
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return (T)Double.valueOf(this.getDouble(n2));
        }
        if (clazz.equals(byte[].class)) {
            return (T)this.getBytes(n2);
        }
        if (clazz.equals(Date.class)) {
            return (T)this.getDate(n2);
        }
        if (clazz.equals(Time.class)) {
            return (T)this.getTime(n2);
        }
        if (clazz.equals(Timestamp.class)) {
            return (T)this.getTimestamp(n2);
        }
        if (clazz.equals(Clob.class)) {
            return (T)this.getClob(n2);
        }
        if (clazz.equals(Blob.class)) {
            return (T)this.getBlob(n2);
        }
        if (clazz.equals(Array.class)) {
            return (T)this.getArray(n2);
        }
        if (clazz.equals(Ref.class)) {
            return (T)this.getRef(n2);
        }
        if (clazz.equals(URL.class)) {
            return (T)this.getURL(n2);
        }
        if (clazz.equals(Struct.class)) {
            throw Driver.notImplemented();
        }
        if (clazz.equals(RowId.class)) {
            return (T)this.getRowId(n2);
        }
        if (clazz.equals(NClob.class)) {
            return (T)this.getNClob(n2);
        }
        if (clazz.equals(SQLXML.class)) {
            return (T)this.getSQLXML(n2);
        }
        try {
            return (T)this.getObject(n2);
        }
        catch (ClassCastException classCastException) {
            throw new SQLException("Conversion not supported for type " + clazz.getName());
        }
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        OscarResultSet oscarResultSet = this;
        return oscarResultSet.getObject(oscarResultSet.findColumn(string), clazz);
    }

    protected static BaseResultSet getInstance(BaseStatement baseStatement, Field[] fieldArray, List<byte[][]> list, String string, long l2, long l3, int n2, int n3) throws SQLException {
        if (OscarJDBCUtil.isEqualOrGreaterJdbc42()) {
            return (BaseResultSet)OscarJDBCUtil.handleNewInstance(JDBC_4_RS_1_ARG, new Object[]{baseStatement, fieldArray, list, string, l2, l3, n2, n3});
        }
        return new OscarResultSet(baseStatement, fieldArray, list, string, l2, l3, n2, n3);
    }

    protected static BaseResultSet getInstanceDataKind(BaseStatement baseStatement, Field[] fieldArray, List<byte[][]> list, String string, long l2, long l3, int n2, int n3, int n4) throws SQLException {
        if (OscarJDBCUtil.isEqualOrGreaterJdbc42()) {
            return (BaseResultSet)OscarJDBCUtil.handleNewInstance(JDBC_4_RS_2_ARG, new Object[]{baseStatement, fieldArray, list, string, l2, l3, n2, n3, n4});
        }
        return new OscarResultSet(baseStatement, fieldArray, list, string, l2, l3, n2, n3, n4);
    }

    protected static BaseResultSet getInstanceV2(BaseStatement baseStatement, BaseConnection baseConnection, boolean bl, boolean bl2, int n2, int n3, boolean bl3, int n4, Encoding encoding, String string, Field[] fieldArray, List<byte[][]> list, String string2, long l2, long l3, int n5, int n6) throws SQLException {
        if (OscarJDBCUtil.isEqualOrGreaterJdbc42()) {
            return (BaseResultSet)OscarJDBCUtil.handleNewInstance(JDBC_4_RS_1_ARG_V2, new Object[]{baseStatement, baseConnection, bl, bl2, n2, n3, bl3, n4, encoding, string, fieldArray, list, string2, l2, l3, n5, n6});
        }
        return new OscarResultSetV2(baseStatement, baseConnection, bl, bl2, n2, n3, bl3, n4, encoding, string, fieldArray, list, string2, l2, l3, n5, n6);
    }

    protected static BaseResultSet getInstanceV2CallableStatement(BaseStatement baseStatement, Field[] fieldArray, List<byte[][]> list, String string, long l2, long l3, int n2, int n3) throws SQLException {
        if (OscarJDBCUtil.isEqualOrGreaterJdbc42()) {
            return (BaseResultSet)OscarJDBCUtil.handleNewInstance(JDBC_4_RS_2_ARG_V2, new Object[]{baseStatement, fieldArray, list, string, l2, l3, n2, n3});
        }
        return new OscarResultSetV2(baseStatement, fieldArray, list, string, l2, l3, n2, n3);
    }

    @Override
    public void setType(int n2) {
        this.type = n2;
    }

    static {
        if (OscarJDBCUtil.isEqualOrGreaterJdbc4()) {
            try {
                String string = OscarJDBCUtil.isEqualOrGreaterJdbc42() ? "com.oscar.jdbc.Oscar42ResultSetV2" : "com.oscar.jdbc.OscarResultSetV2";
                JDBC_4_RS_1_ARG_V2 = Class.forName(string).getConstructor(BaseStatement.class, BaseConnection.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Encoding.class, String.class, Field[].class, List.class, String.class, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE);
                JDBC_4_RS_2_ARG_V2 = Class.forName(string).getConstructor(BaseStatement.class, Field[].class, List.class, String.class, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE);
                string = OscarJDBCUtil.isEqualOrGreaterJdbc42() ? "com.oscar.jdbc.Oscar42ResultSet" : "com.oscar.jdbc.OscarResultSet";
                JDBC_4_RS_1_ARG = Class.forName(string).getConstructor(BaseStatement.class, Field[].class, List.class, String.class, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE);
                JDBC_4_RS_2_ARG = Class.forName(string).getConstructor(BaseStatement.class, Field[].class, List.class, String.class, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (RuntimeException runtimeException) {
                RuntimeException runtimeException2 = runtimeException;
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else {
            JDBC_4_RS_1_ARG = null;
            JDBC_4_RS_2_ARG = null;
            JDBC_4_RS_1_ARG_V2 = null;
            JDBC_4_RS_2_ARG_V2 = null;
        }
    }

    static class NullObject {
        NullObject() {
        }
    }
}

