/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.core.Field;
import com.oscar.core.FieldMetadata;
import com.oscar.jdbc.OscarJdbc2Connection;
import com.oscar.protocol.ProtocolVersion;
import com.oscar.util.OSQLException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class OscarResultSetMetaData
implements ResultSetMetaData {
    private Field[] fields;
    protected OscarJdbc2Connection connection;
    protected boolean rsDateWithHMS;
    protected final int compatableDbms;
    private boolean fieldInfoFetched = false;
    private boolean useColumnLabel = true;
    private boolean useAttributedef = false;

    public OscarResultSetMetaData(Field[] fieldArray) {
        this.fields = fieldArray == null ? new Field[0] : fieldArray;
        this.compatableDbms = 0;
    }

    public OscarResultSetMetaData(Field[] object, OscarJdbc2Connection oscarJdbc2Connection) {
        this.fields = object == null ? new Field[0] : object;
        this.connection = oscarJdbc2Connection;
        object = oscarJdbc2Connection.getConnectionProperties();
        this.rsDateWithHMS = Boolean.parseBoolean(((Properties)object).getProperty("RSDATEWITHHMS", "false"));
        this.compatableDbms = Integer.parseInt(((Properties)object).getProperty("COMPATABLE_DBMS", "0"));
        this.useColumnLabel = Boolean.parseBoolean(((Properties)object).getProperty("USECOLUMNLABEL", "TRUE"));
        this.useAttributedef = Boolean.parseBoolean(((Properties)object).getProperty("USEATTRIBUTEDEF", "FALSE"));
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.fields.length;
    }

    @Override
    public boolean isAutoIncrement(int n2) throws SQLException {
        this.getFieldMetaData();
        Object object = this.getField(n2);
        object = ((Field)object).getMetadata();
        return object != null && ((FieldMetadata)object).isAutoIncrement();
    }

    private void getFieldMetaData() throws SQLException {
        Object object;
        if (this.fieldInfoFetched) {
            return;
        }
        OscarResultSetMetaData oscarResultSetMetaData = this;
        if (oscarResultSetMetaData.populateFieldsWithMetadata(oscarResultSetMetaData.connection.getFieldMetadataCache())) {
            return;
        }
        Object object3 = this.connection.getProtocolVersion();
        StringBuilder stringBuilder = new StringBuilder("SELECT c.oid, a.attnum, a.attname, c.relname, n.nspname, t.typname, ");
        stringBuilder.append(this.useAttributedef ? "a.adsrc," : "d.adsrc, ").append(" a.attnotnull, ");
        if (!((ProtocolVersion)object3).isMpp5() && !((ProtocolVersion)object3).isKstore() && this.connection.isSupportAuto()) {
            stringBuilder.append(" a.attisauto ");
        } else {
            stringBuilder.append(" 'false' attisauto ");
        }
        stringBuilder.append("FROM INFO_SCHEM.v_sys_class c \nJOIN INFO_SCHEM.v_sys_namespace n ON (c.relnamespace = n.oid) \n");
        if (this.useAttributedef) {
            stringBuilder.append("JOIN INFO_SCHEM.v_sys_attributedef a ON (c.oid = a.attrelid) \n");
            stringBuilder.append("JOIN INFO_SCHEM.v_sys_type t ON (a.atttypid = t.oid) \n");
        } else {
            stringBuilder.append("JOIN INFO_SCHEM.v_sys_attribute a ON (c.oid = a.attrelid) \n");
            stringBuilder.append("JOIN INFO_SCHEM.v_sys_type t ON (a.atttypid = t.oid) \n");
            stringBuilder.append("LEFT JOIN INFO_SCHEM.v_sys_attrdef d ON (d.adrelid = a.attrelid AND d.adnum = a.attnum) \n");
        }
        stringBuilder.append("WHERE c.oid in (");
        object3 = new HashMap();
        Field[] fieldArray = this.fields;
        int n2 = this.fields.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Field object22 = fieldArray[i2];
            if (object22.getMetadata() != null || object3.containsKey(object = object22.getSchemaName() + "_" + object22.getTableName())) continue;
            object3.put(object, object22);
        }
        int n3 = 0;
        Set set = object3.entrySet();
        for (Map.Entry entry : set) {
            if (n3 != 0) {
                stringBuilder.append(" , ");
            }
            object = (Field)entry.getValue();
            stringBuilder.append(this.getTableOid(((Field)object).getSchemaName(), ((Field)object).getTableName()));
            if (n3 != 0) continue;
            n3 = 1;
        }
        stringBuilder.append(" ) AND a.attnum>0 AND ATTISDROPPED = false");
        if (n3 == 0) {
            this.fieldInfoFetched = true;
            return;
        }
        HashMap<FieldMetadata.Key, FieldMetadata> hashMap = new HashMap<FieldMetadata.Key, FieldMetadata>();
        try (Object object4 = null;){
            block21: {
                try {
                    object4 = this.connection.execSQL(stringBuilder.toString());
                }
                catch (SQLException sQLException) {
                    object = sQLException;
                    if (sQLException.getMessage() == null) break block21;
                    if (((Throwable)object).getMessage().toUpperCase().contains("V_SYS_ATTRIBUTEDEF")) {
                        int n4 = stringBuilder.indexOf("INFO_SCHEM.v_sys_attributedef");
                        n3 = stringBuilder.indexOf("WHERE c.oid");
                        StringBuilder stringBuilder2 = stringBuilder;
                        stringBuilder2.replace(stringBuilder2.indexOf("a.adsrc"), stringBuilder.indexOf("a.adsrc") + 7, "d.adsrc");
                        stringBuilder.replace(n4, n3, "INFO_SCHEM.v_sys_attribute a ON (c.oid = a.attrelid) \n JOIN INFO_SCHEM.v_sys_type t ON (a.atttypid = t.oid) \nLEFT JOIN INFO_SCHEM.v_sys_attrdef d ON (d.adrelid = a.attrelid AND d.adnum = a.attnum) ");
                        object4 = this.connection.execSQL(stringBuilder.toString());
                    }
                    if (((Throwable)object).getMessage() == null || !((Throwable)object).getMessage().toUpperCase().contains("ATTISAUTO")) break block21;
                    this.connection.setSupportAuto(false);
                    object4 = this.connection.execSQL(stringBuilder.toString().replace("a.attisauto", "'false' attisauto"));
                }
            }
            if (object4 != null) {
                while (object4.next()) {
                    Object object2;
                    Object object5;
                    object = object4.getString(3);
                    String string = object4.getString(4);
                    String string2 = object4.getString(5);
                    int n5 = object4.getBoolean(8) ? 0 : 1;
                    boolean bl = object4.getBoolean(9);
                    if (!bl) {
                        object5 = object4.getString(7);
                        object2 = object4.getString(6);
                        if (object5 != null && object2 != null && ((String)object5).startsWith("NEXTVAL") && (((String)object2).equals("INT4") || ((String)object2).equals("INT8"))) {
                            bl = true;
                        }
                    }
                    object5 = new FieldMetadata((String)object, string, string2, n5, bl);
                    object2 = new FieldMetadata.Key(string2, string, (String)object);
                    hashMap.put((FieldMetadata.Key)object2, (FieldMetadata)object5);
                }
            }
        }
        this.populateFieldsWithMetadata(hashMap);
        this.connection.getFieldMetadataCache().putAll(hashMap);
    }

    private boolean populateFieldsWithMetadata(Map<FieldMetadata.Key, FieldMetadata> map) {
        boolean bl = true;
        Field[] fieldArray = this.fields;
        int n2 = this.fields.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Field field = fieldArray[i2];
            if (field.getMetadata() != null) continue;
            FieldMetadata fieldMetadata = map.get(new FieldMetadata.Key(field.getSchemaName(), field.getTableName(), field.getAliasName()));
            if (fieldMetadata == null) {
                bl = false;
                continue;
            }
            field.setMetadata(fieldMetadata);
        }
        this.fieldInfoFetched |= bl;
        return bl;
    }

    private String getTableOid(String string, String string2) {
        return "INFO_SCHEM.sys_get_relid('" + string + "', '" + string2 + "')";
    }

    @Override
    public boolean isCaseSensitive(int n2) throws SQLException {
        n2 = this.getField(n2).getSQLType();
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 2004: {
                return false;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isSearchable(int n2) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int n2) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int n2) throws SQLException {
        return this.getField(n2).isNullable();
    }

    @Override
    public boolean isSigned(int n2) throws SQLException {
        n2 = this.getField(n2).getSQLType();
        switch (n2) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return false;
    }

    @Override
    public int getColumnDisplaySize(int n2) throws SQLException {
        Field field = this.getField(n2);
        int n3 = field.getMod();
        switch (field.getSQLType()) {
            case -6: {
                return 4;
            }
            case 5: {
                return 6;
            }
            case 4: {
                return 11;
            }
            case -5: {
                return 20;
            }
            case 7: {
                return 14;
            }
            case 6: 
            case 8: {
                return 24;
            }
            case -7: {
                if (n3 == -1) {
                    return 1;
                }
                return n3;
            }
            case 16: {
                return 1;
            }
            case 2: 
            case 3: {
                int n4 = n3 >> 16 & 0xFFFF;
                return n4 + 2;
            }
            case 1: 
            case 12: {
                if (field.getOID() == 18) {
                    return n3;
                }
                if (n3 == -1) {
                    return 8000;
                }
                return n3 - 4;
            }
            case -1: {
                return 8000;
            }
            case -3: 
            case -2: {
                if (n3 == -1) {
                    return 1;
                }
                return n3 - 4;
            }
            case -4: {
                return 8000;
            }
            case 2004: 
            case 2005: {
                return Integer.MAX_VALUE;
            }
            case 91: {
                return 10;
            }
            case 92: {
                if (n3 == -1) {
                    return 18;
                }
                return n3;
            }
            case 93: {
                if (n3 == -1) {
                    return 29;
                }
                return n3;
            }
        }
        return 0;
    }

    @Override
    public String getColumnLabel(int n2) throws SQLException {
        return this.getField(n2).getAliasNameCase();
    }

    @Override
    public String getColumnName(int n2) throws SQLException {
        if (this.useColumnLabel) {
            return this.getColumnLabel(n2);
        }
        String string = this.getField(n2).getNameCase();
        if (string == null || string.isEmpty()) {
            return this.getColumnLabel(n2);
        }
        return string;
    }

    @Override
    public String getSchemaName(int n2) throws SQLException {
        return this.getField(n2).getSchemaName();
    }

    @Override
    public int getPrecision(int n2) throws SQLException {
        Field field = this.getField(n2);
        int n3 = field.getSQLType();
        switch (n3) {
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case -5: {
                return 19;
            }
            case 7: {
                return 8;
            }
            case 6: 
            case 8: {
                return 15;
            }
            case -7: {
                return field.getMod();
            }
            case 16: {
                return 0;
            }
            case 2: 
            case 3: {
                if (field.getMod() == -1) {
                    if (this.compatableDbms == 1) {
                        return 0;
                    }
                    return 18;
                }
                return 0xFFFF & field.getMod() - 4 >> 16;
            }
            case 1: 
            case 12: {
                if (1186 == field.getOID() || 1188 == field.getOID()) {
                    return (0xFF00 & field.getMod()) >> 8;
                }
                return this.getColumnDisplaySize(n2);
            }
            case -3: 
            case -2: {
                return this.getColumnDisplaySize(n2);
            }
            case -4: 
            case -1: 
            case 2004: 
            case 2005: {
                return 0;
            }
            case 91: {
                return 8;
            }
            case 92: {
                return 15;
            }
            case 93: {
                return 23;
            }
        }
        return 0;
    }

    @Override
    public int getScale(int n2) throws SQLException {
        Field field = this.getField(n2);
        int n3 = field.getSQLType();
        switch (n3) {
            case 2: 
            case 3: {
                if (field.getMod() == -1) {
                    return 0;
                }
                return (short)(0xFFFF & field.getMod() - 4);
            }
            case 1188: {
                return 0xFF & field.getMod();
            }
        }
        if (1188 == field.getOID()) {
            return 0xFF & field.getMod();
        }
        return 0;
    }

    @Override
    public String getTableName(int n2) throws SQLException {
        return this.getField(n2).getTableName();
    }

    @Override
    public String getCatalogName(int n2) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int n2) throws SQLException {
        if ((n2 = this.getField(n2).getSQLType()) == 91 && this.rsDateWithHMS) {
            return 93;
        }
        return n2;
    }

    @Override
    public String getColumnTypeName(int n2) throws SQLException {
        return this.getField(n2).getDBType();
    }

    @Override
    public boolean isReadOnly(int n2) throws SQLException {
        return !this.isWritable(n2);
    }

    @Override
    public boolean isWritable(int n2) throws SQLException {
        return this.getField(n2).isUpdatable();
    }

    @Override
    public boolean isDefinitelyWritable(int n2) throws SQLException {
        return false;
    }

    protected Field getField(int n2) throws SQLException {
        if (n2 <= 0 || n2 > this.fields.length) {
            throw new OSQLException("OSCAR-00305", "88888", 305);
        }
        return this.fields[n2 - 1];
    }

    @Override
    public String getColumnClassName(int n2) throws SQLException {
        switch (this.getField(n2).getSQLType()) {
            case -6: 
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 6: 
            case 8: {
                return "java.lang.Double";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case -7: 
            case 16: {
                return "java.lang.Boolean";
            }
            case -1: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case -4: 
            case -3: 
            case -2: {
                return "[B";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case 2004: {
                return "java.sql.Blob";
            }
            case 2005: {
                return "java.sql.Clob";
            }
            case 2002: {
                return "java.sql.Struct";
            }
            case 2006: {
                return "java.sql.Ref";
            }
            case 2003: {
                return "java.sql.Array";
            }
            case 70: {
                return "java.net.URL";
            }
            case 1111: {
                Object object = this.getColumnTypeName(n2);
                object = this.connection.getOscarObject((String)object);
                if (object != null) {
                    return ((Class)object).getName();
                }
                return "java.lang.String";
            }
        }
        throw new OSQLException("OSCAR-00411", "88888", 411);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isAssignableFrom(this.getClass());
    }
}

