/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseStatement;
import com.oscar.core.Encoding;
import com.oscar.core.Field;
import com.oscar.jdbc.OscarBlob;
import com.oscar.jdbc.OscarClob;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.protocol.b;
import com.oscar.sql.Time;
import com.oscar.util.OSCARbyte;
import com.oscar.util.OSQLException;
import com.oscar.util.converter.BooleanConverter;
import com.oscar.util.converter.DateConverter;
import com.oscar.util.converter.IntervalConverter;
import com.oscar.util.converter.NumberConverter;
import com.oscar.util.converter.RowidConverter;
import com.oscar.util.converter.TimestampConverter;
import com.oscar.util.converter.TimestamptzConverter;
import com.oscar.util.converter.TimetzConverter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;

public class OscarResultSetV2
extends OscarResultSet {
    private boolean netDataByStr;
    private boolean numericKeepPrecision;

    public OscarResultSetV2(BaseStatement baseStatement, BaseConnection baseConnection, boolean bl, boolean bl2, int n2, int n3, boolean bl3, int n4, Encoding encoding, String string, Field[] fieldArray, List<byte[][]> list, String string2, long l2, long l3, int n5, int n6) {
        super(baseStatement, baseConnection, n2, n3, bl3, n4, string, fieldArray, list, string2, l2, l3, n5, n6);
        this.netDataByStr = false;
        this.numericKeepPrecision = true;
        this.netDataByStr = bl;
        this.numericKeepPrecision = bl2;
        this.encoding = encoding;
    }

    public OscarResultSetV2(BaseStatement baseStatement, Field[] fieldArray, List<byte[][]> list, String string, long l2, long l3, int n2, int n3) throws SQLException {
        BaseStatement baseStatement2 = baseStatement;
        super(baseStatement2, baseStatement2.getDBConnection(), baseStatement.getResultSetType(), baseStatement.getResultSetConcurrency(), baseStatement.getResultSetCanUpdateable(), baseStatement.getFetchDirection(), baseStatement.getCursorName(), fieldArray, list, string, l2, l3, baseStatement.getFetchSize(), n3);
        this.netDataByStr = false;
        this.numericKeepPrecision = true;
        this.netDataByStr = this.connection.isNetDataByStr();
        this.numericKeepPrecision = this.connection.isNumericKeepPrecision();
    }

    @Override
    public void close() throws SQLException {
        if (this.type != 1003 || this.concurrency != 1007) {
            super.close();
            return;
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            if (this.cursorUsed && this.connection != null && !((Connection)((Object)this.connection)).isClosed()) {
                int n2 = this.connection.checkPlanID(this.planID);
                if (n2 >= 0) {
                    ((b)this.connection.getProtocol()).a(null, null, null, null, this.planID, this.fetchSize, this.maxRows, true, false, this.statement, false);
                    this.connection.removePlanID(n2);
                }
                try {
                    if (this.connection.hasCursor(this.cursorName)) {
                        String string = "CLOSE " + this.cursorName + ";DEALLOCATE " + this.cursorName;
                        this.connection.execSQL(string, this.statement);
                        this.connection.removeCursor(this.cursorName);
                    }
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    Driver.writeLog(exception);
                }
            }
            this.rows = null;
            this.encoding = null;
            this.fields = null;
            this.status = null;
            this.this_row = null;
            this.tidList = null;
            this.tidField = null;
            this.warnings = null;
            this.next = null;
            this.sbuf = null;
            this.rowBuffer = null;
            this.updateValues = null;
            this.connection = null;
            this.cursorName = null;
            this.closed = true;
            this.deleteStatement = null;
            this.columnNameIndexMap = null;
            return;
        }
        finally {
            if (this.statement != null) {
                this.statement.checkAndPerformCloseOnCompletionAction();
            }
            this.statement = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized boolean next() throws SQLException {
        block11: {
            if (this.isOldProtocolResult || this.type != 1003 || this.concurrency != 1007) {
                return super.next();
            }
            this.checkClosed();
            if (this.maxRows > 0 && this.maxRowsCopy <= 0) {
                this.cursorPosition = 1;
                return false;
            }
            this.updateValues.clear();
            if (!this.cursorUsed && this.current_row == this.rows.size()) {
                this.this_row = null;
                return false;
            }
            if (this.cursorPosition == 1 && this.current_row == this.rows.size()) {
                this.this_row = null;
                return false;
            }
            if (++this.current_row < this.rows.size()) break block11;
            if (!this.cursorUsed) {
                this.this_row = null;
                return false;
            }
            if (this.cursorPosition == 1) {
                this.this_row = null;
                return false;
            }
            var1_1 = 0;
            if (this.maxRows > 0) {
                var1_1 = this.maxRowsCopy;
            }
            if (this.planID == null) ** GOTO lbl-1000
            ((b)this.connection.getProtocol()).a(null, null, null, null, this.planID, this.fetchSize, var1_1, false, false, this.statement, this, false, 0);
            if (this.moveSize >= this.fetchSize) {
                this.cursorPosition = 0;
            } else lbl-1000:
            // 2 sources

            {
                this.cursorPosition = 1;
            }
            this.current_row = 0;
            if (this.rows.size() == 0) {
                this.this_row = null;
                this.rowBuffer = null;
                return false;
            }
        }
        if (this.maxRows > 0) {
            --this.maxRowsCopy;
        }
        this.this_row = this.rows.get(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    @Override
    public String getString(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        if (this.netDataByStr) {
            return super.getString(n2);
        }
        OscarResultSetV2 oscarResultSetV2 = this;
        return oscarResultSetV2.getStringValue(oscarResultSetV2.this_row[n2 - 1], this.getOscarType(n2));
    }

    @Override
    protected String getFixedString(int n2) throws SQLException {
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        if (this.netDataByStr) {
            return super.getFixedString(n2);
        }
        OscarResultSetV2 oscarResultSetV2 = this;
        return oscarResultSetV2.getStringValue(oscarResultSetV2.this_row[n2 - 1], this.getOscarType(n2));
    }

    private String getStringValue(byte[] object, int n2) throws SQLException {
        if (object == null) {
            return null;
        }
        if (((byte[])object).length == 2 && object[0] == -3) {
            if (object[1] == 1) {
                return "NaN";
            }
            if (object[1] == 2) {
                return "infinity";
            }
            if (object[1] == 3) {
                return "-infinity";
            }
        }
        switch (n2) {
            case 35: {
                return this.encoding.decode((byte[])object);
            }
            case 51: {
                OscarClob oscarClob = this.connection.getClobInstance(this.connection.getEncoding().decode((byte[])object));
                object = oscarClob;
                long l2 = oscarClob.length();
                if (l2 > Integer.MAX_VALUE) {
                    throw new OSQLException("OSCAR-00316", "22000", 316);
                }
                return object.getSubString(1L, (int)l2);
            }
            case 33: {
                return String.valueOf(BooleanConverter.convertToBoolean((byte[])object));
            }
            case 25: {
                return DateConverter.convertBytesToDateString((byte[])object);
            }
            case 34: {
                if (this.numericKeepPrecision) {
                    return this.encoding.decode((byte[])object);
                }
                String string = String.valueOf(NumberConverter.convertBytesToDouble((byte[])object));
                object = string;
                if (string.endsWith(".0") && ((String)object).length() > 2) {
                    return ((String)object).substring(0, ((String)object).length() - 2);
                }
                return object;
            }
            case 31: {
                return IntervalConverter.convertToIntervalDTS((byte[])object);
            }
            case 30: {
                return IntervalConverter.convertToIntervalYTM((byte[])object);
            }
            case 23: {
                return String.valueOf(NumberConverter.convertBytesToLong((byte[])object));
            }
            case 32: {
                return String.valueOf(RowidConverter.convertToRowID((byte[])object));
            }
            case 26: {
                return TimetzConverter.convertBytesToTimeString((byte[])object);
            }
            case 28: {
                return TimestampConverter.convertBytesToTimeStamp((byte[])object).stringValue();
            }
            case 29: {
                return TimestamptzConverter.convertBytesToTimeStamp((byte[])object).stringValue();
            }
            case 27: {
                return TimetzConverter.convertBytesToTimeZoneString((byte[])object);
            }
            case 24: 
            case 2003: {
                return this.encoding.decode((byte[])object);
            }
        }
        return this.encoding.decode((byte[])object);
    }

    @Override
    public int getInt(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return 0;
        }
        if (this.netDataByStr) {
            return super.getInt(n2);
        }
        switch (this.getOscarType(n2)) {
            case 34: {
                if (this.numericKeepPrecision) {
                    String string = this.fields[n2 - 1].getDBType();
                    String string2 = this.encoding.decode(this.this_row[n2 - 1]);
                    if (string.equalsIgnoreCase("float") || string.startsWith("double")) {
                        double d2 = Double.parseDouble(string2);
                        if (d2 < -2.147483648E9 || d2 > 2.147483647E9) {
                            throw new OSQLException("OSCAR-00719", "88888", 719);
                        }
                        return (int)d2;
                    }
                    if (string.equalsIgnoreCase("decimal") || string.equalsIgnoreCase("numeric")) {
                        BigDecimal bigDecimal = new BigDecimal(string2);
                        if (bigDecimal.compareTo(BIG_DECIMAL_MIN_INTEGER_VALUE) < 0 || bigDecimal.compareTo(BIG_DECIMAL_MAX_INTEGER_VALUE) > 0) {
                            throw new OSQLException("OSCAR-00719", "88888", 719);
                        }
                        return bigDecimal.intValue();
                    }
                    return Integer.parseInt(string2);
                }
                return (int)NumberConverter.convertBytesToDouble(this.this_row[n2 - 1]);
            }
            case 23: {
                return (int)NumberConverter.convertBytesToLong(this.this_row[n2 - 1]);
            }
        }
        return super.getInt(n2);
    }

    @Override
    public long getLong(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return 0L;
        }
        if (this.netDataByStr) {
            return super.getLong(n2);
        }
        switch (this.getOscarType(n2)) {
            case 34: {
                if (this.numericKeepPrecision) {
                    String string = this.fields[n2 - 1].getDBType();
                    Object object = this.encoding.decode(this.this_row[n2 - 1]);
                    if (string.equalsIgnoreCase("decimal") || string.equalsIgnoreCase("numeric") || string.startsWith("double")) {
                        if (((BigDecimal)(object = new BigDecimal((String)object))).compareTo(BIG_DECIMAL_MIN_LONG_VALUE) < 0 || ((BigDecimal)object).compareTo(BIG_DECIMAL_MAX_LONG_VALUE) > 0) {
                            throw new OSQLException("OSCAR-00718", "88888", 718);
                        }
                        return ((BigDecimal)object).longValue();
                    }
                    if (string.equalsIgnoreCase("float")) {
                        return (long)Double.parseDouble((String)object);
                    }
                    return Long.parseLong((String)object);
                }
                return (long)NumberConverter.convertBytesToDouble(this.this_row[n2 - 1]);
            }
            case 23: {
                return NumberConverter.convertBytesToLong(this.this_row[n2 - 1]);
            }
        }
        return super.getLong(n2);
    }

    @Override
    public float getFloat(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return 0.0f;
        }
        if (this.netDataByStr) {
            return super.getFloat(n2);
        }
        switch (this.getOscarType(n2)) {
            case 34: {
                if (this.numericKeepPrecision) {
                    return Float.parseFloat(this.encoding.decode(this.this_row[n2 - 1]));
                }
                return (float)NumberConverter.convertBytesToDouble(this.this_row[n2 - 1]);
            }
            case 23: {
                return NumberConverter.convertBytesToLong(this.this_row[n2 - 1]);
            }
        }
        return super.getFloat(n2);
    }

    @Override
    public double getDouble(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return 0.0;
        }
        if (this.netDataByStr) {
            return super.getDouble(n2);
        }
        if (this.this_row[n2 - 1].length == 2 && this.this_row[n2 - 1][0] == -3) {
            if (this.this_row[n2 - 1][1] == 1) {
                return Double.NaN;
            }
            if (this.this_row[n2 - 1][1] == 2) {
                return Double.POSITIVE_INFINITY;
            }
            if (this.this_row[n2 - 1][1] == 3) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        switch (this.getOscarType(n2)) {
            case 34: {
                if (this.numericKeepPrecision) {
                    return Double.parseDouble(this.encoding.decode(this.this_row[n2 - 1]));
                }
                return NumberConverter.convertBytesToDouble(this.this_row[n2 - 1]);
            }
            case 23: {
                return NumberConverter.convertBytesToLong(this.this_row[n2 - 1]);
            }
        }
        return super.getDouble(n2);
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        if (this.netDataByStr) {
            return super.getBytes(n2);
        }
        switch (this.getOscarType(n2)) {
            case 24: {
                if (this.encodingFlag) {
                    return this.this_row[n2 - 1];
                }
                return this.clientEncoding.encode(this.encoding.decode(this.this_row[n2 - 1]));
            }
            case 2003: {
                if (this.encodingFlag) {
                    return this.this_row[n2 - 1];
                }
                return this.clientEncoding.encode(this.encoding.decode(this.this_row[n2 - 1]));
            }
            case 50: {
                OscarBlob oscarBlob = this.connection.getBlobInstance(new String(this.this_row[n2 - 1]));
                long l2 = oscarBlob.length();
                if (l2 > Integer.MAX_VALUE) {
                    throw new OSQLException("OSCAR-00316", "22000", 316);
                }
                return oscarBlob.getBytes(1L, (int)l2);
            }
            case 35: {
                if (this.encodingFlag) {
                    return OSCARbyte.toBytes(this.this_row[n2 - 1]);
                }
                return OSCARbyte.toBytes(this.clientEncoding.encode(this.encoding.decode(this.this_row[n2 - 1])));
            }
        }
        return this.clientEncoding.encode(((OscarResultSet)this).getString(n2));
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        if (this.netDataByStr) {
            return super.getTimestamp(n2);
        }
        switch (this.getOscarType(n2)) {
            case 26: 
            case 27: {
                Time time = TimetzConverter.convertBytesToTime(this.this_row[n2 - 1]);
                Timestamp timestamp = new Timestamp(time.getTime());
                timestamp.setNanos(time.getNanos());
                return timestamp;
            }
            case 28: {
                com.oscar.sql.Timestamp timestamp = TimestampConverter.convertBytesToTimeStamp(this.this_row[n2 - 1]);
                Timestamp timestamp2 = new Timestamp(timestamp.getTime());
                timestamp2.setNanos(timestamp.getNanos());
                return timestamp2;
            }
            case 29: {
                com.oscar.sql.Timestamp timestamp = TimestamptzConverter.convertBytesToTimeStamp(this.this_row[n2 - 1]);
                Timestamp timestamp3 = new Timestamp(timestamp.getTime());
                timestamp3.setNanos(timestamp.getNanos());
                return timestamp3;
            }
        }
        return super.getTimestamp(n2);
    }

    public Timestamp getOscarTimestamp(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        if (this.netDataByStr) {
            return super.getTimestamp(n2);
        }
        switch (this.getOscarType(n2)) {
            case 26: {
                return new Timestamp(TimetzConverter.convertBytesToTime(this.this_row[n2 - 1]).getTime());
            }
            case 28: {
                return TimestampConverter.convertBytesToTimeStamp(this.this_row[n2 - 1]);
            }
            case 29: {
                return TimestamptzConverter.convertBytesToTimeStamp(this.this_row[n2 - 1]);
            }
            case 27: {
                return new Timestamp(TimetzConverter.convertBytesToTime(this.this_row[n2 - 1]).getTime());
            }
        }
        return super.getTimestamp(n2);
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar comparable) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        if (this.netDataByStr) {
            return super.getTimestamp(n2, (Calendar)comparable);
        }
        switch (this.getOscarType(n2)) {
            case 26: {
                return new Timestamp(TimetzConverter.convertBytesToTime(this.this_row[n2 - 1], comparable).getTime());
            }
            case 28: 
            case 29: {
                com.oscar.sql.Timestamp timestamp = (com.oscar.sql.Timestamp)TimestamptzConverter.convertBytesToTimeStamp(this.this_row[n2 - 1], comparable);
                comparable = new Timestamp(timestamp.getTime());
                ((Timestamp)comparable).setNanos(timestamp.getNanos());
                return comparable;
            }
            case 27: {
                return new Timestamp(TimetzConverter.convertBytesToTime(this.this_row[n2 - 1], comparable).getTime());
            }
        }
        return super.getTimestamp(n2, (Calendar)comparable);
    }

    @Override
    protected java.sql.Time getOscarTime(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2);
        this.checkNull();
        if (this.this_row[n2 - 1] == null) {
            return null;
        }
        if (this.netDataByStr) {
            return super.getTime(n2);
        }
        switch (this.getOscarType(n2)) {
            case 26: {
                return new java.sql.Time(TimetzConverter.convertBytesToTime(this.this_row[n2 - 1]).getTime());
            }
            case 28: {
                return new java.sql.Time(TimestampConverter.convertBytesToTimeStamp(this.this_row[n2 - 1]).getTime());
            }
            case 29: {
                return new java.sql.Time(TimestamptzConverter.convertBytesToTimeStamp(this.this_row[n2 - 1]).getTime());
            }
            case 27: {
                return TimetzConverter.convertBytesToTime(this.this_row[n2 - 1]);
            }
        }
        return super.getTime(n2);
    }

    @Override
    public java.sql.Time getTime(int n2) throws SQLException {
        java.sql.Time time = this.getOscarTime(n2);
        if (time instanceof Time) {
            return new java.sql.Time(((Time)time).getTime());
        }
        return time;
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarResultSetV2.class + ", isLast() ");
        }
        this.checkClosed();
        if (this.nullResult && this.rows.size() == 0) {
            return false;
        }
        if (!this.cursorUsed) {
            return this.current_row == this.rows.size() - 1 && this.rows.size() != 0;
        }
        if (this.maxRows > 0 && this.maxRowsCopy < 0) {
            return false;
        }
        if (this.maxRows > 0 && this.maxRowsCopy - 1 <= 0) {
            return true;
        }
        if (this.current_row == this.rows.size() - 1) {
            if (this.cursorPosition == 1) {
                return true;
            }
            if (this.planID != null) {
                ((b)this.connection.getProtocol()).a(null, null, null, null, this.planID, this.fetchSize, this.maxRows, false, false, this.statement, this, false, 0);
                if (this.moveSize == 0) {
                    return true;
                }
                this.cursorPosition = this.moveSize < this.fetchSize ? 1 : 0;
                return false;
            }
            return super.isLast();
        }
        return false;
    }
}

