/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.core.BaseConnection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class OscarSQLXML
implements SQLXML {
    private DOMResult domResult;
    private StringWriter stringWriter;
    private boolean freed;
    private boolean initialized;
    private boolean active;
    private ByteArrayOutputStream byteArrayOutputStream;
    private String data;
    private BaseConnection conn;

    public OscarSQLXML(BaseConnection baseConnection) {
        this(baseConnection, null, false);
    }

    public OscarSQLXML(BaseConnection baseConnection, String string) {
        this(baseConnection, string, true);
    }

    private OscarSQLXML(BaseConnection baseConnection, String string, boolean bl) {
        this.conn = baseConnection;
        this.data = string;
        this.initialized = bl;
        this.active = false;
        this.freed = false;
    }

    @Override
    public void free() throws SQLException {
        this.freed = true;
        this.data = null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkFreed();
        this.ensureInitialized();
        if (this.data == null) {
            return null;
        }
        return new ByteArrayInputStream(this.conn.getEncoding().encode(this.data));
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        this.checkFreed();
        this.initialize();
        this.active = true;
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        return this.byteArrayOutputStream;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkFreed();
        this.ensureInitialized();
        if (this.data == null) {
            return null;
        }
        return new StringReader(this.data);
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        this.checkFreed();
        this.initialize();
        this.active = true;
        this.stringWriter = new StringWriter();
        return this.stringWriter;
    }

    @Override
    public String getString() throws SQLException {
        this.checkFreed();
        this.ensureInitialized();
        return this.data;
    }

    @Override
    public void setString(String string) throws SQLException {
        this.checkFreed();
        this.initialize();
        this.data = string;
    }

    public Source getSource(Class object) throws SQLException {
        this.checkFreed();
        this.ensureInitialized();
        if (this.data == null) {
            return null;
        }
        try {
            if (object == null || DOMSource.class.equals(object)) {
                object = DocumentBuilderFactory.newInstance();
                object = ((DocumentBuilderFactory)object).newDocumentBuilder();
                ((DocumentBuilder)object).setErrorHandler(new NonPrintingErrorHandler());
                InputSource inputSource = new InputSource(new StringReader(this.data));
                return new DOMSource(((DocumentBuilder)object).parse(inputSource));
            }
            if (SAXSource.class.equals(object)) {
                object = new InputSource(new StringReader(this.data));
                return new SAXSource((InputSource)object);
            }
            if (StreamSource.class.equals(object)) {
                return new StreamSource(new StringReader(this.data));
            }
            if (StAXSource.class.equals(object)) {
                object = XMLInputFactory.newInstance();
                object = ((XMLInputFactory)object).createXMLStreamReader(new StringReader(this.data));
                return new StAXSource((XMLStreamReader)object);
            }
        }
        catch (Exception exception) {
            throw new SQLException("Unable to decode xml data.");
        }
        throw new SQLException("Unknown XML Source class: {0}");
    }

    public synchronized Result setResult(Class object) throws SQLException {
        this.checkFreed();
        this.initialize();
        if (object == null || DOMResult.class.equals(object)) {
            this.domResult = new DOMResult();
            this.active = true;
            return this.domResult;
        }
        if (SAXResult.class.equals(object)) {
            try {
                object = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                object = ((SAXTransformerFactory)object).newTransformerHandler();
                this.stringWriter = new StringWriter();
                object.setResult(new StreamResult(this.stringWriter));
                this.active = true;
                return new SAXResult((ContentHandler)object);
            }
            catch (TransformerException transformerException) {
                throw new SQLException("Unable to create SAXResult for SQLXML.");
            }
        }
        if (StreamResult.class.equals(object)) {
            this.stringWriter = new StringWriter();
            this.active = true;
            return new StreamResult(this.stringWriter);
        }
        if (StAXResult.class.equals(object)) {
            this.stringWriter = new StringWriter();
            try {
                object = XMLOutputFactory.newInstance();
                object = ((XMLOutputFactory)object).createXMLStreamWriter(this.stringWriter);
                this.active = true;
                return new StAXResult((XMLStreamWriter)object);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new SQLException("Unable to create StAXResult for SQLXML");
            }
        }
        throw new SQLException("Unknown XML Result class: {0}");
    }

    private void checkFreed() throws SQLException {
        if (this.freed) {
            throw new SQLException("This SQLXML object has already been freed.");
        }
    }

    private void initialize() throws SQLException {
        if (this.initialized) {
            throw new SQLException("This SQLXML object has already been initialized, so you cannot manipulate it further.");
        }
        this.initialized = true;
    }

    private void ensureInitialized() throws SQLException {
        if (!this.initialized) {
            throw new SQLException("This SQLXML object has not been initialized, so you cannot retrieve data from it.");
        }
        if (!this.active) {
            return;
        }
        if (this.byteArrayOutputStream != null) {
            try {
                this.data = this.conn.getEncoding().decode(this.byteArrayOutputStream.toByteArray());
            }
            finally {
                this.byteArrayOutputStream = null;
                this.active = false;
            }
        } else {
            if (this.stringWriter != null) {
                this.data = this.stringWriter.toString();
                this.stringWriter = null;
                this.active = false;
                return;
            }
            if (this.domResult != null) {
                try {
                    Object object = TransformerFactory.newInstance();
                    object = ((TransformerFactory)object).newTransformer();
                    DOMSource dOMSource = new DOMSource(this.domResult.getNode());
                    StringWriter stringWriter = new StringWriter();
                    StreamResult streamResult = new StreamResult(stringWriter);
                    ((Transformer)object).transform(dOMSource, streamResult);
                    this.data = stringWriter.toString();
                    return;
                }
                catch (TransformerException transformerException) {
                    throw new SQLException("Unable to convert DOMResult SQLXML data to a string.");
                }
                finally {
                    this.domResult = null;
                    this.active = false;
                }
            }
        }
    }

    static class NonPrintingErrorHandler
    implements ErrorHandler {
        NonPrintingErrorHandler() {
        }

        @Override
        public void error(SAXParseException sAXParseException) {
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) {
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
        }
    }
}

