/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.BaseStatement;
import com.oscar.core.Encoding;
import com.oscar.core.Field;
import com.oscar.jdbc.EscapeProcessor;
import com.oscar.jdbc.EscapeProcessorResult;
import com.oscar.jdbc.ExceptionUtil;
import com.oscar.jdbc.OscarBfile;
import com.oscar.jdbc.OscarBlob;
import com.oscar.jdbc.OscarClob;
import com.oscar.jdbc.OscarCursorResultSet;
import com.oscar.jdbc.OscarJdbc2Connection;
import com.oscar.jdbc.OscarLob;
import com.oscar.jdbc.OscarParaMetaData;
import com.oscar.jdbc.OscarPreparedStatement;
import com.oscar.jdbc.OscarPreparedStatementV2;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.jdbc.OscarSQLXML;
import com.oscar.partition.PartitionInfo;
import com.oscar.protocol.ProtocolVersion;
import com.oscar.protocol.a.l;
import com.oscar.util.BatchDataStream;
import com.oscar.util.CommonUtil;
import com.oscar.util.OSCARbyte;
import com.oscar.util.OSQLException;
import com.oscar.util.OscarJDBCUtil;
import com.oscar.util.OscarSqlProcessor;
import com.oscar.util.OtherType;
import com.oscar.util.TypeConverter;
import com.oscar.util.Word;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;

public class OscarStatement
implements BaseStatement,
Statement {
    protected BaseConnection connection;
    protected Encoding encoding;
    protected Encoding clientEncoding;
    protected SQLWarning warnings = null;
    protected int maxrows = 0;
    protected int fetchSize = 16;
    protected int timeout = 0;
    protected boolean replaceProcessingEnabled = true;
    protected String osql;
    protected BaseResultSet result = null;
    protected StringBuffer sbuf = new StringBuffer(32);
    protected String[] m_sqlFragments;
    protected String[] m_origSqlFragments;
    int fragmentsCount = 0;
    protected String[] m_executeSqlFragments;
    protected Object[] m_binds = new Object[0];
    protected Object[] m_binds_old = new Object[0];
    protected List<String> binds_name = new ArrayList<String>();
    protected OscarLob[] m_lobs = new OscarLob[0];
    protected Hashtable<Integer, Character> tableTypes = new Hashtable();
    protected int[] m_bindTypes = new int[0];
    protected int[] m_functionTypes = new int[0];
    protected Object[] m_outValues = new Object[0];
    protected String m_statementName = null;
    protected String m_cursorName = null;
    protected boolean m_statementIsCursor = false;
    protected OscarParaMetaData pMetaData;
    protected static final AtomicInteger m_preparedCount = new AtomicInteger(1);
    public static final String cursorPrefix = "C";
    protected boolean isCallable;
    protected boolean isResultNeeded;
    protected int functionReturnType;
    protected boolean returnTypeSet;
    protected Vector<Integer> outParameterType = new Vector();
    protected Vector<Integer> outParameterIndex = new Vector();
    protected int parameterNum = 0;
    protected boolean isClosed = false;
    protected int maxFieldSize = 8000;
    protected int resultSetType = 1003;
    protected int resultSetConcurrency = 1007;
    protected boolean resultSetCanUpdateable = true;
    protected int statementType = 0;
    protected int bufSize = 102400;
    public static final int STATEMENT = 0;
    public static final int PREPAREDSTATEMENT = 1;
    public static final int CALLABLESTATEMENT = 2;
    protected boolean tidUsed = false;
    protected int autoGeneratedInfo = -1;
    protected boolean selectSql = false;
    protected boolean ddlSql = false;
    protected boolean insertSql = false;
    protected int lastIndex = 0;
    protected boolean prepareAndNotRealPrepare = false;
    protected boolean isMultiSqlSentens = false;
    protected List<String> importRows = null;
    protected int transferCount = 0;
    public static final int DB_TINYINT = 0;
    public static final int DB_SMALLINT = 0;
    public static final int DB_INT = 0;
    public static final int DB_BIGINT = 0;
    public static final int DB_FLOAT = 0;
    public static final int DB_REAL = 0;
    public static final int DB_DOUBLE = 0;
    public static final int DB_NUMERIC = 0;
    public static final int DB_DECIMAL = 0;
    public static final int DB_BOOLEAN = 0;
    public static final int DB_BIT = 0;
    public static final int DB_CHAR = 0;
    public static final int DB_VARCHAR = 0;
    public static final int DB_TEXT = 0;
    public static final int DB_BINARY = 0;
    public static final int DB_VARBINARY = 0;
    public static final int DB_LONGVARBINARY = 0;
    public static final int DB_DATE = 0;
    public static final int DB_TIME = 0;
    public static final int DB_TIMESTAMP = 0;
    public static final int DB_CLOB = -1;
    public static final int DB_BLOB = -2;
    public static final int DB_BFILE = -3;
    protected List batch = null;
    protected int fetchdirection = 1000;
    protected Calendar systemCal = Calendar.getInstance();
    protected static final int NO_AUTO_GENERATED = 0;
    protected static final int AUTO_GENERATED = 1;
    protected static final int AUTO_GENERATED_COLINDEX = 2;
    protected static final int AUTO_GENERATED_COLNAME = 3;
    protected int[] columnIndex = null;
    protected String[] columnName = null;
    protected int resultSetHoldability = 2;
    protected Vector<OscarLob> tempResource = new Vector();
    protected boolean hasEscapeChar = false;
    protected boolean addBatchUseSql = false;
    protected int updateBatchCount = 0;
    protected l batchPacket = null;
    protected boolean cursorError = false;
    public short cacheState;
    private boolean poolable = true;
    protected Field[] fields = null;
    protected boolean logFlag = Driver.getLogLevel() >= 2;
    protected boolean stLogFlag = Driver.getLogLevel() > 0;
    protected int sessionId;
    protected int pid;
    protected int batchCount = 0;
    protected boolean useAsynBatch = false;
    protected boolean isBegin = false;
    protected BatchDataStream batchDataStream;
    protected int[] hashColIds;
    protected int buckets;
    protected boolean print = false;
    protected boolean isAnonymous = false;
    protected boolean anonymousSupportPrepare = true;
    protected boolean compatibleOracle = false;
    protected boolean supportGeneratedKey = true;
    protected boolean errorMessNeedOffset;
    protected boolean isHaveFuncReturn = false;
    protected Field firstField = null;
    private Map<String, String> generatedKeyMap = new HashMap<String, String>();
    private boolean closeOnCompletion = false;
    protected Object m_returnValue = new Object();
    protected int m_returnType = 0;
    boolean isFunc = false;
    protected static final String AT_CHARACTER_POSITION = "at character";
    protected static final String AT_END_OF_INPUT_POSITION = "at end of input";
    protected boolean useSensitiveCursor = false;
    private Map<Integer, OscarCursorResultSet> cursorResultMap = new HashMap<Integer, OscarCursorResultSet>();
    protected boolean notRealPrepare = false;
    protected Calendar localCalendar;
    private static final Constructor<?> JDBC_4_PSTMT_ARG;
    private static final Constructor<?> JDBC_4_PSTMT_ARG_V2;

    public OscarStatement(BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.encoding = baseConnection.getEncoding();
        this.clientEncoding = baseConnection.getClientEncoding();
        this.resultSetType = 1003;
        this.resultSetConcurrency = 1007;
        this.batchCount = baseConnection.getBatchCount();
        this.useAsynBatch = baseConnection.isUseAsynBatch();
        Properties properties = baseConnection.getConnectionProperties();
        Object object = baseConnection.getProtocolVersion();
        this.supportGeneratedKey = Boolean.valueOf(properties.getProperty("SUPPORTGENERATEDKEY", ((ProtocolVersion)object).isKstore() || ((ProtocolVersion)object).isMpp5() ? "false" : "true"));
        this.anonymousSupportPrepare = Boolean.valueOf(properties.getProperty("ANONYMOUSSUPPORTPREPARE", "true"));
        object = properties.getProperty("APPLICATION", "");
        if (((String)object).contains("DBStudio") || ((String)object).contains("Analyze Query SQL")) {
            this.errorMessNeedOffset = true;
        }
        this.useSensitiveCursor = Boolean.valueOf(properties.getProperty("USESENSITIVECURSOR", "true"));
        this.sessionId = baseConnection.getSessionID();
        this.pid = baseConnection.getPlanID();
        this.notRealPrepare = baseConnection.isNotRealPrepare();
        this.localCalendar = baseConnection.getCalendar();
    }

    public OscarStatement(BaseConnection baseConnection, String string) throws SQLException {
        this(baseConnection);
        this.osql = string;
        this.parseSqlStmt(string);
    }

    @Override
    public boolean isHaveFuncRetrun() {
        return this.isHaveFuncReturn;
    }

    protected int getNextPreparedCount() {
        int n2 = m_preparedCount.getAndIncrement();
        if (n2 < 0) {
            Class<OscarStatement> clazz = OscarStatement.class;
            synchronized (OscarStatement.class) {
                if (m_preparedCount.get() < 0) {
                    m_preparedCount.set(1);
                }
                // ** MonitorExit[var1_2] (shouldn't be in output)
                return this.getNextPreparedCount();
            }
        }
        return n2;
    }

    @Override
    public void setParamInfor(Object[][] objectArray) {
        this.pMetaData = new OscarParaMetaData(objectArray, this);
    }

    @Override
    public ParameterMetaData getParamInfo() {
        return this.pMetaData;
    }

    @Override
    public int[] getHashColIds() {
        return this.hashColIds;
    }

    @Override
    public void setHashColIds(int[] nArray) {
        this.hashColIds = nArray;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        Object object = this.getResultSet();
        if (object != null) {
            return object.getMetaData();
        }
        if (this.m_statementName == null || this.insertSql) {
            return null;
        }
        object = "GET ROWDESCRIPTION FOR " + this.m_statementName;
        if ((object = this.connection.execSQL((String)object)) != null && object.reallyResultSet()) {
            return object.getMetaData();
        }
        return null;
    }

    @Override
    public BaseConnection getDBConnection() {
        return this.connection;
    }

    @Override
    public String getCursorName() {
        return this.m_cursorName;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void parseSqlStmt(String string) throws SQLException {
        int n2;
        String string2;
        boolean bl;
        boolean bl2;
        Vector<String> vector;
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", parseSqlStmt(String o_sql), \n sql: " + string);
        }
        string = this.checkSqlEmptyOrTrim(string);
        string = this.replaceProcessing(string);
        string = this.subParseSqlStmt(string);
        OscarSqlProcessor.ParseResult parseResult = OscarSqlProcessor.parsingWithCheck(string);
        this.isAnonymous = parseResult.isAnonymous();
        this.selectSql = parseResult.isSelectSql();
        this.insertSql = parseResult.isInsertSql();
        this.ddlSql = parseResult.isDdlSql();
        this.isMultiSqlSentens = parseResult.getSqlCounts() > 1 && !this.isAnonymous;
        string = parseResult.getTransSql();
        if (this.isAnonymous && !string.toUpperCase().startsWith("DO")) {
            this.osql = string = "DO " + string;
        }
        int n3 = 0;
        if (this.isNotSupportPrePare()) {
            vector = new Vector<String>();
            bl2 = false;
            bl = false;
            string2 = "";
        } else {
            int n4 = parseResult.getQuestionMarks().size();
            this.fragmentsCount = n4 + 1;
            this.m_sqlFragments = new String[1];
            this.m_sqlFragments[0] = string;
            if (this.isCallable && this.isResultNeeded) {
                this.m_binds = new Object[this.fragmentsCount];
                this.m_binds_old = new Object[this.fragmentsCount];
                this.m_lobs = new OscarLob[this.fragmentsCount];
                this.m_bindTypes = new int[this.fragmentsCount];
                this.m_outValues = new Object[this.fragmentsCount];
                this.fields = new Field[this.fragmentsCount];
            } else {
                this.m_binds = new Object[this.fragmentsCount - 1];
                this.m_binds_old = new Object[this.fragmentsCount - 1];
                this.m_bindTypes = new int[this.fragmentsCount - 1];
                this.m_lobs = new OscarLob[this.fragmentsCount - 1];
                this.m_outValues = new Object[this.fragmentsCount - 1];
                this.fields = new Field[this.fragmentsCount - 1];
            }
            if (!this.notRealPrepare && (this.isMultiSqlSentens || this.m_binds != null && this.m_binds.length > Short.MAX_VALUE)) {
                this.notRealPrepare = true;
            }
            if (!this.isHaveFuncReturn) {
                if (!this.isNotRealPrepare()) return;
            }
            this.m_executeSqlFragments = new String[this.fragmentsCount];
            if (n4 <= 0) {
                this.m_executeSqlFragments[0] = string;
                return;
            }
            int n5 = 0;
            while (true) {
                String string3;
                if (n5 >= n4) {
                    String string4;
                    this.m_executeSqlFragments[this.fragmentsCount - 1] = string4 = string.substring(n3);
                    return;
                }
                Word word = parseResult.getQuestionMarks().get(n5);
                this.m_executeSqlFragments[n5] = string3 = string.substring(n3, word.getTokenBegin());
                n3 = word.getTokenEnd();
                ++n5;
            }
        }
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c2 = string.charAt(n2);
            if (c2 == '\'') {
                boolean bl3 = bl2 = !bl2;
                if (bl) {
                    bl = false;
                    this.binds_name.add(string2);
                    string2 = "";
                }
            }
            if ((c2 == ' ' || c2 == ';' || c2 == '\'' || c2 == '(') && bl) {
                bl = false;
                this.binds_name.add(string2);
                string2 = "";
            }
            if (c2 == '?' && !bl2) {
                this.compatibleOracle = false;
                if (this.isHaveFuncReturn || this.isNotRealPrepare() || this.isAnonymous) {
                    vector.addElement(string.substring(n3, n2));
                    n3 = n2 + 1;
                }
                ++this.fragmentsCount;
            } else if (c2 == '&') {
                this.compatibleOracle = true;
                if (this.isHaveFuncReturn || this.isNotRealPrepare() || this.isAnonymous) {
                    vector.addElement(string.substring(n3, n2));
                    n3 = n2 + 1;
                }
                ++this.fragmentsCount;
                bl = true;
                continue;
            }
            if (!bl) continue;
            string2 = string2 + (char)c2;
        }
        ++this.fragmentsCount;
        if (this.isHaveFuncReturn || this.isNotRealPrepare() || this.isAnonymous) {
            vector.addElement(string.substring(n3, string.length()));
            this.m_executeSqlFragments = new String[vector.size()];
            for (n2 = 0; n2 < this.m_executeSqlFragments.length; ++n2) {
                this.m_executeSqlFragments[n2] = (String)vector.elementAt(n2);
            }
        }
        this.m_sqlFragments = new String[1];
        this.m_sqlFragments[0] = string;
        if (this.isCallable && this.isResultNeeded) {
            this.m_binds = new Object[this.fragmentsCount];
            this.m_binds_old = new Object[this.fragmentsCount];
            this.m_lobs = new OscarLob[this.fragmentsCount];
            this.m_bindTypes = new int[this.fragmentsCount];
            this.m_outValues = new Object[this.fragmentsCount];
            this.fields = new Field[this.fragmentsCount];
            return;
        }
        this.m_binds = new Object[this.fragmentsCount - 1];
        this.m_binds_old = new Object[this.fragmentsCount - 1];
        this.m_bindTypes = new int[this.fragmentsCount - 1];
        this.m_lobs = new OscarLob[this.fragmentsCount - 1];
        this.m_outValues = new Object[this.fragmentsCount - 1];
        this.fields = new Field[this.fragmentsCount - 1];
    }

    protected String subParseSqlStmt(String string) throws SQLException {
        return string;
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.checkClosed();
        if (this.stLogFlag || this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", executeQuery(String o_sql), \n sql: " + string);
        }
        string = this.checkSqlEmptyOrTrim(string);
        this.osql = string = this.replaceProcessing(string);
        OscarSqlProcessor.ParseResult parseResult = OscarSqlProcessor.parsingWithCheck(string);
        this.isAnonymous = parseResult.isAnonymous();
        if (this.isAnonymous && !string.toUpperCase().startsWith("DO")) {
            string = "DO " + string;
        }
        this.isMultiSqlSentens = parseResult.getSqlCounts() > 1 && !this.isAnonymous;
        this.selectSql = parseResult.isSelectSql();
        this.insertSql = parseResult.isInsertSql();
        this.m_sqlFragments = new String[]{string};
        this.m_binds = new Object[0];
        this.m_lobs = new OscarLob[0];
        this.m_bindTypes = new int[0];
        if (this.m_statementName != null) {
            this.releasePrepareStatement();
        }
        if (!(this.selectSql || parseResult.isFenormalSelect() || this.connection.isCompatibleOracle())) {
            throw new OSQLException("OSCAR-00402", "88888", 402);
        }
        return this.executeQuery();
    }

    public ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        if (this.m_sqlFragments != null && this.m_sqlFragments.length > 1) {
        }
        this.executeStatement();
        this.cleanEnvTemp();
        while (this.result != null && !this.result.reallyResultSet()) {
            this.result = (BaseResultSet)this.result.getNext();
        }
        return this.result;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        return CommonUtil.convertToInt(this.executeLargeUpdate(string));
    }

    @Override
    public long executeLargeUpdate(String string) throws SQLException {
        this.checkClosed();
        if (this.stLogFlag || this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", executeUpdate(String o_sql), \n sql: " + string);
        }
        string = this.checkSqlEmptyOrTrim(string);
        this.osql = string = this.replaceProcessing(string);
        OscarSqlProcessor.ParseResult parseResult = OscarSqlProcessor.parsingWithCheck(string);
        this.isAnonymous = parseResult.isAnonymous();
        if (this.isAnonymous && !string.toUpperCase().startsWith("DO")) {
            string = "DO " + string;
        }
        this.selectSql = parseResult.isSelectSql();
        this.insertSql = parseResult.isInsertSql();
        if (!this.connection.isCompatibleOracle() && this.selectSql) {
            throw new OSQLException("OSCAR-00403", "88888", 403);
        }
        this.isMultiSqlSentens = parseResult.getSqlCounts() > 1 && !this.isAnonymous;
        this.m_sqlFragments = new String[]{string};
        this.m_binds = new Object[0];
        this.m_lobs = new OscarLob[0];
        this.m_bindTypes = new int[0];
        if (this.m_statementName != null) {
            this.releasePrepareStatement();
        }
        return this.executeLargeUpdate();
    }

    public int executeUpdate() throws SQLException {
        return CommonUtil.convertToInt(this.executeLargeUpdate());
    }

    public long executeLargeUpdate() throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", executeUpdate(), \n");
        }
        if (!this.connection.isCompatibleOracle() && this.selectSql) {
            throw new OSQLException("OSCAR-00403", "88888", 403);
        }
        if (this.isNotSupportPrePare()) {
            this.execute();
        } else {
            this.executeStatement();
        }
        this.cleanEnvTemp();
        return this.getLargeUpdateCount();
    }

    @Override
    public boolean execute(String string) throws SQLException {
        return this.doExecute(string);
    }

    private boolean doExecute(String string) throws SQLException {
        this.checkClosed();
        if (this.stLogFlag || this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", execute(String o_sql), \n sql: " + string);
        }
        string = this.checkSqlEmptyOrTrim(string);
        this.osql = string = this.replaceProcessing(string);
        OscarSqlProcessor.ParseResult parseResult = OscarSqlProcessor.parsingWithCheck(string);
        this.isAnonymous = parseResult.isAnonymous();
        if (this.isAnonymous && !string.toUpperCase().startsWith("DO")) {
            string = "DO " + string;
        }
        this.selectSql = parseResult.isSelectSql();
        this.insertSql = parseResult.isInsertSql();
        this.isMultiSqlSentens = parseResult.getSqlCounts() > 1 && !this.isAnonymous;
        this.m_sqlFragments = new String[]{string};
        this.m_binds = new Object[0];
        this.m_lobs = new OscarLob[0];
        this.m_bindTypes = new int[0];
        if (this.m_statementName != null) {
            this.releasePrepareStatement();
        }
        return this.executeStatement();
    }

    public boolean execute() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", execute() ");
        }
        if (this.isNotSupportPrePare()) {
            if (this.compatibleOracle) {
                for (int i2 = 0; i2 < this.m_binds.length; ++i2) {
                    this.m_sqlFragments[0] = this.m_sqlFragments[0].replace("&" + this.binds_name.get(i2), String.valueOf(this.m_binds[i2]));
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder(this.m_executeSqlFragments[0]);
                for (int i3 = 0; i3 < this.m_binds.length; ++i3) {
                    if (this.m_binds[i3] instanceof String) {
                        this.m_binds[i3] = ((String)this.m_binds[i3]).replaceAll("'", "''");
                    }
                    if (this.m_binds[i3] instanceof String || this.m_binds[i3] instanceof Time || this.m_binds[i3] instanceof Timestamp || this.m_binds[i3] instanceof java.sql.Date || this.m_binds[i3] instanceof Date) {
                        stringBuilder.append("'").append(this.m_binds[i3]).append("'").append(this.m_executeSqlFragments[i3 + 1]);
                        continue;
                    }
                    stringBuilder.append(String.valueOf(this.m_binds[i3])).append(this.m_executeSqlFragments[i3 + 1]);
                }
                this.m_sqlFragments[0] = stringBuilder.toString();
            }
            OscarStatement oscarStatement = this;
            return oscarStatement.doExecute(oscarStatement.m_sqlFragments[0]);
        }
        this.checkClosed();
        boolean bl = this.executeStatement();
        this.cleanEnvTemp();
        return bl;
    }

    protected synchronized void cleanEnvTemp() throws SQLException {
        for (int i2 = 0; i2 < this.tempResource.size(); ++i2) {
            if (!(this.tempResource.get(i2) instanceof OscarLob)) continue;
            OscarLob oscarLob = this.tempResource.get(i2);
            if (oscarLob.isTempLob()) {
                oscarLob.freeTemporary();
                continue;
            }
            if (!oscarLob.isTableIdLob()) continue;
            oscarLob.freePersist();
        }
        this.tempResource.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean executeStatement() throws SQLException {
        block43: {
            this.clearWarnings();
            this.cursorError = false;
            this.m_statementIsCursor = false;
            this.m_cursorName = null;
            if (this.result != null) {
                this.releaseResources();
                this.result.close();
                this.result = null;
            }
            if (this.statementType == 0) {
                Object object;
                Object object2;
                boolean bl = false;
                int n2 = 0;
                try {
                    object2 = this.m_sqlFragments[0].trim();
                    if (this.selectSql && (this.fetchSize == 0 || this.isMultiSqlSentens || this.checkDBLinkSql((String)object2))) {
                        if (this.resultSetConcurrency == 1008) {
                            this.tidUsed = true;
                        }
                        this.m_statementIsCursor = false;
                    } else if (this.fetchSize > 0 && this.selectSql) {
                        object = new String[this.m_sqlFragments.length];
                        object2 = cursorPrefix + this.getNextPreparedCount();
                        Object object3 = this.resultSetType == 1003 ? (this.useSensitiveCursor ? "DECLARE " + (String)object2 + " CURSOR FOR " : "DECLARE " + (String)object2 + " INSENSITIVE CURSOR FOR ") : (this.resultSetType == 1004 ? "DECLARE " + (String)object2 + " INSENSITIVE SCROLL CURSOR FOR " : "DECLARE " + (String)object2 + " SCROLL CURSOR FOR ");
                        String string2 = "OPEN " + (String)object2;
                        String string3 = " FETCH FORWARD " + this.fetchSize + " FROM " + (String)object2 + ";";
                        if (((String[])object).length > 1) {
                            throw new IllegalStateException("cursor fetches not supported with prepared statements.");
                        }
                        n2 = ((String)object3).length();
                        object[0] = (String)object3 + this.m_sqlFragments[0];
                        if (this.resultSetConcurrency == 1008) {
                            this.tidUsed = true;
                        }
                        object3 = (BaseStatement)((Object)this.connection.createStatement());
                        object3.setUseTid(this.tidUsed);
                        this.connection.execSQL(object[0], (BaseStatement)object3);
                        n2 = 0;
                        this.m_cursorName = object2;
                        this.m_statementIsCursor = true;
                        this.m_sqlFragments = object;
                        this.connection.execSQL(string2, (BaseStatement)object3);
                        bl = true;
                        object2 = ((Statement)object3).getWarnings();
                        if (object2 != null) {
                            this.addWarning((SQLWarning)object2);
                        }
                        object[0] = string3;
                    }
                    if (this.isAnonymous) {
                        n2 = 3;
                    }
                    this.result = this.getDBConnection().getQueryExecutor().execute(this.m_sqlFragments, this.m_binds, this);
                    n2 = 0;
                    if (this.result != null) {
                        this.result.setResultType(true);
                    }
                    if (this.result != null && !this.cursorError || !this.m_statementIsCursor) break block43;
                    this.cursorError = false;
                }
                catch (SQLException sQLException) {
                    try {
                        String string4;
                        if (this.errorMessNeedOffset && sQLException instanceof OSQLException && (string4 = sQLException.getMessage()) != null && (string4.contains(AT_CHARACTER_POSITION) || string4.contains(AT_END_OF_INPUT_POSITION))) {
                            ((OSQLException)sQLException).setJdbcOffset(n2);
                        }
                        this.cursorError = true;
                        this.checkConnectionClosed(sQLException);
                        throw sQLException;
                    }
                    catch (Throwable throwable) {
                        if (this.result != null) {
                            if (!this.cursorError) throw throwable;
                        }
                        if (!this.m_statementIsCursor) throw throwable;
                        this.cursorError = false;
                        try {
                            String string5 = !bl ? "DEALLOCATE " + this.m_cursorName : "CLOSE " + this.m_cursorName + ";DEALLOCATE " + this.m_cursorName;
                            BaseStatement baseStatement = (BaseStatement)((Object)this.connection.createStatement());
                            baseStatement.setUseTid(this.tidUsed);
                            this.connection.execSQL(string5, baseStatement);
                            this.connection.removeCursor(this.m_cursorName);
                            throw throwable;
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                }
                try {
                    object2 = !bl ? "DEALLOCATE " + this.m_cursorName : "CLOSE " + this.m_cursorName + ";DEALLOCATE " + this.m_cursorName;
                    object = (BaseStatement)((Object)this.connection.createStatement());
                    object.setUseTid(this.tidUsed);
                    this.connection.execSQL((String)object2, (BaseStatement)object);
                    this.connection.removeCursor(this.m_cursorName);
                }
                catch (Exception exception) {}
            } else {
                this.m_statementIsCursor = false;
                if (this.isCallable || this.isAnonymous && this.outParameterIndex.size() > 0) {
                    Object[] objectArray = new String[this.m_binds.length];
                    for (int i2 = 0; i2 < this.m_binds.length; ++i2) {
                        if (this.m_binds[i2] != null) {
                            if (this.outParameterIndex.indexOf(i2 + 1) != -1) {
                                objectArray[i2] = this.m_binds[i2].toString();
                                continue;
                            }
                            objectArray[i2] = this.m_binds[i2].toString();
                            continue;
                        }
                        if (this.outParameterIndex.indexOf(i2 + 1) == -1) throw new OSQLException("OSCAR-00404", "88888", 404, i2 + 1);
                        objectArray[i2] = "NULL";
                    }
                    try {
                        this.result = this.connection.getQueryExecutor().execute(this.m_sqlFragments, objectArray, this);
                    }
                    catch (SQLException sQLException) {
                        this.checkConnectionClosed(sQLException);
                        throw sQLException;
                    }
                }
                for (int i3 = 0; i3 < this.m_binds.length; ++i3) {
                    if (this.m_binds[i3] != null) continue;
                    throw new OSQLException("OSCAR-00405", "88888", 405, i3 + 1);
                }
                try {
                    if (!this.isNotRealPrepare() && this.fetchSize > 0 && this.selectSql) {
                        this.decalreCursor();
                    }
                    if (this.m_sqlFragments == null && this.fetchSize == 0) {
                        this.setSqlFragments();
                    }
                    this.result = this.connection.getQueryExecutor().execute(this.m_sqlFragments, this.m_binds, this);
                    if (this.result != null) {
                        this.result.setResultType(true);
                    }
                    if (this.result != null && !this.cursorError || !this.m_statementIsCursor) break block43;
                    this.cursorError = false;
                }
                catch (SQLException sQLException) {
                    try {
                        this.cursorError = true;
                        this.checkConnectionClosed(sQLException);
                        throw sQLException;
                    }
                    catch (Throwable throwable) {
                        if (this.result != null) {
                            if (!this.cursorError) throw throwable;
                        }
                        if (!this.m_statementIsCursor) throw throwable;
                        this.cursorError = false;
                        try {
                            String string7 = "CLOSE " + this.m_cursorName + ";DEALLOCATE " + this.m_cursorName;
                            BaseStatement baseStatement = (BaseStatement)((Object)this.connection.createStatement());
                            baseStatement.setUseTid(this.tidUsed);
                            this.connection.execSQL(string7, baseStatement);
                            this.connection.removeCursor(this.m_cursorName);
                            throw throwable;
                        }
                        catch (SQLException sQLException2) {}
                        throw throwable;
                    }
                }
                try {
                    String string6 = "CLOSE " + this.m_cursorName + ";DEALLOCATE " + this.m_cursorName;
                    BaseStatement baseStatement = (BaseStatement)((Object)this.connection.createStatement());
                    baseStatement.setUseTid(this.tidUsed);
                    this.connection.execSQL(string6, baseStatement);
                    this.connection.removeCursor(this.m_cursorName);
                }
                catch (SQLException sQLException) {}
            }
        }
        if (this.isCallable || this.isAnonymous && this.outParameterIndex.size() > 0) {
            if (!(this.result.getTupleCount() != 0 && this.result.reallyResultSet() || this.outParameterIndex.isEmpty())) {
                throw new OSQLException("OSCAR-00406", "88888", 406);
            }
            this.getProcedureResult();
            if (this.result == null) return false;
            if (this.result.getNext() == null) return false;
            return true;
        }
        if (this.result == null) return false;
        String string = this.result.getStatusString();
        if (string == null) return false;
        if (string.startsWith("23")) return this.result.reallyResultSet();
        if (string.startsWith("45")) return this.result.reallyResultSet();
        if (string.startsWith("5D")) return this.result.reallyResultSet();
        if (string.startsWith("10")) return this.result.reallyResultSet();
        if (!string.startsWith("48")) return false;
        return this.result.reallyResultSet();
    }

    private boolean checkDBLinkSql(String string) {
        if (this.connection.checkDBLinkSql()) {
            return string != null && string.contains("@");
        }
        return false;
    }

    protected void setSqlFragments() {
        if (this.m_origSqlFragments == null) {
            return;
        }
        if (!(this.isNotSupportPrePare() || this.isNotRealPrepare() || this.fetchSize > 0 && this.selectSql)) {
            this.m_executeSqlFragments = new String[this.fragmentsCount];
            this.m_executeSqlFragments[0] = "EXECUTE " + this.m_statementName;
            if (this.fragmentsCount > 1) {
                this.m_executeSqlFragments[0] = this.m_executeSqlFragments[0] + "(";
                if (this.isResultNeeded) {
                    for (int i2 = 1; i2 < this.m_binds.length - 1; ++i2) {
                        this.m_executeSqlFragments[i2] = ", ";
                    }
                    this.m_executeSqlFragments[this.m_binds.length - 1] = ")";
                } else {
                    for (int i3 = 1; i3 < this.m_binds.length; ++i3) {
                        this.m_executeSqlFragments[i3] = ", ";
                    }
                    this.m_executeSqlFragments[this.m_binds.length] = ")";
                }
            }
        }
        this.m_sqlFragments = this.m_executeSqlFragments;
    }

    protected void decalreCursor() throws SQLException {
        String string;
        String string2 = cursorPrefix + this.getNextPreparedCount();
        Object object = this.m_statementName;
        if (this.resultSetType == 1003) {
            string = this.useSensitiveCursor ? "DECLARE " + string2 + " CURSOR FOR " : "DECLARE " + string2 + " INSENSITIVE CURSOR FOR ";
            string = string + (String)object;
            if (this.resultSetConcurrency == 1007) {
                string = string + " For Read Only";
            }
        } else if (this.resultSetType == 1004) {
            string = "DECLARE " + string2 + " INSENSITIVE SCROLL CURSOR FOR ";
            string = string + (String)object;
        } else {
            string = "DECLARE " + string2 + " SCROLL CURSOR FOR ";
            string = string + (String)object;
        }
        object = (BaseStatement)((Object)this.connection.createStatement());
        if (this.resultSetConcurrency == 1008) {
            this.tidUsed = true;
        }
        object.setUseTid(this.tidUsed);
        this.connection.execSQL(string, (BaseStatement)object);
        this.m_cursorName = string2;
        this.m_statementIsCursor = true;
    }

    protected void getProcedureResult() throws SQLException {
        this.result.next();
        byte[][] byArray = this.result.getCurrentRow();
        this.m_functionTypes = new int[this.m_binds.length];
        int n2 = this.parameterNum;
        int n3 = 0;
        if (!this.isResultNeeded && this.isFunc) {
            ++n2;
            this.m_returnValue = byArray[0];
            this.m_returnType = this.result.getMetaData().getColumnType(1);
            ++n3;
        }
        if (this.parameterNum != 0 && n2 != this.result.getColumnCount()) {
            throw new OSQLException("OSCAR-00407", "88888", 407);
        }
        for (Integer n4 : this.outParameterIndex) {
            int n5 = n4 - 1;
            this.m_functionTypes[n5] = this.result.getMetaData().getColumnType(n3 + 1);
            this.m_outValues[n5] = byArray[n3];
            ++n3;
        }
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.checkClosed();
        this.connection.setCursorName(string);
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return false;
        }
        BaseResultSet baseResultSet = (BaseResultSet)this.result.getNext();
        this.result.close();
        this.result = baseResultSet;
        return this.result != null && this.result.reallyResultSet();
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkClosed();
        return this.resultSetType;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return this.resultSetConcurrency;
    }

    @Override
    public boolean getResultSetCanUpdateable() throws SQLException {
        return this.resultSetCanUpdateable;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxrows;
    }

    @Override
    public void setMaxRows(int n2) throws SQLException {
        if (n2 < 0) {
            throw new OSQLException("OSCAR-00408", "88888", 408);
        }
        this.maxrows = n2;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkClosed();
        this.replaceProcessingEnabled = bl;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return this.timeout;
    }

    @Override
    public void setQueryTimeout(int n2) throws SQLException {
        this.checkClosed();
        if (n2 < 0) {
            throw new OSQLException("OSCAR-00408", "88888", 408);
        }
        this.timeout = n2;
    }

    @Override
    public void addWarning(String string, String string2) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(new SQLWarning(string, string2));
            return;
        }
        this.warnings = new SQLWarning(string);
    }

    public void addWarning(SQLWarning sQLWarning) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(sQLWarning);
            return;
        }
        this.warnings = sQLWarning;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int n2) throws SQLException {
        this.checkClosed();
        if (n2 < 0) {
            throw new OSQLException("OSCAR-00408", "88888", 408);
        }
        if (n2 < 8000) {
            this.maxFieldSize = n2;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warnings = null;
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        if (this.connection != null) {
            this.connection.cancelQuery();
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        if (this.result != null && this.result.reallyResultSet()) {
            if (this.supportGeneratedKey && this.result.getStatusString() != null && this.result.getStatusString().startsWith("21") && (this.autoGeneratedInfo == 1 || this.autoGeneratedInfo == 2 || this.autoGeneratedInfo == 3)) {
                return null;
            }
            return this.result;
        }
        return null;
    }

    protected void hardClose() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", hardClose()");
        }
        if (this.isClosed) {
            return;
        }
        if (this.result != null) {
            this.result.close();
        }
        this.result = null;
        this.cleanEnvTemp();
        if (this.statementType != 0 && this.m_statementName != null) {
            if (this.statementType == 2) {
                if (this.connection != null && !((Connection)((Object)this.connection)).isClosed()) {
                    this.connection.execSQL("DEALLOCATE PREPARE " + this.m_statementName);
                }
            } else {
                this.releasePrepareStatement();
            }
        }
        this.connection = null;
        this.encoding = null;
        this.clientEncoding = null;
        this.osql = null;
        this.outParameterType = null;
        this.outParameterIndex = null;
        this.pMetaData = null;
        this.sbuf = null;
        this.m_sqlFragments = null;
        this.m_origSqlFragments = null;
        this.m_executeSqlFragments = null;
        this.m_binds = null;
        this.m_functionTypes = null;
        this.m_outValues = null;
        this.m_returnValue = null;
        this.m_returnType = 0;
        this.isClosed = true;
    }

    @Override
    public void close() throws SQLException {
        if (this.logFlag) {
            if (this.connection != null) {
                Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", close()");
            } else {
                Driver.writeLog("conid: , " + OscarStatement.class + ", close()");
            }
        }
        if (this.isClosed) {
            return;
        }
        this.releaseResources();
        OscarJdbc2Connection oscarJdbc2Connection = (OscarJdbc2Connection)this.connection;
        if (oscarJdbc2Connection.getStList() != null) {
            oscarJdbc2Connection.getStList().remove(this);
        }
        this.closeOrCache();
    }

    protected void closeOrCache() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", closeOrCache()");
        }
        if (this.useCache()) {
            this.cache();
        } else {
            this.hardClose();
        }
        if (this.generatedKeyMap != null) {
            this.generatedKeyMap.clear();
            this.generatedKeyMap = null;
        }
    }

    protected void cache() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", Cache()");
        }
        OscarJdbc2Connection oscarJdbc2Connection = (OscarJdbc2Connection)this.connection;
        if (this instanceof OscarPreparedStatement) {
            oscarJdbc2Connection.cacheImplicitStatement((OscarPreparedStatement)this, this.osql, this.statementType, this.resultSetType);
            return;
        }
        this.hardClose();
    }

    protected boolean useCache() throws SQLException {
        if (!this.isPoolable()) {
            return false;
        }
        OscarJdbc2Connection oscarJdbc2Connection = (OscarJdbc2Connection)this.connection;
        return this.statementType != 0 && this.cacheState != 3 && this.cacheState != 4 && oscarJdbc2Connection.isStatementCacheInitialized() && oscarJdbc2Connection.getImplicitCachingEnabled();
    }

    protected void releasePrepareStatement() throws SQLException {
        if (this.m_statementName != null) {
            this.releasePrepareStatementReally();
            this.firstField = null;
            this.m_statementName = null;
            this.m_origSqlFragments = null;
            this.m_executeSqlFragments = null;
            this.fragmentsCount = 0;
        }
    }

    protected void releasePrepareStatementReally() throws SQLException {
        if (this.connection != null && !((Connection)((Object)this.connection)).isClosed()) {
            this.connection.execSQL("DEALLOCATE PREPARE " + this.m_statementName);
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new OSQLException("OSCAR-00409", "88888", 409);
        }
    }

    protected void checkConnectionClosed(Exception exception) {
        try {
            switch (ExceptionUtil.isConnectionClosed(exception)) {
                case 1: 
                case 2: {
                    if (this.getConnection() != null) {
                        this.getConnection().close();
                    }
                    if (this.connection.isSlave()) {
                        this.isClosed = true;
                        break;
                    }
                    this.close();
                }
                default: {
                    return;
                }
            }
        }
        catch (SQLException sQLException) {
            if (this.stLogFlag) {
                Driver.writeLog("OscarStatement.class checkConnectionClosed() ::" + sQLException.getMessage());
            }
            this.isClosed = true;
        }
    }

    protected String replaceProcessing(String object) throws SQLException {
        if (this.replaceProcessingEnabled) {
            if ((object = EscapeProcessor.escapeSQL((String)object, true)) instanceof String) {
                return (String)object;
            }
            return ((EscapeProcessorResult)object).escapedSql;
        }
        return object;
    }

    public int getInsertRowid() throws SQLException {
        if (this.result == null) {
            return 0;
        }
        return (int)this.result.getInsertRowid();
    }

    public void setNull(int n2, int n3) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setNull(int parameterIndex, int sqlType),parameterIndex: " + n2 + ",sqlType: " + n3);
        }
        this.checkClosed();
        switch (n3) {
            case -6: {
                n3 = 0;
                break;
            }
            case 5: {
                n3 = 0;
                break;
            }
            case 4: {
                n3 = 0;
                break;
            }
            case -5: {
                n3 = 0;
                break;
            }
            case 7: {
                n3 = 0;
                break;
            }
            case 6: {
                n3 = 0;
                break;
            }
            case 8: {
                n3 = 0;
                break;
            }
            case -7: 
            case 16: {
                n3 = 0;
                break;
            }
            case 2: 
            case 3: {
                n3 = 0;
                break;
            }
            case 1: {
                n3 = 0;
                break;
            }
            case 12: {
                n3 = 0;
                break;
            }
            case -1: {
                n3 = 0;
                break;
            }
            case 91: {
                n3 = 0;
                break;
            }
            case 92: {
                n3 = 0;
                break;
            }
            case 93: {
                n3 = 0;
                break;
            }
            case -2: {
                n3 = 0;
                break;
            }
            case -4: 
            case -3: {
                n3 = 0;
                break;
            }
            case 1111: {
                n3 = 0;
                break;
            }
            case 2005: {
                n3 = 51;
                break;
            }
            case 2004: {
                n3 = 50;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        this.bind(n2, "null", n3);
    }

    public void setBoolean(int n2, boolean bl) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setBoolean(int parameterIndex, boolean x),parameterIndex: " + n2 + ",x: " + bl);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[n2 - 1] = bl;
            return;
        }
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        if (bl) {
            this.setObject(n2, (Object)"1", this.pMetaData.getParameterType(n2));
            return;
        }
        this.setObject(n2, (Object)"0", this.pMetaData.getParameterType(n2));
    }

    public void setByte(int n2, byte by) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setByte(int parameterIndex, byte x),parameterIndex: " + n2 + ",x: " + by);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[n2 - 1] = by;
            return;
        }
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        this.setObject(n2, (Object)by, this.pMetaData.getParameterType(n2));
    }

    public void setShort(int n2, short s2) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setShort(int parameterIndex, short x),parameterIndex: " + n2 + ",x: " + s2);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[n2 - 1] = s2;
            return;
        }
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        this.setObject(n2, (Object)s2, this.pMetaData.getParameterType(n2));
    }

    public void setInt(int n2, int n3) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setInt(int parameterIndex, int x),parameterIndex: " + n2 + ",x: " + n3);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[n2 - 1] = n3;
            return;
        }
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        this.setObject(n2, (Object)n3, this.pMetaData.getParameterType(n2));
    }

    public void setLong(int n2, long l2) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setLong(int parameterIndex, long x),parameterIndex: " + n2 + ",x: " + l2);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[n2 - 1] = l2;
            return;
        }
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        this.setObject(n2, (Object)l2, this.pMetaData.getParameterType(n2));
    }

    public void setFloat(int n2, float f2) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setFloat(int parameterIndex, float x),parameterIndex: " + n2 + ",x: " + f2);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[n2 - 1] = Float.valueOf(f2);
            return;
        }
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        this.setObject(n2, (Object)Float.valueOf(f2), this.pMetaData.getParameterType(n2));
    }

    public void setDouble(int n2, double d2) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setDouble(int parameterIndex, double x),parameterIndex: " + n2 + ",x: " + d2);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[n2 - 1] = d2;
            return;
        }
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        this.setObject(n2, (Object)d2, this.pMetaData.getParameterType(n2));
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setBigDecimal(int parameterIndex, BigDecimal x),parameterIndex: " + n2 + ",x: " + bigDecimal);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[n2 - 1] = bigDecimal;
            return;
        }
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        if (bigDecimal == null) {
            this.setNull(n2, this.pMetaData.getParameterType(n2));
            return;
        }
        this.setObject(n2, (Object)bigDecimal, this.pMetaData.getParameterType(n2));
    }

    public void setString(int n2, String string) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setString(int i, String x),i: " + n2 + ",x: " + string);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[n2 - 1] = string;
            return;
        }
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n3 = this.pMetaData.getParameterType(n2);
        switch (n3) {
            case 2005: {
                if (string == null) {
                    this.setObject(n2, null);
                    this.m_lobs[n2 - 1] = null;
                } else if (string.length() > 1000) {
                    OscarClob oscarClob;
                    n3 = this.pMetaData.getParameterRelOid(n2);
                    if (n3 != 0) {
                        Character c2 = this.tableTypes.get(n3);
                        if (c2 == null) {
                            c2 = this.getRelKind(n3);
                            this.tableTypes.put(n3, c2);
                        }
                        if (c2.charValue() == 'r') {
                            int n4 = this.pMetaData.getParameterRelColIndex(n2);
                            oscarClob = OscarClob.createForTable(this.getConnection(), n3, n4);
                        } else {
                            oscarClob = ((OscarJdbc2Connection)this.connection).createClob();
                        }
                    } else {
                        oscarClob = ((OscarJdbc2Connection)this.connection).createClob();
                    }
                    oscarClob.setString(1L, string);
                    this.setObject(n2, (Object)oscarClob);
                    this.m_lobs[n2 - 1] = oscarClob;
                } else {
                    this.setObject(n2, (Object)string, n3);
                    this.m_lobs[n2 - 1] = null;
                }
                if (this.m_lobs[n2 - 1] == null || !this.m_lobs[n2 - 1].isTempLob() && !this.m_lobs[n2 - 1].isTableIdLob()) break;
                this.tempResource.add(this.m_lobs[n2 - 1]);
                return;
            }
            default: {
                this.setObject(n2, (Object)string, n3);
            }
        }
    }

    public void setBlobString(int n2, Object object, int n3) throws SQLException {
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        if (object == null) {
            this.setObject(n2, null);
            this.m_lobs[n2 - 1] = null;
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length > 4000) {
                OscarBlob oscarBlob;
                int n4 = this.pMetaData.getParameterRelOid(n2);
                if (n4 != 0) {
                    Character c2 = this.tableTypes.get(n4);
                    if (c2 == null) {
                        c2 = this.getRelKind(n4);
                        this.tableTypes.put(n4, c2);
                    }
                    if (c2.charValue() == 'r') {
                        int n5 = this.pMetaData.getParameterRelColIndex(n2);
                        oscarBlob = OscarBlob.createForTable(this.getConnection(), n4, n5);
                    } else {
                        oscarBlob = ((OscarJdbc2Connection)this.connection).createBlob();
                    }
                } else {
                    oscarBlob = ((OscarJdbc2Connection)this.connection).createBlob();
                }
                oscarBlob.setBytes(1L, byArray);
                this.setObject(n2, (Object)oscarBlob);
                this.m_lobs[n2 - 1] = oscarBlob;
            } else {
                this.setString(n2, OSCARbyte.toOSCARString((byte[])object), 0);
                this.m_lobs[n2 - 1] = null;
            }
        }
        if (this.m_lobs[n2 - 1] != null && (this.m_lobs[n2 - 1].isTempLob() || this.m_lobs[n2 - 1].isTableIdLob())) {
            this.tempResource.add(this.m_lobs[n2 - 1]);
        }
    }

    public void setString(int n2, String string, int n3) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setString(int parameterIndex, String x, int type),parameterIndex: " + n2 + ",x: " + string + ",type: " + n3);
        }
        this.checkClosed();
        if (string == null) {
            this.setNull(n2, 12);
            return;
        }
        StringBuffer stringBuffer = this.sbuf;
        synchronized (stringBuffer) {
            this.sbuf.setLength(0);
            this.sbuf.ensureCapacity(string.length() + string.length() / 10);
            this.sbuf.append('\'');
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (this.connection.getVersion().getTransferType() == 1) {
                    if (c2 == '\\' || c2 == '\'') {
                        this.sbuf.append('\\');
                    }
                } else if (this.connection.getVersion().getTransferType() == 2 && c2 == '\'') {
                    this.sbuf.append('\'');
                    if (!this.hasEscapeChar) {
                        this.hasEscapeChar = true;
                    }
                }
                this.sbuf.append(c2);
            }
            this.sbuf.append('\'');
            this.bind(n2, this.sbuf.toString(), n3);
            return;
        }
    }

    public void setBytes(int n2, byte[] byArray) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setBytes(int parameterIndex, byte x[]),parameterIndex: " + n2 + ",x: " + (byArray == null ? "null" : Arrays.toString(byArray)));
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[n2 - 1] = this.clientEncoding.decode(byArray);
            return;
        }
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        this.setObject(n2, (Object)byArray, this.pMetaData.getParameterType(n2));
    }

    public void setDate(int n2, java.sql.Date date) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setDate(int parameterIndex, java.sql.Date x),parameterIndex: " + n2 + ",x: " + date);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[n2 - 1] = date.toString();
            return;
        }
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        this.setObject(n2, (Object)date, this.pMetaData.getParameterType(n2));
    }

    public void setTime(int n2, Time time) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setTime(int parameterIndex, Time x),parameterIndex: " + n2 + ",x: " + time);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[n2 - 1] = time.toString();
            return;
        }
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        this.setObject(n2, (Object)time, this.pMetaData.getParameterType(n2));
    }

    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setTime(int parameterIndex, Timestamp x),parameterIndex: " + n2 + ",x: " + timestamp);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            this.m_binds[n2 - 1] = timestamp.toString();
            return;
        }
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        this.setObject(n2, (Object)timestamp, this.pMetaData.getParameterType(n2));
    }

    public void setUnicodeStream(int n2, InputStream closeable, int n3) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        switch (this.pMetaData.getParameterType(n2)) {
            case -1: 
            case 1: 
            case 12: {
                break;
            }
            default: {
                throw new OSQLException("OSCAR-00410", "88888", 410);
            }
        }
        try {
            if (closeable == null) {
                this.setString(n2, null, 0);
                return;
            }
            closeable = new InputStreamReader((InputStream)closeable, "UTF-16BE");
            char[] cArray = new char[n3];
            int n4 = ((InputStreamReader)closeable).read(cArray, 0, n3);
            this.setString(n2, new String(cArray, 0, n4), 0);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OSQLException("OSCAR-00303", "88888", 303, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new OSQLException("OSCAR-00303", "88888", 303, iOException.getMessage(), iOException);
        }
    }

    public void clearParameters() throws SQLException {
        this.checkClosed();
        if (this.m_binds != null) {
            for (int i2 = 0; i2 < this.m_binds.length; ++i2) {
                this.m_binds[i2] = null;
                this.m_lobs[i2] = null;
                this.m_bindTypes[i2] = 0;
            }
        }
    }

    public void freeBindedLob(OscarLob oscarLob, int n2) throws SQLException {
        if (oscarLob != null && (n2 == -2 || n2 == -1 || n2 == -3)) {
            if (oscarLob.isTempLob()) {
                oscarLob.freeTemporary();
                return;
            }
            if (oscarLob.isTableIdLob()) {
                oscarLob.freePersist();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setObject(int parameterIndex, Object x, int targetSqlType, int scale),parameterIndex: " + n2 + ",x: " + object + ",targetSqlType: " + n3 + ",scale: " + n4);
        }
        this.checkClosed();
        if (object == null) {
            this.setNull(n2, n3);
            return;
        }
        switch (n3) {
            case 2009: {
                if (object instanceof SQLXML) {
                    this.setSQLXML(n2, (SQLXML)object);
                    return;
                }
                this.setSQLXML(n2, (SQLXML)new OscarSQLXML(this.connection, object.toString()));
                return;
            }
            case 4: {
                if (object instanceof Integer || object instanceof Short || object instanceof Byte) {
                    this.bind(n2, object, 0);
                    return;
                }
                if (object instanceof Float) {
                    if (((Float)object).floatValue() > 2.1474836E9f) throw new OSQLException("OSCAR-00703", "88888", 703);
                    if (((Float)object).floatValue() < -2.1474836E9f) {
                        throw new OSQLException("OSCAR-00703", "88888", 703);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, 4, 4));
                    this.bind(n2, ((Float)object).intValue(), 0);
                    return;
                }
                if (object instanceof Double) {
                    if ((Double)object > 2.147483647E9) throw new OSQLException("OSCAR-00703", "88888", 703);
                    if ((Double)object < -2.147483648E9) {
                        throw new OSQLException("OSCAR-00703", "88888", 703);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, 8, 4));
                    this.bind(n2, ((Double)object).intValue(), 0);
                    return;
                }
                if (object instanceof Long) {
                    if ((Long)object > Integer.MAX_VALUE) throw new OSQLException("OSCAR-00703", "88888", 703);
                    if ((Long)object < Integer.MIN_VALUE) {
                        throw new OSQLException("OSCAR-00703", "88888", 703);
                    }
                    this.bind(n2, ((Long)object).intValue(), 0);
                    return;
                }
                if (object instanceof Boolean) {
                    this.bind(n2, (Boolean)object != false ? 1 : 0, 0);
                    return;
                }
                if (object instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (bigDecimal.doubleValue() > 2.147483647E9) throw new OSQLException("OSCAR-00703", "88888", 703);
                    if (bigDecimal.doubleValue() < -2.147483648E9) {
                        throw new OSQLException("OSCAR-00703", "88888", 703);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, -1, 4));
                    this.bind(n2, (int)bigDecimal.doubleValue(), 0);
                    return;
                }
                if (object instanceof String) {
                    double d2;
                    if (object.toString().trim().equals("")) {
                        this.setNull(n2, n3);
                        return;
                    }
                    try {
                        d2 = Double.parseDouble((String)object);
                    }
                    catch (Exception exception) {
                        int n5;
                        StringBuffer stringBuffer = new StringBuffer((String)object);
                        for (n5 = 0; n5 < stringBuffer.length() && (Character.isDigit(stringBuffer.charAt(n5)) || n5 == 0 && (stringBuffer.charAt(n5) == '-' || stringBuffer.charAt(n5) == '+')); ++n5) {
                        }
                        String string = stringBuffer.substring(0, n5);
                        try {
                            d2 = Double.parseDouble(string);
                        }
                        catch (Exception exception2) {
                            this.setString(n2, object.toString(), 0);
                            return;
                        }
                    }
                    if (d2 > 2.147483647E9) throw new OSQLException("OSCAR-00703", "88888", 703);
                    if (d2 < -2.147483648E9) {
                        throw new OSQLException("OSCAR-00703", "88888", 703);
                    }
                    this.bind(n2, (int)d2, 0);
                    return;
                }
                if (!(object instanceof Character)) throw new OSQLException("OSCAR-00703", "88888", 703);
                try {
                    this.bind(n2, Integer.valueOf(object.toString()), 0);
                    return;
                }
                catch (Exception exception) {
                    throw new OSQLException("OSCAR-00703", "88888", 703, exception);
                }
            }
            case -5: {
                if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
                    this.bind(n2, object, 0);
                    return;
                }
                if (object instanceof Double) {
                    if (((Double)object).longValue() >= Long.MAX_VALUE) throw new OSQLException("OSCAR-00704", "88888", 704);
                    if (((Double)object).longValue() <= Long.MIN_VALUE) {
                        throw new OSQLException("OSCAR-00704", "88888", 704);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, 8, 8));
                    this.bind(n2, ((Double)object).longValue(), 0);
                    return;
                }
                if (object instanceof Float) {
                    if (((Float)object).floatValue() > 9.223372E18f) throw new OSQLException("OSCAR-00704", "88888", 704);
                    if (((Float)object).floatValue() < -9.223372E18f) {
                        throw new OSQLException("OSCAR-00704", "88888", 704);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, 4, 8));
                    this.bind(n2, ((Float)object).longValue(), 0);
                    return;
                }
                if (object instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (bigDecimal.compareTo(new BigDecimal(Long.MAX_VALUE)) == 1) throw new OSQLException("OSCAR-00704", "88888", 704);
                    if (bigDecimal.compareTo(new BigDecimal(Long.MIN_VALUE)) == -1) {
                        throw new OSQLException("OSCAR-00704", "88888", 704);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, -1, 8));
                    this.bind(n2, bigDecimal.longValue(), 0);
                    return;
                }
                if (object instanceof Boolean) {
                    this.bind(n2, (Boolean)object != false ? 1L : 0L, 0);
                    return;
                }
                if (object instanceof String) {
                    if (object.toString().trim().equals("")) {
                        this.setNull(n2, n3);
                        return;
                    }
                    try {
                        BigDecimal bigDecimal = new BigDecimal((String)object);
                        if (bigDecimal.compareTo(new BigDecimal(Long.MAX_VALUE)) == 1) throw new OSQLException("OSCAR-00704", "88888", 704);
                        if (bigDecimal.compareTo(new BigDecimal(Long.MIN_VALUE)) == -1) {
                            throw new OSQLException("OSCAR-00704", "88888", 704);
                        }
                        this.bind(n2, bigDecimal.longValue(), 0);
                        return;
                    }
                    catch (Exception exception) {
                        this.setString(n2, object.toString(), 0);
                        return;
                    }
                }
                if (!(object instanceof Character)) throw new OSQLException("OSCAR-00704", "88888", 704);
                try {
                    this.bind(n2, Long.parseLong(object.toString()), 0);
                    return;
                }
                catch (Exception exception) {
                    throw new OSQLException("OSCAR-00704", "88888", 704, exception);
                }
            }
            case -6: {
                if (object instanceof Integer) {
                    if ((Integer)object > 127) throw new OSQLException("OSCAR-00701", "88888", 701);
                    if ((Integer)object < -128) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    this.bind(n2, object, 0);
                    return;
                }
                if (object instanceof Byte) {
                    this.bind(n2, object, 0);
                    return;
                }
                if (object instanceof Short) {
                    if (((Short)object).intValue() > 127) throw new OSQLException("OSCAR-00701", "88888", 701);
                    if (((Short)object).intValue() < -128) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    this.bind(n2, object, 0);
                    return;
                }
                if (object instanceof Float) {
                    if (((Float)object).floatValue() > 127.0f) throw new OSQLException("OSCAR-00701", "88888", 701);
                    if (((Float)object).floatValue() < -128.0f) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, 4, 1));
                    this.bind(n2, ((Float)object).intValue(), 0);
                    return;
                }
                if (object instanceof Double) {
                    if ((Double)object > 127.0) throw new OSQLException("OSCAR-00701", "88888", 701);
                    if ((Double)object < -128.0) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, 8, 1));
                    this.bind(n2, ((Double)object).intValue(), 0);
                    return;
                }
                if (object instanceof Long) {
                    if ((Long)object > 127L) throw new OSQLException("OSCAR-00701", "88888", 701);
                    if ((Long)object < -128L) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    this.bind(n2, ((Long)object).intValue(), 0);
                    return;
                }
                if (object instanceof Boolean) {
                    this.bind(n2, (Boolean)object != false ? 1 : 0, 0);
                    return;
                }
                if (object instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (bigDecimal.doubleValue() > 127.0) throw new OSQLException("OSCAR-00701", "88888", 701);
                    if (bigDecimal.doubleValue() < -128.0) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, -1, 1));
                    this.bind(n2, (int)bigDecimal.doubleValue(), 0);
                    return;
                }
                if (object instanceof String) {
                    double d3;
                    if (object.toString().trim().equals("")) {
                        this.setNull(n2, n3);
                        return;
                    }
                    try {
                        d3 = Double.parseDouble((String)object);
                    }
                    catch (Exception exception) {
                        this.setString(n2, object.toString(), 0);
                        return;
                    }
                    if (d3 > 127.0) throw new OSQLException("OSCAR-00701", "88888", 701);
                    if (d3 < -128.0) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    this.bind(n2, (int)d3, 0);
                    return;
                }
                if (!(object instanceof Character)) throw new OSQLException("OSCAR-00701", "88888", 701);
                try {
                    this.bind(n2, Integer.valueOf(object.toString()), 0);
                    return;
                }
                catch (Exception exception) {
                    throw new OSQLException("OSCAR-00701", "88888", 701, exception);
                }
            }
            case 5: {
                if (object instanceof Integer) {
                    if ((Integer)object > Short.MAX_VALUE) throw new OSQLException("OSCAR-00702", "88888", 702);
                    if ((Integer)object < Short.MIN_VALUE) {
                        throw new OSQLException("OSCAR-00702", "88888", 702);
                    }
                    this.bind(n2, object, 0);
                    return;
                }
                if (object instanceof Byte || object instanceof Short) {
                    this.bind(n2, object, 0);
                    return;
                }
                if (object instanceof Float) {
                    if (((Float)object).floatValue() > 32767.0f) throw new OSQLException("OSCAR-00702", "88888", 702);
                    if (((Float)object).floatValue() < -32768.0f) {
                        throw new OSQLException("OSCAR-00702", "88888", 702);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, 4, 2));
                    this.bind(n2, ((Float)object).intValue(), 0);
                    return;
                }
                if (object instanceof Double) {
                    if ((Double)object > 32767.0) throw new OSQLException("OSCAR-00702", "88888", 702);
                    if ((Double)object < -32768.0) {
                        throw new OSQLException("OSCAR-00702", "88888", 702);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, 8, 2));
                    this.bind(n2, ((Double)object).intValue(), 0);
                    return;
                }
                if (object instanceof Long) {
                    if ((Long)object > 32767L) throw new OSQLException("OSCAR-00702", "88888", 702);
                    if ((Long)object < -32768L) {
                        throw new OSQLException("OSCAR-00702", "88888", 702);
                    }
                    this.bind(n2, ((Long)object).intValue(), 0);
                    return;
                }
                if (object instanceof Boolean) {
                    this.bind(n2, (Boolean)object != false ? 1 : 0, 0);
                    return;
                }
                if (object instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (bigDecimal.doubleValue() > 32767.0) throw new OSQLException("OSCAR-00702", "88888", 702);
                    if (bigDecimal.doubleValue() < -32768.0) {
                        throw new OSQLException("OSCAR-00702", "88888", 702);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, -1, 2));
                    this.bind(n2, (int)bigDecimal.doubleValue(), 0);
                    return;
                }
                if (object instanceof String) {
                    double d4;
                    if (object.toString().trim().equals("")) {
                        this.setNull(n2, n3);
                        return;
                    }
                    try {
                        d4 = Double.parseDouble((String)object);
                    }
                    catch (Exception exception) {
                        this.setString(n2, object.toString(), 0);
                        return;
                    }
                    if (d4 > 32767.0) throw new OSQLException("OSCAR-00702", "88888", 702);
                    if (d4 < -32768.0) {
                        throw new OSQLException("OSCAR-00702", "88888", 702);
                    }
                    this.bind(n2, (int)d4, 0);
                    return;
                }
                if (!(object instanceof Character)) throw new OSQLException("OSCAR-00702", "88888", 702);
                try {
                    this.bind(n2, Integer.valueOf(object.toString()), 0);
                    return;
                }
                catch (Exception exception) {
                    throw new OSQLException("OSCAR-00702", "88888", 702, exception);
                }
            }
            case 7: {
                if (object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Long || object instanceof Float) {
                    this.bind(n2, object, 0);
                    return;
                }
                if (object instanceof Double) {
                    if ((Double)object > 3.4028234663852886E38) throw new OSQLException("OSCAR-00705", "88888", 705);
                    if ((Double)object < -3.4028234663852886E38) {
                        throw new OSQLException("OSCAR-00705", "88888", 705);
                    }
                    this.bind(n2, object, 0);
                    return;
                }
                if (object instanceof Boolean) {
                    this.bind(n2, new Float((Boolean)object != false ? 1.0f : 0.0f), 0);
                    return;
                }
                if (object instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (bigDecimal.doubleValue() > 3.4028234663852886E38) throw new OSQLException("OSCAR-00705", "88888", 705);
                    if (bigDecimal.doubleValue() < -3.4028234663852886E38) {
                        throw new OSQLException("OSCAR-00705", "88888", 705);
                    }
                    this.bind(n2, new Float(bigDecimal.doubleValue()), 0);
                    return;
                }
                if (object instanceof String) {
                    double d5;
                    if (object.toString().trim().equals("")) {
                        this.setNull(n2, n3);
                        return;
                    }
                    try {
                        d5 = Double.parseDouble((String)object);
                    }
                    catch (Exception exception) {
                        this.setString(n2, object.toString(), 0);
                        return;
                    }
                    if (d5 > 3.4028234663852886E38) throw new OSQLException("OSCAR-00705", "88888", 705);
                    if (d5 < -3.4028234663852886E38) {
                        throw new OSQLException("OSCAR-00705", "88888", 705);
                    }
                    this.bind(n2, new Float((float)d5), 0);
                    return;
                }
                if (!(object instanceof Character)) throw new OSQLException("OSCAR-00705", "88888", 705);
                try {
                    this.bind(n2, Float.valueOf(Float.parseFloat(object.toString())), 0);
                    return;
                }
                catch (Exception exception) {
                    throw new OSQLException("OSCAR-00705", "88888", 705, exception);
                }
            }
            case 6: 
            case 8: {
                if (object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Long || object instanceof Float || object instanceof Double) {
                    this.bind(n2, object, 0);
                    return;
                }
                if (object instanceof Boolean) {
                    this.bind(n2, new Double((Boolean)object != false ? 1.0 : 0.0), 0);
                    return;
                }
                if (object instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (bigDecimal.doubleValue() > Double.MAX_VALUE) throw new OSQLException("OSCAR-00706", "88888", 706);
                    if (bigDecimal.doubleValue() < -1.7976931348623157E308) {
                        throw new OSQLException("OSCAR-00706", "88888", 706);
                    }
                    this.bind(n2, new Double(bigDecimal.doubleValue()), 0);
                    return;
                }
                if (object instanceof String) {
                    double d6;
                    if (object.toString().trim().equals("")) {
                        this.setNull(n2, n3);
                        return;
                    }
                    try {
                        d6 = Double.parseDouble((String)object);
                    }
                    catch (Exception exception) {
                        this.setString(n2, object.toString(), 0);
                        return;
                    }
                    this.bind(n2, d6, 0);
                    return;
                }
                if (!(object instanceof Character)) throw new OSQLException("OSCAR-00706", "88888", 706);
                try {
                    this.bind(n2, Double.parseDouble(object.toString()), 0);
                    return;
                }
                catch (Exception exception) {
                    throw new OSQLException("OSCAR-00706", "88888", 706, exception);
                }
            }
            case 2: 
            case 3: {
                if (object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof BigInteger) {
                    if (object.toString().equals("NaN")) {
                        this.setString(n2, object.toString(), 0);
                        return;
                    }
                    if (n4 == -2147483638) {
                        this.bind(n2, new BigDecimal(object.toString()), 0);
                        return;
                    }
                    this.bind(n2, new BigDecimal(object.toString()).setScale(n4, 4), 0);
                    return;
                }
                if (object instanceof Boolean) {
                    if (n4 == -2147483638) {
                        this.bind(n2, new BigDecimal((Boolean)object != false ? 1 : 0), 0);
                        return;
                    }
                    if (n4 < 0) {
                        throw new OSQLException("OSCAR-00707", "88888", 707);
                    }
                    this.bind(n2, new BigDecimal((Boolean)object != false ? 1 : 0).setScale(n4), 0);
                    return;
                }
                if (object instanceof BigDecimal) {
                    if (n4 == -2147483638) {
                        this.bind(n2, (BigDecimal)object, 0);
                        return;
                    }
                    this.bind(n2, ((BigDecimal)object).setScale(n4, 4), 0);
                    return;
                }
                if (!(object instanceof String)) throw new OSQLException("OSCAR-00707", "88888", 707);
                if (object.toString().trim().equals("")) {
                    this.setNull(n2, n3);
                    return;
                }
                try {
                    if (n4 == -2147483638) {
                        this.bind(n2, new BigDecimal(object.toString().trim()), 0);
                        return;
                    }
                    this.bind(n2, new BigDecimal(object.toString().trim()).setScale(n4, 4), 0);
                    return;
                }
                catch (Exception exception) {
                    this.setString(n2, object.toString(), 0);
                    return;
                }
            }
            case -7: {
                String string;
                if (object instanceof Boolean) {
                    if (((Boolean)object).booleanValue()) {
                        this.setString(n2, "1", 0);
                        return;
                    }
                    this.setString(n2, "0", 0);
                    return;
                }
                if (!(object instanceof BigDecimal || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Short || object instanceof String || object instanceof Character)) {
                    if (!(object instanceof BigInteger)) throw new OSQLException("OSCAR-00717", "88888", 717);
                }
                if ((string = object.toString()).equalsIgnoreCase("true")) {
                    this.setString(n2, "1", 0);
                    return;
                }
                if (string.equalsIgnoreCase("false")) {
                    this.setString(n2, "0", 0);
                    return;
                }
                if (string.length() > 0 && string.charAt(0) == '\u0000') {
                    string = "";
                }
                this.setString(n2, string, 0);
                return;
            }
            case -1: 
            case 1: 
            case 12: {
                if (object instanceof byte[]) {
                    String string;
                    try {
                        string = this.clientEncoding.decode((byte[])object);
                    }
                    catch (Exception exception) {
                        throw new OSQLException("OSCAR-00713", "88888", 713, exception);
                    }
                    this.setString(n2, string, 0);
                    return;
                }
                if (object instanceof OscarBlob) {
                    if (!this.connection.getVersion().isConvertLobLocatorByFunc()) throw new OSQLException("OSCAR-00713", "88888", 713);
                    this.bind(n2, "blob_locator('" + ((OscarBlob)object).getLocatorStr() + "')", -2);
                    return;
                }
                if (object instanceof OtherType) {
                    OtherType otherType = (OtherType)object;
                    if (otherType.getObj() instanceof Reader) {
                        this.setCharacterStream(n2, (Reader)otherType.getObj(), otherType.getLength());
                        return;
                    }
                    if (!(otherType.getObj() instanceof InputStream)) throw new OSQLException("OSCAR-00709", "88888", 709);
                    this.setAsciiStream(n2, (InputStream)otherType.getObj(), otherType.getLength());
                    return;
                }
                String string = object.toString();
                if (string.length() > 0 && string.charAt(0) == '\u0000') {
                    string = "";
                }
                this.setString(n2, string, 0);
                return;
            }
            case 91: {
                if (object instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)object;
                    if (Long.MAX_VALUE == timestamp.getTime()) {
                        this.setString(n2, "infinity", 0);
                        return;
                    }
                    if (Long.MIN_VALUE == timestamp.getTime()) {
                        this.setString(n2, "-infinity", 0);
                        return;
                    }
                    this.setString(n2, object.toString().substring(0, object.toString().indexOf(" ")), 0);
                    return;
                }
                if (object instanceof java.sql.Date) {
                    java.sql.Date date = (java.sql.Date)object;
                    if (Long.MAX_VALUE == date.getTime()) {
                        this.setString(n2, "infinity");
                        return;
                    }
                    if (Long.MIN_VALUE == date.getTime()) {
                        this.setString(n2, "-infinity");
                        return;
                    }
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    this.setString(n2, simpleDateFormat.format(date));
                    return;
                }
                if (object instanceof Date) {
                    Date date = (Date)object;
                    if (Long.MAX_VALUE == date.getTime()) {
                        this.setString(n2, "infinity", 0);
                        return;
                    }
                    if (Long.MIN_VALUE == date.getTime()) {
                        this.setString(n2, "-infinity", 0);
                        return;
                    }
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    this.setString(n2, simpleDateFormat.format(date), 0);
                    return;
                }
                if (!(object instanceof String)) throw new OSQLException("OSCAR-00710", "88888", 710);
                try {
                    if (!"infinity".equalsIgnoreCase((String)object) && !"-infinity".equalsIgnoreCase((String)object)) {
                        long l2 = Timestamp.valueOf(object.toString().trim()).getTime();
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        this.setString(n2, simpleDateFormat.format(new Date(l2)), 0);
                        return;
                    }
                    this.setString(n2, (String)object, 0);
                    return;
                }
                catch (Exception exception) {
                    try {
                        this.setDate(n2, com.oscar.sql.Date.valueOf(object.toString().trim()));
                        return;
                    }
                    catch (Exception exception3) {
                        throw new OSQLException("OSCAR-00710", "88888", 710);
                    }
                }
            }
            case 27: 
            case 92: {
                if (object instanceof Timestamp) {
                    this.setString(n2, object.toString().substring(object.toString().indexOf(" ") + 1), 0);
                    return;
                }
                if (object instanceof Time) {
                    this.setString(n2, object.toString(), 0);
                    return;
                }
                if (!(object instanceof String)) throw new OSQLException("OSCAR-00711", "88888", 711);
                try {
                    long l3 = Timestamp.valueOf(object.toString().trim()).getTime();
                    this.setString(n2, new Time(l3).toString(), 0);
                    return;
                }
                catch (Exception exception) {
                    try {
                        try {
                            this.setString(n2, Time.valueOf(object.toString().trim()).toString(), 0);
                            return;
                        }
                        catch (Exception exception4) {
                            this.setString(n2, object.toString().trim(), 0);
                            return;
                        }
                    }
                    catch (Exception exception5) {
                        throw new OSQLException("OSCAR-00711", "88888", 711, exception5);
                    }
                }
            }
            case 29: 
            case 93: {
                if (object instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)object;
                    if (Long.MAX_VALUE == timestamp.getTime()) {
                        this.setString(n2, "infinity", 0);
                        return;
                    }
                    if (Long.MIN_VALUE == timestamp.getTime()) {
                        this.setString(n2, "-infinity", 0);
                        return;
                    }
                    this.setString(n2, object.toString(), 0);
                    return;
                }
                if (object instanceof Date) {
                    Date date = (Date)object;
                    if (Long.MAX_VALUE == date.getTime()) {
                        this.setString(n2, "infinity", 0);
                        return;
                    }
                    if (Long.MIN_VALUE == date.getTime()) {
                        this.setString(n2, "-infinity", 0);
                        return;
                    }
                    this.setString(n2, new Timestamp(date.getTime()).toString(), 0);
                    return;
                }
                if (!(object instanceof String)) throw new OSQLException("OSCAR-00712", "88888", 712);
                try {
                    if (!"infinity".equalsIgnoreCase((String)object) && !"-infinity".equalsIgnoreCase((String)object)) {
                        long l4 = java.sql.Date.valueOf(object.toString().trim()).getTime();
                        this.setString(n2, new Timestamp(l4).toString(), 0);
                        return;
                    }
                    this.setString(n2, (String)object, 0);
                    return;
                }
                catch (Exception exception) {
                    try {
                        try {
                            Timestamp timestamp = Timestamp.valueOf(object.toString().trim());
                            this.setString(n2, timestamp.toString(), 0);
                            return;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.setString(n2, object.toString(), 0);
                            return;
                        }
                    }
                    catch (Exception exception6) {
                        throw new OSQLException("OSCAR-00712", "88888", 712, exception6);
                    }
                }
            }
            case 16: {
                double d7;
                String string;
                if (object instanceof Boolean) {
                    if (((Boolean)object).booleanValue()) {
                        this.setString(n2, "1", 0);
                        return;
                    }
                    this.setString(n2, "0", 0);
                    return;
                }
                if (!(object instanceof BigDecimal || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Short || object instanceof Byte || object instanceof String || object instanceof Character)) {
                    if (!(object instanceof BigInteger)) throw new OSQLException("OSCAR-00708", "88888", 708);
                }
                if ((string = object.toString()).length() == 1) {
                    if (string.charAt(0) != '1' && string.charAt(0) != 't' && string.charAt(0) != 'y' && string.charAt(0) != 'T' && string.charAt(0) != 'Y') {
                        this.setString(n2, "0", 0);
                        return;
                    }
                    this.setString(n2, "1", 0);
                    return;
                }
                if (string.length() <= 1) {
                    this.setString(n2, "0", 0);
                    return;
                }
                if (string.equalsIgnoreCase("true")) {
                    this.setString(n2, "1", 0);
                    return;
                }
                if (string.equalsIgnoreCase("false")) {
                    this.setString(n2, "0", 0);
                    return;
                }
                if (string.equalsIgnoreCase("yes")) {
                    this.setString(n2, "1", 0);
                    return;
                }
                if (string.equalsIgnoreCase("no")) {
                    this.setString(n2, "0", 0);
                    return;
                }
                try {
                    d7 = Double.parseDouble(string);
                }
                catch (Exception exception) {
                    throw new OSQLException("OSCAR-00708", "88888", 708, exception);
                }
                if (!(d7 >= 1.0E-10) && !(d7 <= -1.0E-10)) {
                    this.setString(n2, "0", 0);
                    return;
                }
                this.setString(n2, "1", 0);
                return;
            }
            case -4: 
            case -3: 
            case -2: {
                if (object instanceof byte[]) {
                    String string;
                    if (this.connection.sendBinaryTypeAsHex()) {
                        this.setString(n2, OSCARbyte.toOSCARString((byte[])object), 0);
                        return;
                    }
                    try {
                        string = this.clientEncoding.decode((byte[])object);
                    }
                    catch (Exception exception) {
                        throw new OSQLException("OSCAR-00713", "88888", 713, exception);
                    }
                    this.setString(n2, string, 0);
                    return;
                }
                if (!(object instanceof String)) {
                    if (!(object instanceof OtherType)) throw new OSQLException("OSCAR-00709", "88888", 709);
                    OtherType otherType = (OtherType)object;
                    if (!(otherType.getObj() instanceof InputStream)) throw new OSQLException("OSCAR-00709", "88888", 709);
                    this.setBinaryStream(n2, (InputStream)otherType.getObj(), otherType.getLength());
                    return;
                }
                if (this.connection.sendBinaryTypeAsHex()) {
                    this.setString(n2, OSCARbyte.toOSCARString(this.encoding.encode((String)object)), 0);
                    return;
                }
                this.setString(n2, (String)object, 0);
                return;
            }
            case 2004: {
                if (object instanceof Blob) {
                    if (!(object instanceof OscarBlob)) {
                        Blob blob = (Blob)object;
                        byte[] byArray = blob.getBytes(1L, (int)blob.length());
                        this.setBlobString(n2, byArray, 2004);
                        return;
                    }
                    if (((OscarBlob)object).isEmptyLob()) {
                        this.bind(n2, "EMPTY_BLOB()", -2);
                        return;
                    }
                    if (this.connection.getVersion().isConvertLobLocatorByFunc()) {
                        this.bind(n2, "blob_locator('" + ((OscarBlob)object).getLocatorStr() + "')", -2);
                        return;
                    }
                    this.setString(n2, ((OscarBlob)object).getLocatorStr(), -2);
                    return;
                }
                if (object instanceof byte[]) {
                    this.setBlobString(n2, (byte[])object, 0);
                    return;
                }
                if (object instanceof InputStream) {
                    this.setBinaryStream(n2, (InputStream)object);
                    return;
                }
                if (!(object instanceof OtherType)) throw new OSQLException("OSCAR-00714", "88888", 714);
                OtherType otherType = (OtherType)object;
                if (!(otherType.getObj() instanceof InputStream)) throw new OSQLException("OSCAR-00709", "88888", 709);
                this.setBinaryStream(n2, (InputStream)otherType.getObj(), otherType.getLength());
                return;
            }
            case 2005: {
                if (object instanceof Clob) {
                    if (object instanceof OscarClob) {
                        if (((OscarClob)object).isEmptyLob()) {
                            this.bind(n2, "EMPTY_CLOB()", -1);
                            return;
                        }
                        if (this.connection.getVersion().isConvertLobLocatorByFunc()) {
                            this.bind(n2, "clob_locator('" + ((OscarClob)object).getLocatorStr() + "')", -1);
                            return;
                        }
                        this.setString(n2, ((OscarClob)object).getLocatorStr(), -1);
                        return;
                    }
                    String string = this.clob2String((Clob)object);
                    if (string.length() > 0 && string.charAt(0) == '\u0000') {
                        string = "";
                    }
                    this.bind(n2, string, 24);
                    return;
                }
                if (object instanceof String) {
                    String string = object.toString();
                    if (string.length() > 0 && string.charAt(0) == '\u0000') {
                        string = "";
                    }
                    this.setString(n2, string, 0);
                    return;
                }
                if (object instanceof byte[]) {
                    String string = this.clientEncoding.decode((byte[])object);
                    this.setString(n2, string, 0);
                    return;
                }
                if (object instanceof Reader) {
                    this.setCharacterStream(n2, (Reader)object);
                    return;
                }
                if (!(object instanceof OtherType)) throw new OSQLException("OSCAR-00715", "88888", 715);
                OtherType otherType = (OtherType)object;
                if (otherType.getObj() instanceof Reader) {
                    this.setCharacterStream(n2, (Reader)otherType.getObj(), otherType.getLength());
                    return;
                }
                if (!(otherType.getObj() instanceof InputStream)) throw new OSQLException("OSCAR-00709", "88888", 709);
                this.setAsciiStream(n2, (InputStream)otherType.getObj(), otherType.getLength());
                return;
            }
            case -11: {
                if (!(object instanceof OscarBfile)) throw new OSQLException("OSCAR-00716", "88888", 716);
                if (this.connection.getVersion().isConvertLobLocatorByFunc()) {
                    this.bind(n2, "bfile_locator('" + ((OscarBfile)object).getLocatorStr() + "')", -3);
                    return;
                }
                this.setString(n2, ((OscarBfile)object).getLocatorStr(), -3);
                return;
            }
            case 1111: {
                this.setString(n2, object.toString(), 0);
                return;
            }
            case 2003: {
                this.setString(n2, this.getArrayToString(object), 0);
                return;
            }
        }
        throw new OSQLException("OSCAR-00411", "88888", 411);
    }

    public String clob2String(Clob object) throws SQLException {
        if (object == null) {
            return null;
        }
        try {
            object = object.getCharacterStream();
            if (object != null) {
                int n2;
                StringBuilder stringBuilder = new StringBuilder();
                char[] cArray = new char[1024];
                while ((n2 = ((Reader)object).read(cArray)) != -1) {
                    stringBuilder.append(cArray, 0, n2);
                }
                return stringBuilder.toString();
            }
            return null;
        }
        catch (Exception exception) {
            throw new OSQLException("OSCAR-00712", "88888", 712, exception);
        }
    }

    protected String getArrayToString(Object object) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof int[]) {
            stringBuffer.append("{");
            for (n2 = 0; n2 < ((int[])object).length; ++n2) {
                stringBuffer.append(((int[])object)[n2]);
                if (n2 >= ((int[])object).length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("}");
        }
        if (object instanceof int[][]) {
            stringBuffer.append("{");
            for (n2 = 0; n2 < ((int[][])object).length; ++n2) {
                stringBuffer.append("{");
                for (int i2 = 0; i2 < ((int[][])object)[n2].length; ++i2) {
                    stringBuffer.append(((int[][])object)[n2][i2]);
                    if (i2 >= ((int[][])object)[n2].length - 1) continue;
                    stringBuffer.append(",");
                }
                stringBuffer.append("}");
                if (n2 >= ((int[][])object).length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("}");
        } else if (object instanceof double[]) {
            stringBuffer.append("{");
            for (n2 = 0; n2 < ((double[])object).length; ++n2) {
                stringBuffer.append(((double[])object)[n2]);
                if (n2 >= ((double[])object).length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("}");
        } else if (object instanceof double[][]) {
            stringBuffer.append("{");
            for (n2 = 0; n2 < ((double[][])object).length; ++n2) {
                stringBuffer.append("{");
                for (int i3 = 0; i3 < ((double[][])object)[n2].length; ++i3) {
                    stringBuffer.append(((double[][])object)[n2][i3]);
                    if (i3 >= ((double[][])object)[n2].length - 1) continue;
                    stringBuffer.append(",");
                }
                stringBuffer.append("}");
                if (n2 >= ((double[][])object).length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("}");
        } else if (object instanceof byte[]) {
            stringBuffer.append("{");
            for (n2 = 0; n2 < ((byte[])object).length; ++n2) {
                stringBuffer.append("\"").append(((byte[])object)[n2]).append("\"");
                if (n2 >= ((byte[])object).length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("}");
        } else if (object instanceof byte[][]) {
            stringBuffer.append("{");
            for (n2 = 0; n2 < ((byte[][])object).length; ++n2) {
                stringBuffer.append("{");
                for (int i4 = 0; i4 < ((byte[][])object)[n2].length; ++i4) {
                    stringBuffer.append("\"").append(((byte[][])object)[n2][i4]).append("\"");
                    if (i4 >= ((byte[][])object)[n2].length - 1) continue;
                    stringBuffer.append(",");
                }
                stringBuffer.append("}");
                if (n2 >= ((byte[][])object).length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("}");
        } else if (object instanceof Object[][]) {
            stringBuffer.append("{");
            for (n2 = 0; n2 < ((Object[][])object).length; ++n2) {
                stringBuffer.append("{");
                for (int i5 = 0; i5 < ((Object[][])object)[n2].length; ++i5) {
                    stringBuffer.append("\"").append(((Object[][])object)[n2][i5]).append("\"");
                    if (i5 >= ((Object[][])object)[n2].length - 1) continue;
                    stringBuffer.append(",");
                }
                stringBuffer.append("}");
                if (n2 >= ((Object[][])object).length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("}");
        } else if (object instanceof Object[]) {
            stringBuffer.append("{");
            for (n2 = 0; n2 < ((Object[])object).length; ++n2) {
                stringBuffer.append("\"").append(((Object[])object)[n2]).append("\"");
                if (n2 >= ((Object[])object).length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("}");
        } else {
            stringBuffer.append(object.toString());
        }
        return stringBuffer.toString();
    }

    public void setObject(int n2, Object object, int n3) throws SQLException {
        this.setObject(n2, object, n3, -2147483638);
    }

    public void setObject(int n2, Object object) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setObject(int parameterIndex, Object x), parameterIndex: " + n2 + ", x: " + object);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            if (object == null) {
                this.m_binds[n2 - 1] = "null";
                return;
            }
            this.m_binds[n2 - 1] = object.toString();
            return;
        }
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        this.setObject(n2, object, this.pMetaData.getParameterType(n2));
    }

    public void registerOutParameter(int n2, int n3) throws SQLException {
        this.checkClosed();
        if (!this.isCallable && !this.isAnonymous) {
            throw new OSQLException("OSCAR-00412", "88888", 412);
        }
        if (this.isResultNeeded && n2 == 1) {
            this.functionReturnType = n3;
            this.returnTypeSet = true;
            this.m_binds[0] = null;
            this.m_bindTypes[0] = 23;
            this.isHaveFuncReturn = true;
        } else if (this.m_binds[n2 - 1] == null) {
            this.setNull(n2, n3);
            this.m_binds[n2 - 1] = null;
        }
        int n4 = this.outParameterIndex.indexOf(n2);
        if (n4 != -1) {
            this.outParameterIndex.remove(n4);
            this.outParameterType.remove(n4);
            --this.parameterNum;
        } else {
            this.fields[n2 - 1] = new Field();
        }
        this.outParameterIndex.add(this.parameterNum, n2);
        Collections.sort(this.outParameterIndex);
        n2 = this.outParameterIndex.indexOf(n2);
        this.outParameterType.insertElementAt(n3, n2);
        ++this.parameterNum;
    }

    public boolean wasNull() throws SQLException {
        if (this.lastIndex == 0) {
            throw new OSQLException("OSCAR-00425", "88888", 425);
        }
        return this.m_outValues[this.lastIndex - 1] == null;
    }

    public String getString(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2, -1, "String");
        return this.getFixedString(n2);
    }

    protected String getFixedString(int n2) throws SQLException {
        this.checkOutParameter(n2);
        if (this.checkNullValue(n2 - 1)) {
            return null;
        }
        return this.encoding.decode((byte[])this.m_outValues[n2 - 1]);
    }

    public boolean getBoolean(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2, 16, "Boolean");
        return TypeConverter.toBoolean(this.getFixedString(n2), this.m_functionTypes[n2 - 1]);
    }

    public byte getByte(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2, -6, "byte");
        int n3 = this.m_functionTypes[n2 - 1];
        if (n3 == 6 || n3 == 8) {
            this.addWarning(new DataTruncation(n2, true, true, 8, 1));
        } else if (n3 == 7) {
            this.addWarning(new DataTruncation(n2, true, true, 4, 1));
        } else if (n3 == 2 || n3 == 3) {
            this.addWarning(new DataTruncation(n2, true, true, -1, 1));
        }
        return TypeConverter.toByte(this.getFixedString(n2), n3);
    }

    public short getShort(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2, 5, "short");
        int n3 = this.m_functionTypes[n2 - 1];
        if (n3 == 6 || n3 == 8) {
            this.addWarning(new DataTruncation(n2, true, true, 8, 2));
        } else if (n3 == 7) {
            this.addWarning(new DataTruncation(n2, true, true, 4, 2));
        } else if (n3 == 2 || n3 == 3) {
            this.addWarning(new DataTruncation(n2, true, true, -1, 2));
        }
        return TypeConverter.toShort(this.getFixedString(n2), n3);
    }

    public int getInt(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2, 4, "int");
        int n3 = this.m_functionTypes[n2 - 1];
        if (n3 == 6 || n3 == 8) {
            this.addWarning(new DataTruncation(n2, true, true, 8, 4));
        } else if (n3 == 7) {
            this.addWarning(new DataTruncation(n2, true, true, 4, 4));
        } else if (n3 == 2 || n3 == 3) {
            this.addWarning(new DataTruncation(n2, true, true, -1, 4));
        }
        return TypeConverter.toInt(this.getFixedString(n2), n3);
    }

    public long getLong(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2, -5, "long");
        int n3 = this.m_functionTypes[n2 - 1];
        if (n3 == 6 || n3 == 8) {
            this.addWarning(new DataTruncation(n2, true, true, 8, 8));
        } else if (n3 == 7) {
            this.addWarning(new DataTruncation(n2, true, true, 4, 8));
        } else if (n3 == 2 || n3 == 3) {
            this.addWarning(new DataTruncation(n2, true, true, -1, 8));
        }
        return TypeConverter.toLong(this.getFixedString(n2), n3);
    }

    public float getFloat(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2, 7, "Float");
        return TypeConverter.toFloat(this.getFixedString(n2), this.m_functionTypes[n2 - 1]);
    }

    public double getDouble(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2, 8, "Double");
        return TypeConverter.toDouble(this.getFixedString(n2), this.m_functionTypes[n2 - 1]);
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2, 3, "BigDecimal");
        return TypeConverter.toBigDecimal(this.getFixedString(n2), this.m_functionTypes[n2 - 1], n3);
    }

    public byte[] getBytes(int n2) throws SQLException {
        this.checkClosed();
        this.checkOutParameter(n2);
        this.checkIndex(n2, -3, "Bytes");
        if (this.checkNullValue(n2 - 1)) {
            return null;
        }
        byte[] byArray = (byte[])this.m_outValues[n2 - 1];
        if (this.clientEncoding.equals(this.encoding)) {
            return TypeConverter.toBytes(this.connection, byArray, this.m_functionTypes[n2 - 1]);
        }
        return TypeConverter.toBytes(this.connection, this.clientEncoding.encode(this.encoding.decode(byArray)), this.m_functionTypes[n2 - 1]);
    }

    public java.sql.Date getDate(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2, 91, "Date");
        return TypeConverter.toDate(this.getFixedString(n2), this.m_functionTypes[n2 - 1]);
    }

    public Time getTime(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2, 92, "Time");
        return TypeConverter.toTime(this.getFixedString(n2), this.m_functionTypes[n2 - 1], this.localCalendar);
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2, 93, "Timestamp");
        return TypeConverter.toTimestamp(this.getFixedString(n2), this.m_functionTypes[n2 - 1], this.localCalendar);
    }

    public ResultSet getCursorResult(int n2) throws SQLException {
        this.checkIndex(n2, -10, "Refcursor");
        if (this.cursorResultMap.containsKey(n2)) {
            return this.cursorResultMap.get(n2);
        }
        OscarCursorResultSet oscarCursorResultSet = new OscarCursorResultSet(this.getFixedString(n2), this.fetchSize, this.connection);
        this.cursorResultMap.put(n2, oscarCursorResultSet);
        return oscarCursorResultSet;
    }

    public Object getObject(int n2) throws SQLException {
        this.checkClosed();
        this.checkProcedure(n2);
        this.checkOutParameter(n2);
        if (this.checkNullValue(n2 - 1)) {
            this.setLastParameterIndex(n2);
            return null;
        }
        int n3 = this.outParameterIndex.indexOf(n2);
        n3 = this.outParameterType.get(n3);
        switch (n3) {
            case -6: {
                return (int)this.getByte(n2);
            }
            case 5: {
                return (int)this.getShort(n2);
            }
            case 4: {
                return this.getInt(n2);
            }
            case -5: {
                return this.getLong(n2);
            }
            case 7: {
                return new Float(this.getFloat(n2));
            }
            case 6: 
            case 8: {
                return new Double(this.getDouble(n2));
            }
            case 2: 
            case 3: {
                this.checkIndex(n2, 3, "Decimal");
                return TypeConverter.toBigDecimal(this.getFixedString(n2), this.m_functionTypes[n2 - 1]);
            }
            case -7: 
            case 16: {
                return this.getBoolean(n2);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n2);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(n2);
            }
            case 91: {
                return this.getDate(n2);
            }
            case 92: {
                return this.getTime(n2);
            }
            case 93: {
                return this.getTimestamp(n2);
            }
            case 2004: {
                return this.connection.getBlobInstance(new String((byte[])this.m_outValues[n2 - 1]));
            }
            case 2005: {
                return this.connection.getClobInstance(new String((byte[])this.m_outValues[n2 - 1]));
            }
            case -11: {
                return this.connection.getBfileInstance(new String((byte[])this.m_outValues[n2 - 1]));
            }
            case -10: {
                return this.getCursorResult(n2);
            }
            case 2003: {
                return this.getStringArray(n2);
            }
        }
        return this.getFixedString(n2);
    }

    public String[] getStringArray(int n2) throws SQLException {
        this.checkIndex(n2, 2003, "String");
        return this.getFixedStringArray(n2);
    }

    protected String[] getFixedStringArray(int n2) throws SQLException {
        this.checkOutParameter(n2);
        if (this.checkNullValue(n2 - 1)) {
            return null;
        }
        String string = this.encoding.decode((byte[])this.m_outValues[n2 - 1]);
        return string.substring(1, string.length() - 1).split(",");
    }

    public String toString() {
        if (this.m_sqlFragments == null) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        for (int i2 = 0; i2 < this.m_binds.length; ++i2) {
            stringBuffer.append(this.m_sqlFragments[i2]);
            if (this.m_binds[i2] == null) {
                stringBuffer.append('?');
                continue;
            }
            stringBuffer.append(this.m_binds[i2]);
        }
        stringBuffer.append(this.m_sqlFragments[this.m_binds.length]);
        return stringBuffer.toString();
    }

    protected void bind(int n2, Object object, int n3) throws SQLException {
        if (n2 <= 0 || n2 > this.m_binds.length) {
            throw new OSQLException("OSCAR-00305", "88888", 305);
        }
        if (n2 == 1 && this.isResultNeeded) {
            throw new OSQLException("OSCAR-00413", "88888", 413);
        }
        this.m_binds[n2 - 1] = object;
        this.m_binds_old[n2 - 1] = object;
        this.m_bindTypes[n2 - 1] = n3;
    }

    protected void checkIndex(int n2, int n3, String string) throws SQLException {
        int n4;
        this.checkProcedure(n2);
        if (this.isResultNeeded && n2 == 1) {
            n4 = this.functionReturnType;
        } else {
            this.checkOutParameter(n2);
            n4 = this.outParameterIndex.indexOf(n2);
            n4 = this.outParameterType.get(n4);
        }
        if (!(n3 == n4 || n3 == -1 || n3 == 8 && n4 == 6 || n3 == 7 && n4 == 6 || n3 == -3 && (n4 == -2 || n4 == -4) || (n3 == 3 || n3 == -5 || n3 == 4 || n3 == 5 || n3 == 8 || n3 == -6) && n4 == 2 || n3 == 16 && n4 == -7 || n3 == 4 && n4 == 16)) {
            throw new OSQLException("OSCAR-00415", "88888", 415, new Object[]{n4, n3});
        }
        this.setLastParameterIndex(n2);
    }

    protected void checkProcedure(int n2) throws SQLException {
        if (!this.isCallable && !this.isAnonymous) {
            throw new SQLException("OSCAR-00416", "88888", 416);
        }
    }

    protected void checkOutParameter(int n2) throws SQLException {
        if (n2 <= 0 || n2 > this.m_functionTypes.length) {
            throw new OSQLException("OSCAR-00305", "88888", 305);
        }
        if (this.m_functionTypes[n2 - 1] == 0) {
            throw new OSQLException("OSCAR-00417", "88888", 417);
        }
    }

    protected void setLastParameterIndex(int n2) {
        this.lastIndex = n2;
    }

    @Override
    public boolean useTid() {
        return this.tidUsed;
    }

    @Override
    public void setUseTid(boolean bl) {
        this.tidUsed = bl;
    }

    @Override
    public boolean isDDLSql() {
        return this.ddlSql;
    }

    @Override
    public boolean isPrepareAndNotRealPrepare() {
        return this.prepareAndNotRealPrepare;
    }

    @Override
    public void setPrepareAndNotRealPrepare(boolean bl) {
        this.prepareAndNotRealPrepare = bl;
    }

    @Override
    public void resetDDLSql(boolean bl) {
        this.ddlSql = bl;
    }

    @Override
    public int getAutoGeneratedInfo() {
        return this.autoGeneratedInfo;
    }

    @Override
    public void importValues(List<String> list) {
        this.importRows = list;
    }

    @Override
    public List<String> getImportValues() {
        return this.importRows;
    }

    @Override
    public void setTransferRowCount(int n2) {
        this.transferCount = n2;
    }

    @Override
    public int getTransferRowCount() {
        return this.transferCount;
    }

    @Override
    public boolean isResultNeeded() {
        return this.isCallable && this.isResultNeeded;
    }

    @Override
    public boolean isCursorUsed() {
        return this.m_statementIsCursor;
    }

    @Override
    public void addBatch(String objectArray) throws SQLException {
        if (this.stLogFlag || this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", addBatch(String o_sql), \n sql: " + (String)objectArray);
        }
        this.checkClosed();
        if (this.batch == null) {
            this.batch = new LinkedList();
        }
        objectArray = new Object[]{new String[]{objectArray}, new Object[0], new String[0]};
        this.batch.add(objectArray);
        if (!this.addBatchUseSql) {
            this.addBatchUseSql = true;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", clearBatch()");
        }
        this.batch = null;
        this.hasEscapeChar = false;
        this.addBatchUseSql = false;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return CommonUtil.convertToInt(this.executeLargeBatch());
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", executeBatch()");
        }
        if (this.useAsynBatch) {
            if (this.batchDataStream != null) {
                this.batchDataStream.finshed();
            }
            this.isBegin = false;
            return null;
        }
        if (this.batch == null) {
            return new long[0];
        }
        int n2 = this.batch.size();
        if (this.statementType == 2 && !this.outParameterType.isEmpty()) {
            throw new BatchUpdateException("oscar.call.outparam", "HY065", 1, new int[0]);
        }
        if (this.result != null) {
            this.result.close();
            this.result = null;
        }
        this.updateBatchCount = 0;
        long[] lArray = new long[n2];
        int n3 = 0;
        try {
            if (n2 > 0) {
                if (this.addBatchUseSql) {
                    String[] stringArray = this.m_sqlFragments;
                    Object[] objectArray = this.m_binds;
                    for (Object object : this.batch) {
                        this.m_sqlFragments = (String[])object[0];
                        this.m_binds = (Object[])object[1];
                        if (this.m_sqlFragments != null && this.m_sqlFragments.length == 1) {
                            object = OscarSqlProcessor.parsingWithCheck(this.m_sqlFragments[0]);
                            this.selectSql = ((OscarSqlProcessor.ParseResult)object).isSelectSql();
                            this.insertSql = ((OscarSqlProcessor.ParseResult)object).isInsertSql();
                            this.isAnonymous = ((OscarSqlProcessor.ParseResult)object).isAnonymous();
                            if (this.isAnonymous && !this.m_sqlFragments[0].substring(0, 2).equalsIgnoreCase("DO")) {
                                this.m_sqlFragments[0] = "DO " + this.m_sqlFragments[0];
                            }
                        }
                        lArray[n3] = this.executeUpdate();
                        ++n3;
                    }
                    this.m_sqlFragments = stringArray;
                    this.m_binds = objectArray;
                } else {
                    if (this.m_bindTypes.length == 0) {
                        this.execute();
                        lArray[0] = this.getUpdateCount();
                    } else {
                        if (this.batchPacket != null) {
                            this.batchPacket.a(this.batch, this.m_statementName, this.connection.getEncoding(), this.connection.getBatchBufferSize());
                        } else {
                            this.batchPacket = new l(this.batch, this.m_statementName, this.connection.getEncoding(), this.connection.getBatchBufferSize());
                        }
                        this.batchPacket.a(this.connection);
                        this.getDBConnection().getQueryExecutor().executeBatch(this.batchPacket, (BaseStatement)this, lArray);
                    }
                    if (this.result != null && this.result.reallyResultSet() && !this.isCallable && this.autoGeneratedInfo == -1) {
                        throw new OSQLException("OSCAR-00403", "88888", 403);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            long[] lArray2;
            if (this.addBatchUseSql) {
                lArray2 = new long[n3];
                if (n3 > 1) {
                    System.arraycopy(lArray, 0, lArray2, 0, n3);
                }
            } else {
                lArray2 = new long[this.updateBatchCount];
                System.arraycopy(lArray, 0, lArray2, 0, this.updateBatchCount);
            }
            this.checkConnectionClosed(sQLException);
            throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), CommonUtil.convertToInt(lArray2));
        }
        finally {
            if (this.batch != null) {
                this.batch.clear();
            }
            this.cleanEnvTemp();
        }
        this.addBatchUseSql = false;
        this.warnings = null;
        return lArray;
    }

    public void executeBatchAsyn(List list) throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", executeBatchAsyn(List asynBatch)");
        }
        if (list == null) {
            return;
        }
        int n2 = list.size();
        if (this.statementType == 2 && !this.outParameterType.isEmpty()) {
            throw new BatchUpdateException("oscar.call.outparam", "HY065", 1, new int[0]);
        }
        long[] lArray = new long[list.size()];
        try {
            if (n2 > 0) {
                if (this.batchPacket != null) {
                    this.batchPacket.a(list, this.m_statementName, this.connection.getEncoding(), this.connection.getBatchBufferSize());
                } else {
                    this.batchPacket = new l(list, this.m_statementName, this.connection.getEncoding(), this.connection.getBatchBufferSize());
                }
                this.batchPacket.a(this.connection);
                this.getDBConnection().getQueryExecutor().executeBatch(this.batchPacket, (BaseStatement)this, lArray);
                if (this.result != null && this.result.reallyResultSet() && !this.isCallable && this.autoGeneratedInfo == -1) {
                    throw new OSQLException("OSCAR-00403", "88888", 403);
                }
            }
        }
        catch (SQLException sQLException) {
            long[] lArray2 = new long[list.size()];
            System.arraycopy(lArray, 0, lArray2, 0, list.size());
            this.checkConnectionClosed(sQLException);
            throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), CommonUtil.convertToInt(lArray2));
        }
        finally {
            list.clear();
            this.cleanEnvTemp();
        }
        this.result = null;
        this.warnings = null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return (Connection)((Object)this.connection);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchdirection;
    }

    @Override
    public void setFetchDirection(int n2) throws SQLException {
        this.checkClosed();
        if (n2 != 1000 && n2 != 1001 && n2 != 1002) {
            throw new OSQLException("OSCAR-00418", "88888", 418);
        }
        if (this.resultSetType == 1003 && n2 != 1000) {
            throw new OSQLException("OSCAR-00418", "88888", 418);
        }
        this.fetchdirection = n2;
    }

    @Override
    public void setFetchSize(int n2) throws SQLException {
        this.checkClosed();
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", setFetchSize(int rows), fetchSize: " + n2);
        }
        if (n2 < 0) {
            throw new OSQLException("OSCAR-00307", "88888", 307);
        }
        this.fetchSize = n2;
    }

    public void setResultSetConcurrency(int n2) throws SQLException {
        this.resultSetConcurrency = n2;
    }

    public void setResultSetType(int n2) throws SQLException {
        this.resultSetType = n2;
    }

    @Override
    public void setResultSetCanUpdateable(boolean bl) throws SQLException {
        this.resultSetCanUpdateable = bl;
    }

    public void addBatch() throws SQLException {
        this.checkClosed();
        Object object = new Object[this.m_binds.length];
        int[] nArray = new int[this.m_bindTypes.length];
        System.arraycopy(this.m_binds, 0, object, 0, this.m_binds.length);
        System.arraycopy(this.m_bindTypes, 0, nArray, 0, this.m_bindTypes.length);
        object = new BatchRowData((Object[])object, nArray, this.hasEscapeChar);
        if (this.useAsynBatch) {
            if (!this.isBegin) {
                this.isBegin = true;
                if (this.batchDataStream == null) {
                    this.batchDataStream = new BatchDataStream(this);
                } else {
                    this.batchDataStream.reInit();
                }
            }
            this.batchDataStream.addBatchData((BatchRowData)object);
        } else {
            if (this.batch == null) {
                this.batch = new LinkedList();
            }
            this.batch.add(object);
            this.hasEscapeChar = false;
            if (this.addBatchUseSql) {
                this.addBatchUseSql = false;
            }
        }
        if (this.m_binds != null) {
            for (int i2 = 0; i2 < this.m_binds.length; ++i2) {
                this.m_binds[i2] = null;
                this.m_lobs[i2] = null;
            }
        }
    }

    public void setArray(int n2, Array array) throws SQLException {
        this.checkClosed();
        if (array == null) {
            this.setNull(n2, 12);
            return;
        }
        this.setString(n2, array.toString());
    }

    public void setBlob(int n2, Blob blob) throws SQLException {
        this.setObject(n2, (Object)blob);
    }

    public void setBfile(int n2, OscarBfile oscarBfile) throws SQLException {
        this.setObject(n2, (Object)oscarBfile);
    }

    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.setAsciiStream(n2, inputStream, Long.parseLong(String.valueOf(n3)));
    }

    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.setBinaryStream(n2, inputStream, Long.parseLong(String.valueOf(n3)));
    }

    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.setCharacterStream(n2, reader, Long.parseLong(String.valueOf(n3)));
    }

    public void setClob(int n2, Clob clob) throws SQLException {
        this.setObject(n2, (Object)clob);
    }

    public void setNull(int n2, int n3, String string) throws SQLException {
        this.setNull(n2, n3);
    }

    public void setRef(int n2, Ref ref) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented();
    }

    public void setDate(int n2, java.sql.Date date, Calendar calendar) throws SQLException {
        this.checkClosed();
        if (calendar == null) {
            this.setDate(n2, date);
            return;
        }
        if (date == null) {
            this.setDate(n2, null);
            return;
        }
        long l2 = calendar.get(15) + calendar.get(16);
        long l3 = this.systemCal.get(15) + this.systemCal.get(16);
        this.setDate(n2, new java.sql.Date(date.getTime() + (l3 - l2)));
    }

    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        this.checkClosed();
        if (calendar == null) {
            this.setTime(n2, time);
            return;
        }
        if (time == null) {
            this.setTime(n2, null);
            return;
        }
        long l2 = calendar.get(15) + calendar.get(16);
        long l3 = this.systemCal.get(15) + this.systemCal.get(16);
        this.setTime(n2, new Time(time.getTime() + (l3 - l2)));
    }

    public void setTimestamp(int n2, Timestamp timestamp, Calendar comparable) throws SQLException {
        if (comparable == null) {
            this.setTimestamp(n2, timestamp);
            return;
        }
        if (timestamp == null) {
            this.setTimestamp(n2, null);
            return;
        }
        long l2 = comparable.get(15) + comparable.get(16);
        long l3 = this.systemCal.get(15) + this.systemCal.get(16);
        comparable = new Timestamp(timestamp.getTime() - (l3 - l2));
        ((Timestamp)comparable).setNanos(timestamp.getNanos());
        this.setTimestamp(n2, (Timestamp)comparable);
    }

    public Array getArray(int n2) throws SQLException {
        this.checkClosed();
        n2 = this.outParameterIndex.indexOf(n2) + 1;
        return this.result.getArray(n2);
    }

    public OscarBfile getBfile(int n2) throws SQLException {
        this.checkOutParameter(n2);
        this.checkIndex(n2, -11, "bfile");
        if (this.m_functionTypes[n2 - 1] != -11) {
            throw new OSQLException("OSCAR-00714", "88888", 714);
        }
        if (this.checkNullValue(n2 - 1)) {
            return null;
        }
        return this.connection.getBfileInstance(new String((byte[])this.m_outValues[n2 - 1]));
    }

    protected boolean checkNullValue(int n2) {
        return this.m_outValues[n2] == null;
    }

    public Blob getBlob(int n2) throws SQLException {
        this.checkClosed();
        this.checkOutParameter(n2);
        this.checkIndex(n2, 2004, "blob");
        if (this.m_functionTypes[n2 - 1] != 2004) {
            throw new OSQLException("OSCAR-00714", "88888", 714);
        }
        if (this.checkNullValue(n2 - 1)) {
            return null;
        }
        return this.connection.getBlobInstance(new String((byte[])this.m_outValues[n2 - 1]));
    }

    public Clob getClob(int n2) throws SQLException {
        this.checkClosed();
        this.checkOutParameter(n2);
        this.checkIndex(n2, 2005, "clob");
        if (this.m_functionTypes[n2 - 1] != 2005) {
            throw new OSQLException("OSCAR-00715", "88888", 715);
        }
        if (this.checkNullValue(n2 - 1)) {
            return null;
        }
        return this.connection.getClobInstance(new String((byte[])this.m_outValues[n2 - 1]));
    }

    public Object getObject(int n2, Map map) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented();
    }

    public Ref getRef(int n2) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented();
    }

    public java.sql.Date getDate(int n2, Calendar calendar) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2, 91, "Date");
        return TypeConverter.toDate(this.getFixedString(n2), this.m_functionTypes[n2 - 1], calendar, this.systemCal);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2, 92, "Time");
        return TypeConverter.toTime(this.getFixedString(n2), this.m_functionTypes[n2 - 1], calendar, this.systemCal);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2, 93, "Timestamp");
        return TypeConverter.toTimestamp(this.getFixedString(n2), this.m_functionTypes[n2 - 1], calendar, this.systemCal);
    }

    public void registerOutParameter(int n2, int n3, String string) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented();
    }

    protected void setStatementType(int n2) {
        this.statementType = n2;
    }

    @Override
    public boolean getMoreResults(int n2) throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return false;
        }
        BaseResultSet baseResultSet = (BaseResultSet)this.result.getNext();
        block0 : switch (n2) {
            case 1: {
                this.result.close();
                break;
            }
            case 3: {
                while (true) {
                    this.result.close();
                    this.result = (BaseResultSet)this.result.getPrevious();
                    if (this.result == null) break block0;
                }
            }
            case 2: {
                break;
            }
            default: {
                throw new OSQLException("OSCAR-00419", "88888", 419);
            }
        }
        this.result = baseResultSet;
        return this.result != null && this.result.reallyResultSet();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkClosed();
        try {
            return this.doGeneratedKeys();
        }
        catch (SQLException sQLException) {
            this.checkConnectionClosed(sQLException);
            throw sQLException;
        }
    }

    public ResultSet doGeneratedKeys() throws SQLException {
        if (this.autoGeneratedInfo == -1) {
            throw new OSQLException("OSCAR-00420", "88888", 420);
        }
        if (this.result == null) {
            return null;
        }
        if (this.result.getStatusString() != null && !this.result.getStatusString().startsWith("21")) {
            return this.createResultSet(new Field[0], new ArrayList<byte[][]>(), null, 0L, 0L);
        }
        if (this.supportGeneratedKey && (this.autoGeneratedInfo == 3 || this.autoGeneratedInfo == 2 || this.autoGeneratedInfo == 1)) {
            if (this.autoGeneratedInfo == 1) {
                boolean bl = false;
                List<byte[][]> list = this.result.getTuples();
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    byte[][] byArray = list.get(i2);
                    if (byArray instanceof byte[][]) {
                        if (byArray.length == 1 && byArray[0] == null) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        continue;
                    }
                    bl = false;
                }
                if (bl) {
                    this.result.reInit(this.result.getFields(), new ArrayList<byte[][]>(), this.result.getStatusString(), 0L, this.result.getInsertRowid());
                }
            }
            this.result.setType(1004);
            return this.result;
        }
        Object object = this.result.getTidField();
        if (object == null) {
            if (this.firstField != null) {
                Driver.writeLog("Filed\u4e3a\u7a7a\u4e86,\u524d\u4e00\u4e2aField\u4e0d\u4e3a\u7a7a");
                object = this.firstField;
            } else {
                throw new OSQLException("OSCAR-00318", "88888", 318);
            }
        }
        String string = ((Field)object).getSchemaName();
        String string2 = ((Field)object).getTableName();
        if (string == null || string2 == null) {
            Driver.writeLog("schemaName\u6216\u8005tableName\u4e3a\u7a7a");
            if (this.firstField != null) {
                string = this.firstField.getSchemaName();
                string2 = this.firstField.getTableName();
            } else {
                throw new OSQLException("OSCAR-00318", "88888", 318);
            }
        }
        object = new StringBuffer(128);
        StringBuffer stringBuffer = new StringBuffer(64);
        long l2 = this.result.getInsertRowid();
        stringBuffer.append("ROWID = ").append(l2);
        if (this.autoGeneratedInfo == 0) {
            ((StringBuffer)object).append("SELECT ROWID FROM " + OscarStatement.getFullName(string, string2) + " WHERE 1 = 0");
        } else if (this.autoGeneratedInfo == 1) {
            String string3 = string + "." + string2;
            String string4 = this.generatedKeyMap.get(string3);
            if (string4 == null) {
                BaseResultSet baseResultSet;
                String string5 = "SELECT B.ATTNAME FROM INFO_SCHEM.V_SYS_ATTRIBUTE B WHERE B.ATTISAUTO=TRUE AND B.ATTRELID=(SELECT GETRELOID('" + string + "','" + string2 + "'))";
                try {
                    baseResultSet = this.connection.execSQL(string5.toString());
                }
                catch (SQLException sQLException) {
                    object = sQLException;
                    if (sQLException.getMessage().contains("ATTAUTOINC\" not found")) {
                        throw new OSQLException("OSCAR-00431", "88888", 431);
                    }
                    throw object;
                }
                if (baseResultSet.next()) {
                    string4 = baseResultSet.getString(1);
                    this.generatedKeyMap.put(string3, string4);
                } else {
                    return this.createResultSet(new Field[0], new ArrayList<byte[][]>(), null, 0L, 0L);
                }
            }
            ((StringBuffer)object).append("SELECT \"" + string4 + "\" FROM " + OscarStatement.getFullName(string, string2) + " WHERE ");
            ((StringBuffer)object).append(stringBuffer);
        } else if (this.autoGeneratedInfo == 2) {
            int n2;
            BaseResultSet baseResultSet = this.connection.execSQL("SELECT * FROM " + OscarStatement.getFullName(string, string2) + " WHERE 1 = 0");
            Field[] fieldArray = baseResultSet.getFields();
            String[] stringArray = new String[this.columnIndex.length];
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                try {
                    stringArray[n2] = fieldArray[this.columnIndex[n2] - 1].getName();
                    continue;
                }
                catch (Exception exception) {
                    throw new OSQLException("OSCAR-00304", "88888", 304);
                }
            }
            ((StringBuffer)object).append("SELECT ");
            for (n2 = 0; n2 < this.columnIndex.length; ++n2) {
                if (n2 == 0) {
                    ((StringBuffer)object).append("\"" + stringArray[n2] + "\"");
                    continue;
                }
                ((StringBuffer)object).append(",");
                ((StringBuffer)object).append("\"" + stringArray[n2] + "\"");
            }
            ((StringBuffer)object).append(" FROM " + OscarStatement.getFullName(string, string2) + " WHERE ");
            ((StringBuffer)object).append(stringBuffer);
        } else {
            ((StringBuffer)object).append("SELECT ");
            for (int i3 = 0; i3 < this.columnName.length; ++i3) {
                if (i3 == 0) {
                    ((StringBuffer)object).append(this.columnName[i3]);
                    continue;
                }
                ((StringBuffer)object).append(",");
                ((StringBuffer)object).append(this.columnName[i3]);
            }
            ((StringBuffer)object).append(" FROM " + OscarStatement.getFullName(string, string2) + " WHERE ");
            ((StringBuffer)object).append(stringBuffer);
        }
        return this.connection.execSQL(((StringBuffer)object).toString());
    }

    private static String getFullName(String string, String string2) {
        return "\"" + string + "\".\"" + string2 + "\"";
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return CommonUtil.convertToInt(this.getLargeUpdateCount());
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return -1L;
        }
        if (this.result.reallyResultSet()) {
            if (this.result.getStatusString() != null && this.result.getStatusString().startsWith("21")) {
                return this.result.getResultCount();
            }
            if (!this.connection.isCompatibleOracle()) {
                return -1L;
            }
            if (this.result.next()) {
                try {
                    return this.result.getLong(1);
                }
                catch (SQLException sQLException) {
                    return -1L;
                }
            }
            return -1L;
        }
        return this.result.getResultCount();
    }

    @Override
    public int executeUpdate(String string, int n2) throws SQLException {
        return CommonUtil.convertToInt(this.executeLargeUpdate(string, n2));
    }

    @Override
    public long executeLargeUpdate(String string, int n2) throws SQLException {
        if (this.stLogFlag || this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", executeUpdate(String sql, int autoGeneratedKeys), \n sql: " + string + ", autoGeneratedKeys: " + n2);
        }
        if (n2 == 2) {
            this.autoGeneratedInfo = 0;
        } else if (n2 == 1) {
            this.autoGeneratedInfo = 1;
        } else {
            throw new OSQLException("OSCAR-00210", "88888", 210);
        }
        return this.executeLargeUpdate(string);
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        return CommonUtil.convertToInt(this.executeLargeUpdate(string, nArray));
    }

    @Override
    public long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        if (this.stLogFlag || this.logFlag) {
            StringBuilder stringBuilder = new StringBuilder(30);
            stringBuilder.append(OscarStatement.class).append(", executeUpdate(String sql, int columnIndexes[]), \n sql: ");
            stringBuilder.append(string).append(", columnIndexes: ");
            if (nArray == null) {
                stringBuilder.append("null");
            } else {
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    stringBuilder.append(nArray[i2]).append(" ");
                }
            }
            Driver.writeLog(this.sessionId, this.pid, stringBuilder.toString());
        }
        this.autoGeneratedInfo = 2;
        if (nArray != null) {
            this.columnIndex = new int[nArray.length];
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                this.columnIndex[i3] = nArray[i3];
            }
        }
        return this.executeLargeUpdate(string);
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        return CommonUtil.convertToInt(this.executeLargeUpdate(string, stringArray));
    }

    @Override
    public long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        if (this.stLogFlag || this.logFlag) {
            StringBuilder stringBuilder = new StringBuilder(20);
            stringBuilder.append(OscarStatement.class).append(", executeUpdate(String sql, String columnNames[]), \n sql: ");
            stringBuilder.append(string).append(", columnNames: ");
            if (stringArray == null) {
                stringBuilder.append("null");
            } else {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    stringBuilder.append(stringArray[i2]).append(" ");
                }
            }
            Driver.writeLog(this.sessionId, this.pid, stringBuilder.toString());
        }
        this.autoGeneratedInfo = 3;
        if (stringArray != null) {
            this.columnName = new String[stringArray.length];
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                this.columnName[i3] = stringArray[i3];
            }
        }
        return this.executeLargeUpdate(string);
    }

    @Override
    public boolean execute(String string, int n2) throws SQLException {
        if (this.stLogFlag || this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatement.class + ", execute(String sql, int autoGeneratedKeys), \n sql: " + string + ", autoGeneratedKeys: " + n2);
        }
        if (n2 == 2) {
            this.autoGeneratedInfo = 0;
        } else if (n2 == 1) {
            this.autoGeneratedInfo = 1;
        } else {
            throw new OSQLException("OSCAR-00210", "88888", 210);
        }
        return this.execute(string);
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        if (this.stLogFlag || this.logFlag) {
            StringBuilder stringBuilder = new StringBuilder(20);
            stringBuilder.append(OscarStatement.class).append(", execute(String sql, int columnIndexes[]), \n sql: ");
            stringBuilder.append(string).append(", columnIndexes: ");
            if (nArray == null) {
                stringBuilder.append("null");
            } else {
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    stringBuilder.append(nArray[i2]).append(" ");
                }
            }
            Driver.writeLog(this.sessionId, this.pid, stringBuilder.toString());
        }
        this.autoGeneratedInfo = 2;
        if (nArray != null) {
            this.columnIndex = new int[nArray.length];
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                this.columnIndex[i3] = nArray[i3];
            }
        }
        return this.execute(string);
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        if (this.stLogFlag || this.logFlag) {
            StringBuilder stringBuilder = new StringBuilder(20);
            stringBuilder.append(OscarStatement.class).append(", execute(String sql, String columnNames[]), \n sql: ");
            stringBuilder.append(string).append(", columnNames: ");
            if (stringArray == null) {
                stringBuilder.append("null");
            } else {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    stringBuilder.append(stringArray[i2]).append(" ");
                }
            }
            Driver.writeLog(this.sessionId, this.pid, stringBuilder.toString());
        }
        this.autoGeneratedInfo = 3;
        if (stringArray != null) {
            this.columnName = new String[stringArray.length];
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                this.columnName[i3] = stringArray[i3];
            }
        }
        return this.execute(string);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkClosed();
        return this.resultSetHoldability;
    }

    public void setResultSetHoldability(int n2) throws SQLException {
        this.resultSetHoldability = n2;
    }

    public void setURL(int n2, URL uRL) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        if (this.m_statementName == null) {
            throw new OSQLException("OSCAR-00421", "88888", 421);
        }
        if (this.pMetaData != null) {
            return this.pMetaData;
        }
        throw new OSQLException("OSCAR-00421", "88888", 421);
    }

    public void registerOutParameter(String string, int n2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n3 = this.pMetaData.getIndex(string);
        this.registerOutParameter(n3, n2);
    }

    public void registerOutParameter(String string, int n2, String string2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n3 = this.pMetaData.getIndex(string);
        this.registerOutParameter(n3, n2, string2);
    }

    public URL getURL(int n2) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented();
    }

    public void setURL(String string, URL uRL) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setURL(n2, uRL);
    }

    public void setNull(String string, int n2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n3 = this.pMetaData.getIndex(string);
        this.setNull(n3, n2);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setBoolean(n2, bl);
    }

    public void setByte(String string, byte by) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setByte(n2, by);
    }

    public void setShort(String string, short s2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setShort(n2, s2);
    }

    public void setInt(String string, int n2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n3 = this.pMetaData.getIndex(string);
        this.setInt(n3, n2);
    }

    public void setLong(String string, long l2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setLong(n2, l2);
    }

    public void setFloat(String string, float f2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setFloat(n2, f2);
    }

    public void setDouble(String string, double d2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setDouble(n2, d2);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setBigDecimal(n2, bigDecimal);
    }

    public void setString(String string, String string2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setString(n2, string2);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setBytes(n2, byArray);
    }

    public void setDate(String string, java.sql.Date date) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setDate(n2, date);
    }

    public void setTime(String string, Time time) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setTime(n2, time);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setTimestamp(n2, timestamp);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n3 = this.pMetaData.getIndex(string);
        this.setAsciiStream(n3, inputStream, n2);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n3 = this.pMetaData.getIndex(string);
        this.setBinaryStream(n3, inputStream, n2);
    }

    public void setObject(String string, Object object, int n2, int n3) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n4 = this.pMetaData.getIndex(string);
        this.setObject(n4, object, n2, n3);
    }

    public void setObject(String string, Object object, int n2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n3 = this.pMetaData.getIndex(string);
        this.setObject(n3, object, n2);
    }

    public void setObject(String string, Object object) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setObject(n2, object);
    }

    public void setCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n3 = this.pMetaData.getIndex(string);
        this.setCharacterStream(n3, reader, n2);
    }

    public void setDate(String string, java.sql.Date date, Calendar calendar) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setDate(n2, date, calendar);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setTime(n2, time, calendar);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setTimestamp(n2, timestamp, calendar);
    }

    public void setNull(String string, int n2, String string2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n3 = this.pMetaData.getIndex(string);
        this.setNull(n3, n2, string2);
    }

    public String getString(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getString(n2);
    }

    public boolean getBoolean(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getBoolean(n2);
    }

    public byte getByte(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getByte(n2);
    }

    public short getShort(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getShort(n2);
    }

    public int getInt(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getInt(n2);
    }

    public long getLong(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getLong(n2);
    }

    public float getFloat(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getFloat(n2);
    }

    public double getDouble(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getDouble(n2);
    }

    public byte[] getBytes(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getBytes(n2);
    }

    public java.sql.Date getDate(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getDate(n2);
    }

    public Time getTime(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getTime(n2);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getTimestamp(n2);
    }

    public Object getObject(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getObject(n2);
    }

    public Object getObject(String string, Map map) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getObject(n2, map);
    }

    public Ref getRef(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getRef(n2);
    }

    public OscarBfile getBfile(String string) throws SQLException {
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getBfile(n2);
    }

    public Blob getBlob(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getBlob(n2);
    }

    public Clob getClob(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getClob(n2);
    }

    public Array getArray(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getArray(n2);
    }

    public java.sql.Date getDate(String string, Calendar calendar) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getDate(n2, calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getTime(n2, calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getTimestamp(n2, calendar);
    }

    public URL getURL(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getURL(n2);
    }

    protected void setAutoGeneratedInfo(int n2) {
        this.autoGeneratedInfo = n2;
    }

    protected void setAutoGeneratedIndexes(int[] nArray) {
        this.columnIndex = nArray;
    }

    protected void setAutoGeneratedNames(String[] stringArray) {
        this.columnName = stringArray;
    }

    @Override
    public BaseResultSet createResultSet(Field[] fieldArray, List<byte[][]> list, String string, long l2, long l3) throws SQLException {
        return OscarResultSet.getInstance(this, fieldArray, list, string, l2, l3, this.fetchSize, this.maxrows);
    }

    @Override
    public BaseResultSet createResultSet(Field[] fieldArray, List<byte[][]> list, String string, long l2, long l3, int n2) throws SQLException {
        return OscarResultSet.getInstanceDataKind(this, fieldArray, list, string, l2, l3, n2, this.maxrows, n2);
    }

    @Override
    public int getStatementType() {
        return this.statementType;
    }

    @Override
    public void setResultSet(BaseResultSet baseResultSet) {
        this.result = baseResultSet;
    }

    @Override
    public void setUpdateBatchSize(int n2) {
        this.updateBatchCount = n2;
    }

    public byte[] backupKstore(String string) throws SQLException {
        return this.getDBConnection().getQueryExecutor().backupKstore(string, this);
    }

    public byte[] getNextPhysicalDataRow() throws SQLException {
        return this.getDBConnection().getQueryExecutor().getNextPhysicalDataRow(this);
    }

    public void restoreKstore(String string, byte[] byArray, byte[] byArray2) throws SQLException {
        this.getDBConnection().getQueryExecutor().restoreKstore(string, byArray, byArray2, this);
    }

    public PartitionInfo getPartitionInfo(String object) throws SQLException {
        ArrayList<String> arrayList;
        PartitionInfo partitionInfo = new PartitionInfo();
        Object object2 = "select TABLE_TYPE from tables where TABLE_NAME = '" + (String)object + "'";
        if ((object2 = this.executeQuery((String)object2)).next()) {
            String string = object2.getString("TABLE_TYPE");
            if (string != null && string.equalsIgnoreCase("KSTORE")) {
                partitionInfo.setTableType(1);
            } else {
                partitionInfo.setTableType(0);
            }
        }
        object2.close();
        object2 = "select version()";
        object2 = this.executeQuery((String)object2);
        boolean bl = true;
        boolean bl2 = false;
        if (object2.next() && (arrayList = object2.getString("VERSION")) != null && !"".equals(arrayList) && ((String)((Object)arrayList)).startsWith("ShenTong KSTORE")) {
            bl = false;
        }
        object2.close();
        if (bl) {
            object2 = "select PARTTYPE1, PARTTYPE2 from v_sys_PART_TABLES where relname='" + (String)object + "' order by OID";
            if ((object2 = this.executeQuery((String)object2)).next()) {
                arrayList = object2.getString("PARTTYPE1");
                partitionInfo.setPartType(this.parsePartType((String)((Object)arrayList)));
                Object object3 = object2.getString("PARTTYPE2");
                partitionInfo.setSubPartType(this.parsePartType((String)object3));
                object2.close();
                object2 = "select PARTNAME from v_sys_tab_partitions where relname='" + (String)object + "' order by OID";
                object2 = this.executeQuery((String)object2);
                arrayList = new ArrayList<String>();
                while (object2.next()) {
                    arrayList.add(object2.getString("PARTNAME"));
                }
                partitionInfo.setPartNames(arrayList);
                object2.close();
                if (object3 != null && !"".equals(object3) && arrayList.size() > 0) {
                    object3 = new Hashtable();
                    for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                        String string = ((String)arrayList.get(i2)).toString();
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        object2 = "select SUBPARTNAME from v_sys_tab_subpartitions where relname='" + (String)object + "' and partname='" + string + "' order by OID";
                        object2 = this.executeQuery((String)object2);
                        while (object2.next()) {
                            arrayList2.add(object2.getString("SUBPARTNAME"));
                            if (bl2) continue;
                            bl2 = true;
                        }
                        ((Hashtable)object3).put(string, arrayList2);
                    }
                    partitionInfo.setSubPartNames((Hashtable)object3);
                }
                object2.close();
            }
        } else {
            object2 = "select TABLE_ID, PARTITION_TYPE from v_sys_PART_TABLES where TABLE_NAME='" + (String)object + "' order by TABLE_ID";
            if ((object2 = this.executeQuery((String)object2)).next()) {
                arrayList = object2.getString("PARTITION_TYPE");
                partitionInfo.setPartType((String)((Object)arrayList));
                Object object4 = object2.getString("TABLE_ID");
                object2.close();
                object2 = "select PARTITION_NAME from v_sys_tab_partitions where TABLE_ID=" + (String)object4 + " order by TABLE_ID";
                object2 = this.executeQuery((String)object2);
                arrayList = new ArrayList();
                while (object2.next()) {
                    arrayList.add(object2.getString("PARTITION_NAME"));
                }
                partitionInfo.setPartNames(arrayList);
                object2.close();
                if (arrayList.size() > 0) {
                    object4 = new Hashtable();
                    String string = "";
                    for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                        String string2 = ((String)arrayList.get(i3)).toString();
                        object = new ArrayList();
                        object2 = " select PARTITION_NAME, PARTITION_TYPE from v_sys_tab_partitions t where t.table_id=(select table_id from v_sys_part_tables where table_name='" + string2 + "') order by TABLE_ID";
                        object2 = this.executeQuery((String)object2);
                        while (object2.next()) {
                            ((ArrayList)object).add(object2.getString("PARTITION_NAME"));
                            string = object2.getString("PARTITION_TYPE");
                            if (bl2) continue;
                            bl2 = true;
                        }
                        ((Hashtable)object4).put(string2, object);
                        object2.close();
                    }
                    partitionInfo.setSubPartType(string);
                    partitionInfo.setSubPartNames((Hashtable)object4);
                }
            }
        }
        if (bl2) {
            partitionInfo.setPartitionLevel(2);
        } else if (partitionInfo.getPartNames() != null && partitionInfo.getPartNames().size() > 0) {
            partitionInfo.setPartitionLevel(1);
        }
        return partitionInfo;
    }

    protected Character getRelKind(int n2) throws SQLException {
        char c2 = 'r';
        Object object = "select relkind from v_sys_class where oid = " + n2;
        if ((object = this.connection.execSQL((String)object)) != null && object.next()) {
            c2 = object.getString(1).charAt(0);
        }
        if (object != null) {
            object.close();
        }
        return Character.valueOf(c2);
    }

    private String parsePartType(String string) {
        if (string != null && !"".equals(string.trim())) {
            if (string.equals("1")) {
                return "RANGE";
            }
            if (string.equals("2")) {
                return "LIST";
            }
            if (string.equals("3")) {
                return "HASH";
            }
            if (string.equals("4")) {
                return "INTERVAL";
            }
        }
        return null;
    }

    @Override
    public Field[] getFields() {
        return null;
    }

    @Override
    public void setFields(Field[] fieldArray) {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkClosed();
        return this.poolable;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        this.checkClosed();
        this.poolable = bl;
    }

    public void setBatchCount(int n2) {
        this.batchCount = n2;
    }

    public int getBatchCount() {
        return this.batchCount;
    }

    public void setUseAsynBatch(boolean bl) {
        this.useAsynBatch = bl;
    }

    public boolean isUseAsynBatch() {
        return this.useAsynBatch;
    }

    @Override
    public int getBuckets() {
        return this.buckets;
    }

    @Override
    public void setBuckets(int n2) {
        this.buckets = n2;
    }

    public String getSql() {
        return this.osql;
    }

    @Override
    public void setPrint(boolean bl) {
        this.print = bl;
    }

    @Override
    public boolean isPrint() {
        return this.print;
    }

    @Override
    public String getSQL() {
        return this.osql;
    }

    @Override
    public boolean isNotRealPrepare() {
        return this.notRealPrepare;
    }

    protected boolean isNotSupportPrePare() {
        return this.isAnonymous && !this.anonymousSupportPrepare;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        this.checkClosed();
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        this.checkClosed();
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public void setRowId(int n2, RowId rowId) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setClob(int n2, Reader reader, long l2) throws SQLException {
        this.checkClosed();
        if (reader == null) {
            this.setNull(n2, 2005);
            return;
        }
        if (l2 < 0L) {
            throw new SQLException("Invalid stream length " + Long.valueOf(l2));
        }
        this.setCharacterStream(n2, reader, l2);
    }

    public void setBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        this.checkClosed();
        if (inputStream == null) {
            this.setNull(n2, 2004);
            return;
        }
        if (l2 < 0L) {
            throw new SQLException("Invalid stream length " + Long.valueOf(l2));
        }
        this.setBinaryStream(n2, inputStream, l2);
    }

    public void setSQLXML(int n2, SQLXML object) throws SQLException {
        this.checkClosed();
        if (object == null) {
            this.setNull(n2, 2009);
            return;
        }
        if ((object = object.getString()) == null) {
            this.setNull(n2, 2009);
            return;
        }
        this.setString(n2, (String)object, 24);
    }

    public void setAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        switch (this.pMetaData.getParameterType(n2)) {
            case -1: 
            case 1: 
            case 12: {
                try {
                    if (inputStream != null) {
                        int n3 = l2 > Integer.MAX_VALUE || l2 == -1L ? 8001 : (int)l2;
                        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "US-ASCII");
                        char[] cArray = new char[n3];
                        int n4 = inputStreamReader.read(cArray, 0, n3);
                        this.setString(n2, new String(cArray, 0, n4), 0);
                        return;
                    }
                    this.setString(n2, null);
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new OSQLException("OSCAR-00302", "88888", 302, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                }
                catch (IOException iOException) {
                    throw new OSQLException("OSCAR-00302", "88888", 302, iOException.getMessage(), iOException);
                }
            }
            case 2005: {
                if (inputStream == null) {
                    this.setObject(n2, null);
                    this.m_lobs[n2 - 1] = null;
                } else {
                    OscarClob oscarClob;
                    if (this.pMetaData.getParameterRelOid(n2) != 0) {
                        int n5 = this.pMetaData.getParameterRelOid(n2);
                        int n6 = this.pMetaData.getParameterRelColIndex(n2);
                        oscarClob = OscarClob.createForTable(this.getConnection(), n5, n6);
                    } else {
                        oscarClob = ((OscarJdbc2Connection)this.connection).createClob();
                    }
                    if (l2 > 0L && l2 <= Integer.MAX_VALUE) {
                        try {
                            ((OscarLob)oscarClob).write(1L, inputStream, l2);
                        }
                        catch (Exception exception) {
                            this.m_lobs[n2 - 1] = null;
                        }
                    } else {
                        OutputStream outputStream = oscarClob.setAsciiStream(1L);
                        try {
                            int n7;
                            byte[] byArray = new byte[this.bufSize];
                            while ((n7 = inputStream.read(byArray, 0, this.bufSize)) > 0) {
                                outputStream.write(byArray, 0, n7);
                            }
                            outputStream.flush();
                            outputStream.close();
                        }
                        catch (Exception exception) {
                            this.m_lobs[n2 - 1] = null;
                        }
                    }
                    this.setObject(n2, (Object)oscarClob);
                    this.m_lobs[n2 - 1] = oscarClob;
                }
                if (this.m_lobs[n2 - 1] == null || !this.m_lobs[n2 - 1].isTempLob() && !this.m_lobs[n2 - 1].isTableIdLob()) break;
                this.tempResource.add(this.m_lobs[n2 - 1]);
                return;
            }
            default: {
                throw new OSQLException("OSCAR-00410", "88888", 410);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBinaryStream(int n2, InputStream object, long l2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n3 = this.pMetaData.getParameterType(n2);
        switch (n3) {
            case -4: 
            case -3: 
            case -2: {
                int n4;
                n3 = l2 > Integer.MAX_VALUE || l2 == -1L ? 8001 : (int)l2;
                byte[] byArray = new byte[n3];
                try {
                    if (object == null) {
                        this.setBytes(n2, null);
                        return;
                    }
                    n4 = ((InputStream)object).read(byArray, 0, n3);
                }
                catch (IOException iOException) {
                    throw new OSQLException("OSCAR-00410", "88888", 410, iOException.getMessage(), iOException);
                }
                if ((long)n4 == l2) {
                    this.setBytes(n2, byArray);
                    return;
                }
                byte[] byArray2 = new byte[n4];
                System.arraycopy(byArray, 0, byArray2, 0, n4);
                this.setBytes(n2, byArray2);
                return;
            }
            case 2004: {
                OscarBlob oscarBlob;
                Object object2;
                n3 = this.pMetaData.getParameterRelOid(n2);
                if (n3 != 0) {
                    object2 = this.tableTypes.get(n3);
                    if (object2 == null) {
                        object2 = this.getRelKind(n3);
                        this.tableTypes.put(n3, (Character)object2);
                    }
                    if (((Character)object2).charValue() == 'r') {
                        int n5 = this.pMetaData.getParameterRelColIndex(n2);
                        oscarBlob = OscarBlob.createForTable(this.getConnection(), n3, n5);
                    } else {
                        oscarBlob = ((OscarJdbc2Connection)this.connection).createBlob();
                    }
                } else {
                    oscarBlob = ((OscarJdbc2Connection)this.connection).createBlob();
                }
                if (l2 > 0L && l2 <= Integer.MAX_VALUE) {
                    try {
                        ((OscarLob)oscarBlob).write(1L, (InputStream)object, l2);
                    }
                    catch (SQLException sQLException) {
                        this.m_lobs[n2 - 1] = null;
                        throw sQLException;
                    }
                }
                object2 = oscarBlob.setBinaryStream(1L);
                try {
                    int n6;
                    byte[] byArray = new byte[this.bufSize];
                    while ((n6 = ((InputStream)object).read(byArray, 0, this.bufSize)) > 0) {
                        ((OutputStream)object2).write(byArray, 0, n6);
                    }
                    ((OutputStream)object2).flush();
                    ((OutputStream)object2).close();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    exception.printStackTrace();
                    this.m_lobs[n2 - 1] = null;
                }
                this.setObject(n2, (Object)oscarBlob);
                this.m_lobs[n2 - 1] = oscarBlob;
                if (this.m_lobs[n2 - 1] == null || !this.m_lobs[n2 - 1].isTempLob() && !this.m_lobs[n2 - 1].isTableIdLob()) return;
                this.tempResource.add(this.m_lobs[n2 - 1]);
                return;
            }
            case -1: 
            case 1: 
            case 12: {
                ByteArrayOutputStream byteArrayOutputStream = null;
                if (l2 == -1L || l2 > 8000L) {
                    int n7;
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray = new byte[1024];
                    while ((n7 = ((InputStream)object).read(byArray, 0, byArray.length)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n7);
                    }
                    byteArrayOutputStream.flush();
                    this.setString(n2, OSCARbyte.toOSCARString(byteArrayOutputStream.toByteArray()), 0);
                } else {
                    int n8 = (int)l2;
                    byte[] byArray = new byte[n8];
                    ((InputStream)object).read(byArray, 0, n8);
                    this.setString(n2, OSCARbyte.toOSCARString(byArray), 0);
                }
                if (byteArrayOutputStream == null) return;
                try {
                    byteArrayOutputStream.close();
                    return;
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    Driver.writeLog(iOException);
                }
                return;
                catch (Exception exception) {
                    try {
                        Exception exception3 = exception;
                        Driver.writeLog(exception);
                        throw new OSQLException("OSCAR-00410", "88888", 410);
                    }
                    catch (Throwable throwable) {
                        if (byteArrayOutputStream == null) throw throwable;
                        try {
                            byteArrayOutputStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            object = iOException;
                            Driver.writeLog(iOException);
                        }
                        throw throwable;
                    }
                }
            }
            default: {
                throw new OSQLException("OSCAR-00410", "88888", 410);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        switch (this.pMetaData.getParameterType(n2)) {
            case -1: 
            case 1: 
            case 12: {
                try {
                    if (reader == null) {
                        this.setString(n2, null);
                        return;
                    }
                    if (l2 == -1L) {
                        int n3;
                        char[] cArray = new char[1024];
                        StringBuffer stringBuffer = new StringBuffer(200);
                        for (int i2 = 0; (n3 = reader.read(cArray)) != -1 && i2 < 0x1000000; i2 += n3) {
                            stringBuffer.append(new String(cArray, 0, n3));
                        }
                        this.setString(n2, stringBuffer.toString());
                        return;
                    }
                    int n4 = (int)l2;
                    char[] cArray = new char[n4];
                    int n5 = reader.read(cArray, 0, n4);
                    this.setString(n2, new String(cArray, 0, n5));
                    return;
                }
                catch (IOException iOException) {
                    throw new OSQLException("OSCAR-00311", "88888", 311, iOException.getMessage(), iOException);
                }
            }
            case 2005: {
                if (reader == null) {
                    this.setObject(n2, null);
                    this.m_lobs[n2 - 1] = null;
                } else {
                    OscarClob oscarClob;
                    Object object;
                    int n6 = this.pMetaData.getParameterRelOid(n2);
                    if (n6 != 0) {
                        object = this.tableTypes.get(n6);
                        if (object == null) {
                            object = this.getRelKind(n6);
                            this.tableTypes.put(n6, (Character)object);
                        }
                        if (((Character)object).charValue() == 'r') {
                            int n7 = this.pMetaData.getParameterRelColIndex(n2);
                            oscarClob = OscarClob.createForTable(this.getConnection(), n6, n7);
                        } else {
                            oscarClob = ((OscarJdbc2Connection)this.connection).createClob();
                        }
                    } else {
                        oscarClob = ((OscarJdbc2Connection)this.connection).createClob();
                    }
                    if (l2 > 0L && l2 < Integer.MAX_VALUE) {
                        try {
                            oscarClob.write(1L, reader, l2);
                        }
                        catch (Exception exception) {
                            this.m_lobs[n2 - 1] = null;
                        }
                    } else {
                        object = oscarClob.setCharacterStream(1L);
                        try {
                            int n8;
                            char[] cArray = new char[this.bufSize];
                            while ((n8 = reader.read(cArray, 0, this.bufSize)) > 0) {
                                ((Writer)object).write(cArray, 0, n8);
                            }
                            ((Writer)object).flush();
                            ((Writer)object).close();
                        }
                        catch (Exception exception) {
                            this.m_lobs[n2 - 1] = null;
                        }
                    }
                    this.setObject(n2, (Object)oscarClob);
                    this.m_lobs[n2 - 1] = oscarClob;
                }
                if (this.m_lobs[n2 - 1] == null || !this.m_lobs[n2 - 1].isTempLob() && !this.m_lobs[n2 - 1].isTableIdLob()) return;
                this.tempResource.add(this.m_lobs[n2 - 1]);
                return;
            }
            default: {
                throw new OSQLException("OSCAR-00410", "88888", 410);
            }
        }
    }

    public void setAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.setAsciiStream(n2, inputStream, -1);
    }

    public void setBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.setBinaryStream(n2, inputStream, -1);
    }

    public void setCharacterStream(int n2, Reader reader) throws SQLException {
        this.setCharacterStream(n2, reader, -1);
    }

    public void setClob(int n2, Reader reader) throws SQLException {
        this.setCharacterStream(n2, reader);
    }

    public void setBlob(int n2, InputStream inputStream) throws SQLException {
        this.setBinaryStream(n2, inputStream, -1);
    }

    public RowId getRowId(int n2) throws SQLException {
        throw Driver.notImplemented();
    }

    public RowId getRowId(String string) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setRowId(String string, RowId rowId) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setClob(String string, Reader reader, long l2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setClob(n2, reader, l2);
    }

    public void setBlob(String string, InputStream inputStream, long l2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setBlob(n2, inputStream, l2);
    }

    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setSQLXML(n2, sQLXML);
    }

    public SQLXML getSQLXML(int n2) throws SQLException {
        this.checkClosed();
        this.checkIndex(n2, 2009, "String");
        String string = this.getFixedString(n2);
        if (string == null) {
            return null;
        }
        return new OscarSQLXML(this.connection, string);
    }

    public SQLXML getSQLXML(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getSQLXML(n2);
    }

    public Reader getCharacterStream(int n2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        switch (this.pMetaData.getParameterType(n2)) {
            case -1: 
            case 1: 
            case 12: {
                return new StringReader(this.getFixedString(n2));
            }
            case 2005: {
                return this.getClob(n2).getCharacterStream();
            }
        }
        throw new OSQLException("OSCAR-00410", "88888", 410);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        return this.getCharacterStream(n2);
    }

    public void setBlob(String string, Blob blob) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setBlob(n2, blob);
    }

    public void setClob(String string, Clob clob) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setClob(n2, clob);
    }

    public void setAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setAsciiStream(n2, inputStream, l2);
    }

    public void setBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setBinaryStream(n2, inputStream, l2);
    }

    public void setCharacterStream(String string, Reader reader, long l2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setCharacterStream(n2, reader, l2);
    }

    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setAsciiStream(n2, inputStream);
    }

    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setBinaryStream(n2, inputStream);
    }

    public void setCharacterStream(String string, Reader reader) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setCharacterStream(n2, reader);
    }

    public void setClob(String string, Reader reader) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setClob(n2, reader);
    }

    public void setBlob(String string, InputStream inputStream) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)this.getParameterMetaData();
        }
        int n2 = this.pMetaData.getIndex(string);
        this.setBlob(n2, inputStream);
    }

    public void setNClob(String string, Reader reader) throws SQLException {
        throw Driver.notImplemented();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkClosed();
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkClosed();
        return this.closeOnCompletion;
    }

    @Override
    public void checkAndPerformCloseOnCompletionAction() throws SQLException {
        if (this.isCloseOnCompletion() && (this.result == null || this.result.isClosed())) {
            this.close();
        }
    }

    protected static OscarPreparedStatement getPreparedInstance(OscarJdbc2Connection oscarJdbc2Connection, String string) throws SQLException {
        if (OscarJDBCUtil.isEqualOrGreaterJdbc42()) {
            return (OscarPreparedStatement)OscarJDBCUtil.handleNewInstance(JDBC_4_PSTMT_ARG, new Object[]{oscarJdbc2Connection, string});
        }
        return new OscarPreparedStatement(oscarJdbc2Connection, string);
    }

    protected static OscarPreparedStatementV2 getPreparedInstanceV2(OscarJdbc2Connection oscarJdbc2Connection, String string) throws SQLException {
        if (OscarJDBCUtil.isEqualOrGreaterJdbc42()) {
            return (OscarPreparedStatementV2)OscarJDBCUtil.handleNewInstance(JDBC_4_PSTMT_ARG_V2, new Object[]{oscarJdbc2Connection, string});
        }
        return new OscarPreparedStatementV2(oscarJdbc2Connection, string);
    }

    protected void releaseResources() {
        if (this.isCallable && this.result != null) {
            this.releaseRetrunResources();
            if (this.outParameterIndex.size() > 0) {
                for (int i2 = 0; i2 < this.outParameterIndex.size(); ++i2) {
                    OscarStatement oscarStatement = this;
                    oscarStatement.releaseOutResources(Integer.parseInt(oscarStatement.outParameterIndex.get(i2).toString()));
                }
                this.cursorResultMap.clear();
            }
        }
    }

    private void releaseRetrunResources() {
        if (!this.isResultNeeded && this.isFunc) {
            this.releaseOutResources(0);
        }
    }

    private void releaseOutResources(int n2) {
        int n3 = this.outParameterIndex.indexOf(n2);
        Object object = null;
        int n4 = 0;
        if (this.isFunc && !this.isResultNeeded) {
            ++n3;
            if (n2 == 0) {
                if (this.m_returnValue != null) {
                    object = this.m_returnValue;
                    n4 = this.m_returnType;
                }
            } else {
                object = this.m_outValues[n3 - 1];
                n4 = this.m_functionTypes[n3 - 1];
            }
        } else {
            object = this.m_outValues[n2 - 1];
            n4 = this.m_functionTypes[n2 - 1];
        }
        try {
            if (object != null && n4 != 0) {
                Driver.writeLog(this.sessionId, this.pid, "\u51c6\u5907\u91ca\u653e\u4e34\u65f6lob\u6216\u8005\u6e38\u6807");
                OscarLob oscarLob = null;
                if (n4 == 50 || n4 == 2004) {
                    oscarLob = this.connection.getBlobInstance(new String((byte[])object));
                } else if (n4 == 51 || n4 == 2005) {
                    oscarLob = this.connection.getClobInstance(new String((byte[])object));
                } else {
                    object = this.getFixedString(n2);
                    if (object != null && ((String)object).startsWith("<UNNAMED CURSOR ")) {
                        ResultSet resultSet = this.cursorResultMap.containsKey(n2) ? (ResultSet)this.cursorResultMap.remove(n2) : new OscarCursorResultSet((String)object, this.fetchSize, this.connection);
                        resultSet.close();
                    }
                }
                if (oscarLob != null) {
                    oscarLob.setTempLob(true);
                    oscarLob.freeTemporary();
                }
            }
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            Driver.writeLog(sQLException);
            return;
        }
    }

    protected void checkConnClose() throws SQLException {
        if (this.connection == null || this.connection.getProtocol() == null || ((Connection)((Object)this.connection)).isClosed()) {
            throw new OSQLException("OSCAR-00211", "08003", 211);
        }
    }

    protected void initParams() {
        this.batchPacket = null;
    }

    @Override
    public String generatedKeySqlTransform(String charSequence) {
        if (this.supportGeneratedKey && this.insertSql) {
            if (this.autoGeneratedInfo == 1) {
                charSequence = OscarSqlProcessor.makeSqlEndWithReturnGeneratedKeys((String)charSequence);
            } else if (this.autoGeneratedInfo == 3) {
                charSequence = OscarSqlProcessor.makeSqlEndWithReturnGeneratedKeys((String)charSequence);
                if (this.columnName != null && this.columnName.length > 0) {
                    charSequence = ((String)charSequence).concat(" ");
                    charSequence = new StringBuilder((String)charSequence);
                    for (int i2 = 0; i2 < this.columnName.length; ++i2) {
                        ((StringBuilder)charSequence).append(this.columnName[i2]);
                        if (i2 + 1 >= this.columnName.length) continue;
                        ((StringBuilder)charSequence).append(",");
                    }
                    charSequence = ((StringBuilder)charSequence).toString();
                } else {
                    charSequence = (String)charSequence + " NULL";
                }
            } else if (this.autoGeneratedInfo == 2) {
                charSequence = OscarSqlProcessor.makeSqlEndWithReturnGeneratedKeys((String)charSequence);
                if (this.columnIndex != null && this.columnIndex.length > 0) {
                    charSequence = ((String)charSequence).concat(" ");
                    charSequence = new StringBuilder((String)charSequence);
                    for (int i3 = 0; i3 < this.columnIndex.length; ++i3) {
                        ((StringBuilder)charSequence).append(this.columnIndex[i3]);
                        if (i3 + 1 >= this.columnIndex.length) continue;
                        ((StringBuilder)charSequence).append(",");
                    }
                    charSequence = ((StringBuilder)charSequence).toString();
                } else {
                    charSequence = (String)charSequence + " NULL";
                }
            }
        }
        return charSequence;
    }

    protected String checkSqlEmptyOrTrim(String string) throws OSQLException {
        if (string == null || (string = string.trim()).length() == 0) {
            throw new OSQLException("OSCAR-00433", "88888", 433);
        }
        return string;
    }

    @Override
    public ResultSet getRealResultSet() throws SQLException {
        if (this.result != null) {
            return this.result;
        }
        return null;
    }

    static {
        if (OscarJDBCUtil.isEqualOrGreaterJdbc4()) {
            try {
                String string = OscarJDBCUtil.isEqualOrGreaterJdbc42() ? "com.oscar.jdbc.Oscar42PreparedStatementV2" : "com.oscar.jdbc.OscarPreparedStatementV2";
                JDBC_4_PSTMT_ARG_V2 = Class.forName(string, false, OscarStatement.class.getClassLoader()).getConstructor(BaseConnection.class, String.class);
                string = OscarJDBCUtil.isEqualOrGreaterJdbc42() ? "com.oscar.jdbc.Oscar42PreparedStatement" : "com.oscar.jdbc.OscarPreparedStatement";
                JDBC_4_PSTMT_ARG = Class.forName(string, false, OscarStatement.class.getClassLoader()).getConstructor(BaseConnection.class, String.class);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else {
            JDBC_4_PSTMT_ARG = null;
            JDBC_4_PSTMT_ARG_V2 = null;
        }
    }

    public static class BatchRowData {
        private Object[] data;
        private int[] types;
        private boolean hasEscapeChar = false;

        public BatchRowData(Object[] objectArray, int[] nArray, boolean bl) {
            this.data = objectArray;
            this.types = nArray;
            this.hasEscapeChar = bl;
        }

        public boolean hasEscapeChar() {
            return this.hasEscapeChar;
        }

        public Object[] getData() {
            return this.data;
        }

        public int[] getTypes() {
            return this.types;
        }
    }
}

