/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.BaseStatement;
import com.oscar.core.Field;
import com.oscar.gis.OscarObject;
import com.oscar.jdbc.OscarBfile;
import com.oscar.jdbc.OscarBlob;
import com.oscar.jdbc.OscarClob;
import com.oscar.jdbc.OscarJdbc2Connection;
import com.oscar.jdbc.OscarLob;
import com.oscar.jdbc.OscarParaMetaData;
import com.oscar.jdbc.OscarPreparedStatementV2;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.jdbc.OscarResultSetMetaData;
import com.oscar.jdbc.OscarStatement;
import com.oscar.jdbc.ae.OscarResultSetAeHandler;
import com.oscar.protocol.a.m;
import com.oscar.protocol.b;
import com.oscar.util.OSCARbyte;
import com.oscar.util.OSQLException;
import com.oscar.util.OtherType;
import com.oscar.util.converter.BindConverter;
import com.oscar.util.converter.BooleanConverter;
import com.oscar.util.converter.DateConverter;
import com.oscar.util.converter.IntervalConverter;
import com.oscar.util.converter.NumberConverter;
import com.oscar.util.converter.RowidConverter;
import com.oscar.util.converter.TimestampConverter;
import com.oscar.util.converter.TimestamptzConverter;
import com.oscar.util.converter.TimetzConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OscarStatementV2
extends OscarStatement {
    protected String m_prepareSqlStatement;
    protected int[] m_preBindTypes = new int[0];
    protected m batchPacketV2 = null;
    protected boolean netDataByStr = false;
    protected boolean numericKeepPrecision = true;
    protected boolean prepareSimpleExecute = true;
    protected Boolean isPrepared = null;
    protected boolean bindTypeBackuped = false;
    protected int lobDisplayMaxSize = -1;
    private static final Pattern PATTERN_PREPARE = Pattern.compile("(?<=PREPARE ).*?(?= AS )");

    public OscarStatementV2(BaseConnection baseConnection) {
        super(baseConnection);
        this.initVar(baseConnection);
    }

    public OscarStatementV2(BaseConnection baseConnection, String string) throws SQLException {
        super(baseConnection, string);
        this.initVar(baseConnection);
    }

    protected void initVar(BaseConnection baseConnection) {
        this.netDataByStr = baseConnection.isNetDataByStr();
        this.numericKeepPrecision = baseConnection.isNumericKeepPrecision();
        this.prepareSimpleExecute = baseConnection.isPrepareSimpleExecute();
        this.batchCount = baseConnection.getBatchCount();
        this.useAsynBatch = baseConnection.isUseAsynBatch();
    }

    @Override
    protected boolean executeStatement() throws SQLException {
        try {
            this.checkConnClose();
            return this.doExecuteStatement();
        }
        catch (SQLException sQLException) {
            this.checkConnectionClosed(sQLException);
            throw sQLException;
        }
    }

    boolean doExecuteStatement() throws SQLException {
        String string;
        int n2;
        if (this.fetchSize > 0 && this.selectSql && (this.resultSetType != 1003 || this.resultSetConcurrency != 1007)) {
            if (this.m_prepareSqlStatement != null && !this.isMarkPrepared() && !this.isNotRealPrepare()) {
                try {
                    this.handleNullStatementName("notImplemented");
                    this.markPrepared(false);
                    this.connection.execSQL(this.m_prepareSqlStatement, this);
                    this.markPrepared(true);
                }
                catch (SQLException sQLException) {
                    this.m_statementName = null;
                    throw sQLException;
                }
            }
            this.convertBindDatas(true);
            return super.executeStatement();
        }
        boolean bl = this.checkBindTypes();
        if (!this.bindTypeBackuped) {
            if (this.m_preBindTypes.length != this.m_bindTypes.length) {
                this.m_preBindTypes = new int[this.m_bindTypes.length];
            }
            System.arraycopy(this.m_bindTypes, 0, this.m_preBindTypes, 0, this.m_bindTypes.length);
            this.bindTypeBackuped = true;
        }
        this.clearWarnings();
        this.cursorError = false;
        this.m_statementIsCursor = false;
        this.m_cursorName = null;
        if (this.result != null) {
            this.releaseResources();
            this.result.close();
            this.result = null;
        }
        if (this.statementType == 0) {
            if (this.fetchSize > 0 && this.selectSql && !this.isMultiSqlSentens) {
                this.m_statementIsCursor = true;
                OscarStatementV2 oscarStatementV2 = this;
                oscarStatementV2.fetchMore(oscarStatementV2.m_sqlFragments[0], null, null, null, this.fetchSize, this.getMaxRows(), false, false, this, false);
            } else {
                this.fields = null;
                n2 = 0;
                try {
                    if (this.isAnonymous) {
                        n2 = 3;
                    }
                    this.result = this.getDBConnection().getQueryExecutor().execute(this.m_sqlFragments, this.m_binds, this);
                }
                catch (SQLException sQLException) {
                    String string2;
                    if (this.errorMessNeedOffset && sQLException instanceof OSQLException && (string2 = sQLException.getMessage()) != null && (string2.contains("at character") || string2.contains("at end of input"))) {
                        ((OSQLException)sQLException).setJdbcOffset(n2);
                    }
                    this.cursorError = true;
                    throw sQLException;
                }
                finally {
                    if ((this.result == null || this.cursorError) && this.m_statementIsCursor) {
                        this.cursorError = false;
                    }
                }
            }
        } else {
            this.m_statementIsCursor = false;
            for (n2 = 0; n2 < this.m_bindTypes.length; ++n2) {
                if (this.m_bindTypes[n2] != 0) continue;
                throw new OSQLException("OSCAR-00405", "88888", 405, n2 + 1);
            }
            if (this.isCallable) {
                this.convertBindDatas(false);
                this.markPrepared(false);
                this.result = ((b)this.connection.getProtocol()).a(this.m_prepareSqlStatement, this.m_statementName, this.m_bindTypes, this.m_binds, this.getMaxRows(), this, bl);
                this.markPrepared(true);
                if (this.m_prepareSqlStatement != null) {
                    this.m_prepareSqlStatement = null;
                }
            } else {
                try {
                    if (this.isNotRealPrepare()) {
                        this.convertBindDatas(true);
                        n2 = super.executeStatement() ? 1 : 0;
                        return n2 != 0;
                    }
                    if (this.m_bindTypes != null && this.m_bindTypes.length >= 256 && this.connection.getProtocolVersion().getProtocolType() < 3) {
                        if (!this.isMarkPrepared() && this.m_prepareSqlStatement != null) {
                            try {
                                this.markPrepared(false);
                                this.connection.execSQL(this.m_prepareSqlStatement, this);
                                this.markPrepared(true);
                            }
                            catch (SQLException sQLException) {
                                this.m_statementName = null;
                                throw sQLException;
                            }
                        }
                        this.convertBindDatas(true);
                        n2 = super.executeStatement();
                        return n2 != 0;
                    }
                    if (this.selectSql && this.fetchSize > 0) {
                        this.m_statementIsCursor = true;
                        this.convertBindDatas(false);
                        if (this.prepareSimpleExecute && (this.m_binds == null || this.m_binds.length == 0)) {
                            String string3 = this.osql.trim().toUpperCase();
                            if (string3.indexOf("{FN ") != -1 || string3.indexOf(" FN ") != -1) {
                                OscarStatementV2 oscarStatementV2 = this;
                                oscarStatementV2.fetchMore(oscarStatementV2.m_prepareSqlStatement, this.m_statementName, this.m_bindTypes, this.m_binds, this.fetchSize, this.getMaxRows(), false, true, this, bl);
                                if (this.m_prepareSqlStatement != null) {
                                    this.m_prepareSqlStatement = null;
                                }
                            } else {
                                OscarStatementV2 oscarStatementV2 = this;
                                oscarStatementV2.fetchMore(oscarStatementV2.osql, null, null, null, this.fetchSize, this.getMaxRows(), false, false, this, false);
                            }
                        } else {
                            if (this.m_statementName == null && (this.m_binds == null || this.m_binds.length == 0)) {
                                OscarStatementV2 oscarStatementV2 = this;
                                oscarStatementV2.fetchMore(oscarStatementV2.osql, null, null, null, this.fetchSize, this.getMaxRows(), false, false, this, false);
                                return true;
                            }
                            this.markPrepared(false);
                            OscarStatementV2 oscarStatementV2 = this;
                            oscarStatementV2.fetchMore(oscarStatementV2.m_prepareSqlStatement, this.m_statementName, this.m_bindTypes, this.m_binds, this.fetchSize, this.getMaxRows(), false, true, this, bl);
                            this.markPrepared(true);
                            if (this.m_prepareSqlStatement != null) {
                                this.m_prepareSqlStatement = null;
                            }
                        }
                        return true;
                    }
                    if (this.m_sqlFragments == null && this.fetchSize == 0) {
                        this.setSqlFragments();
                    }
                    this.convertBindDatas(false);
                    if (this.m_sqlFragments != null && this.m_sqlFragments[0].startsWith("EXECUTE")) {
                        if (this.prepareSimpleExecute && (this.m_binds == null || this.m_binds.length == 0)) {
                            this.result = this.getDBConnection().getQueryExecutor().execute(new String[]{this.osql}, this.m_binds, this);
                        } else {
                            this.markPrepared(false);
                            this.result = ((b)this.connection.getProtocol()).a(this.m_prepareSqlStatement, this.m_statementName, this.m_bindTypes, this.m_binds, this.getMaxRows(), this, bl);
                            this.markPrepared(true);
                            if (this.m_prepareSqlStatement != null) {
                                this.m_prepareSqlStatement = null;
                            }
                        }
                    } else {
                        this.result = this.getDBConnection().getQueryExecutor().execute(this.m_sqlFragments, this.m_binds, this);
                    }
                }
                catch (SQLException sQLException) {
                    this.cursorError = true;
                    throw sQLException;
                }
                finally {
                    if ((this.result == null || this.cursorError) && this.m_statementIsCursor) {
                        this.cursorError = false;
                    }
                }
            }
        }
        if (this.isCallable || this.isAnonymous && this.outParameterIndex.size() > 0) {
            if (this.result == null) {
                if (this.isAnonymous) {
                    return false;
                }
                throw new OSQLException("OSCAR-00406", "88888", 406);
            }
            if (this.outParameterIndex.isEmpty() ? this.result.getTupleCount() > 1 : this.result.getTupleCount() == 0 || !this.result.reallyResultSet()) {
                throw new OSQLException("OSCAR-00406", "88888", 406);
            }
            this.getProcedureResult();
            return this.result != null && this.result.getNext() != null;
        }
        if (this.result != null && (string = this.result.getStatusString()) != null && (string.startsWith("23") || string.startsWith("45") || string.startsWith("5D") || string.startsWith("10") || string.startsWith("48"))) {
            return this.result.reallyResultSet();
        }
        return false;
    }

    boolean checkBindTypes() {
        if (this.logFlag) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(OscarStatementV2.class);
            stringBuffer.append(", checkBindTypes()\n");
            stringBuffer.append("preBindTypes: ");
            this.append(stringBuffer, this.m_preBindTypes);
            stringBuffer.append("\ncurrentBindTypes: ");
            this.append(stringBuffer, this.m_bindTypes);
            Driver.writeLog(this.sessionId, this.pid, stringBuffer.toString());
        }
        if (this.m_preBindTypes.length == 0 && this.m_bindTypes.length == 0) {
            return false;
        }
        if (this.m_preBindTypes.length != this.m_bindTypes.length) {
            return true;
        }
        for (int i2 = 0; i2 < this.m_preBindTypes.length; ++i2) {
            if (this.m_preBindTypes[i2] == this.m_bindTypes[i2]) continue;
            return true;
        }
        return false;
    }

    protected void append(StringBuffer stringBuffer, int[] nArray) {
        if (nArray == null) {
            stringBuffer.append("null");
            return;
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            stringBuffer.append(nArray[i2]).append(" ");
        }
    }

    @Override
    public BaseResultSet createResultSet(Field[] fieldArray, List<byte[][]> object, String string, long l2, long l3) throws SQLException {
        OscarStatementV2 oscarStatementV2 = this;
        object = OscarResultSet.getInstanceV2(oscarStatementV2, oscarStatementV2.connection, this.netDataByStr, this.numericKeepPrecision, this.resultSetType, this.resultSetConcurrency, this.resultSetCanUpdateable, this.fetchdirection, this.encoding, this.m_cursorName, fieldArray, object, string, l2, l3, this.fetchSize, this.maxrows);
        return this.wrapUpResultSetIfCe((BaseResultSet)object, fieldArray);
    }

    protected BaseResultSet wrapUpResultSetIfCe(BaseResultSet object, Field[] object2) {
        if (this.connection.enableCe() && this.hasEncryptedColumn((Field[])object2)) {
            object2 = object.getClass().getClassLoader();
            object = new OscarResultSetAeHandler((BaseResultSet)object);
            object = Proxy.newProxyInstance((ClassLoader)object2, new Class[]{BaseResultSet.class, ResultSet.class}, (InvocationHandler)object);
            return (BaseResultSet)object;
        }
        return object;
    }

    protected boolean hasEncryptedColumn(Field[] fieldArray) {
        if (fieldArray == null) {
            return false;
        }
        for (Field field : fieldArray) {
            if (field == null) break;
            if (field.getColumnEncryptMode() == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setArray(int n2, Array array) throws SQLException {
        this.checkClosed();
        if (array == null) {
            ((OscarStatement)this).setNull(n2, 12);
            return;
        }
        ((OscarStatement)this).setString(n2, array.toString());
    }

    @Override
    public void setBlob(int n2, Blob blob) throws SQLException {
        this.setObject(n2, (Object)blob, 2004);
    }

    @Override
    public void setBfile(int n2, OscarBfile oscarBfile) throws SQLException {
        this.setObject(n2, (Object)oscarBfile, -11);
    }

    @Override
    public void setClob(int n2, Clob clob) throws SQLException {
        this.setObject(n2, (Object)clob, 2005);
    }

    @Override
    public void setNull(int n2, int n3) throws SQLException {
        int n4;
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", setNull(int parameterIndex, int sqlType),parameterIndex: " + n2 + ",sqlType: " + n3);
        }
        this.checkClosed();
        if (this.netDataByStr) {
            this.bind(n2, null, 24);
            return;
        }
        if (this.m_bindTypes.length >= n2 && (n4 = this.m_bindTypes[n2 - 1]) != 0) {
            this.bind(n2, null, n4);
            return;
        }
        switch (n3) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n4 = 23;
                break;
            }
            case -7: 
            case 16: {
                n4 = 33;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                n4 = 24;
                break;
            }
            case 91: {
                n4 = 25;
                break;
            }
            case 92: {
                n4 = 26;
                break;
            }
            case 93: {
                n4 = 28;
                break;
            }
            case -2: {
                n4 = 24;
                break;
            }
            case -4: 
            case -3: {
                n4 = 24;
                break;
            }
            case 1111: {
                n4 = 24;
                break;
            }
            case 2005: {
                n4 = 51;
                break;
            }
            case 2004: {
                n4 = 50;
                break;
            }
            case 29: {
                n4 = 29;
                break;
            }
            default: {
                n4 = 24;
            }
        }
        this.bind(n2, null, n4);
    }

    @Override
    public void setBoolean(int n2, boolean bl) throws SQLException {
        if (this.isNotSupportPrePare()) {
            super.setBoolean(n2, bl);
            return;
        }
        if (bl) {
            ((OscarStatement)this).setString(n2, "1");
            return;
        }
        ((OscarStatement)this).setString(n2, "0");
    }

    @Override
    public void setByte(int n2, byte by) throws SQLException {
        ((OscarStatement)this).setString(n2, String.valueOf(by));
    }

    @Override
    public void setShort(int n2, short s2) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", setShort(int parameterIndex, short x),parameterIndex: " + n2 + ",x: " + s2);
        }
        this.checkClosed();
        if (this.netDataByStr) {
            this.bind(n2, s2, 24);
            return;
        }
        this.bind(n2, s2, 23);
    }

    @Override
    public void setInt(int n2, int n3) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", setInt(int parameterIndex, int x),parameterIndex: " + n2 + ",x: " + n3);
        }
        this.checkClosed();
        if (this.netDataByStr) {
            this.bind(n2, n3, 24);
            return;
        }
        this.bind(n2, n3, 23);
    }

    @Override
    public void setLong(int n2, long l2) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", setLong(int parameterIndex, long x),parameterIndex: " + n2 + ",x: " + l2);
        }
        this.checkClosed();
        if (this.netDataByStr) {
            this.bind(n2, l2, 24);
            return;
        }
        this.bind(n2, l2, 23);
    }

    @Override
    public void setFloat(int n2, float f2) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", setFloat(int parameterIndex, float x) ,parameterIndex: " + n2 + ",x: " + f2);
        }
        this.checkClosed();
        if (this.netDataByStr) {
            this.bind(n2, Float.valueOf(f2), 24);
            return;
        }
        if (this.numericKeepPrecision) {
            this.bind(n2, Float.valueOf(f2), 24);
            return;
        }
        this.bind(n2, Float.valueOf(f2), 23);
    }

    public void setEmptyString(int n2) throws SQLException {
        if (this.isNotRealPrepare()) {
            this.bind(n2, "", 24);
            return;
        }
        this.bind(n2, Character.valueOf('\u0000'), 24);
    }

    @Override
    public void setDouble(int n2, double d2) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", setDouble(int parameterIndex, double x) ,parameterIndex: " + n2 + ",x: " + d2);
        }
        this.checkClosed();
        if (this.netDataByStr) {
            this.bind(n2, d2, 24);
            return;
        }
        if (this.numericKeepPrecision) {
            this.bind(n2, d2, 24);
            return;
        }
        this.bind(n2, d2, 23);
    }

    @Override
    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", setBigDecimal(int parameterIndex, BigDecimal x) ,parameterIndex: " + n2 + ",x: " + bigDecimal);
        }
        this.checkClosed();
        if (this.netDataByStr) {
            this.bind(n2, bigDecimal, 24);
            return;
        }
        if (this.numericKeepPrecision) {
            this.bind(n2, bigDecimal, 24);
            return;
        }
        if (bigDecimal == null) {
            ((OscarStatement)this).setNull(n2, 2);
            return;
        }
        this.bind(n2, new Double(bigDecimal.doubleValue()), 23);
    }

    @Override
    public void setString(int n2, String string) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", setString(int i, String x) ,i: " + n2 + ",x: " + string);
        }
        this.checkClosed();
        if (this.isNotSupportPrePare()) {
            super.setString(n2, string);
            return;
        }
        if (string == null) {
            ((OscarStatement)this).setNull(n2, 12);
            return;
        }
        if (string.toString().length() == 0) {
            if (this.isNotRealPrepare()) {
                ((OscarStatement)this).setString(n2, "", 24);
                return;
            }
            ((OscarStatement)this).setString(n2, "\u0000", 24);
            return;
        }
        ((OscarStatement)this).setString(n2, string, 24);
    }

    @Override
    public void setString(int n2, String string, int n3) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", setString(int parameterIndex, String x, int type) ,parameterIndex: " + n2 + ",x: " + string + ", type: " + n3);
        }
        this.checkClosed();
        if (string == null) {
            ((OscarStatement)this).setNull(n2, 12);
            return;
        }
        this.bind(n2, string, n3);
    }

    @Override
    public void setDate(int n2, Date date) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", setDate(int parameterIndex, java.sql.Date x) ,parameterIndex: " + n2 + ",x: " + date);
        }
        this.checkClosed();
        if (date == null) {
            ((OscarStatement)this).setNull(n2, 91);
            return;
        }
        if (this.netDataByStr) {
            ((OscarStatement)this).setString(n2, date.toString());
            return;
        }
        this.bind(n2, date, 25);
    }

    @Override
    public void setTime(int n2, Time time) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", setTime(int parameterIndex, Time x) ,parameterIndex: " + n2 + ",x: " + time);
        }
        this.checkClosed();
        if (time == null) {
            ((OscarStatement)this).setNull(1, 92);
            return;
        }
        if (this.netDataByStr) {
            ((OscarStatement)this).setString(n2, time.toString());
            return;
        }
        this.bind(n2, time, 26);
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", setTimestamp(int parameterIndex, Timestamp x) ,parameterIndex: " + n2 + ",x: " + timestamp);
        }
        this.checkClosed();
        if (timestamp == null) {
            ((OscarStatement)this).setNull(n2, 93);
            return;
        }
        if (this.netDataByStr) {
            ((OscarStatement)this).setString(n2, timestamp.toString());
            return;
        }
        this.bind(n2, timestamp, 28);
    }

    @Override
    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        this.checkClosed();
        if (date == null) {
            ((OscarStatement)this).setNull(n2, 91);
            return;
        }
        if (calendar != null) {
            long l2 = calendar.get(15) + calendar.get(16);
            long l3 = this.systemCal.get(15) + this.systemCal.get(16);
            date = new Date(date.getTime() + (l3 - l2));
        }
        if (this.netDataByStr) {
            ((OscarStatement)this).setString(n2, date.toString());
            return;
        }
        this.bind(n2, date, 25);
    }

    @Override
    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        this.checkClosed();
        if (time == null) {
            ((OscarStatement)this).setNull(n2, 92);
            return;
        }
        if (calendar != null) {
            long l2 = calendar.get(15) + calendar.get(16);
            long l3 = this.systemCal.get(15) + this.systemCal.get(16);
            time = new Time(time.getTime() + (l3 - l2));
        }
        if (this.netDataByStr) {
            ((OscarStatement)this).setString(n2, time.toString());
            return;
        }
        this.bind(n2, time, 26);
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkClosed();
        if (timestamp == null) {
            ((OscarStatement)this).setNull(n2, 29);
            return;
        }
        if (calendar != null) {
            long l2 = calendar.get(15) + calendar.get(16);
            long l3 = this.systemCal.get(15) + this.systemCal.get(16);
            timestamp = new Timestamp(timestamp.getTime() - (l3 - l2));
        }
        if (this.netDataByStr) {
            ((OscarStatement)this).setString(n2, timestamp.toString());
            return;
        }
        this.bind(n2, timestamp, 29);
    }

    @Override
    protected void bind(int n2, Object object, int n3) throws SQLException {
        if (n2 <= 0 || n2 > this.m_binds.length) {
            throw new OSQLException("OSCAR-00305", "88888", 305);
        }
        if (n2 == 1 && this.isResultNeeded) {
            throw new OSQLException("OSCAR-00413", "88888", 413);
        }
        this.m_binds[n2 - 1] = object;
        this.m_binds_old[n2 - 1] = object;
        this.m_bindTypes[n2 - 1] = n3;
    }

    @Override
    public Field[] getFields() {
        return this.fields;
    }

    @Override
    public void setFields(Field[] fieldArray) {
        this.fields = fieldArray;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            if (this.fragmentsCount > 1) {
                if (this.m_prepareSqlStatement != null && !this.isMarkPrepared()) {
                    try {
                        this.markPrepared(false);
                        this.connection.execSQL(this.m_prepareSqlStatement, this);
                        this.markPrepared(true);
                    }
                    catch (SQLException sQLException) {
                        this.m_statementName = null;
                        throw sQLException;
                    }
                }
                this.handleNullStatementName("OSCAR-00421");
                Object object = "GET PARAMINFO FOR " + this.m_statementName;
                this.connection.execSQL((String)object);
                object = (OscarParaMetaData)this.connection.getDefaultStatement().getParamInfo();
                this.pMetaData = new OscarParaMetaData(((OscarParaMetaData)object).getParamInfor(), this);
                if (this instanceof CallableStatement && this.isResultNeeded) {
                    object = (OscarResultSetMetaData)this.getMetaData();
                    if (object == null || ((OscarResultSetMetaData)object).getColumnCount() == 0) {
                        throw new OSQLException("OSCAR-00401", "88888", 401);
                    }
                    object = ((OscarResultSetMetaData)object).getField(1);
                    Object[] objectArray = this.connection.getVersion().isNewParamInfoPacket() ? new Object[6] : new Object[8];
                    objectArray[0] = this.encoding.encode(((Field)object).getAliasName());
                    objectArray[1] = ((Field)object).getOID();
                    objectArray[2] = (short)((Field)object).getLength();
                    objectArray[3] = ((Field)object).getMod();
                    objectArray[4] = (byte)((Field)object).isNullable();
                    objectArray[5] = (byte)2;
                    this.pMetaData.addReturnParam(objectArray);
                }
            } else {
                this.pMetaData = new OscarParaMetaData(new Object[0][0], this);
            }
        }
        return this.pMetaData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", setObject(int parameterIndex, Object x, int targetSqlType, int scale), parameterIndex: " + n2 + ", x: " + object + ", targetSqlType: " + n3 + ", scale: " + n4);
        }
        this.checkClosed();
        if (object == null) {
            ((OscarStatement)this).setNull(n2, n3);
            return;
        }
        switch (n3) {
            case 4: {
                if (object instanceof Integer) {
                    ((OscarStatement)this).setInt(n2, (int)((Integer)object));
                    return;
                }
                if (object instanceof Short) {
                    ((OscarStatement)this).setInt(n2, ((Short)object).intValue());
                    return;
                }
                if (object instanceof Byte) {
                    ((OscarStatement)this).setInt(n2, ((Byte)object).intValue());
                    return;
                }
                if (object instanceof Float) {
                    if (((Float)object).floatValue() > 2.1474836E9f) throw new OSQLException("OSCAR-00703", "88888", 703);
                    if (((Float)object).floatValue() < -2.1474836E9f) {
                        throw new OSQLException("OSCAR-00703", "88888", 703);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, 4, 4));
                    ((OscarStatement)this).setInt(n2, ((Float)object).intValue());
                    return;
                }
                if (object instanceof Double) {
                    if ((Double)object > 2.147483647E9) throw new OSQLException("OSCAR-00703", "88888", 703);
                    if ((Double)object < -2.147483648E9) {
                        throw new OSQLException("OSCAR-00703", "88888", 703);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, 8, 4));
                    ((OscarStatement)this).setInt(n2, ((Double)object).intValue());
                    return;
                }
                if (object instanceof Long) {
                    if ((Long)object > Integer.MAX_VALUE) throw new OSQLException("OSCAR-00703", "88888", 703);
                    if ((Long)object < Integer.MIN_VALUE) {
                        throw new OSQLException("OSCAR-00703", "88888", 703);
                    }
                    ((OscarStatement)this).setInt(n2, ((Long)object).intValue());
                    return;
                }
                if (object instanceof Boolean) {
                    ((OscarStatement)this).setInt(n2, (Boolean)object != false ? 1 : 0);
                    return;
                }
                if (object instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (bigDecimal.doubleValue() > 2.147483647E9) throw new OSQLException("OSCAR-00703", "88888", 703);
                    if (bigDecimal.doubleValue() < -2.147483648E9) {
                        throw new OSQLException("OSCAR-00703", "88888", 703);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, -1, 4));
                    ((OscarStatement)this).setInt(n2, (int)bigDecimal.doubleValue());
                    return;
                }
                if (object instanceof String) {
                    double d2;
                    if (object.toString().trim().equals("")) {
                        this.setEmptyString(n2);
                        return;
                    }
                    try {
                        d2 = Double.parseDouble((String)object);
                    }
                    catch (Exception exception) {
                        int n5;
                        StringBuffer stringBuffer = new StringBuffer((String)object);
                        for (n5 = 0; n5 < stringBuffer.length() && (Character.isDigit(stringBuffer.charAt(n5)) || n5 == 0 && (stringBuffer.charAt(n5) == '-' || stringBuffer.charAt(n5) == '+')); ++n5) {
                        }
                        object = stringBuffer.substring(0, n5);
                        try {
                            d2 = Double.parseDouble((String)object);
                        }
                        catch (Exception exception2) {
                            d2 = 0.0;
                        }
                    }
                    if (d2 > 2.147483647E9) throw new OSQLException("OSCAR-00703", "88888", 703);
                    if (d2 < -2.147483648E9) {
                        throw new OSQLException("OSCAR-00703", "88888", 703);
                    }
                    ((OscarStatement)this).setInt(n2, (int)d2);
                    return;
                }
                if (!(object instanceof Character)) throw new OSQLException("OSCAR-00703", "88888", 703);
                try {
                    ((OscarStatement)this).setInt(n2, Integer.parseInt(object.toString()));
                    return;
                }
                catch (Exception exception) {
                    throw new OSQLException("OSCAR-00703", "88888", 703, exception);
                }
            }
            case -5: {
                if (object instanceof Long) {
                    ((OscarStatement)this).setLong(n2, (long)((Long)object));
                    return;
                }
                if (object instanceof Integer) {
                    ((OscarStatement)this).setLong(n2, ((Integer)object).longValue());
                    return;
                }
                if (object instanceof Short) {
                    ((OscarStatement)this).setLong(n2, ((Short)object).longValue());
                    return;
                }
                if (object instanceof Byte) {
                    ((OscarStatement)this).setLong(n2, ((Byte)object).longValue());
                    return;
                }
                if (object instanceof Double) {
                    if (((Double)object).longValue() >= Long.MAX_VALUE) throw new OSQLException("OSCAR-00704", "88888", 704);
                    if (((Double)object).longValue() <= Long.MIN_VALUE) {
                        throw new OSQLException("OSCAR-00704", "88888", 704);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, 8, 8));
                    ((OscarStatement)this).setLong(n2, ((Double)object).longValue());
                    return;
                }
                if (object instanceof Float) {
                    if (((Float)object).floatValue() > 9.223372E18f) throw new OSQLException("OSCAR-00704", "88888", 704);
                    if (((Float)object).floatValue() < -9.223372E18f) {
                        throw new OSQLException("OSCAR-00704", "88888", 704);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, 4, 8));
                    ((OscarStatement)this).setLong(n2, ((Float)object).longValue());
                    return;
                }
                if (object instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (bigDecimal.compareTo(new BigDecimal(Long.MAX_VALUE)) == 1) throw new OSQLException("OSCAR-00704", "88888", 704);
                    if (bigDecimal.compareTo(new BigDecimal(Long.MIN_VALUE)) == -1) {
                        throw new OSQLException("OSCAR-00704", "88888", 704);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, -1, 8));
                    ((OscarStatement)this).setLong(n2, bigDecimal.longValue());
                    return;
                }
                if (object instanceof Boolean) {
                    ((OscarStatement)this).setLong(n2, (Boolean)object != false ? 1L : 0L);
                    return;
                }
                if (object instanceof String) {
                    if (object.toString().trim().equals("")) {
                        this.setEmptyString(n2);
                        return;
                    }
                    BigDecimal bigDecimal = new BigDecimal((String)object);
                    if (bigDecimal.compareTo(new BigDecimal(Long.MAX_VALUE)) == 1) throw new OSQLException("OSCAR-00704", "88888", 704);
                    if (bigDecimal.compareTo(new BigDecimal(Long.MIN_VALUE)) == -1) {
                        throw new OSQLException("OSCAR-00704", "88888", 704);
                    }
                    ((OscarStatement)this).setLong(n2, bigDecimal.longValue());
                    return;
                }
                if (!(object instanceof Character)) throw new OSQLException("OSCAR-00704", "88888", 704);
                try {
                    ((OscarStatement)this).setLong(n2, Long.parseLong(object.toString()));
                    return;
                }
                catch (Exception exception) {
                    throw new OSQLException("OSCAR-00704", "88888", 704, exception);
                }
            }
            case -6: {
                if (object instanceof Integer) {
                    if ((Integer)object > 127) throw new OSQLException("OSCAR-00701", "88888", 701);
                    if ((Integer)object < -128) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    ((OscarStatement)this).setInt(n2, (int)((Integer)object));
                    return;
                }
                if (object instanceof Byte) {
                    ((OscarStatement)this).setInt(n2, ((Byte)object).intValue());
                    return;
                }
                if (object instanceof Short) {
                    if (((Short)object).intValue() > 127) throw new OSQLException("OSCAR-00701", "88888", 701);
                    if (((Short)object).intValue() < -128) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    ((OscarStatement)this).setInt(n2, ((Short)object).intValue());
                    return;
                }
                if (object instanceof Float) {
                    if (((Float)object).floatValue() > 127.0f) throw new OSQLException("OSCAR-00701", "88888", 701);
                    if (((Float)object).floatValue() < -128.0f) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, 4, 1));
                    ((OscarStatement)this).setInt(n2, ((Float)object).intValue());
                    return;
                }
                if (object instanceof Double) {
                    if ((Double)object > 127.0) throw new OSQLException("OSCAR-00701", "88888", 701);
                    if ((Double)object < -128.0) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, 8, 1));
                    ((OscarStatement)this).setInt(n2, ((Double)object).intValue());
                    return;
                }
                if (object instanceof Long) {
                    if ((Long)object > 127L) throw new OSQLException("OSCAR-00701", "88888", 701);
                    if ((Long)object < -128L) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    ((OscarStatement)this).setInt(n2, ((Long)object).intValue());
                    return;
                }
                if (object instanceof Boolean) {
                    ((OscarStatement)this).setInt(n2, (Boolean)object != false ? 1 : 0);
                    return;
                }
                if (object instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (bigDecimal.doubleValue() > 127.0) throw new OSQLException("OSCAR-00701", "88888", 701);
                    if (bigDecimal.doubleValue() < -128.0) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, -1, 1));
                    ((OscarStatement)this).setInt(n2, (int)bigDecimal.doubleValue());
                    return;
                }
                if (object instanceof String) {
                    double d3;
                    if (object.toString().trim().equals("")) {
                        this.setEmptyString(n2);
                        return;
                    }
                    try {
                        d3 = Double.parseDouble((String)object);
                    }
                    catch (Exception exception) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    if (d3 > 127.0) throw new OSQLException("OSCAR-00701", "88888", 701);
                    if (d3 < -128.0) {
                        throw new OSQLException("OSCAR-00701", "88888", 701);
                    }
                    ((OscarStatement)this).setInt(n2, (int)d3);
                    return;
                }
                if (!(object instanceof Character)) throw new OSQLException("OSCAR-00701", "88888", 701);
                try {
                    ((OscarStatement)this).setInt(n2, Integer.parseInt(object.toString()));
                    return;
                }
                catch (Exception exception) {
                    throw new OSQLException("OSCAR-00701", "88888", 701, exception);
                }
            }
            case 5: {
                if (object instanceof Integer) {
                    if ((Integer)object > Short.MAX_VALUE) throw new OSQLException("OSCAR-00702", "88888", 702);
                    if ((Integer)object < Short.MIN_VALUE) {
                        throw new OSQLException("OSCAR-00702", "88888", 702);
                    }
                    ((OscarStatement)this).setInt(n2, (int)((Integer)object));
                    return;
                }
                if (object instanceof Byte) {
                    ((OscarStatement)this).setInt(n2, ((Byte)object).intValue());
                    return;
                }
                if (object instanceof Short) {
                    ((OscarStatement)this).setInt(n2, ((Short)object).intValue());
                    return;
                }
                if (object instanceof Float) {
                    if (((Float)object).floatValue() > 32767.0f) throw new OSQLException("OSCAR-00702", "88888", 702);
                    if (((Float)object).floatValue() < -32768.0f) {
                        throw new OSQLException("OSCAR-00702", "88888", 702);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, 4, 2));
                    ((OscarStatement)this).setInt(n2, ((Float)object).intValue());
                    return;
                }
                if (object instanceof Double) {
                    if ((Double)object > 32767.0) throw new OSQLException("OSCAR-00702", "88888", 702);
                    if ((Double)object < -32768.0) {
                        throw new OSQLException("OSCAR-00702", "88888", 702);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, 8, 2));
                    ((OscarStatement)this).setInt(n2, ((Double)object).intValue());
                    return;
                }
                if (object instanceof Long) {
                    if ((Long)object > 32767L) throw new OSQLException("OSCAR-00702", "88888", 702);
                    if ((Long)object < -32768L) {
                        throw new OSQLException("OSCAR-00702", "88888", 702);
                    }
                    ((OscarStatement)this).setInt(n2, ((Long)object).intValue());
                    return;
                }
                if (object instanceof Boolean) {
                    ((OscarStatement)this).setInt(n2, (Boolean)object != false ? 1 : 0);
                    return;
                }
                if (object instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (bigDecimal.doubleValue() > 32767.0) throw new OSQLException("OSCAR-00702", "88888", 702);
                    if (bigDecimal.doubleValue() < -32768.0) {
                        throw new OSQLException("OSCAR-00702", "88888", 702);
                    }
                    this.addWarning(new DataTruncation(n2, true, false, -1, 2));
                    ((OscarStatement)this).setInt(n2, (int)bigDecimal.doubleValue());
                    return;
                }
                if (object instanceof String) {
                    double d4;
                    if (object.toString().trim().equals("")) {
                        this.setEmptyString(n2);
                        return;
                    }
                    try {
                        d4 = Double.parseDouble((String)object);
                    }
                    catch (Exception exception) {
                        throw new OSQLException("OSCAR-00702", "88888", 702, exception);
                    }
                    if (d4 > 32767.0) throw new OSQLException("OSCAR-00702", "88888", 702);
                    if (d4 < -32768.0) {
                        throw new OSQLException("OSCAR-00702", "88888", 702);
                    }
                    ((OscarStatement)this).setInt(n2, (int)d4);
                    return;
                }
                if (!(object instanceof Character)) throw new OSQLException("OSCAR-00702", "88888", 702);
                try {
                    ((OscarStatement)this).setInt(n2, Integer.parseInt(object.toString()));
                    return;
                }
                catch (Exception exception) {
                    throw new OSQLException("OSCAR-00702", "88888", 702, exception);
                }
            }
            case 7: {
                if (object instanceof Integer) {
                    ((OscarStatement)this).setDouble(n2, ((Integer)object).doubleValue());
                    return;
                }
                if (object instanceof Byte) {
                    ((OscarStatement)this).setDouble(n2, ((Byte)object).doubleValue());
                    return;
                }
                if (object instanceof Short) {
                    ((OscarStatement)this).setDouble(n2, ((Short)object).doubleValue());
                    return;
                }
                if (object instanceof Long) {
                    ((OscarStatement)this).setDouble(n2, ((Long)object).doubleValue());
                    return;
                }
                if (object instanceof Float) {
                    ((OscarStatement)this).setDouble(n2, ((Float)object).doubleValue());
                    return;
                }
                if (object instanceof Double) {
                    if ((Double)object > 3.4028234663852886E38) throw new OSQLException("OSCAR-00705", "88888", 705);
                    if ((Double)object < -3.4028234663852886E38) {
                        throw new OSQLException("OSCAR-00705", "88888", 705);
                    }
                    ((OscarStatement)this).setDouble(n2, (double)((Double)object));
                    return;
                }
                if (object instanceof Boolean) {
                    ((OscarStatement)this).setDouble(n2, (Boolean)object != false ? 1.0 : 0.0);
                    return;
                }
                if (object instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (bigDecimal.doubleValue() > 3.4028234663852886E38) throw new OSQLException("OSCAR-00705", "88888", 705);
                    if (bigDecimal.doubleValue() < -3.4028234663852886E38) {
                        throw new OSQLException("OSCAR-00705", "88888", 705);
                    }
                    ((OscarStatement)this).setDouble(n2, bigDecimal.doubleValue());
                    return;
                }
                if (object instanceof String) {
                    double d5;
                    if (object.toString().trim().equals("")) {
                        this.setEmptyString(n2);
                        return;
                    }
                    try {
                        d5 = Double.parseDouble((String)object);
                    }
                    catch (Exception exception) {
                        throw new OSQLException("OSCAR-00705", "88888", 705, exception);
                    }
                    if (d5 > 3.4028234663852886E38) throw new OSQLException("OSCAR-00705", "88888", 705);
                    if (d5 < -3.4028234663852886E38) {
                        throw new OSQLException("OSCAR-00705", "88888", 705);
                    }
                    ((OscarStatement)this).setDouble(n2, d5);
                    return;
                }
                if (!(object instanceof Character)) throw new OSQLException("OSCAR-00705", "88888", 705);
                try {
                    ((OscarStatement)this).setDouble(n2, Double.parseDouble(object.toString()));
                    return;
                }
                catch (Exception exception) {
                    throw new OSQLException("OSCAR-00705", "88888", 705, exception);
                }
            }
            case 6: 
            case 8: {
                if (object instanceof Integer) {
                    ((OscarStatement)this).setDouble(n2, ((Integer)object).doubleValue());
                    return;
                }
                if (object instanceof Byte) {
                    ((OscarStatement)this).setDouble(n2, ((Byte)object).doubleValue());
                    return;
                }
                if (object instanceof Short) {
                    ((OscarStatement)this).setDouble(n2, ((Short)object).doubleValue());
                    return;
                }
                if (object instanceof Long) {
                    ((OscarStatement)this).setDouble(n2, ((Long)object).doubleValue());
                    return;
                }
                if (object instanceof Float) {
                    ((OscarStatement)this).setDouble(n2, ((Float)object).doubleValue());
                    return;
                }
                if (object instanceof Double) {
                    ((OscarStatement)this).setDouble(n2, (double)((Double)object));
                    return;
                }
                if (object instanceof Boolean) {
                    ((OscarStatement)this).setDouble(n2, (Boolean)object != false ? 1.0 : 0.0);
                    return;
                }
                if (object instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (bigDecimal.doubleValue() > Double.MAX_VALUE) throw new OSQLException("OSCAR-00706", "88888", 706);
                    if (bigDecimal.doubleValue() < -1.7976931348623157E308) {
                        throw new OSQLException("OSCAR-00706", "88888", 706);
                    }
                    ((OscarStatement)this).setDouble(n2, bigDecimal.doubleValue());
                    return;
                }
                if (object instanceof String) {
                    double d6;
                    if (object.toString().trim().equals("")) {
                        this.setEmptyString(n2);
                        return;
                    }
                    try {
                        d6 = Double.parseDouble((String)object);
                    }
                    catch (Exception exception) {
                        throw new OSQLException("OSCAR-00706", "88888", 706, exception);
                    }
                    ((OscarStatement)this).setDouble(n2, d6);
                    return;
                }
                if (!(object instanceof Character)) throw new OSQLException("OSCAR-00706", "88888", 706);
                try {
                    ((OscarStatement)this).setDouble(n2, Double.parseDouble(object.toString()));
                    return;
                }
                catch (Exception exception) {
                    throw new OSQLException("OSCAR-00706", "88888", 706, exception);
                }
            }
            case 2: 
            case 3: {
                if (object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof BigInteger || object instanceof Character) {
                    if (n4 == -2147483638) {
                        ((OscarStatement)this).setBigDecimal(n2, new BigDecimal(object.toString()));
                        return;
                    }
                    ((OscarStatement)this).setBigDecimal(n2, new BigDecimal(object.toString()).setScale(n4, 4));
                    return;
                }
                if (object instanceof Boolean) {
                    if (n4 == -2147483638) {
                        ((OscarStatement)this).setDouble(n2, (Boolean)object != false ? 1.0 : 0.0);
                        return;
                    }
                    if (n4 < 0) {
                        throw new OSQLException("OSCAR-00707", "88888", 707);
                    }
                    ((OscarStatement)this).setDouble(n2, new BigDecimal((Boolean)object != false ? 1 : 0).setScale(n4).doubleValue());
                    return;
                }
                if (object instanceof BigDecimal) {
                    if (n4 == -2147483638) {
                        ((OscarStatement)this).setBigDecimal(n2, (BigDecimal)object);
                        return;
                    }
                    ((OscarStatement)this).setBigDecimal(n2, ((BigDecimal)object).setScale(n4, 4));
                    return;
                }
                if (!(object instanceof String)) throw new OSQLException("OSCAR-00707", "88888", 707);
                if (object.toString().trim().equals("")) {
                    this.setEmptyString(n2);
                    return;
                }
                if (n4 == -2147483638) {
                    ((OscarStatement)this).setBigDecimal(n2, new BigDecimal(object.toString().trim()));
                    return;
                }
                ((OscarStatement)this).setBigDecimal(n2, new BigDecimal(object.toString().trim()).setScale(n4, 4));
                return;
            }
            case -7: {
                String string;
                if (object instanceof Boolean) {
                    if (((Boolean)object).booleanValue()) {
                        ((OscarStatement)this).setBoolean(n2, true);
                        return;
                    }
                    ((OscarStatement)this).setBoolean(n2, false);
                    return;
                }
                if (!(object instanceof BigDecimal || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Short || object instanceof String || object instanceof Character)) {
                    if (!(object instanceof BigInteger)) throw new OSQLException("OSCAR-00717", "88888", 717);
                }
                if ((string = object.toString()).equalsIgnoreCase("true")) {
                    ((OscarStatement)this).setBoolean(n2, true);
                    return;
                }
                if (string.equalsIgnoreCase("false")) {
                    ((OscarStatement)this).setBoolean(n2, false);
                    return;
                }
                if (string.length() > 0 && string.charAt(0) == '\u0000') {
                    string = "";
                }
                ((OscarStatement)this).setString(n2, string, 24);
                return;
            }
            case -1: 
            case 1: 
            case 12: {
                if (object instanceof byte[]) {
                    String string;
                    try {
                        string = this.encoding.decode((byte[])object);
                    }
                    catch (Exception exception) {
                        throw new OSQLException("OSCAR-00713", "88888", 713, exception);
                    }
                    ((OscarStatement)this).setString(n2, string, 24);
                    return;
                }
                if (object instanceof OscarBlob) {
                    if (!this.connection.getVersion().isConvertLobLocatorByFunc()) throw new OSQLException("OSCAR-00713", "88888", 713);
                    this.bind(n2, "blob_locator('" + ((OscarBlob)object).getLocatorStr() + "')", 50);
                    return;
                }
                if (object instanceof OtherType) {
                    OtherType otherType = (OtherType)object;
                    if (otherType.getObj() instanceof Reader) {
                        ((OscarStatement)this).setCharacterStream(n2, (Reader)otherType.getObj(), otherType.getLength());
                        return;
                    }
                    if (!(otherType.getObj() instanceof InputStream)) throw new OSQLException("OSCAR-00709", "88888", 709);
                    ((OscarStatement)this).setAsciiStream(n2, (InputStream)otherType.getObj(), otherType.getLength());
                    return;
                }
                if (object instanceof OscarObject) {
                    ((OscarStatement)this).setString(n2, ((OscarObject)object).getValue(), 24);
                    return;
                }
                String string = object.toString();
                if (string.length() > 0 && string.charAt(0) == '\u0000') {
                    string = "";
                }
                ((OscarStatement)this).setString(n2, string, 24);
                return;
            }
            case 91: {
                if (object instanceof Timestamp) {
                    ((OscarStatement)this).setDate(n2, new Date(((Timestamp)object).getTime()));
                    return;
                }
                if (object instanceof Date) {
                    ((OscarStatement)this).setDate(n2, (Date)object);
                    return;
                }
                if (object instanceof java.util.Date) {
                    ((OscarStatement)this).setDate(n2, new Date(((java.util.Date)object).getTime()));
                    return;
                }
                if (!(object instanceof String)) throw new OSQLException("OSCAR-00710", "88888", 710);
                try {
                    if (!"infinity".equalsIgnoreCase((String)object) && !"-infinity".equalsIgnoreCase((String)object)) {
                        long l2 = Timestamp.valueOf(object.toString().trim()).getTime();
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        ((OscarStatement)this).setString(n2, simpleDateFormat.format(new Date(l2)));
                        return;
                    }
                    ((OscarStatement)this).setString(n2, (String)object);
                    return;
                }
                catch (Exception exception) {
                    try {
                        ((OscarStatement)this).setDate(n2, com.oscar.sql.Date.valueOf(object.toString().trim()));
                        return;
                    }
                    catch (Exception exception3) {
                        throw new OSQLException("OSCAR-00710", "88888", 710, exception3);
                    }
                }
            }
            case 27: 
            case 92: {
                if (object instanceof Timestamp) {
                    ((OscarStatement)this).setTime(n2, new Time(((Timestamp)object).getHours(), ((Timestamp)object).getMinutes(), ((Timestamp)object).getSeconds()));
                    return;
                }
                if (object instanceof Time) {
                    ((OscarStatement)this).setTime(n2, (Time)object);
                    return;
                }
                if (!(object instanceof String)) throw new OSQLException("OSCAR-00711", "88888", 711);
                try {
                    long l3 = Timestamp.valueOf(object.toString().trim()).getTime();
                    ((OscarStatement)this).setString(n2, new Time(l3).toString());
                    return;
                }
                catch (Exception exception) {
                    try {
                        ((OscarStatement)this).setTime(n2, Time.valueOf(object.toString().trim()));
                        return;
                    }
                    catch (Exception exception4) {
                        try {
                            ((OscarStatement)this).setString(n2, object.toString());
                            return;
                        }
                        catch (Exception exception5) {
                            throw new OSQLException("OSCAR-00711", "88888", 711, exception5);
                        }
                    }
                }
            }
            case 29: 
            case 93: {
                if (object instanceof Timestamp) {
                    ((OscarStatement)this).setTimestamp(n2, (Timestamp)object);
                    return;
                }
                if (object instanceof java.util.Date) {
                    ((OscarStatement)this).setTimestamp(n2, new Timestamp(((java.util.Date)object).getTime()));
                    return;
                }
                if (!(object instanceof String)) throw new OSQLException("OSCAR-00712", "88888", 712);
                try {
                    if ("infinity".equalsIgnoreCase((String)object)) {
                        ((OscarStatement)this).setTimestamp(n2, new Timestamp(Long.MAX_VALUE));
                        return;
                    }
                    if ("-infinity".equalsIgnoreCase((String)object)) {
                        ((OscarStatement)this).setTimestamp(n2, new Timestamp(Long.MIN_VALUE));
                        return;
                    }
                    long l4 = Date.valueOf(object.toString().trim()).getTime();
                    ((OscarStatement)this).setTimestamp(n2, new Timestamp(l4));
                    return;
                }
                catch (Exception exception) {
                    try {
                        ((OscarStatement)this).setTimestamp(n2, Timestamp.valueOf(object.toString().trim()));
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.bind(n2, object, 24);
                        return;
                    }
                    catch (Exception exception6) {
                        throw new OSQLException("OSCAR-00712", "88888", 712, exception6);
                    }
                }
            }
            case 16: {
                double d7;
                String string;
                if (object instanceof Boolean) {
                    ((OscarStatement)this).setBoolean(n2, (boolean)((Boolean)object));
                    return;
                }
                if (!(object instanceof BigDecimal || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Short || object instanceof Byte || object instanceof String || object instanceof Character)) {
                    if (!(object instanceof BigInteger)) throw new OSQLException("OSCAR-00708", "88888", 708);
                }
                if ((string = object.toString()).length() == 1) {
                    if (string.charAt(0) != '1' && string.charAt(0) != 't' && string.charAt(0) != 'y' && string.charAt(0) != 'T' && string.charAt(0) != 'Y') {
                        ((OscarStatement)this).setBoolean(n2, false);
                        return;
                    }
                    ((OscarStatement)this).setBoolean(n2, true);
                    return;
                }
                if (string.length() <= 1) {
                    ((OscarStatement)this).setBoolean(n2, false);
                    return;
                }
                if (string.equalsIgnoreCase("true")) {
                    ((OscarStatement)this).setBoolean(n2, true);
                    return;
                }
                if (string.equalsIgnoreCase("false")) {
                    ((OscarStatement)this).setBoolean(n2, false);
                    return;
                }
                if (string.equalsIgnoreCase("yes")) {
                    ((OscarStatement)this).setBoolean(n2, true);
                    return;
                }
                if (string.equalsIgnoreCase("no")) {
                    ((OscarStatement)this).setBoolean(n2, false);
                    return;
                }
                try {
                    d7 = Double.parseDouble(string);
                }
                catch (Exception exception) {
                    throw new OSQLException("OSCAR-00708", "88888", 708, exception);
                }
                if (!(d7 >= 1.0E-10) && !(d7 <= -1.0E-10)) {
                    ((OscarStatement)this).setBoolean(n2, false);
                    return;
                }
                ((OscarStatement)this).setBoolean(n2, true);
                return;
            }
            case -4: 
            case -3: 
            case -2: {
                if (object instanceof byte[]) {
                    String string;
                    if (this.connection.sendBinaryTypeAsHex()) {
                        ((OscarStatement)this).setString(n2, OSCARbyte.toOSCARString((byte[])object), 24);
                        return;
                    }
                    try {
                        string = this.clientEncoding.decode((byte[])object);
                    }
                    catch (Exception exception) {
                        throw new OSQLException("OSCAR-00713", "88888", 713, exception);
                    }
                    ((OscarStatement)this).setString(n2, string, 24);
                    return;
                }
                if (!(object instanceof String)) {
                    if (!(object instanceof OtherType)) throw new OSQLException("OSCAR-00709", "88888", 709);
                    OtherType otherType = (OtherType)object;
                    if (!(otherType.getObj() instanceof InputStream)) throw new OSQLException("OSCAR-00709", "88888", 709);
                    ((OscarStatement)this).setBinaryStream(n2, (InputStream)otherType.getObj(), otherType.getLength());
                    return;
                }
                if (this.connection.sendBinaryTypeAsHex()) {
                    ((OscarStatement)this).setString(n2, OSCARbyte.toOSCARString(this.encoding.encode((String)object)), 24);
                    return;
                }
                ((OscarStatement)this).setString(n2, (String)object, 24);
                return;
            }
            case 2004: {
                if (object instanceof Blob) {
                    if (!(object instanceof OscarBlob)) {
                        Blob blob = (Blob)object;
                        byte[] byArray = blob.getBytes(1L, (int)blob.length());
                        ((OscarStatement)this).setBlobString(n2, byArray, 2004);
                        return;
                    }
                    if (((OscarBlob)object).isEmptyLob()) {
                        this.bind(n2, "EMPTY_BLOB()", 50);
                        return;
                    }
                    if (this.connection.getVersion().isConvertLobLocatorByFunc()) {
                        this.bind(n2, "blob_locator('" + ((OscarBlob)object).getLocatorStr() + "')", 50);
                        return;
                    }
                    this.bind(n2, ((OscarBlob)object).getLocatorStr(), 50);
                    return;
                }
                if (object instanceof byte[]) {
                    ((OscarStatement)this).setBlobString(n2, (byte[])object, 2004);
                    return;
                }
                if (Boolean.valueOf(this.connection.getConnectionProperties().getProperty("OBJECTTOSTRING", "false")).booleanValue() && object instanceof String) {
                    String string = this.connection.getConnectionProperties().getProperty("OBJECTTOSTRINGCHARSET", this.clientEncoding.getEncoding());
                    try {
                        ((OscarStatement)this).setBlobString(n2, ((String)object).getBytes(string), 2004);
                        return;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new OSQLException("OSCAR-00001", "8888", 1);
                    }
                }
                if (!(object instanceof OtherType)) throw new OSQLException("OSCAR-00714", "88888", 714);
                OtherType otherType = (OtherType)object;
                if (!(otherType.getObj() instanceof InputStream)) throw new OSQLException("OSCAR-00709", "88888", 709);
                ((OscarStatement)this).setBinaryStream(n2, (InputStream)otherType.getObj(), otherType.getLength());
                return;
            }
            case 2005: {
                if (object instanceof Clob) {
                    if (object instanceof OscarClob) {
                        if (((OscarClob)object).isEmptyLob()) {
                            this.bind(n2, "EMPTY_CLOB()", 51);
                            return;
                        }
                        if (this.connection.getVersion().isConvertLobLocatorByFunc()) {
                            this.bind(n2, "clob_locator('" + ((OscarClob)object).getLocatorStr() + "')", 51);
                            return;
                        }
                        this.bind(n2, ((OscarClob)object).getLocatorStr(), 51);
                        return;
                    }
                    String string = this.clob2String((Clob)object);
                    if (string.length() > 0 && string.charAt(0) == '\u0000') {
                        string = "";
                    }
                    this.bind(n2, string, 24);
                    return;
                }
                if (object instanceof String) {
                    String string = object.toString();
                    if (string.length() > 0 && string.charAt(0) == '\u0000') {
                        string = "";
                    }
                    this.bind(n2, string, 24);
                    return;
                }
                if (object instanceof byte[]) {
                    String string = this.encoding.decode((byte[])object);
                    this.bind(n2, string, 24);
                    return;
                }
                if (!(object instanceof OtherType)) throw new OSQLException("OSCAR-00715", "88888", 715);
                OtherType otherType = (OtherType)object;
                if (otherType.getObj() instanceof Reader) {
                    ((OscarStatement)this).setCharacterStream(n2, (Reader)otherType.getObj(), otherType.getLength());
                    return;
                }
                if (!(otherType.getObj() instanceof InputStream)) throw new OSQLException("OSCAR-00709", "88888", 709);
                ((OscarStatement)this).setAsciiStream(n2, (InputStream)otherType.getObj(), otherType.getLength());
                return;
            }
            case -11: {
                if (!(object instanceof OscarBfile)) throw new OSQLException("OSCAR-00716", "88888", 716);
                if (this.connection.getVersion().isConvertLobLocatorByFunc()) {
                    this.bind(n2, "bfile_locator('" + ((OscarBfile)object).getLocatorStr() + "')", 52);
                    return;
                }
                this.bind(n2, ((OscarBfile)object).getLocatorStr(), 52);
                return;
            }
            case 1111: {
                ((OscarStatement)this).setString(n2, String.valueOf(object));
                return;
            }
            case 2003: {
                ((OscarStatement)this).setString(n2, this.getArrayToString(object), 24);
                return;
            }
            case 2002: {
                ((OscarStatement)this).setString(n2, String.valueOf(object));
                return;
            }
        }
        throw new OSQLException("OSCAR-00411", "88888", 411);
    }

    @Override
    public void freeBindedLob(OscarLob oscarLob, int n2) throws SQLException {
        if (oscarLob != null && (n2 == 50 || n2 == 51 || n2 == 52)) {
            if (oscarLob.isTempLob()) {
                oscarLob.freeTemporary();
                return;
            }
            if (oscarLob.isTableIdLob()) {
                oscarLob.freePersist();
            }
        }
    }

    @Override
    protected String getFixedString(int n2) throws SQLException {
        this.checkOutParameter(n2);
        if (this.checkNullValue(n2 - 1)) {
            return null;
        }
        if (this.netDataByStr) {
            return super.getFixedString(n2);
        }
        OscarStatementV2 oscarStatementV2 = this;
        return oscarStatementV2.getStringValue(oscarStatementV2.m_outValues[n2 - 1], this.getOscarType(n2));
    }

    private String getStringValue(Object object, int n2) throws SQLException {
        if (object == null) {
            return null;
        }
        byte[] byArray = (byte[])object;
        object = byArray;
        if (byArray.length == 2 && object[0] == -3) {
            if (object[1] == true) {
                return "NaN";
            }
            if (object[1] == 2) {
                return "infinity";
            }
            if (object[1] == 3) {
                return "-infinity";
            }
        }
        switch (n2) {
            case 35: {
                return this.encoding.decode((byte[])object);
            }
            case 51: {
                object = this.connection.getClobInstance(new String((byte[])object));
                long l2 = object.length();
                if (l2 > Integer.MAX_VALUE) {
                    throw new OSQLException("OSCAR-00316", "22000", 316);
                }
                return object.getSubString(1L, (int)l2);
            }
            case 33: {
                return String.valueOf(BooleanConverter.convertToBoolean((byte[])object));
            }
            case 25: {
                return DateConverter.convertBytesToDateString((byte[])object);
            }
            case 34: {
                if (this.numericKeepPrecision) {
                    return this.encoding.decode((byte[])object);
                }
                if (((String)(object = String.valueOf(NumberConverter.convertBytesToDouble((byte[])object)))).endsWith(".0") && ((String)object).length() > 2) {
                    return ((String)object).substring(0, ((String)object).length() - 2);
                }
                return object;
            }
            case 31: {
                return IntervalConverter.convertToIntervalDTS((byte[])object);
            }
            case 30: {
                return IntervalConverter.convertToIntervalYTM((byte[])object);
            }
            case 23: {
                return String.valueOf(NumberConverter.convertBytesToLong((byte[])object));
            }
            case 32: {
                return String.valueOf(RowidConverter.convertToRowID((byte[])object));
            }
            case 26: {
                return TimetzConverter.convertBytesToTimeString((byte[])object);
            }
            case 28: {
                object = String.valueOf(TimestampConverter.convertBytesToTimeStamp((byte[])object));
                return object;
            }
            case 29: {
                object = String.valueOf(TimestamptzConverter.convertBytesToTimeStamp((byte[])object));
                if (object != null) {
                    if (((String)object).endsWith(".0") && ((String)object).length() > 2) {
                        object = ((String)object).substring(0, ((String)object).length() - 2);
                    } else if (((String)object).endsWith(".0 BC") && ((String)object).length() > 5) {
                        object = ((String)object).substring(0, ((String)object).length() - 5);
                        object = (String)object + " BC";
                    }
                }
                return object;
            }
            case 27: {
                return TimetzConverter.convertBytesToTimeZoneString((byte[])object);
            }
            case 24: {
                return this.encoding.decode((byte[])object);
            }
        }
        return this.encoding.decode((byte[])object);
    }

    protected int getOscarType(int n2) throws SQLException {
        n2 = this.outParameterIndex.indexOf(n2);
        if (this.isFunc && !this.isResultNeeded) {
            ++n2;
        }
        return this.fields[n2].getOscarType();
    }

    @Override
    public void hardClose() throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", hardClose()");
        }
        if (this.isClosed) {
            return;
        }
        if (this.result != null) {
            this.result.close();
            this.result = null;
        }
        this.cleanEnvTemp();
        this.clearParameters();
        if (this.statementType != 0 && this.m_statementName != null) {
            if (this.statementType == 2) {
                this.releasePrepareStatementReally();
            } else {
                this.releasePrepareStatement();
            }
        }
        this.connection = null;
        this.batchPacketV2 = null;
        this.encoding = null;
        this.osql = null;
        this.outParameterType = null;
        this.outParameterIndex = null;
        this.pMetaData = null;
        this.sbuf = null;
        this.m_sqlFragments = null;
        this.m_origSqlFragments = null;
        this.m_executeSqlFragments = null;
        this.m_binds = null;
        this.m_lobs = null;
        this.m_bindTypes = null;
        this.m_functionTypes = null;
        this.m_outValues = null;
        this.m_returnValue = null;
        this.m_returnType = 0;
        this.isClosed = true;
    }

    @Override
    protected void releasePrepareStatementReally() throws SQLException {
        String string;
        if (this.isPrepared != null) {
            try {
                if (this.connection != null && !((Connection)((Object)this.connection)).isClosed()) {
                    this.isPrepared = null;
                    this.connection.execSQL("DEALLOCATE PREPARE " + this.m_statementName);
                }
                return;
            }
            catch (SQLException sQLException) {
                if (this.logFlag) {
                    Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", releasePrepareStatementReally(),error:" + sQLException.getMessage());
                }
                return;
            }
        }
        if (this.m_prepareSqlStatement != null && this.m_sqlFragments != null && this.selectSql && this.fetchSize > 0 && (this.resultSetType != 1003 || this.resultSetConcurrency != 1007) && !(string = "PREPARE " + this.m_statementName + " AS " + this.m_sqlFragments[0] + ";").equalsIgnoreCase(this.m_prepareSqlStatement)) {
            this.m_prepareSqlStatement = string;
        }
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)((OscarStatement)this).getParameterMetaData();
        }
        switch (this.pMetaData.getParameterType(n2)) {
            case -1: 
            case 1: 
            case 12: {
                try {
                    if (inputStream != null) {
                        int n3 = l2 > Integer.MAX_VALUE || l2 == -1L ? 8001 : (int)l2;
                        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "US-ASCII");
                        char[] cArray = new char[n3];
                        int n4 = inputStreamReader.read(cArray, 0, n3);
                        ((OscarStatement)this).setString(n2, new String(cArray, 0, n4));
                        return;
                    }
                    ((OscarStatement)this).setString(n2, null);
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new OSQLException("OSCAR-00302", "88888", 302, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                }
                catch (IOException iOException) {
                    throw new OSQLException("OSCAR-00302", "88888", 302, iOException.getMessage(), iOException);
                }
            }
            case 2005: {
                if (inputStream == null) {
                    this.setObject(n2, null, 2005);
                    this.m_lobs[n2 - 1] = null;
                } else {
                    OscarClob oscarClob;
                    if (this.pMetaData.getParameterRelOid(n2) != 0) {
                        int n5 = this.pMetaData.getParameterRelOid(n2);
                        int n6 = this.pMetaData.getParameterRelColIndex(n2);
                        oscarClob = OscarClob.createForTable(this.getConnection(), n5, n6);
                    } else {
                        oscarClob = ((OscarJdbc2Connection)this.connection).createClob();
                    }
                    if (l2 > 0L && l2 <= Integer.MAX_VALUE) {
                        try {
                            ((OscarLob)oscarClob).write(1L, inputStream, l2);
                        }
                        catch (Exception exception) {
                            this.m_lobs[n2 - 1] = null;
                        }
                    } else {
                        OutputStream outputStream = oscarClob.setAsciiStream(1L);
                        try {
                            int n7;
                            byte[] byArray = new byte[this.bufSize];
                            while ((n7 = inputStream.read(byArray, 0, this.bufSize)) > 0) {
                                outputStream.write(byArray, 0, n7);
                            }
                            outputStream.flush();
                            outputStream.close();
                        }
                        catch (Exception exception) {
                            this.m_lobs[n2 - 1] = null;
                        }
                    }
                    this.setObject(n2, (Object)oscarClob, 2005);
                    this.m_lobs[n2 - 1] = oscarClob;
                }
                if (this.m_lobs[n2 - 1] == null || !this.m_lobs[n2 - 1].isTempLob() && !this.m_lobs[n2 - 1].isTableIdLob()) break;
                this.tempResource.add(this.m_lobs[n2 - 1]);
                return;
            }
            default: {
                throw new OSQLException("OSCAR-00410", "88888", 410);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)((OscarStatement)this).getParameterMetaData();
        }
        int n3 = this.pMetaData.getParameterType(n2);
        switch (n3) {
            case -1: 
            case 1: 
            case 12: {
                Object object = null;
                if (l2 == -1L || l2 > 8000L) {
                    int n4;
                    object = new ByteArrayOutputStream();
                    byte[] byArray = new byte[1024];
                    while ((n4 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                        ((ByteArrayOutputStream)object).write(byArray, 0, n4);
                    }
                    ((OutputStream)object).flush();
                    ((OscarStatement)this).setString(n2, OSCARbyte.toOSCARString(((ByteArrayOutputStream)object).toByteArray()), 24);
                } else {
                    int n5 = (int)l2;
                    byte[] byArray = new byte[n5];
                    inputStream.read(byArray, 0, n5);
                    ((OscarStatement)this).setString(n2, OSCARbyte.toOSCARString(byArray), 24);
                }
                if (object == null) return;
                try {
                    ((ByteArrayOutputStream)object).close();
                    return;
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    Driver.writeLog(iOException);
                }
                return;
                catch (Exception exception) {
                    try {
                        Exception exception2 = exception;
                        Driver.writeLog(exception);
                        throw new OSQLException("OSCAR-00410", "88888", 410);
                    }
                    catch (Throwable throwable) {
                        if (object == null) throw throwable;
                        try {
                            ((ByteArrayOutputStream)object).close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            object = iOException;
                            Driver.writeLog(iOException);
                        }
                        throw throwable;
                    }
                }
            }
            case -4: 
            case -3: 
            case -2: {
                int n6;
                int n7 = l2 > Integer.MAX_VALUE || l2 == -1L ? 8001 : (int)l2;
                byte[] byArray = new byte[n7];
                try {
                    if (inputStream == null) {
                        ((OscarStatement)this).setBytes(n2, null);
                        return;
                    }
                    n6 = inputStream.read(byArray, 0, n7);
                }
                catch (IOException iOException) {
                    throw new OSQLException("OSCAR-00410", "88888", 410, iOException.getMessage(), iOException);
                }
                if ((long)n6 == l2) {
                    ((OscarStatement)this).setBytes(n2, byArray);
                    return;
                }
                byte[] byArray2 = new byte[n6];
                System.arraycopy(byArray, 0, byArray2, 0, n6);
                ((OscarStatement)this).setBytes(n2, byArray2);
                return;
            }
            case 2004: {
                OscarBlob oscarBlob;
                Object object;
                n3 = this.pMetaData.getParameterRelOid(n2);
                if (n3 != 0) {
                    object = this.tableTypes.get(n3);
                    if (object == null) {
                        object = this.getRelKind(n3);
                        this.tableTypes.put(n3, (Character)object);
                    }
                    if (((Character)object).charValue() == 'r') {
                        int n8 = this.pMetaData.getParameterRelColIndex(n2);
                        oscarBlob = OscarBlob.createForTable(this.getConnection(), n3, n8);
                    } else {
                        oscarBlob = ((OscarJdbc2Connection)this.connection).createBlob();
                    }
                } else {
                    oscarBlob = ((OscarJdbc2Connection)this.connection).createBlob();
                }
                if (l2 > 0L && l2 < Integer.MAX_VALUE) {
                    try {
                        ((OscarLob)oscarBlob).write(1L, inputStream, l2);
                    }
                    catch (SQLException sQLException) {
                        this.m_lobs[n2 - 1] = null;
                        throw sQLException;
                    }
                }
                object = oscarBlob.setBinaryStream(1L);
                try {
                    int n9;
                    byte[] byArray = new byte[this.bufSize];
                    while ((n9 = inputStream.read(byArray, 0, this.bufSize)) > 0) {
                        ((OutputStream)object).write(byArray, 0, n9);
                    }
                    ((OutputStream)object).flush();
                    ((OutputStream)object).close();
                }
                catch (Exception exception) {
                    this.m_lobs[n2 - 1] = null;
                }
                this.setObject(n2, (Object)oscarBlob, 2004);
                this.m_lobs[n2 - 1] = oscarBlob;
                if (this.m_lobs[n2 - 1] == null || !this.m_lobs[n2 - 1].isTempLob() && !this.m_lobs[n2 - 1].isTableIdLob()) return;
                this.tempResource.add(this.m_lobs[n2 - 1]);
                return;
            }
            default: {
                throw new OSQLException("OSCAR-00410", "88888", 410);
            }
        }
    }

    @Override
    public void setBlobString(int n2, Object object, int n3) throws SQLException {
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)((OscarStatement)this).getParameterMetaData();
        }
        if (object == null) {
            this.setObject(n2, null, n3);
            this.m_lobs[n2 - 1] = null;
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length > 4000) {
                OscarBlob oscarBlob;
                int n4 = this.pMetaData.getParameterRelOid(n2);
                if (n4 != 0) {
                    Character c2 = this.tableTypes.get(n4);
                    if (c2 == null) {
                        c2 = this.getRelKind(n4);
                        this.tableTypes.put(n4, c2);
                    }
                    if (c2.charValue() == 'r') {
                        int n5 = this.pMetaData.getParameterRelColIndex(n2);
                        oscarBlob = OscarBlob.createForTable(this.getConnection(), n4, n5);
                    } else {
                        oscarBlob = ((OscarJdbc2Connection)this.connection).createBlob();
                    }
                } else {
                    oscarBlob = ((OscarJdbc2Connection)this.connection).createBlob();
                }
                oscarBlob.setBytes(1L, byArray);
                this.setObject(n2, (Object)oscarBlob, n3);
                this.m_lobs[n2 - 1] = oscarBlob;
            } else {
                ((OscarStatement)this).setString(n2, OSCARbyte.toOSCARString((byte[])object), 24);
                this.m_lobs[n2 - 1] = null;
            }
        }
        if (this.m_lobs[n2 - 1] != null && (this.m_lobs[n2 - 1].isTempLob() || this.m_lobs[n2 - 1].isTableIdLob())) {
            this.tempResource.add(this.m_lobs[n2 - 1]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)((OscarStatement)this).getParameterMetaData();
        }
        switch (this.pMetaData.getParameterType(n2)) {
            case -1: 
            case 1: 
            case 12: {
                try {
                    if (reader == null) {
                        ((OscarStatement)this).setString(n2, null);
                        return;
                    }
                    if (l2 == -1L) {
                        int n3;
                        char[] cArray = new char[1024];
                        StringBuilder stringBuilder = new StringBuilder(200);
                        for (int i2 = 0; (n3 = reader.read(cArray)) != -1 && i2 < 0x1000000; i2 += n3) {
                            stringBuilder.append(new String(cArray, 0, n3));
                        }
                        ((OscarStatement)this).setString(n2, stringBuilder.toString());
                        return;
                    }
                    int n4 = (int)l2;
                    char[] cArray = new char[n4];
                    int n5 = reader.read(cArray, 0, n4);
                    ((OscarStatement)this).setString(n2, new String(cArray, 0, n5));
                    return;
                }
                catch (IOException iOException) {
                    throw new OSQLException("OSCAR-00311", "88888", 311, iOException.getMessage(), iOException);
                }
            }
            case 2005: {
                OscarClob oscarClob;
                Object object;
                if (reader == null) {
                    this.setObject(n2, null, 2005);
                    this.m_lobs[n2 - 1] = null;
                    return;
                }
                int n6 = this.pMetaData.getParameterRelOid(n2);
                if (n6 != 0) {
                    object = this.tableTypes.get(n6);
                    if (object == null) {
                        object = this.getRelKind(n6);
                        this.tableTypes.put(n6, (Character)object);
                    }
                    if (((Character)object).charValue() == 'r') {
                        int n7 = this.pMetaData.getParameterRelColIndex(n2);
                        oscarClob = OscarClob.createForTable(this.getConnection(), n6, n7);
                    } else {
                        oscarClob = ((OscarJdbc2Connection)this.connection).createClob();
                    }
                } else {
                    oscarClob = ((OscarJdbc2Connection)this.connection).createClob();
                }
                if (l2 > 0L && l2 < Integer.MAX_VALUE) {
                    try {
                        oscarClob.write(1L, reader, l2);
                    }
                    catch (Exception exception) {
                        this.m_lobs[n2 - 1] = null;
                    }
                } else {
                    object = oscarClob.setCharacterStream(1L);
                    try {
                        int n8;
                        char[] cArray = new char[this.bufSize];
                        while ((n8 = reader.read(cArray, 0, this.bufSize)) > 0) {
                            ((Writer)object).write(cArray, 0, n8);
                        }
                        ((Writer)object).flush();
                        ((Writer)object).close();
                    }
                    catch (Exception exception) {
                        this.m_lobs[n2 - 1] = null;
                    }
                }
                this.setObject(n2, (Object)oscarClob, 2005);
                this.m_lobs[n2 - 1] = oscarClob;
                if (this.m_lobs[n2 - 1] == null || !this.m_lobs[n2 - 1].isTempLob() && !this.m_lobs[n2 - 1].isTableIdLob()) return;
                this.tempResource.add(this.m_lobs[n2 - 1]);
                return;
            }
            default: {
                throw new OSQLException("OSCAR-00410", "88888", 410);
            }
        }
    }

    @Override
    public void setUnicodeStream(int n2, InputStream closeable, int n3) throws SQLException {
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)((OscarStatement)this).getParameterMetaData();
        }
        switch (this.pMetaData.getParameterType(n2)) {
            case -1: 
            case 1: 
            case 12: {
                break;
            }
            default: {
                throw new OSQLException("OSCAR-00410", "88888", 410);
            }
        }
        try {
            if (closeable == null) {
                ((OscarStatement)this).setString(n2, null);
                return;
            }
            closeable = new InputStreamReader((InputStream)closeable, "UTF-16BE");
            char[] cArray = new char[n3];
            int n4 = ((InputStreamReader)closeable).read(cArray, 0, n3);
            ((OscarStatement)this).setString(n2, new String(cArray, 0, n4));
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OSQLException("OSCAR-00303", "88888", 303, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new OSQLException("OSCAR-00303", "88888", 303, iOException.getMessage(), iOException);
        }
    }

    protected void convertBindDatas(boolean bl) throws SQLException {
        if (this.m_bindTypes == null || this.m_bindTypes.length == 0) {
            return;
        }
        if (this.m_binds == null || this.m_binds.length == 0) {
            return;
        }
        if (this.m_binds.length != this.m_bindTypes.length) {
            return;
        }
        System.arraycopy(this.m_binds_old, 0, this.m_binds, 0, this.m_binds.length);
        if (bl) {
            for (int i2 = 0; i2 < this.m_bindTypes.length; ++i2) {
                if (this.m_binds[i2] == null) {
                    this.m_binds[i2] = "null";
                    continue;
                }
                if (this.m_bindTypes[i2] == 52 || this.m_bindTypes[i2] == 50 || this.m_bindTypes[i2] == 51 || this.m_binds[i2] instanceof Integer || this.m_binds[i2] instanceof Long || this.m_binds[i2] instanceof Double || this.m_binds[i2] instanceof Short) continue;
                String string = this.m_binds[i2].toString();
                if (string.length() > 1 && string.charAt(0) == '\'') {
                    String string2 = string;
                    if (string2.charAt(string2.length() - 1) == '\'' && !this.isNotRealPrepare()) continue;
                }
                if (string.equals("\u0000")) {
                    this.m_binds[i2] = "''";
                    continue;
                }
                StringBuffer stringBuffer = this.sbuf;
                synchronized (stringBuffer) {
                    char c2;
                    int n2;
                    this.sbuf.setLength(0);
                    this.sbuf.ensureCapacity(string.length() + string.length() / 10);
                    this.sbuf.append('\'');
                    if (this.m_bindTypes[i2] == 50 || this.m_bindTypes[i2] == 51 || this.m_bindTypes[i2] == 52) {
                        this.sbuf.append(string);
                    } else if (this.connection.getVersion().getTransferType() == 1) {
                        for (n2 = 0; n2 < string.length(); ++n2) {
                            c2 = string.charAt(n2);
                            if (c2 == '\\' || c2 == '\'') {
                                this.sbuf.append('\\');
                            }
                            this.sbuf.append(c2);
                        }
                    } else if (this.connection.getVersion().getTransferType() == 2) {
                        if (string.indexOf("'") != -1) {
                            for (n2 = 0; n2 < string.length(); ++n2) {
                                c2 = string.charAt(n2);
                                if (c2 == '\'') {
                                    this.sbuf.append('\'');
                                    if (!this.hasEscapeChar) {
                                        this.hasEscapeChar = true;
                                    }
                                }
                                this.sbuf.append(c2);
                            }
                        } else {
                            this.sbuf.append(string);
                        }
                    } else {
                        this.sbuf.append(string);
                    }
                    this.sbuf.append('\'');
                    this.m_binds[i2] = this.sbuf.toString();
                    continue;
                }
            }
            return;
        }
        BindConverter.convertBindDatas(this.m_binds, this.m_bindTypes, this.encoding, this.localCalendar);
    }

    @Override
    public void cache() throws SQLException {
        OscarJdbc2Connection oscarJdbc2Connection = (OscarJdbc2Connection)this.connection;
        if (this instanceof OscarPreparedStatementV2) {
            oscarJdbc2Connection.cacheImplicitStatement((OscarPreparedStatementV2)this, this.osql, this.statementType, this.resultSetType);
            return;
        }
        this.hardClose();
    }

    public void setLobDisplayMaxSize(int n2) {
        this.lobDisplayMaxSize = n2;
    }

    private void handleNullStatementName(String string) throws SQLException {
        if (this.m_statementName == null && this.m_prepareSqlStatement.startsWith("PREPARE ")) {
            Matcher matcher = PATTERN_PREPARE.matcher(this.m_prepareSqlStatement);
            if (matcher.find()) {
                this.m_statementName = matcher.group();
                return;
            }
            if ("notImplemented".equals(string)) {
                throw Driver.notImplemented();
            }
            if (string.startsWith("OSCAR")) {
                throw new OSQLException("OSCAR-00421", "88888", 421);
            }
            throw new SQLException("statementName\u4e3anull");
        }
    }

    @Override
    public void setBytes(int n2, byte[] byArray) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog(this.sessionId, this.pid, OscarStatementV2.class + ", setBytes(int parameterIndex, byte x[]), parameterIndex: " + n2 + ", x: " + (byArray == null ? "null" : Arrays.toString(byArray)));
        }
        this.checkClosed();
        if (this.pMetaData == null) {
            this.pMetaData = (OscarParaMetaData)((OscarStatement)this).getParameterMetaData();
        }
        int n3 = this.pMetaData.getParameterType(n2);
        if (byArray == null) {
            ((OscarStatement)this).setNull(n2, n3);
            return;
        }
        if (n3 == 2004) {
            OscarBlob oscarBlob;
            n3 = this.pMetaData.getParameterRelOid(n2);
            if (n3 != 0) {
                Character c2 = this.tableTypes.get(n3);
                if (c2 == null) {
                    c2 = this.getRelKind(n3);
                    this.tableTypes.put(n3, c2);
                }
                if (c2.charValue() == 'r') {
                    int n4 = this.pMetaData.getParameterRelColIndex(n2);
                    oscarBlob = OscarBlob.createForTable(this.getConnection(), n3, n4);
                } else {
                    oscarBlob = ((OscarJdbc2Connection)this.connection).createBlob();
                }
            } else {
                oscarBlob = ((OscarJdbc2Connection)this.connection).createBlob();
            }
            oscarBlob.setBytes(1L, byArray);
            this.setObject(n2, (Object)oscarBlob, 2004);
            this.m_lobs[n2 - 1] = oscarBlob;
            return;
        }
        ((OscarStatement)this).setString(n2, OSCARbyte.toOSCARString(byArray), 24);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fetchMore(String object, String object2, int[] nArray, Object[] objectArray, int n2, int n3, boolean bl, boolean bl2, BaseStatement baseStatement, boolean bl3) throws SQLException {
        block11: {
            try {
                BaseStatement baseStatement2 = baseStatement;
                this.result = ((b)this.getDBConnection().getProtocol()).a((String)object, (String)object2, nArray, objectArray, null, n2, n3, bl, bl2, baseStatement2, (BaseResultSet)baseStatement2.getRealResultSet(), bl3, this.resultSetType);
                if (this.result != null && !this.cursorError || !this.m_statementIsCursor) break block11;
            }
            catch (SQLException sQLException) {
                try {
                    this.cursorError = true;
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    if ((this.result == null || this.cursorError) && this.m_statementIsCursor) {
                        try {
                            byte[] byArray = ((b)this.getDBConnection().getProtocol()).g();
                            object2 = byArray;
                            if (byArray != null) {
                                ((b)this.connection.getProtocol()).a(null, null, null, null, (byte[])object2, n2, 0, true, false, this, false);
                            }
                        }
                        catch (Exception exception) {
                            object2 = exception;
                            Driver.writeLog(exception);
                        }
                    }
                    this.cursorError = false;
                    ((b)this.connection.getProtocol()).b((byte[])null);
                    throw throwable;
                }
            }
            try {
                byte[] byArray = ((b)this.getDBConnection().getProtocol()).g();
                object = byArray;
                if (byArray != null) {
                    ((b)this.connection.getProtocol()).a(null, null, null, null, (byte[])object, n2, 0, true, false, this, false);
                }
            }
            catch (Exception exception) {
                object = exception;
                Driver.writeLog(exception);
            }
        }
        this.cursorError = false;
        ((b)this.connection.getProtocol()).b((byte[])null);
    }

    protected void markPrepared(boolean bl) {
        if (this.isPrepared == null) {
            this.isPrepared = bl;
            return;
        }
        if (bl) {
            this.isPrepared = bl;
        }
    }

    protected boolean isMarkPrepared() {
        return this.isPrepared != null && this.isPrepared != false;
    }

    protected String vaildTimeTz(String string) {
        return string;
    }
}

