/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.util.OSQLException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class OscarStringClob
implements Clob {
    private String content;
    private boolean free = false;

    public OscarStringClob(String string) {
        this.content = string;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.checkFree();
        if (this.content != null) {
            return new ByteArrayInputStream(this.content.getBytes());
        }
        return null;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkFree();
        if (this.content != null) {
            return new StringReader(this.content);
        }
        return null;
    }

    @Override
    public long length() throws SQLException {
        this.checkFree();
        return this.content.length();
    }

    public String toString() {
        return this.content;
    }

    public int getBufferSize() throws SQLException {
        return this.content.length();
    }

    public byte[] getDataInternal(long l2, int n2) throws SQLException {
        int n3 = (int)l2;
        return this.content.substring(n3 - 1, n3 - 1 + n2).getBytes();
    }

    @Override
    public String getSubString(long l2, int n2) throws SQLException {
        if (l2 < 1L) {
            throw new SQLException("CLOB start position can not be < 1");
        }
        int n3 = (int)l2 - 1;
        int n4 = n3 + n2;
        if (this.content != null) {
            if (n4 > this.content.length()) {
                throw new SQLException("Starting position for search is past end of CLOB");
            }
            return this.content.substring(n3, n4);
        }
        return null;
    }

    @Override
    public long position(String string, long l2) throws SQLException {
        if (l2 < 1L) {
            throw new SQLException("CLOB start position can not be < 1");
        }
        if (this.content != null) {
            if (l2 - 1L > (long)this.content.length()) {
                throw new SQLException("Starting position for search is past end of CLOB");
            }
            int n2 = this.content.indexOf(string, (int)(l2 - 1L));
            if (n2 == -1) {
                return -1L;
            }
            return n2 + 1;
        }
        return -1L;
    }

    @Override
    public long position(Clob clob, long l2) throws SQLException {
        return this.position(clob.getSubString(1L, (int)clob.length()), l2);
    }

    @Override
    public int setString(long l2, String string) throws SQLException {
        this.checkFree();
        if (l2 < 1L) {
            throw new SQLException("CLOB start position can not be < 1");
        }
        if (string == null) {
            throw new SQLException("String to set can not be NULL");
        }
        StringBuilder stringBuilder = new StringBuilder(this.content);
        int n2 = string.length();
        stringBuilder.replace((int)(--l2), (int)(l2 + (long)n2), string);
        this.content = stringBuilder.toString();
        return n2;
    }

    @Override
    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        this.checkFree();
        if (l2 < 1L) {
            throw new SQLException("CLOB start position can not be < 1");
        }
        if (string == null) {
            throw new SQLException("String to set can not be NULL");
        }
        StringBuilder stringBuilder = new StringBuilder(this.content);
        int n4 = n2;
        string = string.substring(n4, n4 + n3);
        stringBuilder.replace((int)(--l2), (int)(l2 + (long)string.length()), string);
        this.content = stringBuilder.toString();
        return n3;
    }

    @Override
    public OutputStream setAsciiStream(long l2) throws SQLException {
        this.checkFree();
        if (l2 < 1L) {
            throw new SQLException("CLOB start position can not be < 1");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.content.getBytes(), 0, (int)(l2 - 1L));
        return byteArrayOutputStream;
    }

    @Override
    public Writer setCharacterStream(long l2) throws SQLException {
        this.checkFree();
        if (l2 < 1L) {
            throw new SQLException("CLOB start position can not be < 1");
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        if (l2 > 1L) {
            charArrayWriter.write(this.content, 0, (int)(l2 - 1L));
        }
        return charArrayWriter;
    }

    @Override
    public void truncate(long l2) throws SQLException {
        if (l2 > (long)this.content.length()) {
            throw new SQLException("Cannot truncate CLOB of length " + this.content.length() + " to length of " + l2);
        }
        this.content = this.content.substring(0, (int)l2);
    }

    @Override
    public void free() throws SQLException {
        this.content = null;
        this.free = true;
    }

    private void checkFree() throws OSQLException {
        if (this.free) {
            throw new OSQLException("OSCAR-00512", "88888", 512);
        }
    }

    @Override
    public Reader getCharacterStream(long l2, long l3) throws SQLException {
        this.checkFree();
        if (this.content != null) {
            return new StringReader(this.getSubString(l2, (int)l3));
        }
        return null;
    }
}

