/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.Field;
import com.oscar.jdbc.OscarArray;
import com.oscar.util.OSQLException;
import com.oscar.util.TypeConverter;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;

public class ResultArray
extends OscarArray {
    private BaseConnection conn = null;
    private Field field = null;
    protected OscarArrayList arrayList;
    private Calendar localCalendar;

    public ResultArray(BaseConnection baseConnection, int n2, Field field, BaseResultSet baseResultSet) throws SQLException {
        this.conn = baseConnection;
        this.field = field;
        this.rawString = baseResultSet.getString(n2);
        this.localCalendar = baseConnection.getCalendar();
    }

    @Override
    public Object getArray() throws SQLException {
        return ((OscarArray)this).getArray(1L, 0, null);
    }

    @Override
    public Object getArray(long l2, int n2) throws SQLException {
        return ((OscarArray)this).getArray(l2, n2, null);
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.conn.getSQLType(((OscarArray)this).getBaseTypeName());
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        String string = this.field.getDBType();
        if (string.charAt(0) == '_') {
            string = string.substring(1);
        }
        return string;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return ((OscarArray)this).getResultSet(1L, 0, null);
    }

    @Override
    public ResultSet getResultSet(long l2, int n2) throws SQLException {
        return ((OscarArray)this).getResultSet(l2, n2, null);
    }

    @Override
    public void free() throws SQLException {
        this.field = null;
        this.rawString = null;
        this.free = true;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return ((OscarArray)this).getArray(1L, 0, map);
    }

    @Override
    public Object getArray(long l2, int n2, Map<String, Class<?>> map) throws SQLException {
        this.checkFree();
        if (map != null) {
            throw Driver.notImplemented();
        }
        if (l2 < 1L) {
            throw new OSQLException("OSCAR-00304", "88888", 304);
        }
        this.buildArrayList();
        if (n2 == 0) {
            n2 = this.arrayList.size();
        }
        if (--l2 + (long)n2 > (long)this.arrayList.size()) {
            throw new OSQLException("OSCAR-00304", "888880", 304);
        }
        ResultArray resultArray = this;
        return resultArray.buildArray(resultArray.arrayList, (int)l2, n2);
    }

    private synchronized void buildArrayList() throws SQLException {
        if (this.arrayList != null) {
            return;
        }
        this.arrayList = new OscarArrayList();
        if (this.rawString != null) {
            char[] cArray = this.rawString.toCharArray();
            Object object = null;
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            OscarArrayList oscarArrayList = this.arrayList;
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                if (cArray[i2] == '\\') {
                    ++i2;
                } else {
                    if (!bl && cArray[i2] == '{') {
                        if (arrayList.isEmpty()) {
                            arrayList.add(this.arrayList);
                        } else {
                            object = new OscarArrayList();
                            ArrayList<Object> arrayList2 = arrayList;
                            oscarArrayList = (OscarArrayList)arrayList2.get(arrayList2.size() - 1);
                            oscarArrayList.add(object);
                            arrayList.add(object);
                        }
                        ArrayList<Object> arrayList3 = arrayList;
                        oscarArrayList = (OscarArrayList)arrayList3.get(arrayList3.size() - 1);
                        for (int i3 = i2 + 1; i3 < cArray.length; ++i3) {
                            if (Character.isWhitespace(cArray[i3])) continue;
                            if (cArray[i3] != '{') break;
                            ++oscarArrayList.dimensionsCount;
                        }
                        object = new StringBuilder();
                        continue;
                    }
                    if (cArray[i2] == '\"') {
                        bl = !bl;
                        bl2 = true;
                        continue;
                    }
                    if (!bl && Character.isWhitespace(cArray[i2])) continue;
                    if (!bl && (cArray[i2] == '}' || cArray[i2] == '}' || cArray[i2] == ',') || i2 == cArray.length - 1) {
                        if (cArray[i2] != '\"' && cArray[i2] != '}' && cArray[i2] != '}' && object != null && cArray[i2] != ',') {
                            ((StringBuilder)object).append(cArray[i2]);
                        }
                        if ((object = object == null ? null : ((StringBuilder)object).toString()) != null && (((String)object).length() > 0 || bl2)) {
                            oscarArrayList.add(!bl2 && ((String)object).equals("NULL") ? null : object);
                        }
                        bl2 = false;
                        object = new StringBuilder();
                        if (cArray[i2] != '}') continue;
                        ArrayList<Object> arrayList4 = arrayList;
                        arrayList4.remove(arrayList4.size() - 1);
                        if (!arrayList.isEmpty()) {
                            ArrayList<Object> arrayList5 = arrayList;
                            oscarArrayList = (OscarArrayList)arrayList5.get(arrayList5.size() - 1);
                        }
                        object = null;
                        continue;
                    }
                }
                if (object == null) continue;
                ((StringBuilder)object).append(cArray[i2]);
            }
        }
    }

    private Object buildArray(OscarArrayList oscarArrayList, int n2, int n3) throws SQLException {
        int n4;
        int n5;
        Object[] objectArray;
        if (n3 < 0) {
            n3 = oscarArrayList.size();
        }
        int[] nArray = objectArray = (n5 = oscarArrayList.dimensionsCount) > 1 ? new int[n5] : null;
        if (n5 > 1) {
            for (n4 = 0; n4 < n5; ++n4) {
                int n6 = n4;
                objectArray[n6] = n6 == 0 ? n3 : 0;
            }
        }
        n4 = 0;
        switch (((OscarArray)this).getBaseType()) {
            case 16: {
                Boolean[] booleanArray = null;
                Object[] objectArray2 = null;
                if (n5 > 1) {
                    objectArray2 = (Object[])Array.newInstance(Boolean.class, objectArray);
                    objectArray = objectArray2;
                } else {
                    booleanArray = new Boolean[n3];
                    objectArray = booleanArray;
                }
                while (n3 > 0) {
                    Object e2 = oscarArrayList.get(n2++);
                    if (n5 > 1) {
                        objectArray2[n4++] = e2 == null ? null : this.buildArray((OscarArrayList)e2, 0, -1);
                    } else {
                        booleanArray[n4++] = e2 == null ? false : TypeConverter.toBoolean((String)e2, -7);
                    }
                    --n3;
                }
                break;
            }
            case 4: 
            case 5: {
                Integer[] integerArray = null;
                Object[] objectArray3 = null;
                if (n5 > 1) {
                    objectArray3 = (Object[])Array.newInstance(Integer.class, objectArray);
                    objectArray = objectArray3;
                } else {
                    integerArray = new Integer[n3];
                    objectArray = integerArray;
                }
                while (n3 > 0) {
                    Object e3 = oscarArrayList.get(n2++);
                    if (n5 > 1) {
                        objectArray3[n4++] = e3 == null ? null : this.buildArray((OscarArrayList)e3, 0, -1);
                    } else {
                        integerArray[n4++] = e3 == null ? 0 : TypeConverter.toInt((String)e3, 4);
                    }
                    --n3;
                }
                break;
            }
            case -5: {
                Long[] longArray = null;
                Object[] objectArray4 = null;
                if (n5 > 1) {
                    objectArray4 = (Object[])Array.newInstance(Long.class, objectArray);
                    objectArray = objectArray4;
                } else {
                    longArray = new Long[n3];
                    objectArray = longArray;
                }
                while (n3 > 0) {
                    Object e4 = oscarArrayList.get(n2++);
                    if (n5 > 1) {
                        objectArray4[n4++] = e4 == null ? null : this.buildArray((OscarArrayList)e4, 0, -1);
                    } else {
                        longArray[n4++] = e4 == null ? 0L : TypeConverter.toLong((String)e4, -5);
                    }
                    --n3;
                }
                break;
            }
            case 2: 
            case 3: {
                BigDecimal[] bigDecimalArray = n5 > 1 ? (Object[])Array.newInstance(BigDecimal.class, objectArray) : new BigDecimal[n3];
                objectArray = bigDecimalArray;
                while (n3 > 0) {
                    Object e5 = oscarArrayList.get(n2++);
                    bigDecimalArray[n4++] = n5 > 1 && e5 != null ? this.buildArray((OscarArrayList)e5, 0, -1) : (e5 == null ? null : TypeConverter.toBigDecimal((String)e5, 2));
                    --n3;
                }
                break;
            }
            case 7: {
                Float[] floatArray = null;
                Object[] objectArray5 = null;
                if (n5 > 1) {
                    objectArray5 = (Object[])Array.newInstance(Float.class, objectArray);
                    objectArray = objectArray5;
                } else {
                    floatArray = new Float[n3];
                    objectArray = floatArray;
                }
                while (n3 > 0) {
                    Object e6 = oscarArrayList.get(n2++);
                    if (n5 > 1) {
                        objectArray5[n4++] = e6 == null ? null : this.buildArray((OscarArrayList)e6, 0, -1);
                    } else {
                        floatArray[n4++] = Float.valueOf(e6 == null ? 0.0f : TypeConverter.toFloat((String)e6, 7));
                    }
                    --n3;
                }
                break;
            }
            case 8: {
                Double[] doubleArray = null;
                Object[] objectArray6 = null;
                if (n5 > 1) {
                    objectArray6 = (Object[])Array.newInstance(Double.class, objectArray);
                    objectArray = objectArray6;
                } else {
                    doubleArray = new Double[n3];
                    objectArray = doubleArray;
                }
                while (n3 > 0) {
                    Object e7 = oscarArrayList.get(n2++);
                    if (n5 > 1) {
                        objectArray6[n4++] = e7 == null ? null : this.buildArray((OscarArrayList)e7, 0, -1);
                    } else {
                        doubleArray[n4++] = e7 == null ? 0.0 : TypeConverter.toDouble((String)e7, 8);
                    }
                    --n3;
                }
                break;
            }
            case -7: 
            case -1: 
            case 1: 
            case 12: {
                String[] stringArray = n5 > 1 ? (Object[])Array.newInstance(String.class, objectArray) : new String[n3];
                objectArray = stringArray;
                while (n3 > 0) {
                    Object e8 = oscarArrayList.get(n2++);
                    stringArray[n4++] = n5 > 1 && e8 != null ? this.buildArray((OscarArrayList)e8, 0, -1) : e8;
                    --n3;
                }
                break;
            }
            case 91: {
                Date[] dateArray = n5 > 1 ? (Object[])Array.newInstance(Date.class, objectArray) : new Date[n3];
                objectArray = dateArray;
                while (n3 > 0) {
                    Object e9 = oscarArrayList.get(n2++);
                    dateArray[n4++] = n5 > 1 && e9 != null ? this.buildArray((OscarArrayList)e9, 0, -1) : (e9 == null ? null : TypeConverter.toDate((String)e9, 91));
                    --n3;
                }
                break;
            }
            case 92: {
                Time[] timeArray = n5 > 1 ? (Object[])Array.newInstance(Time.class, objectArray) : new Time[n3];
                objectArray = timeArray;
                while (n3 > 0) {
                    Object e10 = oscarArrayList.get(n2++);
                    timeArray[n4++] = n5 > 1 && e10 != null ? this.buildArray((OscarArrayList)e10, 0, -1) : (e10 == null ? null : TypeConverter.toTime((String)e10, 92, this.localCalendar));
                    --n3;
                }
                break;
            }
            case 93: {
                Timestamp[] timestampArray = n5 > 1 ? (Object[])Array.newInstance(Timestamp.class, objectArray) : new Timestamp[n3];
                objectArray = timestampArray;
                while (n3 > 0) {
                    Object e11 = oscarArrayList.get(n2++);
                    timestampArray[n4++] = n5 > 1 && e11 != null ? this.buildArray((OscarArrayList)e11, 0, -1) : (e11 == null ? null : TypeConverter.toTimestamp((String)e11, 93, this.localCalendar));
                    --n3;
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        return objectArray;
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return ((OscarArray)this).getResultSet(1L, 0, map);
    }

    @Override
    public ResultSet getResultSet(long l2, int n2, Map<String, Class<?>> map) throws SQLException {
        ResultSet resultSet;
        this.checkFree();
        if (this.conn.getProtocolVersion().getProtocolType() >= 2) {
            ResultArray resultArray = this;
            resultSet = resultArray.getResultSetV2(resultArray.conn, l2, n2, map);
        } else {
            ResultArray resultArray = this;
            resultSet = resultArray.getResultSetV1(resultArray.conn, l2, n2, map);
        }
        return resultSet;
    }

    private static class OscarArrayList
    extends ArrayList<Object> {
        private static final long serialVersionUID = 2052783752654562677L;
        int dimensionsCount = 1;

        private OscarArrayList() {
        }
    }
}

