/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class SingleByteCharsetConverter {
    private static final int BYTE_RANGE = 256;
    private static byte[] allBytes;
    private static final Map CONVERTER_MAP;
    private static final byte[] EMPTY_BYTE_ARRAY;
    private static byte[] unknownCharsMap;
    private char[] byteToChars = new char[256];
    private byte[] charToByteMap = new byte[65536];

    public static synchronized SingleByteCharsetConverter getInstance(String string) throws UnsupportedEncodingException, SQLException {
        SingleByteCharsetConverter singleByteCharsetConverter = (SingleByteCharsetConverter)CONVERTER_MAP.get(string);
        if (singleByteCharsetConverter == null) {
            singleByteCharsetConverter = SingleByteCharsetConverter.initCharset(string);
        }
        return singleByteCharsetConverter;
    }

    public static SingleByteCharsetConverter initCharset(String string) throws UnsupportedEncodingException, SQLException {
        SingleByteCharsetConverter singleByteCharsetConverter = new SingleByteCharsetConverter(string);
        CONVERTER_MAP.put(string, singleByteCharsetConverter);
        return singleByteCharsetConverter;
    }

    public static String toStringDefaultEncoding(byte[] byArray, int n2, int n3) {
        return new String(byArray, n2, n3);
    }

    private SingleByteCharsetConverter(String string) throws UnsupportedEncodingException {
        string = new String(allBytes, 0, 256, string);
        int n2 = string.length();
        System.arraycopy(unknownCharsMap, 0, this.charToByteMap, 0, this.charToByteMap.length);
        for (int i2 = 0; i2 < 256 && i2 < n2; ++i2) {
            char c2;
            this.byteToChars[i2] = c2 = string.charAt(i2);
            this.charToByteMap[c2] = allBytes[i2];
        }
    }

    public final byte[] toBytes(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        int n2 = cArray.length;
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = this.charToByteMap[cArray[i2]];
        }
        return byArray;
    }

    public final byte[] toBytesWrapped(char[] cArray, char c2, char c3) {
        if (cArray == null) {
            return null;
        }
        int n2 = cArray.length + 2;
        int n3 = cArray.length;
        byte[] byArray = new byte[n2];
        byte[] byArray2 = byArray;
        byArray[0] = this.charToByteMap[c2];
        for (c2 = '\u0000'; c2 < n3; c2 = (char)(c2 + 1)) {
            byArray2[c2 + '\u0001'] = this.charToByteMap[cArray[c2]];
        }
        byArray2[n2 - 1] = this.charToByteMap[c3];
        return byArray2;
    }

    public final byte[] toBytes(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            return null;
        }
        if (n3 == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[i2] = this.charToByteMap[cArray[i2 + n2]];
        }
        return byArray;
    }

    public final byte[] toBytes(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = this.charToByteMap[string.charAt(i2)];
        }
        return byArray;
    }

    public final byte[] toBytesWrapped(String string, char c2, char c3) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        int n3 = n2 + 2;
        byte[] byArray = new byte[n3];
        byte[] byArray2 = byArray;
        byArray[0] = this.charToByteMap[c2];
        for (c2 = '\u0000'; c2 < n2; c2 = (char)(c2 + 1)) {
            byArray2[c2 + '\u0001'] = this.charToByteMap[string.charAt(c2)];
        }
        byArray2[n3 - 1] = this.charToByteMap[c3];
        return byArray2;
    }

    public final byte[] toBytes(String string, int n2, int n3) {
        if (string == null) {
            return null;
        }
        if (n3 == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2 + n2);
            byArray[i2] = this.charToByteMap[c2];
        }
        return byArray;
    }

    public final String toString(byte[] byArray) {
        return this.toString(byArray, 0, byArray.length);
    }

    public final String toString(byte[] byArray, int n2, int n3) {
        char[] cArray = new char[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            cArray[i2] = this.byteToChars[byArray[n2] - -128];
            ++n2;
        }
        return new String(cArray);
    }

    static {
        int n2;
        allBytes = new byte[256];
        CONVERTER_MAP = new HashMap();
        EMPTY_BYTE_ARRAY = new byte[0];
        unknownCharsMap = new byte[65536];
        for (n2 = -128; n2 <= 127; ++n2) {
            SingleByteCharsetConverter.allBytes[n2 - -128] = (byte)n2;
        }
        for (n2 = 0; n2 < unknownCharsMap.length; ++n2) {
            SingleByteCharsetConverter.unknownCharsMap[n2] = 63;
        }
    }
}

