/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.jdbc.SingleByteCharsetConverter;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class StringUtils {
    private static final int BYTE_RANGE = 256;
    private static byte[] allBytes = new byte[256];
    private static char[] byteToChars = new char[256];
    private static Method toPlainStringMethod;
    static final int WILD_COMPARE_MATCH_NO_WILD = 0;
    static final int WILD_COMPARE_MATCH_WITH_WILD = 1;
    static final int WILD_COMPARE_NO_MATCH = -1;

    public static String consistentToString(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        if (toPlainStringMethod != null) {
            try {
                return (String)toPlainStringMethod.invoke((Object)bigDecimal, new Object[]{null});
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return bigDecimal.toString();
    }

    public static final String dumpAsHex(byte[] byArray, int n2) {
        int n3;
        int n4;
        StringBuffer stringBuffer = new StringBuffer(n2 << 2);
        int n5 = 0;
        int n6 = n2 / 8;
        for (n4 = 0; n4 < n6 && n5 < n2; ++n4) {
            int n7;
            n3 = n5;
            for (n7 = 0; n7 < 8; ++n7) {
                String string = Integer.toHexString(byArray[n3] & 0xFF);
                if (string.length() == 1) {
                    string = "0" + string;
                }
                stringBuffer.append(string + " ");
                ++n3;
            }
            stringBuffer.append("    ");
            for (n7 = 0; n7 < 8; ++n7) {
                int n8 = 0xFF & byArray[n5];
                if (n8 > 32 && n8 < 127) {
                    stringBuffer.append((char)n8 + " ");
                } else {
                    stringBuffer.append(". ");
                }
                ++n5;
            }
            stringBuffer.append("\n");
        }
        n4 = 0;
        for (n3 = n5; n3 < n2; ++n3) {
            String string = Integer.toHexString(byArray[n3] & 0xFF);
            if (string.length() == 1) {
                string = "0" + string;
            }
            stringBuffer.append(string + " ");
            ++n4;
        }
        for (n3 = n4; n3 < 8; ++n3) {
            stringBuffer.append("   ");
        }
        stringBuffer.append("    ");
        for (n3 = n5; n3 < n2; ++n3) {
            int n9 = 0xFF & byArray[n3];
            if (n9 > 32 && n9 < 127) {
                stringBuffer.append((char)n9 + " ");
                continue;
            }
            stringBuffer.append(". ");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private static boolean endsWith(byte[] byArray, String string) {
        for (int i2 = 1; i2 <= string.length(); ++i2) {
            int n2 = byArray.length - i2;
            int n3 = string.length() - i2;
            if (byArray[n2] == string.charAt(n3)) continue;
            return false;
        }
        return true;
    }

    public static byte[] escapeEasternUnicodeByteStream(byte[] byArray, String string, int n2, int n3) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        n2 = byArray.length;
        n3 = 0;
        int n4 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        while (true) {
            if (string.charAt(n4) == '\\') {
                byteArrayOutputStream.write(byArray[n3++]);
            } else {
                int n5 = byArray[n3];
                if (n5 < 0) {
                    n5 += 256;
                }
                byteArrayOutputStream.write(n5);
                if (n5 >= 128) {
                    if (n3 < n2 - 1) {
                        n5 = byArray[n3 + 1];
                        if (n5 < 0) {
                            n5 += 256;
                        }
                        byteArrayOutputStream.write(n5);
                        ++n3;
                        if (n5 == 92) {
                            byteArrayOutputStream.write(n5);
                        }
                    }
                } else if (n5 == 92 && n3 < n2 - 1) {
                    n5 = byArray[n3 + 1];
                    if (n5 < 0) {
                        n5 += 256;
                    }
                    if (n5 == 98) {
                        byteArrayOutputStream.write(92);
                        byteArrayOutputStream.write(98);
                        ++n3;
                    }
                }
                ++n3;
            }
            if (n3 >= n2) break;
            ++n4;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static char firstNonWsCharUc(String string) {
        return StringUtils.firstNonWsCharUc(string, 0);
    }

    public static char firstNonWsCharUc(String string, int n2) {
        if (string == null) {
            return '\u0000';
        }
        int n3 = string.length();
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            if (!Character.isWhitespace(c2)) {
                return Character.toUpperCase(c2);
            }
            ++n2;
        }
        return '\u0000';
    }

    public static char firstAlphaCharUc(String string, int n2) {
        if (string == null) {
            return '\u0000';
        }
        int n3 = string.length();
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            if (Character.isLetter(c2)) {
                return Character.toUpperCase(c2);
            }
            ++n2;
        }
        return '\u0000';
    }

    public static final String fixDecimalExponent(String string) {
        char c2;
        int n2 = string.indexOf("E");
        if (n2 == -1) {
            n2 = string.indexOf("e");
        }
        if (n2 != -1 && string.length() > n2 + 1 && (c2 = string.charAt(n2 + 1)) != '-' && c2 != '+') {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 1);
            stringBuffer.append(string.substring(0, n2 + 1));
            stringBuffer.append('+');
            stringBuffer.append(string.substring(n2 + 1, string.length()));
            string = stringBuffer.toString();
        }
        return string;
    }

    public static final byte[] getBytes(char[] object, SingleByteCharsetConverter singleByteCharsetConverter, String string, String string2, boolean bl) throws SQLException {
        byte[] byArray = null;
        try {
            if (singleByteCharsetConverter != null) {
                byArray = singleByteCharsetConverter.toBytes((char[])object);
            } else if (string == null) {
                byArray = new String((char[])object).getBytes();
            } else {
                String string3 = new String((char[])object);
                object = string3;
                byArray = string3.getBytes(string);
                if (!bl && (string.equalsIgnoreCase("SJIS") || string.equalsIgnoreCase("BIG5") || string.equalsIgnoreCase("GBK")) && !string.equalsIgnoreCase(string2)) {
                    byArray = StringUtils.escapeEasternUnicodeByteStream(byArray, (String)object, 0, ((String)object).length());
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return byArray;
    }

    public static final byte[] getBytes(char[] object, SingleByteCharsetConverter object2, String string, String string2, int n2, int n3, boolean bl) throws SQLException {
        byte[] byArray = null;
        try {
            if (object2 != null) {
                byArray = ((SingleByteCharsetConverter)object2).toBytes((char[])object, n2, n3);
            } else if (string == null) {
                byte[] byArray2 = new String((char[])object, n2, n3).getBytes();
                object = byArray2;
                n3 = byArray2.length;
                byArray = new byte[n3];
                System.arraycopy(object, 0, byArray, 0, n3);
            } else {
                String string3 = new String((char[])object, n2, n3);
                object = string3;
                byte[] byArray3 = string3.getBytes(string);
                object2 = byArray3;
                n3 = byArray3.length;
                byArray = new byte[n3];
                System.arraycopy(object2, 0, byArray, 0, n3);
                if (!bl && (string.equalsIgnoreCase("SJIS") || string.equalsIgnoreCase("BIG5") || string.equalsIgnoreCase("GBK")) && !string.equalsIgnoreCase(string2)) {
                    byArray = StringUtils.escapeEasternUnicodeByteStream(byArray, (String)object, n2, n3);
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return byArray;
    }

    public static final byte[] getBytes(char[] cArray, String string, String string2, boolean bl) throws SQLException {
        byte[] byArray = null;
        try {
            SingleByteCharsetConverter singleByteCharsetConverter = SingleByteCharsetConverter.getInstance(string);
            byArray = StringUtils.getBytes(cArray, singleByteCharsetConverter, string, string2, bl);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return byArray;
    }

    public static final byte[] getBytes(String string, SingleByteCharsetConverter singleByteCharsetConverter, String string2, String string3, boolean bl) throws SQLException {
        byte[] byArray = null;
        try {
            if (singleByteCharsetConverter != null) {
                byArray = singleByteCharsetConverter.toBytes(string);
            } else if (string2 == null) {
                byArray = string.getBytes();
            } else {
                byArray = string.getBytes(string2);
                if (!bl && (string2.equalsIgnoreCase("SJIS") || string2.equalsIgnoreCase("BIG5") || string2.equalsIgnoreCase("GBK")) && !string2.equalsIgnoreCase(string3)) {
                    byArray = StringUtils.escapeEasternUnicodeByteStream(byArray, string, 0, string.length());
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return byArray;
    }

    public static final byte[] getBytesWrapped(String string, char c2, char c3, SingleByteCharsetConverter object, String string2, String string3, boolean bl) throws SQLException {
        byte[] byArray = null;
        try {
            if (object != null) {
                byArray = ((SingleByteCharsetConverter)object).toBytesWrapped(string, c2, c3);
            } else if (string2 == null) {
                object = new StringBuffer(string.length() + 2);
                ((StringBuffer)object).append(c2);
                ((StringBuffer)object).append(string);
                ((StringBuffer)object).append(c3);
                byArray = ((StringBuffer)object).toString().getBytes();
            } else {
                object = new StringBuffer(string.length() + 2);
                ((StringBuffer)object).append(c2);
                ((StringBuffer)object).append(string);
                ((StringBuffer)object).append(c3);
                byArray = ((StringBuffer)object).toString().getBytes(string2);
                if (!bl && (string2.equalsIgnoreCase("SJIS") || string2.equalsIgnoreCase("BIG5") || string2.equalsIgnoreCase("GBK")) && !string2.equalsIgnoreCase(string3)) {
                    byArray = StringUtils.escapeEasternUnicodeByteStream(byArray, string, 0, string.length());
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return byArray;
    }

    public static final byte[] getBytes(String string, SingleByteCharsetConverter object, String string2, String string3, int n2, int n3, boolean bl) throws SQLException {
        byte[] byArray = null;
        try {
            if (object != null) {
                byArray = ((SingleByteCharsetConverter)object).toBytes(string, n2, n3);
            } else if (string2 == null) {
                int n4 = n2;
                byte[] byArray2 = string.substring(n4, n4 + n3).getBytes();
                object = byArray2;
                n3 = byArray2.length;
                byArray = new byte[n3];
                System.arraycopy(object, 0, byArray, 0, n3);
            } else {
                int n5 = n2;
                byte[] byArray3 = string.substring(n5, n5 + n3).getBytes(string2);
                object = byArray3;
                n3 = byArray3.length;
                byArray = new byte[n3];
                System.arraycopy(object, 0, byArray, 0, n3);
                if (!bl && (string2.equalsIgnoreCase("SJIS") || string2.equalsIgnoreCase("BIG5") || string2.equalsIgnoreCase("GBK")) && !string2.equalsIgnoreCase(string3)) {
                    byArray = StringUtils.escapeEasternUnicodeByteStream(byArray, string, n2, n3);
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return byArray;
    }

    public static final byte[] getBytes(String string, String string2, String string3, boolean bl) throws SQLException {
        byte[] byArray = null;
        try {
            SingleByteCharsetConverter singleByteCharsetConverter = SingleByteCharsetConverter.getInstance(string2);
            byArray = StringUtils.getBytes(string, singleByteCharsetConverter, string2, string3, bl);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return byArray;
    }

    public static int getInt(byte[] byArray, int n2, int n3) throws NumberFormatException {
        while (Character.isWhitespace((char)byArray[n2]) && n2 < n3) {
            ++n2;
        }
        if (n2 == n3) {
            throw new NumberFormatException(new String(byArray));
        }
        boolean bl = false;
        if ((char)byArray[n2] == '-') {
            bl = true;
            ++n2;
        } else if ((char)byArray[n2] == '+') {
            ++n2;
        }
        int n4 = n2;
        int cfr_ignored_0 = Integer.MAX_VALUE / 10;
        int n5 = Integer.MAX_VALUE % 10;
        if (bl) {
            ++n5;
        }
        boolean bl2 = false;
        int n6 = 0;
        while (n2 < n3) {
            char c2 = (char)byArray[n2];
            if (Character.isDigit(c2)) {
                c2 = (char)(c2 - 48);
            } else {
                if (!Character.isLetter(c2)) break;
                c2 = (char)(Character.toUpperCase(c2) - 65 + 10);
            }
            if (c2 >= '\n') break;
            if (n6 > 0xCCCCCCC || n6 == 0xCCCCCCC && c2 > n5) {
                bl2 = true;
            } else {
                n6 *= 10;
                n6 += c2;
            }
            ++n2;
        }
        if (n2 == n4) {
            throw new NumberFormatException(new String(byArray));
        }
        if (bl2) {
            throw new NumberFormatException(new String(byArray));
        }
        if (bl) {
            return -n6;
        }
        return n6;
    }

    public static int getInt(byte[] byArray) throws NumberFormatException {
        return StringUtils.getInt(byArray, 0, byArray.length);
    }

    public static long getLong(byte[] byArray) throws NumberFormatException {
        return StringUtils.getLong(byArray, 0, byArray.length);
    }

    public static long getLong(byte[] byArray, int n2, int n3) throws NumberFormatException {
        while (Character.isWhitespace((char)byArray[n2]) && n2 < n3) {
            ++n2;
        }
        if (n2 == n3) {
            throw new NumberFormatException(new String(byArray));
        }
        boolean bl = false;
        if ((char)byArray[n2] == '-') {
            bl = true;
            ++n2;
        } else if ((char)byArray[n2] == '+') {
            ++n2;
        }
        int n4 = n2;
        long cfr_ignored_0 = Long.MAX_VALUE / 10L;
        long cfr_ignored_1 = Long.MAX_VALUE % 10L;
        long l2 = 7L;
        if (bl) {
            l2 = 8L;
        }
        boolean bl2 = false;
        long l3 = 0L;
        while (n2 < n3) {
            char c2 = (char)byArray[n2];
            if (Character.isDigit(c2)) {
                c2 = (char)(c2 - 48);
            } else {
                if (!Character.isLetter(c2)) break;
                c2 = (char)(Character.toUpperCase(c2) - 65 + 10);
            }
            if (c2 >= '\n') break;
            if (l3 > 0xCCCCCCCCCCCCCCCL || l3 == 0xCCCCCCCCCCCCCCCL && (long)c2 > l2) {
                bl2 = true;
            } else {
                l3 *= 10L;
                l3 += (long)c2;
            }
            ++n2;
        }
        if (n2 == n4) {
            throw new NumberFormatException(new String(byArray));
        }
        if (bl2) {
            throw new NumberFormatException(new String(byArray));
        }
        if (bl) {
            return -l3;
        }
        return l3;
    }

    public static short getShort(byte[] byArray) throws NumberFormatException {
        int n2;
        for (n2 = 0; Character.isWhitespace((char)byArray[n2]) && n2 < byArray.length; ++n2) {
        }
        if (n2 == byArray.length) {
            throw new NumberFormatException(new String(byArray));
        }
        boolean bl = false;
        if ((char)byArray[n2] == '-') {
            bl = true;
            ++n2;
        } else if ((char)byArray[n2] == '+') {
            ++n2;
        }
        int n3 = n2;
        int cfr_ignored_0 = Short.MAX_VALUE / 10;
        int cfr_ignored_1 = Short.MAX_VALUE % 10;
        char c2 = '\u0007';
        if (bl) {
            c2 = '\b';
        }
        boolean bl2 = false;
        short s2 = 0;
        while (n2 < byArray.length) {
            char c3 = (char)byArray[n2];
            if (Character.isDigit(c3)) {
                c3 = (char)(c3 - 48);
            } else {
                if (!Character.isLetter(c3)) break;
                c3 = (char)(Character.toUpperCase(c3) - 65 + 10);
            }
            if (c3 >= '\n') break;
            if (s2 > 3276 || s2 == 3276 && c3 > c2) {
                bl2 = true;
            } else {
                s2 = (short)(s2 * 10);
                s2 = (short)(s2 + c3);
            }
            ++n2;
        }
        if (n2 == n3) {
            throw new NumberFormatException(new String(byArray));
        }
        if (bl2) {
            throw new NumberFormatException(new String(byArray));
        }
        if (bl) {
            return (short)(-s2);
        }
        return s2;
    }

    public static final int indexOfIgnoreCase(int n2, String string, String string2) {
        if (string == null || string2 == null || n2 > string.length()) {
            return -1;
        }
        int n3 = string2.length();
        int n4 = string.length();
        n4 -= n3;
        if (n3 == 0) {
            return -1;
        }
        int n5 = Character.toUpperCase(string2.charAt(0));
        int n6 = Character.toLowerCase(string2.charAt(0));
        while (n2 < n4 && Character.toUpperCase(string.charAt(n2)) != n5 && Character.toLowerCase(string.charAt(n2)) != n6) {
            ++n2;
        }
        if (n2 > n4) {
            return -1;
        }
        n4 = n2 + 1;
        n3 = n4 + n3 - 1;
        n5 = 1;
        while (n4 < n3) {
            n6 = n4++;
            int n7 = n5++;
            if (Character.toUpperCase(string.charAt(n6)) != Character.toUpperCase(string2.charAt(n7))) {
                ++n2;
                break;
            }
            if (Character.toLowerCase(string.charAt(n6)) == Character.toLowerCase(string2.charAt(n7))) continue;
            ++n2;
            break;
        }
        return n2;
    }

    public static final int indexOfIgnoreCase(String string, String string2) {
        return StringUtils.indexOfIgnoreCase(0, string, string2);
    }

    public static int indexOfIgnoreCaseRespectMarker(int n2, String string, String string2, String string3, String string4, boolean bl) {
        char c2 = '\u0000';
        boolean bl2 = false;
        int n3 = 0;
        int n4 = string.length();
        for (int i2 = n2; i2 < n4; ++i2) {
            char c3 = string.charAt(i2);
            if (bl && c3 == '\\') {
                bl2 = !bl2;
                continue;
            }
            if (c3 == string4.charAt(n3) && !bl2) {
                c2 = '\u0000';
                continue;
            }
            n2 = string3.indexOf(c3);
            if (n2 != -1 && !bl2 && c2 == '\u0000') {
                n3 = n2;
                c2 = c3;
                continue;
            }
            if (c3 != string2.charAt(0) || bl2 || c2 != '\u0000' || StringUtils.indexOfIgnoreCase(i2, string, string2) == -1) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOfIgnoreCaseRespectQuotes(int n2, String string, String string2, char c2, boolean bl) {
        char c3 = '\u0000';
        boolean bl2 = false;
        int n3 = string.length();
        while (n2 < n3) {
            char c4 = string.charAt(n2);
            if (bl && c4 == '\\') {
                bl2 = !bl2;
            } else if (c4 == c3 && !bl2) {
                c3 = '\u0000';
            } else if (c4 == c2 && !bl2 && c3 == '\u0000') {
                c3 = c4;
            } else if ((Character.toUpperCase(c4) == Character.toUpperCase(string2.charAt(0)) || Character.toLowerCase(c4) == Character.toLowerCase(string2.charAt(0))) && !bl2 && c3 == '\u0000' && StringUtils.startsWithIgnoreCase(string, n2, string2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static final List split(String object, String object2, boolean bl) {
        if (object == null) {
            return new ArrayList();
        }
        if (object2 == null) {
            throw new IllegalArgumentException();
        }
        object = new StringTokenizer((String)object, (String)object2, false);
        object2 = new ArrayList(((StringTokenizer)object).countTokens());
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string = ((StringTokenizer)object).nextToken();
            if (bl) {
                string = string.trim();
            }
            object2.add(string);
        }
        return object2;
    }

    public static final List split(String string, String string2, String string3, String string4, boolean bl) {
        int n2;
        if (string == null) {
            return new ArrayList();
        }
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        int n3 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((n2 = StringUtils.indexOfIgnoreCaseRespectMarker(n3, string, string2, string3, string4, false)) != -1) {
            String string5 = string.substring(n3, n2);
            if (bl) {
                string5 = string5.trim();
            }
            arrayList.add(string5);
            n3 = n2 + 1;
        }
        if (n3 < string.length()) {
            String string6 = string.substring(n3);
            if (bl) {
                string6 = string6.trim();
            }
            arrayList.add(string6);
        }
        return arrayList;
    }

    private static boolean startsWith(byte[] byArray, String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (byArray[i2] == string.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(String string, int n2, String string2) {
        return string.regionMatches(true, n2, string2, 0, string2.length());
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        return StringUtils.startsWithIgnoreCase(string, 0, string2);
    }

    public static boolean startsWithIgnoreCaseAndNonAlphaNumeric(String string, String string2) {
        char c2;
        int n2;
        if (string == null) {
            return string2 == null;
        }
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && !Character.isLetterOrDigit(c2 = string.charAt(n2)); ++n2) {
        }
        return StringUtils.startsWithIgnoreCase(string, n2, string2);
    }

    public static boolean startsWithIgnoreCaseAndWs(String string, String string2) {
        return StringUtils.startsWithIgnoreCaseAndWs(string, string2, 0);
    }

    public static boolean startsWithIgnoreCaseAndWs(String string, String string2, int n2) {
        if (string == null) {
            return string2 == null;
        }
        int n3 = string.length();
        while (n2 < n3 && Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        return StringUtils.startsWithIgnoreCase(string, n2, string2);
    }

    public static byte[] stripEnclosure(byte[] byArray, String string, String string2) {
        if (byArray.length >= string.length() + string2.length() && StringUtils.startsWith(byArray, string) && StringUtils.endsWith(byArray, string2)) {
            int n2 = string.length() + string2.length();
            n2 = byArray.length - n2;
            byte[] byArray2 = new byte[n2];
            int n3 = string.length();
            int n4 = byArray2.length;
            System.arraycopy(byArray, n3, byArray2, 0, n4);
            return byArray2;
        }
        return byArray;
    }

    public static final String toAsciiString(byte[] byArray) {
        return StringUtils.toAsciiString(byArray, 0, byArray.length);
    }

    public static final String toAsciiString(byte[] byArray, int n2, int n3) {
        char[] cArray = new char[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            cArray[i2] = (char)byArray[n2];
            ++n2;
        }
        return new String(cArray);
    }

    public static int wildCompare(String string, String string2) {
        if (string == null || string2 == null) {
            return -1;
        }
        if (string2.equals("%")) {
            return 1;
        }
        int c2 = -1;
        int n2 = 0;
        int n3 = string2.length();
        int n4 = 0;
        int n5 = string.length();
        while (n2 != n3) {
            char c3;
            boolean bl;
            char c4 = string2.charAt(n2);
            while (string2.charAt(n2) != '%' && c4 != '_') {
                if (string2.charAt(n2) == '\\' && n2 + 1 != n3) {
                    ++n2;
                }
                if (n4 == n5 || Character.toUpperCase(string2.charAt(n2++)) != Character.toUpperCase(string.charAt(n4++))) {
                    return 1;
                }
                if (n2 == n3) {
                    if (n4 != n5) {
                        return 1;
                    }
                    return 0;
                }
                bl = true;
            }
            if (string2.charAt(n2) == '_') {
                do {
                    if (n4 == n5) {
                        return bl ? 1 : 0;
                    }
                    ++n4;
                } while (++n2 < n3 && string2.charAt(n2) == '_');
                if (n2 == n3) break;
            }
            if (string2.charAt(n2) != '%') continue;
            ++n2;
            while (n2 != n3) {
                if (string2.charAt(n2) != '%') {
                    if (string2.charAt(n2) != '_') break;
                    if (n4 == n5) {
                        return -1;
                    }
                    ++n4;
                }
                ++n2;
            }
            if (n2 == n3) {
                return 0;
            }
            if (n4 == n5) {
                return -1;
            }
            char c5 = string2.charAt(n2);
            if (c5 == '\\' && n2 + 1 != n3) {
                c3 = string2.charAt(++n2);
            }
            while (true) {
                if (n4 != n5 && Character.toUpperCase(string.charAt(n4)) != Character.toUpperCase(c3)) {
                    ++n4;
                    continue;
                }
                if (n4++ == n5) {
                    return -1;
                }
                n2 = StringUtils.wildCompare(string, string2);
                if (n2 <= 0) {
                    return n2;
                }
                if (n4 == n5 || string2.charAt(0) == '%') break;
            }
            return -1;
        }
        if (n4 != n5) {
            return 1;
        }
        return 0;
    }

    public static int lastIndexOf(byte[] byArray, char c2) {
        if (byArray == null) {
            return -1;
        }
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            if (byArray[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(byte[] byArray, char c2) {
        if (byArray == null) {
            return -1;
        }
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static final boolean isEmptyOrWhitespaceOnly(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    static {
        for (int i2 = -128; i2 <= 127; ++i2) {
            StringUtils.allBytes[i2 - -128] = (byte)i2;
        }
        String string = new String(allBytes, 0, 255);
        int n2 = string.length();
        for (int i3 = 0; i3 < 255 && i3 < n2; ++i3) {
            StringUtils.byteToChars[i3] = string.charAt(i3);
        }
        try {
            toPlainStringMethod = BigDecimal.class.getMethod("toPlainString", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }
}

