/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc.ae;

import com.oscar.core.BaseResultSet;
import com.oscar.core.Field;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.jdbc.ae.valuehandler.BoolValueHandler;
import com.oscar.jdbc.ae.valuehandler.ByteValueHandler;
import com.oscar.jdbc.ae.valuehandler.DateValueHandler;
import com.oscar.jdbc.ae.valuehandler.DoubleValueHandler;
import com.oscar.jdbc.ae.valuehandler.FloatValueHandler;
import com.oscar.jdbc.ae.valuehandler.IntValueHandler;
import com.oscar.jdbc.ae.valuehandler.LongValueHandler;
import com.oscar.jdbc.ae.valuehandler.ObjectValueHandler;
import com.oscar.jdbc.ae.valuehandler.ShortValueHandler;
import com.oscar.jdbc.ae.valuehandler.StringValueHandler;
import com.oscar.jdbc.ae.valuehandler.TimeValueHandler;
import com.oscar.jdbc.ae.valuehandler.TimestampValueHandler;
import com.oscar.jdbc.ae.valuehandler.ValueHandler;
import com.oscar.util.OSQLException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class OscarResultSetAeHandler
implements InvocationHandler {
    public static final int ENCRYPT_MODE_NONE = 0;
    static final int ENCRYPT_MODE_DETERMINISTIC = 1;
    private static final Map<String, ValueHandler<?>> METHOD_NEED_DECRYPT_MAP = new HashMap();
    private BaseResultSet delegate;
    private Field[] field;

    public OscarResultSetAeHandler(BaseResultSet baseResultSet) {
        this.delegate = baseResultSet;
        this.field = baseResultSet.getFields();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object valueHandler, Method method, Object[] objectArray) throws Throwable {
        int n2;
        valueHandler = METHOD_NEED_DECRYPT_MAP.get(method.getName());
        if (valueHandler == null) {
            return this.handleNormal(method, objectArray);
        }
        if (objectArray.length <= 0) return this.handleNormal(method, objectArray);
        if (objectArray[0] instanceof String) {
            n2 = this.delegate.findColumn(objectArray[0].toString());
        } else {
            if (!(objectArray[0] instanceof Integer) && objectArray[0].getClass() != Integer.TYPE) return this.handleNormal(method, objectArray);
            n2 = (Integer)objectArray[0];
        }
        if (this.field[n2 - 1].getColumnEncryptMode() == 0) {
            return this.handleNormal(method, objectArray);
        }
        if (this.delegate.getCurrentRow()[n2 - 1] == null) {
            return this.handleNormal(method, objectArray);
        }
        this.checkClosed();
        ((OscarResultSet)this.delegate).checkIndex(n2);
        this.checkNull();
        return valueHandler.decrypt(this.delegate, method, objectArray, this.field, n2 - 1, this.delegate.getCurrentRow()[n2 - 1]);
    }

    private Object handleNormal(Method method, Object[] objectArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return method.invoke((Object)this.delegate, objectArray);
    }

    private void checkClosed() throws SQLException {
        if (this.delegate.isClosed()) {
            throw new OSQLException("OSCAR-00306", "88888", 306);
        }
    }

    protected void checkNull() throws SQLException {
        if (this.delegate.getCurrentRow() == null) {
            throw new OSQLException("OSCAR-00301", "88888", 301);
        }
    }

    static {
        METHOD_NEED_DECRYPT_MAP.put("getString", new StringValueHandler());
        METHOD_NEED_DECRYPT_MAP.put("getBigDecimal", new IntValueHandler());
        METHOD_NEED_DECRYPT_MAP.put("getLong", new LongValueHandler());
        METHOD_NEED_DECRYPT_MAP.put("getInt", new IntValueHandler());
        METHOD_NEED_DECRYPT_MAP.put("getFloat", new FloatValueHandler());
        METHOD_NEED_DECRYPT_MAP.put("getDouble", new DoubleValueHandler());
        METHOD_NEED_DECRYPT_MAP.put("getShort", new ShortValueHandler());
        METHOD_NEED_DECRYPT_MAP.put("getBoolean", new BoolValueHandler());
        METHOD_NEED_DECRYPT_MAP.put("getByte", new ByteValueHandler());
        METHOD_NEED_DECRYPT_MAP.put("getDate", new DateValueHandler());
        METHOD_NEED_DECRYPT_MAP.put("getTimestamp", new TimestampValueHandler());
        METHOD_NEED_DECRYPT_MAP.put("getTime", new TimeValueHandler());
        METHOD_NEED_DECRYPT_MAP.put("getObject", new ObjectValueHandler());
    }
}

