/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc.ae.valuehandler;

import com.oscar.Driver;
import com.oscar.ae.CekManager;
import com.oscar.ae.ColumnEncryptionKey;
import com.oscar.ae.EncryptionCommon;
import com.oscar.core.BaseResultSet;
import com.oscar.core.Field;
import com.oscar.jdbc.ae.ParameterEncryptionDesc;
import com.oscar.jdbc.ae.valuehandler.ValueHandler;
import com.oscar.util.Hex;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Arrays;

public abstract class AbstractValueHandler<T>
implements ValueHandler<T> {
    protected boolean logFlag = Driver.getLogLevel() >= 2;
    final byte[] vectorBytes = new byte[]{49, -116, 89, -89, -108, 63, 15, -23, -113, 57, -71, 54, 50, 102, 55, 50};

    @Override
    public String encrypt(ParameterEncryptionDesc object, Object object2, int n2) throws SQLException {
        try {
            object = CekManager.singleton().getCek(new String(((ParameterEncryptionDesc)object).getCekEncryptedValue(), EncryptionCommon.ISO_8859_1), ((ParameterEncryptionDesc)object).getCmkPath(), ((ParameterEncryptionDesc)object).getCekAlgorithm());
            if (object == null) {
                throw new SQLException("\u6ca1\u6709\u627e\u5230CEK");
            }
            CekManager.singleton().cache((ColumnEncryptionKey)object);
            if (this.logFlag) {
                Driver.writeLog("\u539f\u503c\uff1a" + object2);
            }
            object = EncryptionCommon.encryptKey_AES128_CBC_HMAC_SHA256(object2.toString().getBytes(EncryptionCommon.ISO_8859_1), ((ColumnEncryptionKey)object).getKeyValueRaw(), this.vectorBytes);
            if (this.logFlag) {
                Driver.writeLog("\u52a0\u5bc6\u540e\u7684\u503c\uff1a" + Arrays.toString((byte[])object));
            }
            object = Hex.bytesToHexString((byte[])object);
            if (this.logFlag) {
                Driver.writeLog("\u5341\u516d\u8fdb\u5236\u503c\uff1a" + (String)object);
            }
            object = "0x01" + (String)object;
            if (this.logFlag) {
                Driver.writeLog("\u6700\u7ec8\u503c\uff1a" + (String)object);
            }
            return object;
        }
        catch (SQLException sQLException) {
            object = sQLException;
            throw sQLException;
        }
        catch (Exception exception) {
            if (this.logFlag) {
                Driver.writeLog("\u89e3\u5bc6\u503c\u53d1\u751f\u9519\u8bef\uff0c\u503c\uff1a" + object2, exception);
            }
            throw new SQLException("\u89e3\u5bc6\u503c\u53d1\u751f\u9519\u8bef\uff0c\u503c\uff1a" + object2 + ", \u8be6\u7ec6\uff1a" + exception.toString(), exception);
        }
    }

    protected String revertValue(Field object, byte[] object2, Object[] objectArray) throws SQLException {
        String string = new String((byte[])object2, EncryptionCommon.ISO_8859_1);
        object2 = string;
        String string2 = string.substring(4);
        object2 = string2;
        objectArray = Hex.hexStringToByte(string2);
        if (this.logFlag) {
            Driver.writeLog("\u539f\u6587\uff1a\uff1a\uff1a" + (String)object2);
            Driver.writeLog("16\u8fdb\u5236\u8fd8\u539f\uff1a\uff1a\uff1a" + Arrays.toString((byte[])objectArray));
        }
        try {
            object = this.decryptionValue((Field)object, (byte[])objectArray);
        }
        catch (Exception exception) {
            if (this.logFlag) {
                Driver.writeLog("\u89e3\u5bc6\u503c\u53d1\u751f\u9519\u8bef\uff0c\u503c\uff1a" + (String)object2, exception);
            }
            throw new SQLException("\u89e3\u5bc6\u503c\u53d1\u751f\u9519\u8bef\uff0c\u503c\uff1a" + (String)object2 + " ,\u539f\u56e0\uff1a" + exception.toString(), exception);
        }
        if (this.logFlag) {
            Driver.writeLog("cek\u89e3\u5bc6\u540e\uff1a\uff1a\uff1a" + (String)object);
        }
        return object;
    }

    protected String decryptionValue(Field object, byte[] byArray) throws Exception {
        EncryptionCommon.ColumnEncryptionAlgorithm columnEncryptionAlgorithm;
        ColumnEncryptionKey columnEncryptionKey = CekManager.singleton().getCek(((Field)object).getColumnEncryptKeyValue(), ((Field)object).getColumnMasterKeyPath(), ((Field)object).getColumnEncryptKeyMode());
        try {
            columnEncryptionAlgorithm = EncryptionCommon.ColumnEncryptionAlgorithm.valueOf(((Field)object).getColumnEncryptType());
        }
        catch (Exception exception) {
            if (((Field)object).getColumnEncryptType().startsWith("AEAD_AES_256_CBC_HMAC")) {
                columnEncryptionAlgorithm = EncryptionCommon.ColumnEncryptionAlgorithm.AEAD_AES_128_CBC_HMAC_SHA256;
            }
            throw new SQLException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5:" + ((Field)object).getColumnEncryptType());
        }
        if (columnEncryptionAlgorithm == EncryptionCommon.ColumnEncryptionAlgorithm.AEAD_AES_128_CBC_HMAC_SHA256) {
            if (this.logFlag) {
                Driver.writeLog("cek\u660e\u6587\uff1a" + columnEncryptionKey.getKeyValueRaw());
            }
            object = EncryptionCommon.decryptKey_AES128_CBC_HMAC_SHA256(byArray, columnEncryptionKey.getKeyValueRaw(), this.vectorBytes);
            return new String((byte[])object, EncryptionCommon.ISO_8859_1);
        }
        if (columnEncryptionAlgorithm == EncryptionCommon.ColumnEncryptionAlgorithm.AEAD_AES_256_CBC_HMAC_SHA256) {
            if (this.logFlag) {
                Driver.writeLog("cek\u660e\u6587\uff1a" + columnEncryptionKey.getKeyValueRaw());
            }
            object = EncryptionCommon.decryptKey_AES256_CBC_HMAC_SHA256(byArray, columnEncryptionKey.getKeyValueRaw(), this.vectorBytes);
            return new String((byte[])object, EncryptionCommon.ISO_8859_1);
        }
        throw new SQLException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5:" + ((Field)object).getColumnEncryptType());
    }

    protected byte[] normalizeValue(byte[] byArray) throws Exception {
        byte[] byArray2 = new byte[byArray.length - 4];
        System.arraycopy(byArray, 4, byArray2, 0, byArray2.length);
        return byArray2;
    }

    protected Object invokeOriginalMethod(BaseResultSet baseResultSet, Method method, Object[] objectArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return method.invoke((Object)baseResultSet, objectArray);
    }
}

