/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc.ae.valuehandler;

import com.oscar.Driver;
import com.oscar.core.BaseResultSet;
import com.oscar.core.Field;
import com.oscar.jdbc.ae.valuehandler.AbstractValueHandler;
import com.oscar.jdbc.ae.valuehandler.ByteValueHandler;
import com.oscar.jdbc.ae.valuehandler.DateValueHandler;
import com.oscar.jdbc.ae.valuehandler.DoubleValueHandler;
import com.oscar.jdbc.ae.valuehandler.FloatValueHandler;
import com.oscar.jdbc.ae.valuehandler.IntValueHandler;
import com.oscar.jdbc.ae.valuehandler.LongValueHandler;
import com.oscar.jdbc.ae.valuehandler.ShortValueHandler;
import com.oscar.jdbc.ae.valuehandler.StringValueHandler;
import com.oscar.jdbc.ae.valuehandler.TimeValueHandler;
import com.oscar.jdbc.ae.valuehandler.TimestampValueHandler;
import com.oscar.jdbc.ae.valuehandler.ValueHandler;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class ObjectValueHandler
extends AbstractValueHandler<Object> {
    private static final Map<Integer, ValueHandler<?>> METHOD_NEED_DECRYPT_MAP = new HashMap();

    @Override
    public Object decrypt(BaseResultSet object, Method method, Object[] objectArray, Field[] fieldArray, int n2, byte[] byArray) throws SQLException {
        ValueHandler<?> valueHandler;
        if (objectArray.length == 2 && (valueHandler = (Map)objectArray[1]) != null && !valueHandler.isEmpty()) {
            throw Driver.notImplemented();
        }
        valueHandler = METHOD_NEED_DECRYPT_MAP.get(fieldArray[n2].getSQLType());
        if (valueHandler == null) {
            try {
                return this.invokeOriginalMethod((BaseResultSet)object, method, objectArray);
            }
            catch (Exception exception) {
                object = exception;
                if (exception.getCause() instanceof SQLException) {
                    throw (SQLException)((Throwable)object).getCause();
                }
                throw new SQLException("\u65b9\u6cd5\u6267\u884c\u5931\u8d25", ((Throwable)object).getCause());
            }
        }
        return valueHandler.decrypt((BaseResultSet)object, method, objectArray, fieldArray, n2, byArray);
    }

    static {
        METHOD_NEED_DECRYPT_MAP.put(12, new StringValueHandler());
        METHOD_NEED_DECRYPT_MAP.put(3, new IntValueHandler());
        METHOD_NEED_DECRYPT_MAP.put(-5, new LongValueHandler());
        METHOD_NEED_DECRYPT_MAP.put(4, new IntValueHandler());
        METHOD_NEED_DECRYPT_MAP.put(6, new FloatValueHandler());
        METHOD_NEED_DECRYPT_MAP.put(8, new DoubleValueHandler());
        METHOD_NEED_DECRYPT_MAP.put(5, new ShortValueHandler());
        METHOD_NEED_DECRYPT_MAP.put(-7, new ByteValueHandler());
        METHOD_NEED_DECRYPT_MAP.put(91, new DateValueHandler());
        METHOD_NEED_DECRYPT_MAP.put(93, new TimestampValueHandler());
        METHOD_NEED_DECRYPT_MAP.put(92, new TimeValueHandler());
    }
}

