/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbcx;

import com.oscar.Driver;
import com.oscar.jdbcx.Jdbc3ConnectionPool;
import com.oscar.jdbcx.Jdbc3ObjectFactory;
import com.oscar.jdbcx.optional.ConnectionPool;
import com.oscar.jdbcx.optional.PoolingDataSource;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Reference;

public class Jdbc3PoolingDataSource
extends PoolingDataSource {
    private static Map dataSources = new HashMap();

    static Jdbc3PoolingDataSource getDataSource(String string) {
        return (Jdbc3PoolingDataSource)dataSources.get(string);
    }

    @Override
    protected void removeStoredDataSource() {
        Map map = dataSources;
        synchronized (map) {
            dataSources.remove(this.dataSourceName);
            return;
        }
    }

    @Override
    public void setDataSourceName(String string) {
        if (this.isInitialized()) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        if (this.dataSourceName != null && string != null && string.equals(this.dataSourceName)) {
            throw new IllegalArgumentException("DataSource with name '" + string + "' already exists!");
        }
        Map map = dataSources;
        synchronized (map) {
            if (Jdbc3PoolingDataSource.getDataSource(string) != null) {
                throw new IllegalArgumentException("DataSource with name '" + string + "' already exists!");
            }
            if (this.dataSourceName != null) {
                dataSources.remove(this.dataSourceName);
            }
            this.dataSourceName = string;
            dataSources.put(string, this);
            return;
        }
    }

    @Override
    protected Reference createReference() {
        return new Reference(this.getClass().getName(), Jdbc3ObjectFactory.class.getName(), null);
    }

    @Override
    protected ConnectionPool createConnectionPool() {
        return new Jdbc3ConnectionPool();
    }

    @Override
    public String getDescription() {
        return "JDBC3 Pooling DataSource from " + Driver.getVersion();
    }
}

