/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbcx.optional;

import com.oscar.jdbcx.optional.OSCARObjectFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public abstract class BaseDataSource
implements Referenceable {
    private transient PrintWriter logger;
    private String serverName = "localhost";
    private String databaseName;
    private String user;
    private boolean isSSL = false;
    private Properties info;
    private String password;
    private int portNumber;
    private String url;
    private int loginTimeout;

    public Connection getConnection() throws SQLException {
        BaseDataSource baseDataSource = this;
        return baseDataSource.getConnection(baseDataSource.user, this.password);
    }

    public Connection getConnection(String string, String object) throws SQLException {
        try {
            if (this.info == null) {
                this.info = new Properties();
            }
            if (string != null) {
                this.info.setProperty("USER", string);
            }
            if (object != null) {
                this.info.setProperty("PASSWORD", (String)object);
            }
            if (this.isSSL) {
                this.info.setProperty("SSL", "t");
                this.info.setProperty("NOSSLVERSION", "f");
            }
            if (this.loginTimeout > 0) {
                this.info.setProperty("LOGINTIMEOUT", String.valueOf(this.loginTimeout * 1000));
            }
            object = DriverManager.getConnection(this.getUrl(), this.info);
            if (this.logger != null) {
                this.logger.println("Created a non-pooled connection for " + string + " at " + this.getUrl());
            }
            return object;
        }
        catch (SQLException sQLException) {
            if (this.logger != null) {
                this.logger.println("Failed to create a non-pooled connection for " + string + " at " + this.getUrl() + ": " + sQLException);
            }
            throw sQLException;
        }
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int n2) throws SQLException {
        this.loginTimeout = n2;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logger;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logger = printWriter;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        if (string == null || string.equals("")) {
            this.serverName = "localhost";
            return;
        }
        this.serverName = string;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public abstract String getDescription();

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int n2) {
        this.portNumber = n2;
    }

    public void setSSL(boolean bl) {
        this.isSSL = bl;
    }

    public void setPropertity(Properties properties) {
        this.info = properties;
    }

    public void setProperties(Properties properties) {
        this.info = properties;
    }

    public String getUrl() {
        if (this.url != null && !"".equals(this.url)) {
            return this.url;
        }
        return "jdbc:oscar://" + this.serverName + (this.portNumber == 0 ? "" : ":" + this.portNumber) + "/" + this.databaseName;
    }

    public Properties getPropertity() {
        return this.info;
    }

    public Properties getProperties() {
        return this.info;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    protected Reference createReference() {
        return new Reference(this.getClass().getName(), OSCARObjectFactory.class.getName(), null);
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = this.createReference();
        reference.add(new StringRefAddr("serverName", this.serverName));
        if (this.portNumber != 0) {
            reference.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
        }
        reference.add(new StringRefAddr("databaseName", this.databaseName));
        if (this.user != null) {
            reference.add(new StringRefAddr("user", this.user));
        }
        if (this.password != null) {
            reference.add(new StringRefAddr("password", this.password));
        }
        return reference;
    }

    static {
        try {
            Class.forName("com.oscar.Driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("oscar DataSource unable to load oscar JDBC Driver");
        }
    }
}

