/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbcx.optional;

import com.oscar.jdbcx.optional.BaseDataSource;
import com.oscar.jdbcx.optional.ConnectionPool;
import com.oscar.jdbcx.optional.PoolingDataSource;
import com.oscar.jdbcx.optional.SimpleDataSource;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class OSCARObjectFactory
implements ObjectFactory {
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (((Reference)(object = (Reference)object)).getClassName().equals(SimpleDataSource.class.getName())) {
            return this.loadSimpleDataSource((Reference)object);
        }
        if (((Reference)object).getClassName().equals(ConnectionPool.class.getName())) {
            return this.loadConnectionPool((Reference)object);
        }
        if (((Reference)object).getClassName().equals(PoolingDataSource.class.getName())) {
            return this.loadPoolingDataSource((Reference)object);
        }
        return null;
    }

    private Object loadPoolingDataSource(Reference object) {
        String string = this.getProperty((Reference)object, "dataSourceName");
        PoolingDataSource poolingDataSource = PoolingDataSource.getDataSource(string);
        if (poolingDataSource != null) {
            return poolingDataSource;
        }
        poolingDataSource = new PoolingDataSource();
        poolingDataSource.setDataSourceName(string);
        this.loadBaseDataSource(poolingDataSource, (Reference)object);
        string = this.getProperty((Reference)object, "initialConnections");
        if (string != null) {
            poolingDataSource.setInitialConnections(Integer.parseInt(string));
        }
        if ((object = this.getProperty((Reference)object, "maxConnections")) != null) {
            poolingDataSource.setMaxConnections(Integer.parseInt((String)object));
        }
        return poolingDataSource;
    }

    private Object loadSimpleDataSource(Reference reference) {
        SimpleDataSource simpleDataSource = new SimpleDataSource();
        return this.loadBaseDataSource(simpleDataSource, reference);
    }

    private Object loadConnectionPool(Reference reference) {
        ConnectionPool connectionPool = new ConnectionPool();
        return this.loadBaseDataSource(connectionPool, reference);
    }

    protected Object loadBaseDataSource(BaseDataSource baseDataSource, Reference reference) {
        baseDataSource.setDatabaseName(this.getProperty(reference, "databaseName"));
        baseDataSource.setPassword(this.getProperty(reference, "password"));
        String string = this.getProperty(reference, "portNumber");
        if (string != null) {
            baseDataSource.setPortNumber(Integer.parseInt(string));
        }
        baseDataSource.setServerName(this.getProperty(reference, "serverName"));
        baseDataSource.setUser(this.getProperty(reference, "user"));
        baseDataSource.setUrl(this.getProperty(reference, "url"));
        return baseDataSource;
    }

    protected String getProperty(Reference serializable, String string) {
        if ((serializable = ((Reference)serializable).get(string)) == null) {
            return null;
        }
        return (String)((RefAddr)serializable).getContent();
    }
}

