/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbcx.optional;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.jdbc.OscarJdbc2Connection;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class PooledConnectionImpl
implements PooledConnection {
    private List<ConnectionEventListener> listeners = new LinkedList<ConnectionEventListener>();
    private Connection con;
    private ConnectionHandler last;
    private boolean autoCommit;
    private boolean isXA;
    private boolean closed = false;
    private List<StatementEventListener> statementListeners = new LinkedList<StatementEventListener>();
    private boolean logFlag = Driver.getLogLevel() > 0;

    protected PooledConnectionImpl(Connection connection, boolean bl) {
        this.con = connection;
        this.autoCommit = bl;
    }

    protected PooledConnectionImpl(Connection connection, boolean bl, boolean bl2) {
        this.con = connection;
        this.autoCommit = bl;
        this.isXA = bl2;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean bl) {
        this.closed = bl;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.add(connectionEventListener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.remove(connectionEventListener);
    }

    @Override
    public void close() throws SQLException {
        if (this.last != null) {
            this.last.close();
            try {
                if (this.con != null && !this.con.isClosed() && !this.con.getAutoCommit()) {
                    this.con.rollback();
                }
            }
            catch (SQLException sQLException) {}
        }
        try {
            if (this.con != null) {
                if (this.logFlag) {
                    Driver.writeLog("\u8fde\u63a5\u6c60\u88ab\u5173\u95ed\uff0c" + this.hashCode() + "  con\u5173\u95ed\uff0c" + this.con.hashCode());
                }
                this.con.close();
            }
        }
        finally {
            if (this.logFlag) {
                Driver.writeLog(PooledConnectionImpl.getStackTrace(new Throwable()));
            }
            this.con = null;
        }
        this.closed = true;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.con == null) {
            if (this.logFlag) {
                Driver.writeLog("\u8fde\u63a5\u6c60\u5173\u95ed\u540e\u8c03\u7528getConnection\uff0c" + this.hashCode());
            }
            SQLException sQLException = new SQLException("This PooledConnection has already been closed!");
            this.fireConnectionFatalError(sQLException);
            throw sQLException;
        }
        if (((BaseConnection)((Object)this.con)).isVerifyPoolConnection() && !((BaseConnection)((Object)this.con)).isValidate(100)) {
            return null;
        }
        try {
            if (this.last != null) {
                if (!this.con.isClosed() && !this.con.getAutoCommit()) {
                    try {
                        this.con.rollback();
                    }
                    catch (SQLException sQLException) {}
                }
                if (!this.con.isClosed()) {
                    this.con.clearWarnings();
                }
            }
            if (!this.isXA && !this.con.isClosed()) {
                this.con.setAutoCommit(this.autoCommit);
            }
        }
        catch (SQLException sQLException) {
            this.fireConnectionFatalError(sQLException);
            throw (SQLException)sQLException.fillInStackTrace();
        }
        PooledConnectionImpl pooledConnectionImpl = this;
        Object object = pooledConnectionImpl.new ConnectionHandler(pooledConnectionImpl.con);
        this.last = object;
        object = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class, BaseConnection.class}, (InvocationHandler)object);
        this.last.setProxy((Connection)object);
        return object;
    }

    void fireConnectionClosed() {
        ConnectionEvent connectionEvent = null;
        ConnectionEventListener[] connectionEventListenerArray = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        for (int i2 = 0; i2 < connectionEventListenerArray.length; ++i2) {
            ConnectionEventListener connectionEventListener = connectionEventListenerArray[i2];
            if (connectionEvent == null) {
                connectionEvent = new ConnectionEvent(this);
            }
            connectionEventListener.connectionClosed(connectionEvent);
        }
    }

    void fireConnectionFatalError(SQLException sQLException) {
        ConnectionEvent connectionEvent = null;
        ConnectionEventListener[] connectionEventListenerArray = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        for (int i2 = 0; i2 < connectionEventListenerArray.length; ++i2) {
            ConnectionEventListener connectionEventListener = connectionEventListenerArray[i2];
            if (connectionEvent == null) {
                connectionEvent = new ConnectionEvent(this, sQLException);
            }
            connectionEventListener.connectionErrorOccurred(connectionEvent);
        }
    }

    private static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        this.statementListeners.add(statementEventListener);
        if (this.con instanceof OscarJdbc2Connection) {
            ((OscarJdbc2Connection)this.con).setStatementListeners(this.statementListeners);
            if (((OscarJdbc2Connection)this.con).getPc() == null) {
                ((OscarJdbc2Connection)this.con).setPc(this);
            }
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        this.statementListeners.remove(statementEventListener);
    }

    private static class StatementHandler
    implements InvocationHandler {
        private ConnectionHandler con;
        private Statement st;

        public StatementHandler(ConnectionHandler connectionHandler, Statement statement) {
            this.con = connectionHandler;
            this.st = statement;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                if (method.getName().equals("toString")) {
                    return "Pooled statement wrapping physical statement " + this.st;
                }
                if (method.getName().equals("hashCode")) {
                    return this.st.hashCode();
                }
                if (method.getName().equals("equals")) {
                    if (objectArray[0] == null) {
                        return Boolean.FALSE;
                    }
                    try {
                        if (Proxy.isProxyClass(objectArray[0].getClass()) && ((StatementHandler)Proxy.getInvocationHandler((Object)objectArray[0])).st == this.st) {
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }
                    catch (ClassCastException classCastException) {
                        return Boolean.FALSE;
                    }
                }
                return method.invoke((Object)this.st, objectArray);
            }
            boolean bl = method.getName().equals("close");
            if (!bl && (this.st == null || this.con.isClosed())) {
                throw new SQLException("Statement has been closed");
            }
            if (bl) {
                if (this.st == null) {
                    return null;
                }
                try {
                    this.st.close();
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = sQLException;
                    sQLException.printStackTrace();
                }
                finally {
                    this.con = null;
                    this.st = null;
                }
                return null;
            }
            if (method.getName().equals("getConnection")) {
                return this.con.getProxy();
            }
            try {
                return method.invoke((Object)this.st, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                InvocationTargetException invocationTargetException2 = invocationTargetException;
                throw invocationTargetException.getTargetException();
            }
        }
    }

    private class ConnectionHandler
    implements InvocationHandler {
        private Connection con;
        private Connection proxy;
        private boolean automatic = false;

        public ConnectionHandler(Connection connection) {
            this.con = connection;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                if (method.getName().equals("toString")) {
                    return "Pooled connection wrapping physical connection " + this.con;
                }
                if (method.getName().equals("hashCode")) {
                    return this.con.hashCode();
                }
                if (method.getName().equals("equals")) {
                    if (objectArray[0] == null) {
                        return Boolean.FALSE;
                    }
                    try {
                        if (Proxy.isProxyClass(objectArray[0].getClass()) && ((ConnectionHandler)Proxy.getInvocationHandler((Object)objectArray[0])).con == this.con) {
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }
                    catch (ClassCastException classCastException) {
                        return Boolean.FALSE;
                    }
                }
                try {
                    return method.invoke((Object)this.con, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    object = invocationTargetException;
                    throw invocationTargetException.getTargetException();
                }
            }
            if (method.getName().equals("isClosed")) {
                return this.con == null ? true : this.con.isClosed();
            }
            boolean bl = method.getName().equals("close");
            if (!bl && this.con == null) {
                throw new SQLException(this.automatic ? "Connection has been closed automatically because a new connection was opened for the same PooledConnection or the PooledConnection has been closed" : "Connection has been closed");
            }
            try {
                if (bl) {
                    SQLException sQLException = null;
                    if (!(PooledConnectionImpl.this.isXA || this.con == null || this.con.isClosed() || this.con.getAutoCommit())) {
                        try {
                            this.con.rollback();
                        }
                        catch (SQLException sQLException2) {
                            sQLException = sQLException2;
                            sQLException = sQLException2;
                        }
                    }
                    if (this.con != null && !this.con.isClosed()) {
                        this.con.clearWarnings();
                    }
                    this.con = null;
                    PooledConnectionImpl.this.last = null;
                    PooledConnectionImpl.this.fireConnectionClosed();
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    return null;
                }
                if (method.getName().equals("createStatement")) {
                    Statement statement = (Statement)method.invoke((Object)this.con, objectArray);
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Statement.class}, (InvocationHandler)new StatementHandler(this, statement));
                }
                if (method.getName().equals("prepareCall")) {
                    Statement statement = (Statement)method.invoke((Object)this.con, objectArray);
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{CallableStatement.class}, (InvocationHandler)new StatementHandler(this, statement));
                }
                if (method.getName().equals("prepareStatement")) {
                    Statement statement = (Statement)method.invoke((Object)this.con, objectArray);
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new StatementHandler(this, statement));
                }
                return method.invoke((Object)this.con, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                InvocationTargetException invocationTargetException2 = invocationTargetException;
                throw invocationTargetException.getTargetException();
            }
        }

        Connection getProxy() {
            return this.proxy;
        }

        void setProxy(Connection connection) {
            this.proxy = connection;
        }

        public void close() {
            try {
                SQLException sQLException = null;
                if (!(PooledConnectionImpl.this.isXA || this.con == null || this.con.isClosed() || this.con.getAutoCommit())) {
                    try {
                        this.con.rollback();
                    }
                    catch (SQLException sQLException2) {
                        sQLException = sQLException2;
                        sQLException = sQLException2;
                    }
                }
                if (this.con != null && !this.con.isClosed()) {
                    this.con.clearWarnings();
                }
                this.con = null;
                this.proxy = null;
                PooledConnectionImpl.this.last = null;
                PooledConnectionImpl.this.fireConnectionClosed();
                if (sQLException != null) {
                    throw sQLException;
                }
                return;
            }
            catch (SQLException sQLException) {
                SQLException sQLException3 = sQLException;
                sQLException.printStackTrace();
                return;
            }
        }

        public boolean isClosed() {
            return this.con == null;
        }
    }
}

