/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbcx.optional;

import com.oscar.Config;
import com.oscar.Driver;
import com.oscar.jdbcx.optional.BaseDataSource;
import com.oscar.jdbcx.optional.ConnectionPool;
import com.oscar.jdbcx.optional.PooledConnectionImpl;
import com.oscar.util.OSQLException;
import com.oscar.util.OscarSqlProcessor;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class PoolingDataSource
extends BaseDataSource
implements ConnectionPoolDataSource {
    private static Map dataSources = new HashMap();
    protected String dataSourceName;
    private int initialConnections = 0;
    private int maxConnections = 0;
    private boolean initialized = false;
    private Stack available = new Stack();
    private Stack used = new Stack();
    private Object lock = new Object();
    private ConnectionPool source;
    private int maxWait = -1;
    private int maxIdle = 0;
    private int minIdle = 0;
    private String validationQuery = "";
    private boolean removeAbandoned = false;
    private int removeAbandonedTimeout;
    private ConcurrentMap connTimeMap = null;
    private int timeBetweenEvictionRunsMillis = -1;
    private int minEvictableIdleTimeMillis;
    private volatile PoolCleaner poolCleaner;
    private int abandonWhenPercentageFull = 0;
    private boolean defaultAutoCommit = true;
    private boolean logFlag = Driver.getLogLevel() > 0;
    public static final String LOGFLAG = "PoolingDataSource------------";
    private static volatile Timer poolCleanTimer = null;
    private static HashSet<PoolCleaner> cleaners = new HashSet();
    private ConnectionEventListener connectionEventListener = new ConnectionEventListener(){

        @Override
        public void connectionClosed(ConnectionEvent connectionEvent) {
            ((PooledConnection)connectionEvent.getSource()).removeConnectionEventListener(this);
            Object object = PoolingDataSource.this.lock;
            synchronized (object) {
                if (PoolingDataSource.this.available == null) {
                    return;
                }
                PooledConnectionImpl pooledConnectionImpl = (PooledConnectionImpl)connectionEvent.getSource();
                boolean bl = PoolingDataSource.this.used.remove(pooledConnectionImpl);
                if (bl) {
                    if (pooledConnectionImpl.isClosed()) {
                        PoolingDataSource.this.available.remove(pooledConnectionImpl);
                    } else if (PoolingDataSource.this.maxIdle > 0 && (PoolingDataSource.this.getMaxConnections() == 0 || PoolingDataSource.this.maxIdle < PoolingDataSource.this.getMaxConnections())) {
                        if (PoolingDataSource.this.available.size() >= PoolingDataSource.this.maxIdle) {
                            try {
                                pooledConnectionImpl.close();
                            }
                            catch (SQLException sQLException) {}
                        } else {
                            PoolingDataSource.this.available.push(connectionEvent.getSource());
                        }
                    } else {
                        PoolingDataSource.this.available.push(connectionEvent.getSource());
                    }
                    PoolingDataSource.this.lock.notify();
                }
                return;
            }
        }

        @Override
        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            ((PooledConnection)connectionEvent.getSource()).removeConnectionEventListener(this);
            Object object = PoolingDataSource.this.lock;
            synchronized (object) {
                if (PoolingDataSource.this.available == null) {
                    return;
                }
                PoolingDataSource.this.used.remove(connectionEvent.getSource());
                PoolingDataSource.this.lock.notify();
                return;
            }
        }
    };

    static PoolingDataSource getDataSource(String string) {
        return (PoolingDataSource)dataSources.get(string);
    }

    public PoolingDataSource() {
        this.initProperties();
    }

    @Override
    public String getDescription() {
        return "Pooling DataSource " + this.dataSourceName + " from " + Driver.getVersion();
    }

    @Override
    public void setServerName(String string) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setServerName(string);
    }

    @Override
    public void setDatabaseName(String string) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setDatabaseName(string);
    }

    @Override
    public void setUser(String string) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setUser(string);
    }

    @Override
    public void setPassword(String string) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setPassword(string);
    }

    @Override
    public void setSSL(boolean bl) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setSSL(bl);
    }

    @Override
    public void setPortNumber(int n2) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setPortNumber(n2);
    }

    public int getInitialConnections() {
        return this.initialConnections;
    }

    public void setInitialConnections(int n2) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        this.initialConnections = n2;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int n2) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        this.maxConnections = n2;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        if (this.dataSourceName != null && string != null && string.equals(this.dataSourceName)) {
            return;
        }
        Map map = dataSources;
        synchronized (map) {
            if (PoolingDataSource.getDataSource(string) != null) {
                throw new IllegalArgumentException("DataSource with name '" + string + "' already exists!");
            }
            if (this.dataSourceName != null) {
                dataSources.remove(this.dataSourceName);
            }
            this.dataSourceName = string;
            dataSources.put(string, this);
            return;
        }
    }

    public void initialize() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.source = this.createConnectionPool();
            this.source.setDatabaseName(this.getDatabaseName());
            this.source.setPassword(this.getPassword());
            this.source.setPortNumber(this.getPortNumber());
            this.source.setServerName(this.getServerName());
            this.source.setUser(this.getUser());
            this.source.setUrl(this.getUrl());
            Properties properties = this.getProperties();
            this.source.setProperties(properties);
            if (properties != null) {
                this.source.setSSL("t".equals(properties.getProperty("ssl", "f")));
            }
            this.source.setDefaultAutoCommit(this.defaultAutoCommit);
            while (this.available.size() < this.initialConnections) {
                this.available.push(this.source.getPooledConnection());
            }
            this.initialized = true;
        }
        this.initializePoolCleaner();
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected ConnectionPool createConnectionPool() {
        return new ConnectionPool();
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        if (string == null || string.equals(this.getUser()) && (string2 == null && this.getPassword() == null || string2 != null && string2.equals(this.getPassword()))) {
            return ((BaseDataSource)this).getConnection();
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
        }
        return super.getConnection(string, string2);
    }

    @Override
    public Connection getConnection() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
        }
        return this.getPooledConnection().getConnection();
    }

    public void close() {
        Object object = this.lock;
        synchronized (object) {
            PooledConnectionImpl pooledConnectionImpl;
            if (this.poolCleaner != null) {
                this.poolCleaner.stopRunning();
            }
            while (this.available.size() > 0) {
                pooledConnectionImpl = (PooledConnectionImpl)this.available.pop();
                try {
                    pooledConnectionImpl.close();
                }
                catch (SQLException sQLException) {}
            }
            this.available = null;
            while (this.used.size() > 0) {
                pooledConnectionImpl = (PooledConnectionImpl)this.used.pop();
                pooledConnectionImpl.removeConnectionEventListener(this.connectionEventListener);
                try {
                    pooledConnectionImpl.close();
                }
                catch (SQLException sQLException) {}
            }
            this.used = null;
        }
        this.removeStoredDataSource();
    }

    protected void removeStoredDataSource() {
        Map map = dataSources;
        synchronized (map) {
            dataSources.remove(this.dataSourceName);
            return;
        }
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        Object object;
        Object object2 = this.lock;
        synchronized (object2) {
            if (!this.initialized) {
                this.initialize();
                return this.getPooledConnection();
            }
            if (this.available == null) {
                throw new SQLException("DataSource has been closed.");
            }
            long l2 = System.currentTimeMillis();
            while (true) {
                Object object3;
                block27: {
                    block25: {
                        block26: {
                            if (this.maxWait > 0 && (Long)(object3 = Long.valueOf(System.currentTimeMillis())) - l2 > (long)this.maxWait) {
                                throw new OSQLException("OSCAR-00122", "08001", 122);
                            }
                            if (this.available.size() <= 0) break block25;
                            if (this.minIdle <= 0 || this.maxIdle != 0 && this.minIdle >= this.maxIdle || this.getMaxConnections() != 0 && this.minIdle >= this.getMaxConnections()) break block26;
                            if (this.available.size() <= this.minIdle) break block25;
                            object3 = (PooledConnectionImpl)this.available.pop();
                            this.poollog("---getPooledConnection---pc::" + object3.hashCode() + "::" + ((PooledConnectionImpl)object3).isClosed());
                            if (((PooledConnectionImpl)object3).isClosed()) {
                                object = this.source.getPooledConnection();
                            } else if (((PooledConnectionImpl)object3).getConnection() == null) {
                                ((PooledConnectionImpl)object3).close();
                                object = this.source.getPooledConnection();
                            } else {
                                object = object3;
                            }
                            this.used.push(object);
                            break block27;
                        }
                        object3 = (PooledConnectionImpl)this.available.pop();
                        this.poollog("getPooledConnection---pc::" + object3.hashCode() + "::" + ((PooledConnectionImpl)object3).isClosed());
                        if (((PooledConnectionImpl)object3).isClosed()) {
                            object = this.source.getPooledConnection();
                        } else if (((PooledConnectionImpl)object3).getConnection() == null) {
                            ((PooledConnectionImpl)object3).close();
                            object = this.source.getPooledConnection();
                        } else {
                            object = object3;
                        }
                        this.used.push(object);
                        break block27;
                    }
                    if (this.maxConnections == 0 || this.used.size() < this.maxConnections) {
                        object = this.source.getPooledConnection();
                        this.used.push(object);
                    } else {
                        try {
                            this.lock.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                }
                if (this.validationQuery == null || "".equals(this.validationQuery)) break;
                object3 = OscarSqlProcessor.parsing(this.validationQuery.trim());
                if (!((OscarSqlProcessor.ParseResult)object3).isSelectSql()) {
                    throw new SQLException("set fail, must be select sql");
                }
                object3 = object.getConnection().createStatement();
                try {
                    object3.execute(this.validationQuery);
                    object3.close();
                }
                catch (SQLException sQLException) {
                    if (object3 == null) continue;
                    try {
                        object3.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                break;
            }
        }
        object.addConnectionEventListener(this.connectionEventListener);
        if (this.connTimeMap == null) {
            this.connTimeMap = new ConcurrentHashMap();
        }
        this.connTimeMap.put(object, System.currentTimeMillis());
        return object;
    }

    public void poollog(String string) {
        if (this.logFlag) {
            Driver.writeLog(LOGFLAG + string);
        }
    }

    private static synchronized void registerCleaner(PoolCleaner poolCleaner) {
        PoolingDataSource.unregisterCleaner(poolCleaner);
        cleaners.add(poolCleaner);
        if (poolCleanTimer == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(PoolingDataSource.class.getClassLoader());
                poolCleanTimer = new Timer("PoolCleaner[" + System.identityHashCode(PoolingDataSource.class.getClassLoader()) + ":" + System.currentTimeMillis() + "]", true);
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        PoolCleaner poolCleaner2 = poolCleaner;
        poolCleanTimer.scheduleAtFixedRate((TimerTask)poolCleaner2, poolCleaner2.sleepTime, poolCleaner.sleepTime);
    }

    private static synchronized void unregisterCleaner(PoolCleaner poolCleaner) {
        boolean bl = cleaners.remove(poolCleaner);
        if (bl) {
            poolCleaner.cancel();
            if (poolCleanTimer != null) {
                poolCleanTimer.purge();
                if (cleaners.size() == 0) {
                    poolCleanTimer.cancel();
                    poolCleanTimer = null;
                }
            }
        }
    }

    public void initializePoolCleaner() {
        this.poollog("initializePoolCleaner");
        if (this.isPoolSweeperEnabled()) {
            this.poollog("isPoolSweeperEnabled() : true");
            PoolingDataSource poolingDataSource = this;
            this.poolCleaner = new PoolCleaner(poolingDataSource, poolingDataSource.timeBetweenEvictionRunsMillis);
            this.poolCleaner.start();
        }
    }

    public void checkAbandoned() {
        if (this.used.size() == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            for (int i2 = 0; i2 < this.used.size(); ++i2) {
                PooledConnection pooledConnection = (PooledConnection)this.used.get(i2);
                if (this.available.contains(pooledConnection)) continue;
                long l2 = System.currentTimeMillis();
                if (!this.shouldAbandon() || this.connTimeMap.get(pooledConnection) == null || l2 - Long.parseLong(this.connTimeMap.get(pooledConnection).toString()) <= (long)(this.removeAbandonedTimeout * 1000)) continue;
                this.used.remove(i2);
                try {
                    pooledConnection.close();
                    continue;
                }
                catch (SQLException sQLException) {}
            }
            return;
        }
    }

    public void checkIdle() {
        if (this.available.size() == 0) {
            return;
        }
        long l2 = System.currentTimeMillis();
        Iterator iterator = this.available.iterator();
        while (this.available.size() >= this.minIdle && iterator.hasNext()) {
            PooledConnection pooledConnection = (PooledConnection)iterator.next();
            Object object = this.lock;
            synchronized (object) {
                if (this.used.contains(pooledConnection)) {
                    continue;
                }
                long l3 = Long.parseLong(this.connTimeMap.get(pooledConnection).toString());
                if (this.shouldReleaseIdle(l2, l3)) {
                    this.available.remove(pooledConnection);
                    try {
                        pooledConnection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    protected boolean shouldReleaseIdle(long l2, long l3) {
        return this.minEvictableIdleTimeMillis > 0 && l2 - l3 > (long)this.minEvictableIdleTimeMillis;
    }

    protected boolean shouldAbandon() {
        if (this.abandonWhenPercentageFull == 0) {
            return true;
        }
        return this.used.size() / this.maxConnections * 100 >= this.abandonWhenPercentageFull;
    }

    public boolean isPoolSweeperEnabled() {
        boolean bl = this.timeBetweenEvictionRunsMillis > 0;
        boolean bl2 = bl && this.removeAbandoned && this.removeAbandonedTimeout > 0;
        bl2 = bl2 || bl && this.minEvictableIdleTimeMillis > 0;
        return bl2;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = super.getReference();
        reference.add(new StringRefAddr("dataSourceName", this.dataSourceName));
        if (this.initialConnections > 0) {
            reference.add(new StringRefAddr("initialConnections", Integer.toString(this.initialConnections)));
        }
        if (this.maxConnections > 0) {
            reference.add(new StringRefAddr("maxConnections", Integer.toString(this.maxConnections)));
        }
        return reference;
    }

    @Override
    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.initialized) {
                ((BaseDataSource)this).setUser(string);
                ((BaseDataSource)this).setPassword(string2);
                this.initialize();
                return this.getPooledConnection();
            }
            if (string == null || string.equals(this.getUser()) && (string2 == null && this.getPassword() == null || string2 != null && string2.equals(this.getPassword()))) {
                return this.getPooledConnection();
            }
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(int n2) {
        this.maxWait = n2;
    }

    public void setMaxIdle(int n2) {
        this.maxIdle = n2;
    }

    public void setMinIdle(int n2) {
        this.minIdle = n2;
    }

    public void setValidationQuery(String string) {
        this.validationQuery = string;
    }

    public void setRemoveabandoned(boolean bl) {
        this.removeAbandoned = bl;
    }

    public void setRemoveabandonedtimeout(int n2) {
        this.removeAbandonedTimeout = n2;
    }

    public void setTimeBetweenEvictionRunsMillis(int n2) {
        this.timeBetweenEvictionRunsMillis = n2;
    }

    public void setMinEvictableIdleTimeMillis(int n2) {
        this.minEvictableIdleTimeMillis = n2;
    }

    public void setAbandonWhenPercentageFull(int n2) {
        this.abandonWhenPercentageFull = n2;
    }

    public void setDefaultAutoCommit(boolean bl) {
        this.defaultAutoCommit = bl;
    }

    protected void initProperties() {
        Properties properties = Config.getConfigProp();
        if (properties != null) {
            this.setMaxConnections(Integer.parseInt(properties.getProperty("MAXACTIVE", "0")));
            this.setInitialConnections(Integer.parseInt(properties.getProperty("INITIALSIZE", "0")));
            if (this.maxConnections < this.initialConnections) {
                PoolingDataSource poolingDataSource = this;
                poolingDataSource.setInitialConnections(poolingDataSource.maxConnections);
            }
            this.setMinIdle(Integer.parseInt(properties.getProperty("MINIDLE", "0")));
            if (this.minIdle > this.maxConnections) {
                PoolingDataSource poolingDataSource = this;
                poolingDataSource.setMinIdle(poolingDataSource.maxConnections);
            }
            this.setMaxIdle(Integer.parseInt(properties.getProperty("MAXIDLE", "0")));
            if (this.maxIdle > this.maxConnections) {
                PoolingDataSource poolingDataSource = this;
                poolingDataSource.setMaxIdle(poolingDataSource.maxConnections);
            }
            if (this.maxIdle < this.minIdle) {
                PoolingDataSource poolingDataSource = this;
                poolingDataSource.setMaxIdle(poolingDataSource.minIdle);
            }
            this.setDefaultAutoCommit(Boolean.valueOf(properties.getProperty("DEFAULTAUTOCOMMIT", "true")));
            this.setMaxWait(Integer.parseInt(properties.getProperty("MAXWAIT", "-1")));
            this.setValidationQuery(properties.getProperty("VALIDATIONQUERY", ""));
            this.setRemoveabandoned(Boolean.valueOf(properties.getProperty("REMOVEABANDONED", "false")));
            this.setRemoveabandonedtimeout(Integer.parseInt(properties.getProperty("REMOVEABANDONEDTIMEOUT", "0")));
            this.setTimeBetweenEvictionRunsMillis(Integer.parseInt(properties.getProperty("TIMEBETWEENEVICTIONRUNSMILLIS", "0")));
            this.setMinEvictableIdleTimeMillis(Integer.parseInt(properties.getProperty("MINEVICTABLEIDLETIMEMILLIS", "0")));
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    protected static class PoolCleaner
    extends TimerTask {
        protected WeakReference<PoolingDataSource> pool;
        protected volatile long lastRun = 0L;
        protected long sleepTime;

        PoolCleaner(PoolingDataSource poolingDataSource, long l2) {
            this.pool = new WeakReference<PoolingDataSource>(poolingDataSource);
            this.sleepTime = l2;
            if (l2 <= 0L) {
                this.sleepTime = 30000L;
            }
        }

        @Override
        public void run() {
            PoolingDataSource poolingDataSource = (PoolingDataSource)this.pool.get();
            if (poolingDataSource == null) {
                this.stopRunning();
            }
            if (System.currentTimeMillis() - this.lastRun > this.sleepTime) {
                this.lastRun = System.currentTimeMillis();
                if (poolingDataSource.removeAbandoned) {
                    poolingDataSource.checkAbandoned();
                }
                if (poolingDataSource.minIdle < poolingDataSource.available.size()) {
                    poolingDataSource.checkIdle();
                }
            }
        }

        public void start() {
            PoolingDataSource.registerCleaner(this);
        }

        public void stopRunning() {
            PoolingDataSource.unregisterCleaner(this);
        }
    }
}

