/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.rac.executor;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.core.BaseResultSet;
import com.oscar.core.Field;
import com.oscar.jdbc.ExceptionUtil;
import com.oscar.jdbc.OscarCallableStatementV2;
import com.oscar.jdbc.OscarJdbc2RacConnection;
import com.oscar.jdbc.OscarResultSetV2;
import com.oscar.jdbc.OscarStatement;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.List;

public class RacCallableStatementV2
extends OscarCallableStatementV2
implements CallableStatement {
    private boolean hasConnect = false;

    public RacCallableStatementV2(BaseConnection baseConnection, String string) throws SQLException {
        super(baseConnection, string);
    }

    public BaseResultSet createResultSet(Field[] fieldArray, List list, String string, int n2, long l2) throws SQLException {
        return new OscarResultSetV2(this, fieldArray, list, string, n2, l2, this.fetchSize, this.maxrows);
    }

    @Override
    protected boolean executeStatement() throws SQLException {
        try {
            return super.executeStatement();
        }
        catch (SQLException sQLException) {
            if (this.connection.getAutoCommit() && this.hasConnect) {
                return this.executeStatement();
            }
            throw sQLException;
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        try {
            long[] lArray = super.executeLargeBatch();
            super.handleBatch();
            return lArray;
        }
        catch (SQLException sQLException) {
            if (this.connection.getAutoCommit() && this.hasConnect) {
                return ((OscarStatement)this).executeLargeBatch();
            }
            throw sQLException;
        }
    }

    @Override
    public void executeBatchAsyn(List list) throws SQLException {
        try {
            super.executeBatchAsyn(list);
            return;
        }
        catch (SQLException sQLException) {
            if (this.connection.getAutoCommit() && this.hasConnect) {
                ((OscarStatement)this).executeBatchAsyn(list);
                return;
            }
            throw sQLException;
        }
    }

    @Override
    protected void checkConnectionClosed(Exception exception) {
        switch (ExceptionUtil.isConnectionClosed(exception)) {
            case 1: 
            case 2: {
                try {
                    this.hasConnect = false;
                    this.reConnect();
                    this.hasConnect = true;
                    return;
                }
                catch (Exception exception2) {
                    Driver.writeLog("rac change connection fail:" + exception2.getMessage());
                    return;
                }
            }
        }
        this.hasConnect = false;
    }

    @Override
    public void handleBatch() {
        if (!this.hasConnect) {
            super.handleBatch();
        }
    }

    private void reConnect() throws SQLException {
        ((OscarJdbc2RacConnection)this.connection).reConnect(this.connection.getConnectionProperties());
        this.initParams();
    }

    @Override
    protected void initParams() {
        this.batchPacketV2 = null;
        if (this.m_prepareSqlStatement == null) {
            if (this.m_statementName == null) {
                this.m_statementName = "J" + this.getNextPreparedCount();
            }
            StringBuffer stringBuffer = this.sbuf;
            synchronized (stringBuffer) {
                this.sbuf.setLength(0);
                this.sbuf.append("PREPARE ");
                this.sbuf.append(this.m_statementName);
                this.sbuf.append(" AS ");
                this.sbuf.append(this.m_origSqlFragments[0]);
                this.m_prepareSqlStatement = this.sbuf.toString();
                return;
            }
        }
    }
}

